/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.concurrent.atomic.AtomicLong;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.FeatureProperties$;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureWriter;
import org.locationtech.geomesa.utils.uuid.FeatureIdGenerator;
import org.locationtech.geomesa.utils.uuid.Z3FeatureIdGenerator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class GeoMesaFeatureWriter$
implements LazyLogging {
    public static final GeoMesaFeatureWriter$ MODULE$ = new GeoMesaFeatureWriter$();
    private static final AtomicLong org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$$tempFeatureIds;
    private static final FeatureIdGenerator idGenerator;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$$tempFeatureIds = new AtomicLong(0L);
        idGenerator = MODULE$.liftedTree1$1();
    }

    private Logger logger$lzycompute() {
        GeoMesaFeatureWriter$ geoMesaFeatureWriter$ = this;
        synchronized (geoMesaFeatureWriter$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public AtomicLong org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$$tempFeatureIds() {
        return org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$$tempFeatureIds;
    }

    private FeatureIdGenerator idGenerator() {
        return idGenerator;
    }

    public <DS extends GeoMesaDataStore<DS>> GeoMesaFeatureWriter<DS> apply(DS ds, SimpleFeatureType sft, Seq<GeoMesaFeatureIndex<?, ?>> indices, Option<Filter> filter) {
        if (TablePartition$.MODULE$.partitioned(sft)) {
            Option<Filter> option = filter;
            if (None$.MODULE$.equals(option)) {
                return new GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter<DS>(ds, sft, indices){
                    private SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature;

                    public boolean hasNext() {
                        return GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.hasNext$(this);
                    }

                    public SimpleFeature next() {
                        return GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.next$(this);
                    }

                    public void write() {
                        GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.write$(this);
                    }

                    public void remove() {
                        GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.remove$(this);
                    }

                    public SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature() {
                        return this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature;
                    }

                    public void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature_$eq(SimpleFeature x$1) {
                        this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature = x$1;
                    }
                    {
                        GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.$init$(this);
                    }
                };
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Filter f = (Filter)some.value();
                return new GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter<DS>(ds, sft, indices, f){
                    private SimpleFeatureReader org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader;
                    private SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original;
                    private SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live;

                    public /* synthetic */ void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$super$close() {
                        super.close();
                    }

                    public boolean hasNext() {
                        return GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.hasNext$(this);
                    }

                    public SimpleFeature next() {
                        return GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.next$(this);
                    }

                    public void write() {
                        GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.write$(this);
                    }

                    public void remove() {
                        GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.remove$(this);
                    }

                    public void close() {
                        GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.close$(this);
                    }

                    public SimpleFeatureReader org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader() {
                        return this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader;
                    }

                    public SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original() {
                        return this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original;
                    }

                    public void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original_$eq(SimpleFeature x$1) {
                        this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original = x$1;
                    }

                    public SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live() {
                        return this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live;
                    }

                    public void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live_$eq(SimpleFeature x$1) {
                        this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live = x$1;
                    }

                    public final void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$_setter_$org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader_$eq(SimpleFeatureReader x$1) {
                        this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader = x$1;
                    }
                    {
                        GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.$init$(this);
                        Statics.releaseFence();
                    }
                };
            }
            throw new MatchError(option);
        }
        Option<Filter> option = filter;
        if (None$.MODULE$.equals(option)) {
            return new GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter<DS>(ds, sft, indices){
                private SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature;

                public boolean hasNext() {
                    return GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.hasNext$(this);
                }

                public SimpleFeature next() {
                    return GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.next$(this);
                }

                public void write() {
                    GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.write$(this);
                }

                public void remove() {
                    GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.remove$(this);
                }

                public SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature() {
                    return this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature;
                }

                public void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature_$eq(SimpleFeature x$1) {
                    this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaAppendFeatureWriter$$currentFeature = x$1;
                }
                {
                    GeoMesaFeatureWriter.GeoMesaAppendFeatureWriter.$init$(this);
                }
            };
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Filter f = (Filter)some.value();
            return new GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter<DS>(ds, sft, indices, f){
                private SimpleFeatureReader org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader;
                private SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original;
                private SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live;

                public /* synthetic */ void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$super$close() {
                    super.close();
                }

                public boolean hasNext() {
                    return GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.hasNext$(this);
                }

                public SimpleFeature next() {
                    return GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.next$(this);
                }

                public void write() {
                    GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.write$(this);
                }

                public void remove() {
                    GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.remove$(this);
                }

                public void close() {
                    GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.close$(this);
                }

                public SimpleFeatureReader org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader() {
                    return this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader;
                }

                public SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original() {
                    return this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original;
                }

                public void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original_$eq(SimpleFeature x$1) {
                    this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$original = x$1;
                }

                public SimpleFeature org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live() {
                    return this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live;
                }

                public void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live_$eq(SimpleFeature x$1) {
                    this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$live = x$1;
                }

                public final void org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$_setter_$org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader_$eq(SimpleFeatureReader x$1) {
                    this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$GeoMesaModifyFeatureWriter$$reader = x$1;
                }
                {
                    GeoMesaFeatureWriter.GeoMesaModifyFeatureWriter.$init$(this);
                    Statics.releaseFence();
                }
            };
        }
        throw new MatchError(option);
    }

    public SimpleFeature featureWithFid(SimpleFeature feature) {
        if (feature.getUserData().containsKey(Hints.PROVIDED_FID)) {
            return this.withFid(feature, feature.getUserData().get(Hints.PROVIDED_FID).toString());
        }
        if (feature.getUserData().containsKey(Hints.USE_PROVIDED_FID) && BoxesRunTime.unboxToBoolean(feature.getUserData().get(Hints.USE_PROVIDED_FID))) {
            return feature;
        }
        return this.withFid(feature, this.idGenerator().createId(feature.getFeatureType(), feature));
    }

    private SimpleFeature withFid(SimpleFeature feature, String fid) {
        BoxedUnit boxedUnit;
        SimpleFeature simpleFeature = feature;
        if (simpleFeature instanceof ScalaSimpleFeature) {
            ScalaSimpleFeature scalaSimpleFeature = (ScalaSimpleFeature)simpleFeature;
            scalaSimpleFeature.setId(fid);
            return scalaSimpleFeature;
        }
        FeatureId featureId = feature.getIdentifier();
        if (featureId instanceof FeatureIdImpl) {
            FeatureIdImpl featureIdImpl = (FeatureIdImpl)featureId;
            featureIdImpl.setID(fid);
            return feature;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Unknown FeatureID implementation found, rebuilding feature: {} '{}'", new Object[]{featureId, featureId.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ScalaSimpleFeature copy = ScalaSimpleFeature$.MODULE$.copy(feature);
        copy.setId(fid);
        return copy;
    }

    private final /* synthetic */ FeatureIdGenerator liftedTree1$1() {
        Z3FeatureIdGenerator z3FeatureIdGenerator;
        try {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Using feature id generator '{}'", (Object)FeatureProperties$.MODULE$.FEATURE_ID_GENERATOR().get());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            z3FeatureIdGenerator = (FeatureIdGenerator)Class.forName(FeatureProperties$.MODULE$.FEATURE_ID_GENERATOR().get()).newInstance();
        }
        catch (Throwable e) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(44).append("Could not load feature id generator class '").append(FeatureProperties$.MODULE$.FEATURE_ID_GENERATOR().get()).append("'").toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            z3FeatureIdGenerator = new Z3FeatureIdGenerator();
        }
        return z3FeatureIdGenerator;
    }

    private GeoMesaFeatureWriter$() {
    }
}

