/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader;
import org.locationtech.geomesa.index.geotools.MetadataBackedDataStore$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata$;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.index.package$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.QueryInterceptor$QueryInterceptorFactory$;
import org.locationtech.geomesa.index.utils.DistributedLocking;
import org.locationtech.geomesa.index.utils.Releasable;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.locationtech.geomesa.utils.index.ReservedWordCheck$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tee!B\u0012%\u0003\u0003y\u0003\u0002\u0003=\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!Q\u00111\u0002\u0001C\u0002\u0013E\u0001&!\u0004\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003\u001fAq!a\n\u0001\r#\tI\u0003C\u0004\u0002f\u00011\t\"a\u001a\t\u000f\u0005E\u0004A\"\u0005\u0002t!9\u0011q\u000f\u0001\u0007\u0012\u0005e\u0004bBA@\u0001\u0019E\u0011\u0011\u0011\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\ty\t\u0001C!\u0003#Cq!a+\u0001\t\u0003\ni\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005M\u0006\u0001\"\u0011\u0002<\"9\u0011\u0011\u0019\u0001\u0005B\u0005\r\u0007bBAa\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\ty\r\u0001C!\u0003+Dq!!7\u0001\t\u0003\nY\u000eC\u0004\u0002j\u0002!\t%a;\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n!9!q\u0001\u0001\u0005B\tm\u0001b\u0002B\u0018\u0001\u0011\u0005#\u0011\u0007\u0005\t\u0005\u000f\u0001a\u0011\u0001\u0015\u00038!9!Q\t\u0001\u0005B\t\u001d\u0003b\u0002B(\u0001\u0011\u0005#\u0011\u000b\u0005\b\u00053\u0002A\u0011\tB.\u0011\u001d\u0011i\u0006\u0001C\t\u0005?B\u0001Ba\u001a\u0001\t#A#\u0011N\u0004\b\u0005c\"\u0003\u0012\u0001B:\r\u0019\u0019C\u0005#\u0001\u0003v!9\u0011\u0011A\u0010\u0005\u0002\tu\u0004\"\u0003B@?\t\u0007I\u0011\u0002BA\u0011!\u00119j\bQ\u0001\n\t\r%aF'fi\u0006$\u0017\r^1CC\u000e\\W\r\u001a#bi\u0006\u001cFo\u001c:f\u0015\t)c%\u0001\u0005hK>$xn\u001c7t\u0015\t9\u0003&A\u0003j]\u0012,\u0007P\u0003\u0002*U\u00059q-Z8nKN\f'BA\u0016-\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0013aA8sO\u000e\u00011c\u0002\u00011q}z\u0006N\u001c\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001\\1oO*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019y%M[3diB\u0011\u0011(P\u0007\u0002u)\u00111\bP\u0001\u0005I\u0006$\u0018M\u0003\u0002&Y%\u0011aH\u000f\u0002\n\t\u0006$\u0018m\u0015;pe\u0016\u00042\u0001\u0011*V\u001d\t\tuJ\u0004\u0002C\u001b:\u00111\t\u0014\b\u0003\t.s!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!s\u0013A\u0002\u001fs_>$h(C\u0001.\u0013\tYC&\u0003\u0002*U%\u0011q\u0005K\u0005\u0003\u001d\u001a\n\u0001\"\\3uC\u0012\fG/Y\u0005\u0003!F\u000bq\u0001]1dW\u0006<WM\u0003\u0002OM%\u00111\u000b\u0016\u0002\u0013\u0011\u0006\u001cx)Z8NKN\fW*\u001a;bI\u0006$\u0018M\u0003\u0002Q#B\u0011a\u000b\u0018\b\u0003/j\u0003\"A\u0012-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u00037b\u0003\"\u0001Y3\u000f\u0005\u0005\u001cgB\u0001\"c\u0013\t)c%\u0003\u0002eI\u0005!r)Z8NKN\fg)Z1ukJ,'+Z1eKJL!AZ4\u0003/!\u000b7oR3p\u001b\u0016\u001c\u0018MR3biV\u0014XMU3bI\u0016\u0014(B\u00013%!\tIG.D\u0001k\u0015\tYg%A\u0003vi&d7/\u0003\u0002nU\n\u0011B)[:ue&\u0014W\u000f^3e\u0019>\u001c7.\u001b8h!\tyg/D\u0001q\u0015\t\t(/\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002ti\u0006AA/\u001f9fg\u00064WMC\u0001v\u0003\r\u0019w.\\\u0005\u0003oB\u00141\u0002T1{s2{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"A_?\u000f\u0005\u0005\\\u0018B\u0001?%\u0003]9Um\\'fg\u0006$\u0015\r^1Ti>\u0014XMR1di>\u0014\u00180\u0003\u0002\u007f\u007f\nya*Y7fgB\f7-Z\"p]\u001aLwM\u0003\u0002}I\u00051A(\u001b8jiz\"B!!\u0002\u0002\nA\u0019\u0011q\u0001\u0001\u000e\u0003\u0011BQ\u0001\u001f\u0002A\u0002e\fA\"\u001b8uKJ\u001cW\r\u001d;peN,\"!a\u0004\u0011\t\u0005E\u0011q\u0004\b\u0005\u0003'\tIBD\u0002C\u0003+I1!a\u0006'\u0003!\u0001H.\u00198oS:<\u0017\u0002BA\u000e\u0003;\t\u0001#U;fefLe\u000e^3sG\u0016\u0004Ho\u001c:\u000b\u0007\u0005]a%\u0003\u0003\u0002\"\u0005\r\"aF)vKJL\u0018J\u001c;fe\u000e,\u0007\u000f^8s\r\u0006\u001cGo\u001c:z\u0015\u0011\tY\"!\b\u0002\u001b%tG/\u001a:dKB$xN]:!\u0003=\u0001(/Z*dQ\u0016l\u0017m\u0011:fCR,G\u0003BA\u0016\u0003g\u0001B!!\f\u000205\t\u0001,C\u0002\u00022a\u0013A!\u00168ji\"9\u0011QG\u0003A\u0002\u0005]\u0012aA:giB!\u0011\u0011HA$\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012AB:j[BdWM\u0003\u0003\u0002B\u0005\r\u0013a\u00024fCR,(/\u001a\u0006\u0004\u0003\u000bb\u0013aB8qK:<\u0017n]\u0005\u0005\u0003\u0013\nYDA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016DS!BA'\u0003G\u0002b!!\f\u0002P\u0005M\u0013bAA)1\n1A\u000f\u001b:poN\u0004B!!\u0016\u0002^9!\u0011qKA.\u001d\r1\u0015\u0011L\u0005\u00023&\u0011\u0001\u000bW\u0005\u0005\u0003?\n\tG\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T!\u0001\u0015-$\u0005\u0005M\u0013a\u00049sKN\u001b\u0007.Z7b+B$\u0017\r^3\u0015\r\u0005-\u0012\u0011NA6\u0011\u001d\t)D\u0002a\u0001\u0003oAq!!\u001c\u0007\u0001\u0004\t9$\u0001\u0005qe\u00164\u0018n\\;tQ\u00151\u0011QJA2\u0003=ygnU2iK6\f7I]3bi\u0016$G\u0003BA\u0016\u0003kBq!!\u000e\b\u0001\u0004\t9$A\bp]N\u001b\u0007.Z7b+B$\u0017\r^3e)\u0019\tY#a\u001f\u0002~!9\u0011Q\u0007\u0005A\u0002\u0005]\u0002bBA7\u0011\u0001\u0007\u0011qG\u0001\u0010_:\u001c6\r[3nC\u0012+G.\u001a;fIR!\u00111FAB\u0011\u001d\t)$\u0003a\u0001\u0003o\tAbZ3u)f\u0004XMT1nKN$\"!!#\u0011\u000b\u00055\u00121R+\n\u0007\u00055\u0005LA\u0003BeJ\f\u00170\u0001\u0005hKRt\u0015-\\3t)\t\t\u0019\n\u0005\u0004\u0002\u0016\u0006m\u0015qT\u0007\u0003\u0003/S1!!'5\u0003\u0011)H/\u001b7\n\t\u0005u\u0015q\u0013\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\u0011\t)+a\u0010\u0002\tQL\b/Z\u0005\u0005\u0003S\u000b\u0019K\u0001\u0003OC6,\u0017\u0001D2sK\u0006$XmU2iK6\fG\u0003BA\u0016\u0003_Cq!!-\r\u0001\u0004\t9$\u0001\u0004tG\",W.Y\u0001\nO\u0016$8k\u00195f[\u0006$B!a\u000e\u00028\"9\u0011\u0011X\u0007A\u0002\u0005}\u0015\u0001\u00028b[\u0016$B!a\u000e\u0002>\"1\u0011q\u0018\bA\u0002U\u000b\u0001\u0002^=qK:\u000bW.Z\u0001\rkB$\u0017\r^3TG\",W.\u0019\u000b\u0007\u0003W\t)-a2\t\r\u0005}v\u00021\u0001V\u0011\u001d\t)d\u0004a\u0001\u0003o!b!a\u000b\u0002L\u00065\u0007bBA`!\u0001\u0007\u0011q\u0014\u0005\b\u0003c\u0003\u0002\u0019AA\u001c\u00031\u0011X-\\8wKN\u001b\u0007.Z7b)\u0011\tY#a5\t\r\u0005}\u0016\u00031\u0001V)\u0011\tY#a6\t\u000f\u0005}&\u00031\u0001\u0002 \u0006\u0001r-\u001a;GK\u0006$XO]3T_V\u00148-\u001a\u000b\u0005\u0003;\f9\u000f\u0005\u0003\u0002`\u0006\rXBAAq\u0015\r\tiDO\u0005\u0005\u0003K\f\tOA\nTS6\u0004H.\u001a$fCR,(/Z*pkJ\u001cW\rC\u0004\u0002@N\u0001\r!a(\u0002!\u001d,GOR3biV\u0014XMU3bI\u0016\u0014HCBAw\u0003g\fi\u0010\u0005\u0003\u0002`\u0006=\u0018\u0002BAy\u0003C\u00141cU5na2,g)Z1ukJ,'+Z1eKJDq!!>\u0015\u0001\u0004\t90A\u0003rk\u0016\u0014\u0018\u0010E\u0002:\u0003sL1!a?;\u0005\u0015\tV/\u001a:z\u0011\u001d\ty\u0010\u0006a\u0001\u0005\u0003\t1\u0002\u001e:b]N\f7\r^5p]B\u0019\u0011Ha\u0001\n\u0007\t\u0015!HA\u0006Ue\u0006t7/Y2uS>t\u0017\u0001E4fi\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s)\u0019\u0011YAa\u0006\u0003\u001aA!!Q\u0002B\t\u001d\r\u0011%qB\u0005\u0003!\u001aJAAa\u0005\u0003\u0016\t1b\t\\;tQ\u0006\u0014G.\u001a$fCR,(/Z,sSR,'O\u0003\u0002QM!1\u0011qX\u000bA\u0002UCq!a@\u0016\u0001\u0004\u0011\t\u0001\u0006\u0005\u0003\f\tu!q\u0004B\u0017\u0011\u0019\tyL\u0006a\u0001+\"9!\u0011\u0005\fA\u0002\t\r\u0012A\u00024jYR,'\u000f\u0005\u0003\u0003&\t%RB\u0001B\u0014\u0015\u0011\u0011\t#a\u0011\n\t\t-\"q\u0005\u0002\u0007\r&dG/\u001a:\t\u000f\u0005}h\u00031\u0001\u0003\u0002\u00051r-\u001a;GK\u0006$XO]3Xe&$XM]!qa\u0016tG\r\u0006\u0004\u0003\f\tM\"Q\u0007\u0005\u0007\u0003\u007f;\u0002\u0019A+\t\u000f\u0005}x\u00031\u0001\u0003\u0002QA!1\u0002B\u001d\u0005w\u0011i\u0004C\u0004\u00026a\u0001\r!a\u000e\t\u000f\u0005}\b\u00041\u0001\u0003\u0002!9!\u0011\u0005\rA\u0002\t}\u0002CBA\u0017\u0005\u0003\u0012\u0019#C\u0002\u0003Da\u0013aa\u00149uS>t\u0017aB4fi&sgm\u001c\u000b\u0003\u0005\u0013\u00022!\u000fB&\u0013\r\u0011iE\u000f\u0002\f'\u0016\u0014h/[2f\u0013:4w.A\thKRdunY6j]\u001el\u0015M\\1hKJ$\"Aa\u0015\u0011\u0007e\u0012)&C\u0002\u0003Xi\u0012a\u0002T8dW&tw-T1oC\u001e,'/A\u0004eSN\u0004xn]3\u0015\u0005\u0005-\u0012\u0001\u0006<bY&$\u0017\r^3TG\",W.Y+qI\u0006$X\r\u0006\u0004\u0002,\t\u0005$Q\r\u0005\b\u0005Gb\u0002\u0019AA\u001c\u0003!)\u00070[:uS:<\u0007bBAY9\u0001\u0007\u0011qG\u0001\u0013C\u000e\fX/\u001b:f\u0007\u0006$\u0018\r\\8h\u0019>\u001c7\u000e\u0006\u0002\u0003lA\u0019\u0011N!\u001c\n\u0007\t=$N\u0001\u0006SK2,\u0017m]1cY\u0016\fq#T3uC\u0012\fG/\u0019\"bG.,G\rR1uCN#xN]3\u0011\u0007\u0005\u001dqdE\u0002 \u0005o\u0002B!!\f\u0003z%\u0019!1\u0010-\u0003\r\u0005s\u0017PU3g)\t\u0011\u0019(\u0001\rV]6|G-\u001b4jC\ndW-V:fe\u0012\u000bG/Y&fsN,\"Aa!\u0011\r\t\u0015%q\u0012BJ\u001b\t\u00119I\u0003\u0003\u0003\n\n-\u0015!C5n[V$\u0018M\u00197f\u0015\r\u0011i\tW\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BI\u0005\u000f\u00131aU3u!\r\t$QS\u0005\u0003;J\n\u0011$\u00168n_\u0012Lg-[1cY\u0016,6/\u001a:ECR\f7*Z=tA\u0001")
public abstract class MetadataBackedDataStore
implements DataStore,
package.HasGeoMesaMetadata<String>,
GeoMesaFeatureReader.HasGeoMesaFeatureReader,
DistributedLocking,
LazyLogging {
    private final GeoMesaDataStoreFactory.NamespaceConfig config;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public <T> T withLock(String key, Function0<T> fn) {
        return (T)DistributedLocking.withLock$(this, key, fn);
    }

    @Override
    public <T> T withLock(String key, long timeOut, Function0<T> fn, Function0<T> fallback) {
        return (T)DistributedLocking.withLock$(this, key, timeOut, fn, fallback);
    }

    private Logger logger$lzycompute() {
        MetadataBackedDataStore metadataBackedDataStore = this;
        synchronized (metadataBackedDataStore) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    public abstract void preSchemaCreate(SimpleFeatureType var1) throws IllegalArgumentException;

    public abstract void preSchemaUpdate(SimpleFeatureType var1, SimpleFeatureType var2) throws IllegalArgumentException;

    public abstract void onSchemaCreated(SimpleFeatureType var1);

    public abstract void onSchemaUpdated(SimpleFeatureType var1, SimpleFeatureType var2);

    public abstract void onSchemaDeleted(SimpleFeatureType var1);

    public String[] getTypeNames() {
        return this.metadata().getFeatureTypes();
    }

    public List<Name> getNames() {
        ArrayList<Name> names = new ArrayList<Name>();
        Option<String> option = this.config.namespace();
        if (None$.MODULE$.equals(option)) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames()), (Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)names.add(new NameImpl(name))));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String ns = (String)some.value();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames()), (Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)names.add(new NameImpl(ns, name))));
        } else {
            throw new MatchError(option);
        }
        return names;
    }

    public void createSchema(SimpleFeatureType schema) {
        if (this.getSchema(schema.getTypeName()) == null) {
            block10: {
                Releasable lock = this.acquireCatalogLock();
                try {
                    if (this.getSchema(schema.getTypeName()) != null) break block10;
                    SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.mutable(schema);
                    GeoMesaSchemaValidator$.MODULE$.validate(sft);
                    this.preSchemaCreate(sft);
                    try {
                        Map metadataMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GeoMesaMetadata$.MODULE$.AttributesKey()), (Object)SimpleFeatureTypes$.MODULE$.encodeType(sft, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GeoMesaMetadata$.MODULE$.StatsGenerationKey()), (Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.GeoToolsDateFormat().format(Instant.now().atOffset(ZoneOffset.UTC)))}));
                        this.metadata().insert(sft.getTypeName(), metadataMap);
                        String attributes2 = (String)this.metadata().readRequired(sft.getTypeName(), GeoMesaMetadata$.MODULE$.AttributesKey());
                        SimpleFeatureType reloadedSft = SimpleFeatureTypes$.MODULE$.createType(sft.getTypeName(), attributes2);
                        HashMap userData = new HashMap();
                        userData.putAll(reloadedSft.getUserData());
                        reloadedSft.getUserData().putAll(sft.getUserData());
                        reloadedSft.getUserData().putAll(userData);
                        this.onSchemaCreated(reloadedSft);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e;
                            block11: {
                                e = (Throwable)option.get();
                                try {
                                    this.metadata().delete(sft.getTypeName());
                                }
                                catch (Throwable throwable3) {
                                    Option option2;
                                    Throwable throwable4 = throwable3;
                                    if (throwable4 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                                        Throwable e2 = (Throwable)option2.get();
                                        e.addSuppressed(e2);
                                        break block11;
                                    }
                                    throw throwable3;
                                }
                            }
                            throw e;
                        }
                        throw throwable;
                    }
                }
                finally {
                    lock.release();
                }
            }
            return;
        }
    }

    public SimpleFeatureType getSchema(Name name) {
        return this.getSchema(name.getLocalPart());
    }

    public SimpleFeatureType getSchema(String typeName) {
        boolean x$3;
        String x$2;
        String x$1;
        GeoMesaMetadata qual$1 = this.metadata();
        Option option = qual$1.read(x$1 = typeName, x$2 = GeoMesaMetadata$.MODULE$.AttributesKey(), x$3 = qual$1.read$default$3());
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String spec = (String)some.value();
            return SimpleFeatureTypes$.MODULE$.createImmutableType((String)this.config.namespace().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), typeName, spec);
        }
        throw new MatchError(option);
    }

    public void updateSchema(String typeName, SimpleFeatureType sft) {
        this.updateSchema((Name)new NameImpl(typeName), sft);
    }

    public void updateSchema(Name typeName, SimpleFeatureType schema) {
        String string = typeName.getLocalPart();
        String string2 = schema.getTypeName();
        if ((string == null ? string2 != null : !string.equals(string2)) && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames()), (Object)schema.getTypeName())) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Updated type name already exists: '").append(typeName).append("' changed to '").append(schema.getTypeName()).append("'").toString());
        }
        Releasable lock = this.acquireCatalogLock();
        try {
            SimpleFeatureType previousSft = this.getSchema(typeName);
            if (previousSft == null) {
                throw new IllegalArgumentException(new StringBuilder(24).append("Schema '").append(typeName).append("' does not exist").toString());
            }
            GeoMesaSchemaValidator$.MODULE$.validate(schema);
            this.validateSchemaUpdate(previousSft, schema);
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.mutable(schema);
            this.preSchemaUpdate(sft, previousSft);
            if (Predef$.MODULE$.Boolean2boolean((Boolean)FastConverter$.MODULE$.convertOrElse(sft.getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.UpdateBackupMetadata()), (Function0 & Serializable)() -> Predef$.MODULE$.boolean2Boolean(true), ClassTag$.MODULE$.apply(Boolean.class)))) {
                this.metadata().backup(typeName.getLocalPart());
            }
            String string3 = typeName.getLocalPart();
            String string4 = schema.getTypeName();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                this.metadata().scan(typeName.getLocalPart(), "", false).foreach((Function1 & Serializable)x0$1 -> {
                    MetadataBackedDataStore.$anonfun$updateSchema$2(this, sft, typeName, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            this.metadata().insert(sft.getTypeName(), GeoMesaMetadata$.MODULE$.AttributesKey(), SimpleFeatureTypes$.MODULE$.encodeType(sft, true));
            this.onSchemaUpdated(sft, previousSft);
        }
        finally {
            lock.release();
        }
    }

    public void removeSchema(String typeName) {
        Releasable lock = this.acquireCatalogLock();
        try {
            Option$.MODULE$.apply((Object)this.getSchema(typeName)).foreach((Function1 & Serializable)sft -> {
                MetadataBackedDataStore.$anonfun$removeSchema$1(this, typeName, sft);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            lock.release();
        }
    }

    public void removeSchema(Name typeName) {
        this.removeSchema(typeName.getLocalPart());
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public SimpleFeatureReader getFeatureReader(Query query, Transaction transaction) {
        Predef$.MODULE$.require(query.getTypeName() != null, (Function0 & Serializable)() -> "Type name is required in the query");
        SimpleFeatureType sft = this.getSchema(query.getTypeName());
        if (sft == null) {
            throw new IOException(new StringBuilder(69).append("Schema '").append(query.getTypeName()).append("' has not been initialized. Please call 'createSchema' first.").toString());
        }
        return this.getFeatureReader(sft, transaction, query).reader();
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Transaction transaction) {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringBuilder(69).append("Schema '").append(typeName).append("' has not been initialized. Please call 'createSchema' first.").toString());
        }
        return this.getFeatureWriter(sft, transaction, (Option<Filter>)Option$.MODULE$.apply((Object)filter));
    }

    public SimpleFeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringBuilder(69).append("Schema '").append(typeName).append("' has not been initialized. Please call 'createSchema' first.").toString());
        }
        return this.getFeatureWriter(sft, transaction, (Option<Filter>)None$.MODULE$);
    }

    public abstract SimpleFeatureWriter getFeatureWriter(SimpleFeatureType var1, Transaction var2, Option<Filter> var3);

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription(new StringBuilder(14).append("Features from ").append(this.getClass().getSimpleName()).toString());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return info;
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public void dispose() {
        package.CloseWithLogging$.MODULE$.apply((Object)this.metadata(), IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply((Object)this.interceptors(), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public void validateSchemaUpdate(SimpleFeatureType existing, SimpleFeatureType schema) {
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema)) != RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(existing))) {
            throw new UnsupportedOperationException("Changing the default geometry attribute is not supported");
        }
        Option option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema));
        Option option2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(existing));
        if (option == null ? option2 != null : !option.equals(option2)) {
            throw new UnsupportedOperationException("Changing the default date attribute is not supported");
        }
        MetadataBackedDataStore$.MODULE$.org$locationtech$geomesa$index$geotools$MetadataBackedDataStore$$UnmodifiableUserDataKeys().foreach((Function1 & Serializable)key -> {
            MetadataBackedDataStore.$anonfun$validateSchemaUpdate$1(schema, existing, key);
            return BoxedUnit.UNIT;
        });
        if (existing.getAttributeCount() > schema.getAttributeCount()) {
            throw new UnsupportedOperationException("Removing attributes from the schema is not supported");
        }
        ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(existing.getAttributeDescriptors()).asScala()).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataBackedDataStore.$anonfun$validateSchemaUpdate$2(schema, x0$1);
            return BoxedUnit.UNIT;
        });
        boolean reserved = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getAttributeDescriptors()).asScala()).map((Function1 & Serializable)x$1 -> x$1.getLocalName())).exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetadataBackedDataStore.$anonfun$validateSchemaUpdate$4(existing, name)));
        if (reserved) {
            ReservedWordCheck$.MODULE$.validateAttributeNames(schema);
            return;
        }
    }

    public Releasable acquireCatalogLock() {
        String dsTypeName = this.getClass().getSimpleName().replaceAll("[^A-Za-z]", "");
        String path = new StringBuilder(30).append("/org.locationtech.geomesa/ds/").append(dsTypeName).append("/").append(this.config.catalog()).toString();
        Duration timeout = (Duration)package$.MODULE$.DistributedLockTimeout().toDuration().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(33).append("Couldn't convert '").append(package$.MODULE$.DistributedLockTimeout().get()).append("' to a duration").toString());
        });
        return (Releasable)this.acquireDistributedLock(path, timeout.toMillis()).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new StringBuilder(48).append("Could not acquire distributed lock at '").append(path).append("' within ").append(timeout).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$updateSchema$2(MetadataBackedDataStore $this, SimpleFeatureType sft$1, Name typeName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            $this.metadata().insert(sft$1.getTypeName(), k, v);
            $this.metadata().remove(typeName$1.getLocalPart(), k);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$removeSchema$1(MetadataBackedDataStore $this, String typeName$2, SimpleFeatureType sft) {
        $this.onSchemaDeleted(sft);
        $this.metadata().delete(typeName$2);
    }

    public static final /* synthetic */ void $anonfun$validateSchemaUpdate$1(SimpleFeatureType schema$1, SimpleFeatureType existing$1, String key) {
        Option option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema$1), (Object)key);
        Option option2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(existing$1), (Object)key);
        if (option == null ? option2 != null : !option.equals(option2)) {
            throw new UnsupportedOperationException(new StringBuilder(28).append("Updating '").append(key).append("' is not supported").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validateSchemaUpdate$2(SimpleFeatureType schema$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AttributeDescriptor prev = (AttributeDescriptor)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Class binding = schema$1.getDescriptor(i).getType().getBinding();
            if (!binding.isAssignableFrom(prev.getType().getBinding())) {
                throw new UnsupportedOperationException(new StringBuilder(50).append("Incompatible schema column type change: ").append(schema$1.getDescriptor(i).getLocalName()).append(" ").append("from ").append(prev.getType().getBinding().getName()).append(" to ").append(binding.getName()).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$validateSchemaUpdate$4(SimpleFeatureType existing$1, String name) {
        return existing$1.getDescriptor(name) == null && FeatureUtils$.MODULE$.ReservedWords().contains((Object)name.toUpperCase(Locale.US));
    }

    public MetadataBackedDataStore(GeoMesaDataStoreFactory.NamespaceConfig config) {
        this.config = config;
        DistributedLocking.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.interceptors = QueryInterceptor$QueryInterceptorFactory$.MODULE$.apply(this);
    }
}

