/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.attribute;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKeySpace$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexValues;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Left;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t}h\u0001\u0002\u0017.\u0001eB\u0001B\u0017\u0001\u0003\u0006\u0004%\ta\u0017\u0005\tM\u0002\u0011\t\u0011)A\u00059\"Aq\r\u0001BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003j\u0011!i\u0007A!A!\u0002\u0013q\u0007\"B=\u0001\t\u0003Q\b\u0002C@\u0001\u0005\u0004%\t\"!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%\t\"!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0005\u0004%\t\"!\u0007\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u00037A\u0011\"a\t\u0001\u0005\u0004%I!!\n\t\u0011\u0005M\u0002\u0001)A\u0005\u0003OA\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\t\u0011\u0005M\u0003\u0001)A\u0005\u0003sA\u0011\"!\u0018\u0001\u0005\u0004%\t\"a\u0018\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003CB\u0011\"!\u001b\u0001\u0005\u0004%\t%a\u001b\t\u0011\u0005}\u0004\u0001)A\u0005\u0003[B\u0011\"!!\u0001\u0005\u0004%\t%a!\t\u0011\u0005E\u0005\u0001)A\u0005\u0003\u000bC\u0011\"a%\u0001\u0005\u0004%\t%!&\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003/Cq!!*\u0001\t\u0003\n9\u000bC\u0004\u0002`\u0002!\t%!9\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!\u0011\u0004\u0001\u0005B\tm\u0001b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005S\u0002A\u0011\u0001B6\u0011\u001d\u0011\u0019\t\u0001C\t\u0005\u000bCqAa$\u0001\t#\u0011\t\nC\u0004\u0003\u0018\u0002!\tB!'\t\u0013\t\r\u0006!%A\u0005\u0012\t\u0015\u0006b\u0002B^\u0001\u0011E!Q\u0018\u0005\n\u0005\u0007\u0004\u0011\u0013!C\t\u0005KCqA!2\u0001\t#\u00119\rC\u0004\u0003N\u0002!IAa4\b\u000f\t]W\u0006#\u0001\u0003Z\u001a1A&\fE\u0001\u00057Da!\u001f\u0015\u0005\u0002\t-\bb\u0002BwQ\u0011\u0005#q\u001e\u0005\b\u0005kDC\u0011\tB|\u0005Y\tE\u000f\u001e:jEV$X-\u00138eKb\\U-_*qC\u000e,'B\u0001\u00180\u0003%\tG\u000f\u001e:jEV$XM\u0003\u00021c\u0005)\u0011N\u001c3fq*\u0011\u0001G\r\u0006\u0003gQ\nqaZ3p[\u0016\u001c\u0018M\u0003\u00026m\u0005aAn\\2bi&|g\u000e^3dQ*\tq'A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001u\u0001\u0003\u0006CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$AB!osJ+g\r\u0005\u0003B\t\u001akU\"\u0001\"\u000b\u0005\r\u000b\u0014aA1qS&\u0011QI\u0011\u0002\u000e\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0007\u001dC%*D\u0001.\u0013\tIUF\u0001\u000bBiR\u0014\u0018NY;uK&sG-\u001a=WC2,Xm\u001d\t\u0003w-K!\u0001\u0014\u001f\u0003\u0007\u0005s\u0017\u0010\u0005\u0002H\u001d&\u0011q*\f\u0002\u0012\u0003R$(/\u001b2vi\u0016Le\u000eZ3y\u0017\u0016L\bCA)Y\u001b\u0005\u0011&BA*U\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t)f+\u0001\u0005usB,7/\u00194f\u0015\u00059\u0016aA2p[&\u0011\u0011L\u0015\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002tMR,\u0012\u0001\u0018\t\u0003;\u0012l\u0011A\u0018\u0006\u0003?\u0002\faa]5na2,'BA1c\u0003\u001d1W-\u0019;ve\u0016T!a\u0019\u001c\u0002\u000f=\u0004XM\\4jg&\u0011QM\u0018\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\n\u0001b\u001d5be\u0012LgnZ\u000b\u0002SB\u0011\u0011I[\u0005\u0003W\n\u0013Qb\u00155be\u0012\u001cFO]1uK\u001eL\u0018!C:iCJ$\u0017N\\4!\u00039\tG\u000f\u001e:jEV$XMR5fY\u0012\u0004\"a\u001c<\u000f\u0005A$\bCA9=\u001b\u0005\u0011(BA:9\u0003\u0019a$o\\8u}%\u0011Q\u000fP\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002vy\u00051A(\u001b8jiz\"Ba\u001f?~}B\u0011q\t\u0001\u0005\u00065\u001a\u0001\r\u0001\u0018\u0005\u0006O\u001a\u0001\r!\u001b\u0005\u0006[\u001a\u0001\rA\\\u0001\u000bM&,G\u000eZ%oI\u0016DXCAA\u0002!\rY\u0014QA\u0005\u0004\u0003\u000fa$aA%oi\u0006Ya-[3mI&sG-\u001a=!\u0003=1\u0017.\u001a7e\u0013:$W\r_*i_J$XCAA\b!\rY\u0014\u0011C\u0005\u0004\u0003'a$!B*i_J$\u0018\u0001\u00054jK2$\u0017J\u001c3fqNCwN\u001d;!\u0003\u0019I7\u000fT5tiV\u0011\u00111\u0004\t\u0004w\u0005u\u0011bAA\u0010y\t9!i\\8mK\u0006t\u0017aB5t\u0019&\u001cH\u000fI\u0001\u000bI\u0016\u001c8M]5qi>\u0014XCAA\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017A\u0006!A/\u001f9f\u0013\u0011\t\t$a\u000b\u0003'\u0005#HO]5ckR,G)Z:de&\u0004Ho\u001c:\u0002\u0017\u0011,7o\u0019:jaR|'\u000fI\u0001\bE&tG-\u001b8h+\t\tI\u0004\r\u0003\u0002<\u0005=\u0003CBA\u001f\u0003\u000f\nY%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0013\u0001\u00026bm\u0006LA!!\u0013\u0002@\t)1\t\\1tgB!\u0011QJA(\u0019\u0001!1\"!\u0015\u0011\u0003\u0003\u0005\tQ!\u0001\u0002V\t\u0019q\f\n\u001a\u0002\u0011\tLg\u000eZ5oO\u0002\n2!a\u0016K!\rY\u0014\u0011L\u0005\u0004\u00037b$a\u0002(pi\"LgnZ\u0001\fI\u0016\u001cw\u000eZ3WC2,X-\u0006\u0002\u0002bA)1(a\u0019ou%\u0019\u0011Q\r\u001f\u0003\u0013\u0019+hn\u0019;j_:\f\u0014\u0001\u00043fG>$WMV1mk\u0016\u0004\u0013AC1uiJL'-\u001e;fgV\u0011\u0011Q\u000e\t\u0006\u0003_\nIH\u001c\b\u0005\u0003c\n)HD\u0002r\u0003gJ\u0011!P\u0005\u0004\u0003ob\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003w\niHA\u0002TKFT1!a\u001e=\u0003-\tG\u000f\u001e:jEV$Xm\u001d\u0011\u0002\u000fMD\u0017M]5oOV\u0011\u0011Q\u0011\t\u0006w\u0005\u001d\u00151R\u0005\u0004\u0003\u0013c$!B!se\u0006L\bcA\u001e\u0002\u000e&\u0019\u0011q\u0012\u001f\u0003\t\tKH/Z\u0001\tg\"\f'/\u001b8hA\u0005\u0011\u0012N\u001c3fq.+\u0017PQ=uK2+gn\u001a;i+\t\t9\n\u0005\u0005\u0002p\u0005e\u0015QTA\u0002\u0013\u0011\tY*! \u0003\t1+g\r\u001e\t\fw\u0005}\u0015QQA\u0002\u0003\u0007\t\u0019!C\u0002\u0002\"r\u0012\u0011BR;oGRLwN\\\u001a\u0002'%tG-\u001a=LKf\u0014\u0015\u0010^3MK:<G\u000f\u001b\u0011\u0002\u0015Q|\u0017J\u001c3fq.+\u0017\u0010\u0006\u0006\u0002*\u0006%\u00171[Al\u00037\u0004R!a+\u0002D6sA!!,\u0002B:!\u0011qVA`\u001d\u0011\t\t,!0\u000f\t\u0005M\u00161\u0018\b\u0005\u0003k\u000bILD\u0002r\u0003oK\u0011aN\u0005\u0003kYJ!a\r\u001b\n\u0005A\u0012\u0014BA\"2\u0013\r\t9HQ\u0005\u0005\u0003\u000b\f9MA\u0006S_^\\U-\u001f,bYV,'bAA<\u0005\"9\u00111Z\rA\u0002\u00055\u0017\u0001C<sSR\f'\r\\3\u0011\u0007\u0005\u000by-C\u0002\u0002R\n\u0013qb\u0016:ji\u0006\u0014G.\u001a$fCR,(/\u001a\u0005\b\u0003+L\u0002\u0019AAC\u0003\u0011!\u0018.\u001a:\t\u000f\u0005e\u0017\u00041\u0001\u0002\u0006\u0006\u0011\u0011\u000e\u001a\u0005\n\u0003;L\u0002\u0013!a\u0001\u00037\tq\u0001\\3oS\u0016tG/\u0001\bhKRLe\u000eZ3y-\u0006dW/Z:\u0015\u000b\u0019\u000b\u0019/!=\t\u000f\u0005\u0015(\u00041\u0001\u0002h\u00061a-\u001b7uKJ\u0004B!!;\u0002n6\u0011\u00111\u001e\u0006\u0004\u0003K\u0014\u0017\u0002BAx\u0003W\u0014aAR5mi\u0016\u0014\bbBAz5\u0001\u0007\u0011Q_\u0001\bKb\u0004H.Y5o!\u0011\t90!@\u000e\u0005\u0005e(bAA~c\u0005)Q\u000f^5mg&!\u0011q`A}\u0005%)\u0005\u0010\u001d7bS:,'/A\u0005hKR\u0014\u0016M\\4fgR1!Q\u0001B\t\u0005+\u0001b!a\u001c\u0003\b\t-\u0011\u0002\u0002B\u0005\u0003{\u0012\u0001\"\u0013;fe\u0006$xN\u001d\t\u0006\u0003W\u0013i!T\u0005\u0005\u0005\u001f\t9MA\u0005TG\u0006t'+\u00198hK\"1!1C\u000eA\u0002\u0019\u000baA^1mk\u0016\u001c\b\"\u0003B\f7A\u0005\t\u0019AA\u0002\u0003)iW\u000f\u001c;ja2LWM]\u0001\u000eO\u0016$(+\u00198hK\nKH/Z:\u0015\r\tu!Q\u0005B\u0015!\u0019\tyGa\u0002\u0003 A!\u00111\u0016B\u0011\u0013\u0011\u0011\u0019#a2\u0003\u0013\tKH/\u001a*b]\u001e,\u0007b\u0002B\u00149\u0001\u0007!QA\u0001\u0007e\u0006tw-Z:\t\u0013\u0005UG\u0004%AA\u0002\u0005m\u0011!D;tK\u001a+H\u000e\u001c$jYR,'\u000f\u0006\u0005\u0002\u001c\t=\"q\u0007B*\u0011\u001d\u0011\u0019\"\ba\u0001\u0005c\u0001Ba\u000fB\u001a\r&\u0019!Q\u0007\u001f\u0003\r=\u0003H/[8o\u0011\u001d\u0011I$\ba\u0001\u0005w\taaY8oM&<\u0007#B\u001e\u00034\tu\u0002\u0003\u0002B \u0005\u001brAA!\u0011\u0003H9!\u0011q\u0016B\"\u0013\r\u0011)%M\u0001\tO\u0016|Go\\8mg&!!\u0011\nB&\u0003]9Um\\'fg\u0006$\u0015\r^1Ti>\u0014XMR1di>\u0014\u0018PC\u0002\u0003FEJAAa\u0014\u0003R\t1r)Z8NKN\fG)\u0019;b'R|'/Z\"p]\u001aLwM\u0003\u0003\u0003J\t-\u0003b\u0002B+;\u0001\u0007!qK\u0001\u0006Q&tGo\u001d\t\u0005\u00053\u0012)'\u0004\u0002\u0003\\)!!Q\fB0\u0003\u001d1\u0017m\u0019;pefTAA!\u0019\u0003d\u0005!Q\u000f^5m\u0015\r\u0011)EN\u0005\u0005\u0005O\u0012YFA\u0003IS:$8/\u0001\beK\u000e|G-\u001a*poZ\u000bG.^3\u0015\u0011\t5$q\u000fB>\u0005\u007f\u0002RAa\u001c\u0003tij!A!\u001d\u000b\u0007\t\u0005D(\u0003\u0003\u0003v\tE$a\u0001+ss\"9!\u0011\u0010\u0010A\u0002\u0005\u0015\u0015a\u0001:po\"9!Q\u0010\u0010A\u0002\u0005\r\u0011AB8gMN,G\u000fC\u0004\u0003\u0002z\u0001\r!a\u0001\u0002\r1,gn\u001a;i\u0003M9W\r\u001e+jKJ,GMU1oO\u0016\u0014\u0015\u0010^3t)\u0019\u0011iBa\"\u0003\n\"9!qE\u0010A\u0002\t\u0015\u0001b\u0002BF?\u0001\u0007!QR\u0001\taJ,g-\u001b=fgB1\u0011qNA=\u0003\u000b\u000bQcZ3u'R\fg\u000eZ1sIJ\u000bgnZ3CsR,7\u000f\u0006\u0004\u0003\u001e\tM%Q\u0013\u0005\b\u0005O\u0001\u0003\u0019\u0001B\u0003\u0011\u001d\u0011Y\t\ta\u0001\u0005\u001b\u000bQ\u0001\\8xKJ$b!!\"\u0003\u001c\n}\u0005B\u0002BOC\u0001\u0007Q*A\u0002lKfD\u0011B!)\"!\u0003\u0005\r!a\u0007\u0002\rA\u0014XMZ5y\u0003=awn^3sI\u0011,g-Y;mi\u0012\u0012TC\u0001BTU\u0011\tYB!+,\u0005\t-\u0006\u0003\u0002BW\u0005ok!Aa,\u000b\t\tE&1W\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!.=\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0013yKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ!\u001e9qKJ$b!!\"\u0003@\n\u0005\u0007B\u0002BOG\u0001\u0007Q\nC\u0005\u0003\"\u000e\u0002\n\u00111\u0001\u0002\u001c\u0005yQ\u000f\u001d9fe\u0012\"WMZ1vYR$#'A\u0006uS\u0016\u0014X\rZ+qa\u0016\u0014H\u0003\u0002Be\u0005\u0017\u0004Ra\u000fB\u001a\u0003\u000bCaA!(&\u0001\u0004i\u0015\u0001C5e\u001f\u001a47/\u001a;\u0015\u0011\u0005\r!\u0011\u001bBj\u0005+DqA!\u001f'\u0001\u0004\t)\tC\u0004\u0003~\u0019\u0002\r!a\u0001\t\u000f\t\u0005e\u00051\u0001\u0002\u0004\u00051\u0012\t\u001e;sS\n,H/Z%oI\u0016D8*Z=Ta\u0006\u001cW\r\u0005\u0002HQM!\u0001F\u000fBo!\u0019\u0011yN!:G\u001b:!\u0011Q\u0016Bq\u0013\r\u0011\u0019OQ\u0001\u000e\u0013:$W\r_&fsN\u0003\u0018mY3\n\t\t\u001d(\u0011\u001e\u0002\u0015\u0013:$W\r_&fsN\u0003\u0018mY3GC\u000e$xN]=\u000b\u0007\t\r(\t\u0006\u0002\u0003Z\u0006A1/\u001e9q_J$8\u000f\u0006\u0004\u0002\u001c\tE(1\u001f\u0005\u00065*\u0002\r\u0001\u0018\u0005\b\u0003SR\u0003\u0019AA7\u0003\u0015\t\u0007\u000f\u001d7z)\u001dY(\u0011 B~\u0005{DQAW\u0016A\u0002qCq!!\u001b,\u0001\u0004\ti\u0007C\u0004\u0002V.\u0002\r!a\u0007")
public class AttributeIndexKeySpace
implements IndexKeySpace<AttributeIndexValues<Object>, AttributeIndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String attributeField;
    private final int fieldIndex;
    private final short fieldIndexShort;
    private final boolean isList;
    private final AttributeDescriptor descriptor;
    private final Class<?> binding;
    private final Function1<String, Object> decodeValue;
    private final Seq<String> attributes;
    private final byte[] sharing;
    private final Left<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static AttributeIndexKeySpace apply(SimpleFeatureType sft, Seq<String> attributes2, boolean tier) {
        return AttributeIndexKeySpace$.MODULE$.apply(sft, (Seq)attributes2, tier);
    }

    public static boolean supports(SimpleFeatureType sft, Seq<String> attributes2) {
        return AttributeIndexKeySpace$.MODULE$.supports(sft, attributes2);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    private Logger logger$lzycompute() {
        AttributeIndexKeySpace attributeIndexKeySpace = this;
        synchronized (attributeIndexKeySpace) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public int fieldIndex() {
        return this.fieldIndex;
    }

    public short fieldIndexShort() {
        return this.fieldIndexShort;
    }

    public boolean isList() {
        return this.isList;
    }

    private AttributeDescriptor descriptor() {
        return this.descriptor;
    }

    private Class<?> binding() {
        return this.binding;
    }

    public Function1<String, Object> decodeValue() {
        return this.decodeValue;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    public Left<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public package.RowKeyValue<AttributeIndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        byte[] shard = this.sharding().apply(writable);
        if (this.isList()) {
            java.util.List attribute = (java.util.List)writable.getAttribute(this.fieldIndex());
            if (attribute == null) {
                return new package.MultiRowKeyValue<AttributeIndexKey>((Seq<byte[]>)((Seq)package$.MODULE$.Seq().empty()), this.sharing(), shard, (Seq)package$.MODULE$.Seq().empty(), tier, id, writable.values());
            }
            Builder rows = package$.MODULE$.Seq().newBuilder();
            rows.sizeHint(attribute.size());
            Builder keys = package$.MODULE$.Seq().newBuilder();
            keys.sizeHint(attribute.size());
            for (int i = 0; i < attribute.size(); ++i) {
                String encoded = AttributeIndexKey$.MODULE$.typeEncode(attribute.get(i));
                byte[] value = encoded.getBytes(StandardCharsets.UTF_8);
                byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + tier.length + id.length + 1 + value.length, (ClassTag)ClassTag$.MODULE$.Byte());
                if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(shard))) {
                    System.arraycopy(value, 0, bytes, 0, value.length);
                    bytes[value.length] = ByteArrays$.MODULE$.ZeroByte();
                    System.arraycopy(tier, 0, bytes, value.length + 1, tier.length);
                    System.arraycopy(id, 0, bytes, value.length + 1 + tier.length, id.length);
                } else {
                    bytes[0] = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(shard)));
                    System.arraycopy(value, 0, bytes, 1, value.length);
                    bytes[value.length + 1] = ByteArrays$.MODULE$.ZeroByte();
                    System.arraycopy(tier, 0, bytes, value.length + 2, tier.length);
                    System.arraycopy(id, 0, bytes, value.length + 2 + tier.length, id.length);
                }
                rows.$plus$eq((Object)bytes);
                keys.$plus$eq((Object)new AttributeIndexKey(this.fieldIndexShort(), encoded, AttributeIndexKey$.MODULE$.apply$default$3()));
            }
            return new package.MultiRowKeyValue<AttributeIndexKey>((Seq<byte[]>)((Seq)rows.result()), this.sharing(), shard, (Seq)keys.result(), tier, id, writable.values());
        }
        Object attribute = writable.getAttribute(this.fieldIndex());
        if (attribute == null) {
            return new package.MultiRowKeyValue<AttributeIndexKey>((Seq<byte[]>)((Seq)package$.MODULE$.Seq().empty()), this.sharing(), shard, (Seq)package$.MODULE$.Seq().empty(), tier, id, writable.values());
        }
        String encoded = AttributeIndexKey$.MODULE$.typeEncode(attribute);
        byte[] value = encoded.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + tier.length + id.length + 1 + value.length, (ClassTag)ClassTag$.MODULE$.Byte());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(shard))) {
            System.arraycopy(value, 0, bytes, 0, value.length);
            bytes[value.length] = ByteArrays$.MODULE$.ZeroByte();
            System.arraycopy(tier, 0, bytes, value.length + 1, tier.length);
            System.arraycopy(id, 0, bytes, value.length + 1 + tier.length, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(shard)));
            System.arraycopy(value, 0, bytes, 1, value.length);
            bytes[value.length + 1] = ByteArrays$.MODULE$.ZeroByte();
            System.arraycopy(tier, 0, bytes, value.length + 2, tier.length);
            System.arraycopy(id, 0, bytes, value.length + 2 + tier.length, id.length);
        }
        return new package.SingleRowKeyValue<AttributeIndexKey>(bytes, this.sharing(), shard, new AttributeIndexKey(this.fieldIndexShort(), encoded, AttributeIndexKey$.MODULE$.apply$default$3()), tier, id, writable.values());
    }

    @Override
    public AttributeIndexValues<Object> getIndexValues(Filter filter, Explainer explain) {
        BoxedUnit boxedUnit;
        FilterValues bounds = FilterHelper$.MODULE$.extractAttributeBounds(filter, this.attributeField, this.binding());
        if (bounds.isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Unable to extract any attribute bounds from: {}", (Object)org.locationtech.geomesa.filter.package$.MODULE$.filterToString(filter));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new AttributeIndexValues<Object>(this.attributeField, this.fieldIndex(), bounds, this.binding());
    }

    @Override
    public Iterator<package.ScanRange<AttributeIndexKey>> getRanges(AttributeIndexValues<Object> values, int multiplier) {
        if (values.values().isEmpty()) {
            return package$.MODULE$.Iterator().single(new package.UnboundedRange<AttributeIndexKey>(new AttributeIndexKey(this.fieldIndexShort(), null, false)));
        }
        if (values.values().disjoint() && !this.isList()) {
            return package$.MODULE$.Iterator().empty();
        }
        return values.values().values().iterator().flatMap((Function1 & Serializable)bounds -> {
            Tuple2 tuple2 = bounds.bounds();
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                    return package$.MODULE$.Iterator().single(new package.UnboundedRange<AttributeIndexKey>(new AttributeIndexKey(this.fieldIndexShort(), null, false)));
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object lower = some.value();
                    if (None$.MODULE$.equals(option3)) {
                        AttributeIndexKey start = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding()), bounds.lower().inclusive());
                        return package$.MODULE$.Iterator().single(new package.LowerBoundedRange<AttributeIndexKey>(start));
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                    Some some = (Some)option4;
                    Object upper = some.value();
                    AttributeIndexKey end = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(upper, this.binding()), bounds.upper().inclusive());
                    return package$.MODULE$.Iterator().single(new package.UpperBoundedRange<AttributeIndexKey>(end));
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option5 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object lower = some.value();
                    if (option5 instanceof Some) {
                        Some some2 = (Some)option5;
                        Object upper = some2.value();
                        if (BoxesRunTime.equals((Object)lower, (Object)upper)) {
                            AttributeIndexKey row = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding()), true);
                            return package$.MODULE$.Iterator().single(new package.SingleRowRange<AttributeIndexKey>(row));
                        }
                        String string = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(lower), org.locationtech.geomesa.filter.package$.MODULE$.WildcardSuffix());
                        Object object = upper;
                        if (!(string != null ? !string.equals(object) : object != null)) {
                            AttributeIndexKey row = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding()), true);
                            return package$.MODULE$.Iterator().single(new package.PrefixRange<AttributeIndexKey>(row));
                        }
                        AttributeIndexKey start = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(lower, this.binding()), bounds.lower().inclusive());
                        AttributeIndexKey end = new AttributeIndexKey(this.fieldIndexShort(), AttributeIndexKey$.MODULE$.encodeForQuery(upper, this.binding()), bounds.upper().inclusive());
                        return package$.MODULE$.Iterator().single(new package.BoundedRange<AttributeIndexKey>(start, end));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<AttributeIndexKey>> ranges, boolean tier) {
        if (tier) {
            return this.getTieredRangeBytes(ranges, this.sharding().shards());
        }
        return this.getStandardRangeBytes(ranges, this.sharding().shards());
    }

    @Override
    public boolean useFullFilter(Option<AttributeIndexValues<Object>> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return values.forall((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)AttributeIndexKeySpace.$anonfun$useFullFilter$1(v)));
    }

    public Try<Object> decodeRowValue(byte[] row, int offset, int length) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            int valueStart = offset + this.sharding().length();
            int valueEnd = scala.math.package$.MODULE$.min(ArrayOps$.MODULE$.indexOf$extension(Predef$.MODULE$.byteArrayOps(row), (Object)BoxesRunTime.boxToByte((byte)ByteArrays$.MODULE$.ZeroByte()), valueStart), offset + length);
            return this.decodeValue().apply((Object)new String(row, valueStart, valueEnd - valueStart, StandardCharsets.UTF_8));
        });
    }

    public Iterator<package.ByteRange> getTieredRangeBytes(Iterator<package.ScanRange<AttributeIndexKey>> ranges, Seq<byte[]> prefixes) {
        Iterator bytes = ranges.map((Function1 & Serializable)x0$1 -> {
            package.ScanRange scanRange = x0$1;
            if (scanRange instanceof package.SingleRowRange) {
                package.SingleRowRange singleRowRange = (package.SingleRowRange)scanRange;
                AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                return new package.SingleRowByteRange(this.lower(row, this.lower$default$2()));
            }
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                AttributeIndexKey lo = (AttributeIndexKey)boundedRange.lower();
                AttributeIndexKey hi = (AttributeIndexKey)boundedRange.upper();
                Option<byte[]> option = this.tieredUpper(hi);
                if (None$.MODULE$.equals(option)) {
                    return new package.LowerBoundedByteRange(this.lower(lo, this.lower$default$2()), this.upper(hi, this.upper$default$2()));
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    byte[] up = (byte[])some.value();
                    return new package.BoundedByteRange(this.lower(lo, this.lower$default$2()), up);
                }
                throw new MatchError(option);
            }
            if (scanRange instanceof package.PrefixRange) {
                package.PrefixRange prefixRange = (package.PrefixRange)scanRange;
                AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                return new package.UnboundedByteRange(this.lower(prefix, true), this.upper(prefix, true));
            }
            if (scanRange instanceof package.LowerBoundedRange) {
                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                return new package.LowerBoundedByteRange(this.lower(lo, this.lower$default$2()), this.upper(new AttributeIndexKey(lo.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.upper$default$2()));
            }
            if (scanRange instanceof package.UpperBoundedRange) {
                package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                AttributeIndexKey hi = (AttributeIndexKey)upperBoundedRange.upper();
                Option<byte[]> option = this.tieredUpper(hi);
                if (None$.MODULE$.equals(option)) {
                    return new package.UnboundedByteRange(this.lower(new AttributeIndexKey(hi.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.lower$default$2()), this.upper(hi, this.upper$default$2()));
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    byte[] up = (byte[])some.value();
                    return new package.UpperBoundedByteRange(this.lower(new AttributeIndexKey(hi.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.lower$default$2()), up);
                }
                throw new MatchError(option);
            }
            if (scanRange instanceof package.UnboundedRange) {
                package.UnboundedRange unboundedRange = (package.UnboundedRange)scanRange;
                AttributeIndexKey empty = (AttributeIndexKey)unboundedRange.empty();
                return new package.UnboundedByteRange(this.lower(empty, this.lower$default$2()), this.upper(empty, this.upper$default$2()));
            }
            throw new MatchError((Object)scanRange);
        });
        if (prefixes.isEmpty()) {
            return bytes;
        }
        return bytes.flatMap((Function1 & Serializable)x0$2 -> {
            Product product = x0$2;
            if (product instanceof package.SingleRowByteRange) {
                package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)product;
                byte[] row = singleRowByteRange.row();
                return (IterableOnce)prefixes.map((Function1 & Serializable)p -> new package.SingleRowByteRange(ByteArrays$.MODULE$.concat(p, row)));
            }
            if (product instanceof package.BoundedByteRange) {
                package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)product;
                byte[] lo = boundedByteRange.lower();
                byte[] hi = boundedByteRange.upper();
                return (IterableOnce)prefixes.map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)));
            }
            if (product instanceof package.LowerBoundedByteRange) {
                package.LowerBoundedByteRange lowerBoundedByteRange = (package.LowerBoundedByteRange)product;
                byte[] lo = lowerBoundedByteRange.lower();
                byte[] hi = lowerBoundedByteRange.upper();
                return (IterableOnce)prefixes.map((Function1 & Serializable)p -> new package.LowerBoundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)));
            }
            if (product instanceof package.UpperBoundedByteRange) {
                package.UpperBoundedByteRange upperBoundedByteRange = (package.UpperBoundedByteRange)product;
                byte[] lo = upperBoundedByteRange.lower();
                byte[] hi = upperBoundedByteRange.upper();
                return (IterableOnce)prefixes.map((Function1 & Serializable)p -> new package.UpperBoundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)));
            }
            if (product instanceof package.UnboundedByteRange) {
                package.UnboundedByteRange unboundedByteRange = (package.UnboundedByteRange)product;
                byte[] lo = unboundedByteRange.lower();
                byte[] hi = unboundedByteRange.upper();
                return (IterableOnce)prefixes.map((Function1 & Serializable)p -> new package.UnboundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)));
            }
            throw new MatchError((Object)product);
        });
    }

    public Iterator<package.ByteRange> getStandardRangeBytes(Iterator<package.ScanRange<AttributeIndexKey>> ranges, Seq<byte[]> prefixes) {
        Iterator bytes = ranges.map((Function1 & Serializable)x0$1 -> {
            package.ScanRange scanRange = x0$1;
            if (scanRange instanceof package.SingleRowRange) {
                package.SingleRowRange singleRowRange = (package.SingleRowRange)scanRange;
                AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                return new package.BoundedByteRange(this.lower(row, this.lower$default$2()), this.upper(row, this.upper$default$2()));
            }
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                AttributeIndexKey lo = (AttributeIndexKey)boundedRange.lower();
                AttributeIndexKey hi = (AttributeIndexKey)boundedRange.upper();
                return new package.BoundedByteRange(this.lower(lo, this.lower$default$2()), this.upper(hi, this.upper$default$2()));
            }
            if (scanRange instanceof package.PrefixRange) {
                package.PrefixRange prefixRange = (package.PrefixRange)scanRange;
                AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                return new package.BoundedByteRange(this.lower(prefix, true), this.upper(prefix, true));
            }
            if (scanRange instanceof package.LowerBoundedRange) {
                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                return new package.BoundedByteRange(this.lower(lo, this.lower$default$2()), this.upper(new AttributeIndexKey(lo.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.upper$default$2()));
            }
            if (scanRange instanceof package.UpperBoundedRange) {
                package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                AttributeIndexKey hi = (AttributeIndexKey)upperBoundedRange.upper();
                return new package.BoundedByteRange(this.lower(new AttributeIndexKey(hi.i(), null, AttributeIndexKey$.MODULE$.apply$default$3()), this.lower$default$2()), this.upper(hi, this.upper$default$2()));
            }
            if (scanRange instanceof package.UnboundedRange) {
                package.UnboundedRange unboundedRange = (package.UnboundedRange)scanRange;
                AttributeIndexKey empty = (AttributeIndexKey)unboundedRange.empty();
                return new package.BoundedByteRange(this.lower(empty, this.lower$default$2()), this.upper(empty, this.upper$default$2()));
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
        if (prefixes.isEmpty()) {
            return bytes;
        }
        return bytes.flatMap((Function1 & Serializable)x0$2 -> {
            package.BoundedByteRange boundedByteRange = x0$2;
            if (boundedByteRange != null) {
                byte[] lo = boundedByteRange.lower();
                byte[] hi = boundedByteRange.upper();
                return (IterableOnce)prefixes.map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lo), ByteArrays$.MODULE$.concat(p, hi)));
            }
            throw new MatchError((Object)boundedByteRange);
        });
    }

    public byte[] lower(AttributeIndexKey key, boolean prefix) {
        if (key.value() == null || key.value().isEmpty()) {
            return (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
        }
        if (prefix) {
            return key.value().getBytes(StandardCharsets.UTF_8);
        }
        if (key.inclusive()) {
            return ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.ZeroByteArray());
        }
        return ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.OneByteArray());
    }

    public boolean lower$default$2() {
        return false;
    }

    public byte[] upper(AttributeIndexKey key, boolean prefix) {
        if (key.value() == null || key.value().isEmpty()) {
            return package$ByteRange$.MODULE$.UnboundedUpperRange();
        }
        if (prefix) {
            return ByteArrays$.MODULE$.rowFollowingPrefix(key.value().getBytes(StandardCharsets.UTF_8));
        }
        if (key.inclusive()) {
            return ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.OneByteArray());
        }
        return ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.ZeroByteArray());
    }

    public boolean upper$default$2() {
        return false;
    }

    public Option<byte[]> tieredUpper(AttributeIndexKey key) {
        if (key.value() == null || !key.inclusive()) {
            return None$.MODULE$;
        }
        return new Some((Object)ByteArrays$.MODULE$.concat(key.value().getBytes(StandardCharsets.UTF_8), ByteArrays$.MODULE$.ZeroByteArray()));
    }

    private int idOffset(byte[] row, int offset, int length) {
        return ArrayOps$.MODULE$.indexOf$extension(Predef$.MODULE$.byteArrayOps(row), (Object)BoxesRunTime.boxToByte((byte)ByteArrays$.MODULE$.ZeroByte()), offset + this.sharding().length()) + 1 - offset;
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$1(AttributeIndexValues v) {
        return v.values().isEmpty() || !v.values().precise();
    }

    public AttributeIndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String attributeField) {
        this.sft = sft;
        this.sharding = sharding;
        this.attributeField = attributeField;
        LazyLogging.$init$((LazyLogging)this);
        this.fieldIndex = sft.indexOf(attributeField);
        this.fieldIndexShort = (short)this.fieldIndex();
        this.isList = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(sft.getDescriptor(this.fieldIndex())));
        this.descriptor = sft.getDescriptor(this.fieldIndex());
        this.binding = this.isList() ? RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(this.descriptor())) : this.descriptor().getType().getBinding();
        String alias = AttributeIndexKey$.MODULE$.alias(this.binding());
        this.decodeValue = this.isList() ? (Function1 & Serializable)encoded -> Collections.singletonList(AttributeIndexKey$.MODULE$.decode(alias, (String)encoded)) : (Function1 & Serializable)x$1 -> AttributeIndexKey$.MODULE$.decode(alias, (String)x$1);
        Predef$.MODULE$.require(AttributeIndexKey$.MODULE$.encodable(this.binding()), (Function0 & Serializable)() -> new StringBuilder(69).append("Indexing is not supported for field ").append($this.attributeField).append(" of type ").append(this.binding().getName()).append(" - supported types are: ").append(((IterableOnceOps)AttributeIndexKey$.MODULE$.lexicoders().map((Function1 & Serializable)x$2 -> x$2.getName())).mkString(", ")).toString());
        this.attributes = new .colon.colon((Object)attributeField, (List)Nil$.MODULE$);
        this.sharing = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
        this.indexKeyByteLength = package$.MODULE$.Left().apply((Function3 & Serializable)(row, offset, length) -> BoxesRunTime.boxToInteger((int)this.idOffset(row, BoxesRunTime.unboxToInt((Object)offset), BoxesRunTime.unboxToInt((Object)length))));
    }
}

