/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.s3;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.S2SFC;
import org.locationtech.geomesa.curve.S2SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.s3.S3IndexKeySpace$;
import org.locationtech.geomesa.index.index.s3.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tUe\u0001\u0002\u0014(\u0001MB\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\tC\u0002\u0011\t\u0011)A\u0005/\"A!\r\u0001BC\u0002\u0013\u00051\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003e\u0011!A\u0007A!A!\u0002\u0013I\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u000bU\u0004A\u0011\u0001<\t\u000fq\u0004!\u0019!C\u0005{\"9\u0011\u0011\u0002\u0001!\u0002\u0013q\b\"CA\u0006\u0001\t\u0007I\u0011BA\u0007\u0011!\t)\u0002\u0001Q\u0001\n\u0005=\u0001\"CA\f\u0001\t\u0007I\u0011BA\u0007\u0011!\tI\u0002\u0001Q\u0001\n\u0005=\u0001\"CA\u000e\u0001\t\u0007I\u0011BA\u000f\u0011!\ti\u0004\u0001Q\u0001\n\u0005}\u0001\"CA \u0001\t\u0007I\u0011BA\u0007\u0011!\t\t\u0005\u0001Q\u0001\n\u0005=\u0001\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\ty\u0005\u0001Q\u0001\n\u0005\u001d\u0003\"CA)\u0001\t\u0007I\u0011BA*\u0011!\tI\b\u0001Q\u0001\n\u0005U\u0003\"CA>\u0001\t\u0007I\u0011IA?\u0011!\ty\t\u0001Q\u0001\n\u0005}\u0004\"CAI\u0001\t\u0007I\u0011IAJ\u0011!\ti\u000b\u0001Q\u0001\n\u0005U\u0005\"CAX\u0001\t\u0007I\u0011IAY\u0011!\t\u0019\f\u0001Q\u0001\n\u0005\u0005\u0006bBA[\u0001\u0011\u0005\u0013q\u0017\u0005\b\u0003S\u0004A\u0011IAv\u0011\u001d\u0011Y\u0001\u0001C!\u0005\u001bAqAa\t\u0001\t\u0003\u0012)\u0003C\u0004\u00036\u0001!\tEa\u000e\b\u000f\t5t\u0005#\u0001\u0003p\u00191ae\nE\u0001\u0005cBa!\u001e\u0012\u0005\u0002\t\u0005\u0005b\u0002BBE\u0011\u0005#Q\u0011\u0005\b\u0005\u0017\u0013C\u0011\tBG\u0005=\u00196'\u00138eKb\\U-_*qC\u000e,'B\u0001\u0015*\u0003\t\u00198G\u0003\u0002+W\u0005)\u0011N\u001c3fq*\u0011!\u0006\f\u0006\u0003[9\nqaZ3p[\u0016\u001c\u0018M\u0003\u00020a\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0011'A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001iiZ\u0005CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\r\u0005\u0003<}\u0001CU\"\u0001\u001f\u000b\u0005uZ\u0013aA1qS&\u0011q\b\u0010\u0002\u000e\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0005\u0005+eB\u0001\"D\u001b\u00059\u0013B\u0001#(\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u001bM\u001b\u0014J\u001c3fqZ\u000bG.^3t\u0015\t!u\u0005\u0005\u0002B\u0013&\u0011!j\u0012\u0002\u000b'NJe\u000eZ3y\u0017\u0016L\bC\u0001'T\u001b\u0005i%B\u0001(P\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0001\u0016+\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0016aA2p[&\u0011A+\u0014\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002tMR,\u0012a\u0016\t\u00031~k\u0011!\u0017\u0006\u00035n\u000baa]5na2,'B\u0001/^\u0003\u001d1W-\u0019;ve\u0016T!A\u0018\u0019\u0002\u000f=\u0004XM\\4jg&\u0011\u0001-\u0017\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\n\u0001b\u001d5be\u0012LgnZ\u000b\u0002IB\u00111(Z\u0005\u0003Mr\u0012Qb\u00155be\u0012\u001cFO]1uK\u001eL\u0018!C:iCJ$\u0017N\\4!\u0003%9Wm\\7GS\u0016dG\r\u0005\u0002kc:\u00111n\u001c\t\u0003YZj\u0011!\u001c\u0006\u0003]J\na\u0001\u0010:p_Rt\u0014B\u000197\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A4\u0014\u0001\u00033uO\u001aKW\r\u001c3\u0002\rqJg.\u001b;?)\u00159\b0\u001f>|!\t\u0011\u0005\u0001C\u0003V\u000f\u0001\u0007q\u000bC\u0003c\u000f\u0001\u0007A\rC\u0003i\u000f\u0001\u0007\u0011\u000eC\u0003u\u000f\u0001\u0007\u0011.A\u0002tM\u000e,\u0012A \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019\u0001L\u0001\u0006GV\u0014h/Z\u0005\u0005\u0003\u000f\t\tAA\u0003TeM35)\u0001\u0003tM\u000e\u0004\u0013!C4f_6Le\u000eZ3y+\t\ty\u0001E\u00026\u0003#I1!a\u00057\u0005\rIe\u000e^\u0001\u000bO\u0016|W.\u00138eKb\u0004\u0013\u0001\u00033uO&sG-\u001a=\u0002\u0013\u0011$x-\u00138eKb\u0004\u0013a\u0003;j[\u0016$v.\u00138eKb,\"!a\b\u0011\t\u0005\u0005\u0012q\u0007\b\u0005\u0003G\t\u0019D\u0004\u0003\u0002&\u0005Eb\u0002BA\u0014\u0003_qA!!\u000b\u0002.9\u0019A.a\u000b\n\u0003EJ!a\f\u0019\n\u00055r\u0013bAA\u0002Y%!\u0011QGA\u0001\u0003)\u0011\u0015N\u001c8fIRKW.Z\u0005\u0005\u0003s\tYD\u0001\tUS6,Gk\u001c\"j]:,G\rV5nK*!\u0011QGA\u0001\u00031!\u0018.\\3U_&sG-\u001a=!\u0003\u001di\u0017\r\u001f+j[\u0016\f\u0001\"\\1y)&lW\rI\u0001\fI\u0006$X\rV8J]\u0012,\u00070\u0006\u0002\u0002HA!\u0011\u0011JA&\u001d\ry\u00181G\u0005\u0005\u0003\u001b\nYD\u0001\tECR,Gk\u001c\"j]:,G\rV5nK\u0006aA-\u0019;f)>Le\u000eZ3yA\u0005i!m\\;oIN$v\u000eR1uKN,\"!!\u0016\u0011\u000fU\n9&a\u0017\u0002x%\u0019\u0011\u0011\f\u001c\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cB\u001b\u0002^\u0005\u0005\u0014\u0011M\u0005\u0004\u0003?2$A\u0002+va2,'\u0007E\u00036\u0003G\n9'C\u0002\u0002fY\u0012aa\u00149uS>t\u0007\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005i&lWM\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\u0011\t)(a\u001b\u0003\u001bi{g.\u001a3ECR,G+[7f!\u001d)\u0014QLA4\u0003O\naBY8v]\u0012\u001cHk\u001c#bi\u0016\u001c\b%\u0001\u0006biR\u0014\u0018NY;uKN,\"!a \u0011\u000b\u0005\u0005\u0015\u0011R5\u000f\t\u0005\r\u0015q\u0011\b\u0004Y\u0006\u0015\u0015\"A\u001c\n\u0005\u00113\u0014\u0002BAF\u0003\u001b\u00131aU3r\u0015\t!e'A\u0006biR\u0014\u0018NY;uKN\u0004\u0013AE5oI\u0016D8*Z=CsR,G*\u001a8hi\",\"!!&\u0011\u0011\u0005\u0005\u0015qSAN\u0003\u001fIA!!'\u0002\u000e\n)!+[4iiBYQ'!(\u0002\"\u0006=\u0011qBA\b\u0013\r\tyJ\u000e\u0002\n\rVt7\r^5p]N\u0002R!NAR\u0003OK1!!*7\u0005\u0015\t%O]1z!\r)\u0014\u0011V\u0005\u0004\u0003W3$\u0001\u0002\"zi\u0016\f1#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQ\u0002\nqa\u001d5be&tw-\u0006\u0002\u0002\"\u0006A1\u000f[1sS:<\u0007%\u0001\u0006u_&sG-\u001a=LKf$\"\"!/\u0002N\u0006]\u00171\\Ap!\u0015\tY,a2I\u001d\u0011\ti,!2\u000f\t\u0005}\u00161\u0019\b\u0005\u0003K\t\t-\u0003\u0002+Y%\u0011QhK\u0005\u0003\trJA!!3\u0002L\nY!k\\<LKf4\u0016\r\\;f\u0015\t!E\bC\u0004\u0002Pr\u0001\r!!5\u0002\u0011]\u0014\u0018\u000e^1cY\u0016\u00042aOAj\u0013\r\t)\u000e\u0010\u0002\u0010/JLG/\u00192mK\u001a+\u0017\r^;sK\"9\u0011\u0011\u001c\u000fA\u0002\u0005\u0005\u0016\u0001\u0002;jKJDq!!8\u001d\u0001\u0004\t\t+\u0001\u0002jI\"I\u0011\u0011\u001d\u000f\u0011\u0002\u0003\u0007\u00111]\u0001\bY\u0016t\u0017.\u001a8u!\r)\u0014Q]\u0005\u0004\u0003O4$a\u0002\"p_2,\u0017M\\\u0001\u000fO\u0016$\u0018J\u001c3fqZ\u000bG.^3t)\u0015\u0001\u0015Q^A~\u0011\u001d\ty/\ba\u0001\u0003c\faAZ5mi\u0016\u0014\b\u0003BAz\u0003ol!!!>\u000b\u0007\u0005=X,\u0003\u0003\u0002z\u0006U(A\u0002$jYR,'\u000fC\u0004\u0002~v\u0001\r!a@\u0002\u000f\u0015D\b\u000f\\1j]B!!\u0011\u0001B\u0004\u001b\t\u0011\u0019AC\u0002\u0003\u0006-\nQ!\u001e;jYNLAA!\u0003\u0003\u0004\tIQ\t\u001f9mC&tWM]\u0001\nO\u0016$(+\u00198hKN$bAa\u0004\u0003\u001c\t}\u0001CBAA\u0005#\u0011)\"\u0003\u0003\u0003\u0014\u00055%\u0001C%uKJ\fGo\u001c:\u0011\u000b\u0005m&q\u0003%\n\t\te\u00111\u001a\u0002\n'\u000e\fgNU1oO\u0016DaA!\b\u001f\u0001\u0004\u0001\u0015A\u0002<bYV,7\u000fC\u0005\u0003\"y\u0001\n\u00111\u0001\u0002\u0010\u0005QQ.\u001e7uSBd\u0017.\u001a:\u0002\u001b\u001d,GOU1oO\u0016\u0014\u0015\u0010^3t)\u0019\u00119Ca\f\u00034A1\u0011\u0011\u0011B\t\u0005S\u0001B!a/\u0003,%!!QFAf\u0005%\u0011\u0015\u0010^3SC:<W\rC\u0004\u00032}\u0001\rAa\u0004\u0002\rI\fgnZ3t\u0011%\tIn\bI\u0001\u0002\u0004\t\u0019/A\u0007vg\u00164U\u000f\u001c7GS2$XM\u001d\u000b\t\u0003G\u0014ID!\u0010\u0003X!9!Q\u0004\u0011A\u0002\tm\u0002\u0003B\u001b\u0002d\u0001CqAa\u0010!\u0001\u0004\u0011\t%\u0001\u0004d_:4\u0017n\u001a\t\u0006k\u0005\r$1\t\t\u0005\u0005\u000b\u0012\tF\u0004\u0003\u0003H\t5SB\u0001B%\u0015\r\u0011YeK\u0001\tO\u0016|Go\\8mg&!!q\nB%\u0003]9Um\\'fg\u0006$\u0015\r^1Ti>\u0014XMR1di>\u0014\u00180\u0003\u0003\u0003T\tU#AF$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f\u0007>tg-[4\u000b\t\t=#\u0011\n\u0005\b\u00053\u0002\u0003\u0019\u0001B.\u0003\u0015A\u0017N\u001c;t!\u0011\u0011iF!\u001b\u000e\u0005\t}#\u0002\u0002B1\u0005G\nqAZ1di>\u0014\u0018P\u0003\u0003\u0003f\t\u001d\u0014\u0001B;uS2T1Aa\u00131\u0013\u0011\u0011YGa\u0018\u0003\u000b!Kg\u000e^:\u0002\u001fM\u001b\u0014J\u001c3fq.+\u0017p\u00159bG\u0016\u0004\"A\u0011\u0012\u0014\t\t\"$1\u000f\t\u0007\u0005k\u0012Y\b\u0011%\u000f\t\u0005u&qO\u0005\u0004\u0005sb\u0014!D%oI\u0016D8*Z=Ta\u0006\u001cW-\u0003\u0003\u0003~\t}$\u0001F%oI\u0016D8*Z=Ta\u0006\u001cWMR1di>\u0014\u0018PC\u0002\u0003zq\"\"Aa\u001c\u0002\u0011M,\b\u000f]8siN$b!a9\u0003\b\n%\u0005\"B+%\u0001\u00049\u0006bBA>I\u0001\u0007\u0011qP\u0001\u0006CB\u0004H.\u001f\u000b\bo\n=%\u0011\u0013BJ\u0011\u0015)V\u00051\u0001X\u0011\u001d\tY(\na\u0001\u0003\u007fBq!!7&\u0001\u0004\t\u0019\u000f")
public class S3IndexKeySpace
implements IndexKeySpace<package.S3IndexValues, package.S3IndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String geomField;
    private final String dtgField;
    private final S2SFC sfc;
    private final int geomIndex;
    private final int dtgIndex;
    private final Function1<Object, BinnedTime> timeToIndex;
    private final int maxTime;
    private final Function1<ZonedDateTime, BinnedTime> dateToIndex;
    private final Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static S3IndexKeySpace apply(SimpleFeatureType sft, Seq<String> attributes2, boolean tier) {
        return S3IndexKeySpace$.MODULE$.apply(sft, (Seq)attributes2, tier);
    }

    public static boolean supports(SimpleFeatureType sft, Seq<String> attributes2) {
        return S3IndexKeySpace$.MODULE$.supports(sft, attributes2);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    private Logger logger$lzycompute() {
        S3IndexKeySpace s3IndexKeySpace = this;
        synchronized (s3IndexKeySpace) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    private S2SFC sfc() {
        return this.sfc;
    }

    private int geomIndex() {
        return this.geomIndex;
    }

    private int dtgIndex() {
        return this.dtgIndex;
    }

    private Function1<Object, BinnedTime> timeToIndex() {
        return this.timeToIndex;
    }

    private int maxTime() {
        return this.maxTime;
    }

    private Function1<ZonedDateTime, BinnedTime> dateToIndex() {
        return this.dateToIndex;
    }

    private Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates() {
        return this.boundsToDates;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    @Override
    public package.RowKeyValue<package.S3IndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        long l;
        Point geom = (Point)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
        }
        Date dtg = (Date)writable.getAttribute(this.dtgIndex());
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)this.timeToIndex().apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) {
            throw new MatchError((Object)binnedTime);
        }
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long t2 = tuple2._2$mcJ$sp();
        try {
            l = this.sfc().index(geom.getX(), geom.getY(), lenient);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(37).append("Invalid s value from geometry/time: ").append(geom).append(",").append(dtg).toString(), e);
            }
            throw throwable;
        }
        long s = l;
        byte[] shard = this.sharding().apply(writable);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 14 + id.length, (ClassTag)ClassTag$.MODULE$.Byte());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(shard))) {
            ByteArrays$.MODULE$.writeShort(b2, bytes, ByteArrays$.MODULE$.writeShort$default$3());
            ByteArrays$.MODULE$.writeLong(s, bytes, 2);
            ByteArrays$.MODULE$.writeInt((int)t2, bytes, 10);
            System.arraycopy(id, 0, bytes, 14, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(shard)));
            ByteArrays$.MODULE$.writeShort(b2, bytes, 1);
            ByteArrays$.MODULE$.writeLong(s, bytes, 3);
            ByteArrays$.MODULE$.writeInt((int)t2, bytes, 11);
            System.arraycopy(id, 0, bytes, 15, id.length);
        }
        return new package.SingleRowKeyValue<package.S3IndexKey>(bytes, this.sharing(), shard, new package.S3IndexKey(b2, s, (int)t2), tier, id, writable.values());
    }

    @Override
    public package.S3IndexValues getIndexValues(Filter filter, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter, this.geomField, FilterHelper$.MODULE$.extractGeometries$default$3());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)new .colon.colon((Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon(), (List)Nil$.MODULE$), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$1 = filter;
        String x$22 = this.dtgField;
        boolean x$3 = true;
        boolean x$4 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$1, x$22, x$4, true);
        explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Geometries: ").append(geometries).toString());
        explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Intervals: ").append(intervals).toString());
        if (geometries.disjoint() || intervals.disjoint()) {
            explain.apply((Function0<String>)(Function0 & Serializable)() -> "Disjoint geometries or dates extracted, short-circuiting to empty query");
            return new package.S3IndexValues(this.sfc(), this.maxTime(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)package$.MODULE$.Seq().empty()), (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)((Seq)package$.MODULE$.Seq().empty()));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1 & Serializable)x$2 -> GeometryUtils$.MODULE$.bounds(x$2, multiplier, bits));
        scala.collection.mutable.Map timesByBin = ((scala.collection.mutable.Map)Map$.MODULE$.empty()).withDefaultValue((Object)package$.MODULE$.Seq().empty());
        Builder unboundedBins = package$.MODULE$.Seq().newBuilder();
        intervals.foreach((Function1 & Serializable)interval -> {
            Tuple2 tuple2 = (Tuple2)this.boundsToDates().apply((Object)interval.bounds());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ZonedDateTime lower = (ZonedDateTime)tuple2._1();
            ZonedDateTime upper = (ZonedDateTime)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)lower, (Object)upper);
            ZonedDateTime lower2 = (ZonedDateTime)tuple22._1();
            ZonedDateTime upper2 = (ZonedDateTime)tuple22._2();
            BinnedTime binnedTime = (BinnedTime)this.dateToIndex().apply((Object)lower2);
            if (binnedTime == null) {
                throw new MatchError((Object)binnedTime);
            }
            short lb = binnedTime.bin();
            long lt = binnedTime.offset();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
            short lb2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long lt2 = tuple23._2$mcJ$sp();
            BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex().apply((Object)upper2);
            if (binnedTime2 == null) {
                throw new MatchError((Object)binnedTime2);
            }
            short ub = binnedTime2.bin();
            long ut = binnedTime2.offset();
            Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
            short ub2 = BoxesRunTime.unboxToShort((Object)tuple24._1());
            long ut2 = tuple24._2$mcJ$sp();
            if (interval.isBoundedBothSides()) {
                if (lb2 == ub2) {
                    timesByBin.update((Object)BoxesRunTime.boxToShort((short)lb2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcII.sp((int)lt2, (int)ut2), (List)Nil$.MODULE$)));
                    return BoxedUnit.UNIT;
                }
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)lb2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcII.sp((int)lt2, this.maxTime()), (List)Nil$.MODULE$)));
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)ub2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcII.sp(0, (int)ut2), (List)Nil$.MODULE$)));
                package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)b -> timesByBin.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)new .colon.colon((Object)new Tuple2.mcII.sp(0, this.maxTime()), (List)Nil$.MODULE$)));
                return BoxedUnit.UNIT;
            }
            if (interval.lower().value().isDefined()) {
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)lb2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcII.sp((int)lt2, this.maxTime()), (List)Nil$.MODULE$)));
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)(lb2 + 1))), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            }
            if (interval.upper().value().isDefined()) {
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)ub2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcII.sp(0, (int)ut2), (List)Nil$.MODULE$)));
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)0), (Object)BoxesRunTime.boxToShort((short)((short)(ub2 - 1)))));
            }
            return BoxedUnit.UNIT;
        });
        return new package.S3IndexValues(this.sfc(), this.maxTime(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)timesByBin.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq<Tuple2<Object, Object>>)((Seq)unboundedBins.result()));
    }

    @Override
    public Iterator<package.ScanRange<package.S3IndexKey>> getRanges(package.S3IndexValues values, int multiplier) {
        package.S3IndexValues s3IndexValues = values;
        if (s3IndexValues == null) {
            throw new MatchError((Object)s3IndexValues);
        }
        S2SFC s3 = s3IndexValues.sfc();
        FilterValues<Geometry> geoms = s3IndexValues.geometries();
        Seq<Tuple4<Object, Object, Object, Object>> xy = s3IndexValues.spatialBounds();
        FilterValues<Bounds<ZonedDateTime>> intervals = s3IndexValues.intervals();
        Map<Object, Seq<Tuple2<Object, Object>>> timesByBin = s3IndexValues.temporalBounds();
        Seq<Tuple2<Object, Object>> unboundedBins = s3IndexValues.temporalUnbounded();
        Tuple6 tuple6 = new Tuple6((Object)s3, geoms, xy, intervals, timesByBin, unboundedBins);
        S2SFC s32 = (S2SFC)tuple6._1();
        FilterValues geoms2 = (FilterValues)tuple6._2();
        Seq xy2 = (Seq)tuple6._3();
        FilterValues intervals2 = (FilterValues)tuple6._4();
        Map timesByBin2 = (Map)tuple6._5();
        Seq unboundedBins2 = (Seq)tuple6._6();
        if (geoms2.disjoint() || intervals2.disjoint()) {
            return package$.MODULE$.Iterator().empty();
        }
        if (timesByBin2.isEmpty() && unboundedBins2.isEmpty()) {
            return package$.MODULE$.Iterator().single(new package.UnboundedRange<Object>(null));
        }
        Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1 & Serializable)t -> BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(1, timesByBin2.isEmpty() ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(t)) : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(t)) / timesByBin2.size() / multiplier)));
        Seq s2CellId = s32.ranges(xy2, -1, target);
        Iterator bounded = timesByBin2.iterator().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Seq times = (Seq)tuple2._2();
                return (Seq)times.flatMap((Function1 & Serializable)time -> (Seq)s2CellId.map((Function1 & Serializable)s -> new package.BoundedRange<package.S3IndexKey>(new package.S3IndexKey(bin, s.lower(), time._1$mcI$sp()), new package.S3IndexKey(bin, s.upper(), time._2$mcI$sp()))));
            }
            throw new MatchError((Object)tuple2);
        });
        Iterator unbounded = unboundedBins2.iterator().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short s2 = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (0 == s && Short.MAX_VALUE == s2) {
                    return new package.UnboundedRange<package.S3IndexKey>(new package.S3IndexKey(0, 0L, 0));
                }
            }
            if (tuple2 != null) {
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (Short.MAX_VALUE == s) {
                    return new package.LowerBoundedRange<package.S3IndexKey>(new package.S3IndexKey(lower, 0L, 0));
                }
            }
            if (tuple2 != null) {
                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (0 == s) {
                    return new package.UpperBoundedRange<package.S3IndexKey>(new package.S3IndexKey(upper, 0L, Integer.MAX_VALUE));
                }
            }
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unexpected unbounded bin endpoints: {}:{}", new Object[]{BoxesRunTime.boxToShort((short)lower), BoxesRunTime.boxToShort((short)upper)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new package.UnboundedRange<package.S3IndexKey>(new package.S3IndexKey(0, 0L, 0));
            }
            throw new MatchError((Object)tuple2);
        });
        return bounded.$plus$plus((Function0 & Serializable)() -> unbounded);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<package.S3IndexKey>> ranges, boolean tier) {
        if (this.sharding().length() == 0) {
            return ranges.map((Function1 & Serializable)x0$1 -> {
                package.ScanRange scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    package.S3IndexKey lo = (package.S3IndexKey)boundedRange.lower();
                    package.S3IndexKey hi = (package.S3IndexKey)boundedRange.upper();
                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset());
                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset());
                    return new package.BoundedByteRange(lower, upper);
                }
                if (scanRange instanceof package.LowerBoundedRange) {
                    package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                    package.S3IndexKey lo = (package.S3IndexKey)lowerBoundedRange.lower();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset()), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                if (scanRange instanceof package.UpperBoundedRange) {
                    package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                    package.S3IndexKey hi = (package.S3IndexKey)upperBoundedRange.upper();
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset()));
                }
                if (scanRange instanceof package.UnboundedRange) {
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }
        return ranges.flatMap((Function1 & Serializable)x0$2 -> {
            package.ScanRange scanRange = x0$2;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                package.S3IndexKey lo = (package.S3IndexKey)boundedRange.lower();
                package.S3IndexKey hi = (package.S3IndexKey)boundedRange.upper();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset());
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset());
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            if (scanRange instanceof package.LowerBoundedRange) {
                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                package.S3IndexKey lo = (package.S3IndexKey)lowerBoundedRange.lower();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.s(), lo.offset());
                byte[] upper = package$ByteRange$.MODULE$.UnboundedUpperRange();
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            if (scanRange instanceof package.UpperBoundedRange) {
                package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                package.S3IndexKey hi = (package.S3IndexKey)upperBoundedRange.upper();
                byte[] lower = package$ByteRange$.MODULE$.UnboundedLowerRange();
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.s(), hi.offset());
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            if (scanRange instanceof package.UnboundedRange) {
                return new .colon.colon((Object)new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange()), (List)Nil$.MODULE$);
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
    }

    @Override
    public boolean useFullFilter(Option<package.S3IndexValues> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return true;
    }

    public S3IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField, String dtgField) {
        this.sft = sft;
        this.sharding = sharding;
        this.geomField = geomField;
        this.dtgField = dtgField;
        LazyLogging.$init$((LazyLogging)this);
        Predef$.MODULE$.require(Point.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0 & Serializable)() -> new StringBuilder(61).append("Expected field ").append($this.geomField).append(" to have a point binding, but instead it has: ").append(this.sft().getDescriptor($this.geomField).getType().getBinding().getSimpleName()).toString());
        Predef$.MODULE$.require(Date.class.isAssignableFrom(sft.getDescriptor(dtgField).getType().getBinding()), (Function0 & Serializable)() -> new StringBuilder(60).append("Expected field ").append($this.dtgField).append(" to have a date binding, but instead it has: ").append(this.sft().getDescriptor($this.dtgField).getType().getBinding().getSimpleName()).toString());
        this.sfc = S2SFC$.MODULE$.apply(QueryProperties$.MODULE$.S2MinLevel(), QueryProperties$.MODULE$.S2MaxLevel(), QueryProperties$.MODULE$.S2LevelMod(), QueryProperties$.MODULE$.S2MaxCells());
        this.geomIndex = sft.indexOf(geomField);
        this.dtgIndex = sft.indexOf(dtgField);
        this.timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.maxTime = (int)BinnedTime$.MODULE$.maxOffset(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getS3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.attributes = new .colon.colon((Object)geomField, (List)new .colon.colon((Object)dtgField, (List)Nil$.MODULE$));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(14 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }
}

