/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2;

import java.io.Serializable;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.XZ2SFC;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$BoundedRange$mcJ$sp;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z2.XZ2IndexKeySpace$;
import org.locationtech.geomesa.index.index.z2.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001B\u000f\u001f\u0001)B\u0001B\u0011\u0001\u0003\u0006\u0004%\ta\u0011\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\t\"Aq\n\u0001BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003R\u0011!)\u0006A!A!\u0002\u00131\u0006\"B1\u0001\t\u0003\u0011\u0007bB4\u0001\u0005\u0004%\t\u0002\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000f5\u0004!\u0019!C\t]\"1Q\u000f\u0001Q\u0001\n=DqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001f\u0005\by\u0002\u0011\r\u0011\"\u0011~\u0011\u001d\ti\u0001\u0001Q\u0001\nyD\u0011\"a\u0004\u0001\u0005\u0004%\t%!\u0005\t\u0011\u0005-\u0002\u0001)A\u0005\u0003'A\u0011\"!\f\u0001\u0005\u0004%\t%a\f\t\u0011\u0005E\u0002\u0001)A\u0005\u0003?Aq!a\r\u0001\t\u0003\n)\u0004C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\"9\u0011q\u0015\u0001\u0005B\u0005%\u0006bBA]\u0001\u0011\u0005\u00131X\u0004\b\u0003ot\u0002\u0012AA}\r\u0019ib\u0004#\u0001\u0002|\"1\u0011-\u0007C\u0001\u0005\u0017AqA!\u0004\u001a\t\u0003\u0012y\u0001C\u0004\u0003\u0016e!\tEa\u0006\u0003!aS&'\u00138eKb\\U-_*qC\u000e,'BA\u0010!\u0003\tQ(G\u0003\u0002\"E\u0005)\u0011N\u001c3fq*\u0011\u0011e\t\u0006\u0003I\u0015\nqaZ3p[\u0016\u001c\u0018M\u0003\u0002'O\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0001&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001WE\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u001a6o}j\u0011a\r\u0006\u0003i\t\n1!\u00199j\u0013\t14GA\u0007J]\u0012,\u0007pS3z'B\f7-\u001a\t\u0003qqr!!\u000f\u001e\u000e\u0003yI!a\u000f\u0010\u0002\u000fA\f7m[1hK&\u0011QH\u0010\u0002\u000f1j\u0013\u0014J\u001c3fqZ\u000bG.^3t\u0015\tYd\u0004\u0005\u0002-\u0001&\u0011\u0011)\f\u0002\u0005\u0019>tw-A\u0002tMR,\u0012\u0001\u0012\t\u0003\u000b2k\u0011A\u0012\u0006\u0003\u000f\"\u000baa]5na2,'BA%K\u0003\u001d1W-\u0019;ve\u0016T!aS\u0014\u0002\u000f=\u0004XM\\4jg&\u0011QJ\u0012\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\n\u0001b\u001d5be\u0012LgnZ\u000b\u0002#B\u0011!GU\u0005\u0003'N\u0012Qb\u00155be\u0012\u001cFO]1uK\u001eL\u0018!C:iCJ$\u0017N\\4!\u0003%9Wm\\7GS\u0016dG\r\u0005\u0002X=:\u0011\u0001\f\u0018\t\u000336j\u0011A\u0017\u0006\u00037&\na\u0001\u0010:p_Rt\u0014BA/.\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005uk\u0013A\u0002\u001fj]&$h\b\u0006\u0003dI\u00164\u0007CA\u001d\u0001\u0011\u0015\u0011e\u00011\u0001E\u0011\u0015ye\u00011\u0001R\u0011\u0015)f\u00011\u0001W\u0003%9Wm\\7J]\u0012,\u00070F\u0001j!\ta#.\u0003\u0002l[\t\u0019\u0011J\u001c;\u0002\u0015\u001d,w.\\%oI\u0016D\b%A\u0002tM\u000e,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003e\u000e\nQaY;sm\u0016L!\u0001^9\u0003\raS&g\u0015$D\u0003\u0011\u0019hm\u0019\u0011\u0002\u0011%\u001c\bk\\5oiN,\u0012\u0001\u001f\t\u0003YeL!A_\u0017\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011n\u001d)pS:$8\u000fI\u0001\u000bCR$(/\u001b2vi\u0016\u001cX#\u0001@\u0011\t}\f9A\u0016\b\u0005\u0003\u0003\t)AD\u0002Z\u0003\u0007I\u0011AL\u0005\u0003w5JA!!\u0003\u0002\f\t\u00191+Z9\u000b\u0005mj\u0013aC1uiJL'-\u001e;fg\u0002\n!#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQV\u0011\u00111\u0003\t\u0007\u007f\u0006U\u0011\u0011D5\n\t\u0005]\u00111\u0002\u0002\u0006%&<\u0007\u000e\u001e\t\tY\u0005m\u0011qD5jS&\u0019\u0011QD\u0017\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004#\u0002\u0017\u0002\"\u0005\u0015\u0012bAA\u0012[\t)\u0011I\u001d:bsB\u0019A&a\n\n\u0007\u0005%RF\u0001\u0003CsR,\u0017aE5oI\u0016D8*Z=CsR,G*\u001a8hi\"\u0004\u0013aB:iCJLgnZ\u000b\u0003\u0003?\t\u0001b\u001d5be&tw\rI\u0001\u000bi>Le\u000eZ3y\u0017\u0016LHCCA\u001c\u0003/\n\t'!\u001a\u0002jA)\u0011\u0011HA)\u007f9!\u00111HA(\u001d\u0011\ti$!\u0014\u000f\t\u0005}\u00121\n\b\u0005\u0003\u0003\nIE\u0004\u0003\u0002D\u0005\u001dcbA-\u0002F%\t\u0001&\u0003\u0002'O%\u0011A%J\u0005\u0003C\rJ!\u0001\u000e\u0012\n\u0005m\u001a\u0014\u0002BA*\u0003+\u00121BU8x\u0017\u0016Lh+\u00197vK*\u00111h\r\u0005\b\u00033\u001a\u0002\u0019AA.\u0003!9(/\u001b;bE2,\u0007c\u0001\u001a\u0002^%\u0019\u0011qL\u001a\u0003\u001f]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016Dq!a\u0019\u0014\u0001\u0004\ty\"\u0001\u0003uS\u0016\u0014\bbBA4'\u0001\u0007\u0011qD\u0001\u0003S\u0012D\u0001\"a\u001b\u0014!\u0003\u0005\r\u0001_\u0001\bY\u0016t\u0017.\u001a8u\u000399W\r^%oI\u0016Dh+\u00197vKN$RaNA9\u0003\u007fBq!a\u001d\u0015\u0001\u0004\t)(\u0001\u0004gS2$XM\u001d\t\u0005\u0003o\nY(\u0004\u0002\u0002z)\u0019\u00111\u000f&\n\t\u0005u\u0014\u0011\u0010\u0002\u0007\r&dG/\u001a:\t\u000f\u0005\u0005E\u00031\u0001\u0002\u0004\u00069Q\r\u001f9mC&t\u0007\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%%%A\u0003vi&d7/\u0003\u0003\u0002\u000e\u0006\u001d%!C#ya2\f\u0017N\\3s\u0003%9W\r\u001e*b]\u001e,7\u000f\u0006\u0004\u0002\u0014\u0006}\u00151\u0015\t\u0006\u007f\u0006U\u0015\u0011T\u0005\u0005\u0003/\u000bYA\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0015\tI$a'@\u0013\u0011\ti*!\u0016\u0003\u0013M\u001b\u0017M\u001c*b]\u001e,\u0007BBAQ+\u0001\u0007q'\u0001\u0004wC2,Xm\u001d\u0005\t\u0003K+\u0002\u0013!a\u0001S\u0006QQ.\u001e7uSBd\u0017.\u001a:\u0002\u001b\u001d,GOU1oO\u0016\u0014\u0015\u0010^3t)\u0019\tY+a-\u00028B)q0!&\u0002.B!\u0011\u0011HAX\u0013\u0011\t\t,!\u0016\u0003\u0013\tKH/\u001a*b]\u001e,\u0007bBA[-\u0001\u0007\u00111S\u0001\u0007e\u0006tw-Z:\t\u0011\u0005\rd\u0003%AA\u0002a\fQ\"^:f\rVdGNR5mi\u0016\u0014Hc\u0002=\u0002>\u0006\u0015\u0017\u0011\u001d\u0005\b\u0003C;\u0002\u0019AA`!\u0011a\u0013\u0011Y\u001c\n\u0007\u0005\rWF\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000f<\u0002\u0019AAe\u0003\u0019\u0019wN\u001c4jOB)A&!1\u0002LB!\u0011QZAn\u001d\u0011\ty-!6\u000f\t\u0005u\u0012\u0011[\u0005\u0004\u0003'\u0014\u0013\u0001C4f_R|w\u000e\\:\n\t\u0005]\u0017\u0011\\\u0001\u0018\u000f\u0016|W*Z:b\t\u0006$\u0018m\u0015;pe\u00164\u0015m\u0019;pefT1!a5#\u0013\u0011\ti.a8\u0003-\u001d+w.T3tC\u0012\u000bG/Y*u_J,7i\u001c8gS\u001eTA!a6\u0002Z\"9\u00111]\fA\u0002\u0005\u0015\u0018!\u00025j]R\u001c\b\u0003BAt\u0003gl!!!;\u000b\t\u0005-\u0018Q^\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\ty/!=\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0003'<\u0013\u0002BA{\u0003S\u0014Q\u0001S5oiN\f\u0001\u0003\u0017.3\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0005eJ2\u0003B\r,\u0003{\u0004b!a@\u0003\u0006]zd\u0002BA\u001e\u0005\u0003I1Aa\u00014\u00035Ie\u000eZ3y\u0017\u0016L8\u000b]1dK&!!q\u0001B\u0005\u0005QIe\u000eZ3y\u0017\u0016L8\u000b]1dK\u001a\u000b7\r^8ss*\u0019!1A\u001a\u0015\u0005\u0005e\u0018\u0001C:vaB|'\u000f^:\u0015\u000ba\u0014\tBa\u0005\t\u000b\t[\u0002\u0019\u0001#\t\u000bq\\\u0002\u0019\u0001@\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\r\u0014IBa\u0007\u0003\u001e!)!\t\ba\u0001\t\")A\u0010\ba\u0001}\"1\u00111\r\u000fA\u0002a\u0004")
public class XZ2IndexKeySpace
implements IndexKeySpace<package.XZ2IndexValues, Object> {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String geomField;
    private final int geomIndex;
    private final XZ2SFC sfc;
    private final boolean isPoints;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;

    public static XZ2IndexKeySpace apply(SimpleFeatureType sft, Seq<String> attributes2, boolean tier) {
        return XZ2IndexKeySpace$.MODULE$.apply(sft, (Seq)attributes2, tier);
    }

    public static boolean supports(SimpleFeatureType sft, Seq<String> attributes2) {
        return XZ2IndexKeySpace$.MODULE$.supports(sft, attributes2);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public XZ2SFC sfc() {
        return this.sfc;
    }

    private boolean isPoints() {
        return this.isPoints;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    @Override
    public package.RowKeyValue<Object> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        long l;
        Geometry geom = (Geometry)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
        }
        Envelope envelope = geom.getEnvelopeInternal();
        try {
            l = this.sfc().index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), lenient);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(32).append("Invalid xz value from geometry: ").append(geom).toString(), e);
            }
            throw throwable;
        }
        long xz = l;
        byte[] shard = this.sharding().apply(writable);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 8 + id.length, (ClassTag)ClassTag$.MODULE$.Byte());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(shard))) {
            ByteArrays$.MODULE$.writeLong(xz, bytes, 0);
            System.arraycopy(id, 0, bytes, 8, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(shard)));
            ByteArrays$.MODULE$.writeLong(xz, bytes, 1);
            System.arraycopy(id, 0, bytes, 9, id.length);
        }
        return new package.SingleRowKeyValue<Object>(bytes, this.sharing(), shard, BoxesRunTime.boxToLong((long)xz), tier, id, writable.values());
    }

    @Override
    public package.XZ2IndexValues getIndexValues(Filter filter, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter, this.geomField, this.isPoints());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)new .colon.colon((Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon(), (List)Nil$.MODULE$), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Geometries: ").append(geometries).toString());
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1 & Serializable)x$1 -> GeometryUtils$.MODULE$.bounds(x$1, multiplier, bits));
        return new package.XZ2IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    @Override
    public Iterator<package.ScanRange<Object>> getRanges(package.XZ2IndexValues values, int multiplier) {
        package.XZ2IndexValues xZ2IndexValues = values;
        if (xZ2IndexValues == null) {
            throw new MatchError((Object)xZ2IndexValues);
        }
        XZ2SFC sfc = xZ2IndexValues.sfc();
        Seq<Tuple4<Object, Object, Object, Object>> xy = xZ2IndexValues.spatialBounds();
        Tuple2 tuple2 = new Tuple2((Object)sfc, xy);
        XZ2SFC sfc2 = (XZ2SFC)tuple2._1();
        Seq xy2 = (Seq)tuple2._2();
        Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1 & Serializable)t -> BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(1, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(t)) / multiplier)));
        return sfc2.ranges(xy2, target).iterator().map((Function1 & Serializable)r -> new package$BoundedRange$mcJ$sp(r.lower(), r.upper()));
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<Object>> ranges, boolean tier) {
        if (this.sharding().length() == 0) {
            return ranges.map((Function1 & Serializable)x0$1 -> {
                package.ScanRange scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }
        return ranges.flatMap((Function1 & Serializable)x0$2 -> {
            package.ScanRange scanRange = x0$2;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                long lo = boundedRange.lower$mcJ$sp();
                long hi = boundedRange.upper$mcJ$sp();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
    }

    @Override
    public boolean useFullFilter(Option<package.XZ2IndexValues> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return true;
    }

    public XZ2IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField) {
        this.sft = sft;
        this.sharding = sharding;
        this.geomField = geomField;
        Predef$.MODULE$.require(Geometry.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0 & Serializable)() -> new StringBuilder(64).append("Expected field ").append($this.geomField).append(" to have a geometry binding, but instead it has: ").append(this.sft().getDescriptor($this.geomField).getType().getBinding().getSimpleName()).toString());
        this.geomIndex = sft.indexOf(geomField);
        this.sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Class clazz = sft.getDescriptor(this.geomIndex()).getType().getBinding();
        Class<Point> clazz2 = Point.class;
        this.isPoints = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        this.attributes = new .colon.colon((Object)geomField, (List)Nil$.MODULE$);
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(8 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }
}

