/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2;

import java.io.Serializable;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.Z2SFC;
import org.locationtech.geomesa.curve.Z2SFC$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$BoundedRange$mcJ$sp;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z2.Z2IndexKeySpace$;
import org.locationtech.geomesa.index.index.z2.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.java8.JFunction0;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tUa\u0001B\u000e\u001d\u0001!B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\n\u0001BC\u0002\u0013\u0005a\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003P\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\"B0\u0001\t\u0003\u0001\u0007bB3\u0001\u0005\u0004%\tB\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B4\t\u000f9\u0004!\u0019!C\t_\"11\u000f\u0001Q\u0001\nADq\u0001\u001e\u0001C\u0002\u0013\u0005S\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA\u001e\u0005\t\u007f\u0002\u0011\r\u0011\"\u0011\u0002\u0002!A\u00111\u0004\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0011\u0002 !A\u0011\u0011\u0005\u0001!\u0002\u0013\ty\u0001C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003_\u0003A\u0011IAY\u000f\u001d\ti\u000f\bE\u0001\u0003_4aa\u0007\u000f\t\u0002\u0005E\bBB0\u0018\t\u0003\u0011\t\u0001C\u0004\u0003\u0004]!\tE!\u0002\t\u000f\t-q\u0003\"\u0011\u0003\u000e\ty!LM%oI\u0016D8*Z=Ta\u0006\u001cWM\u0003\u0002\u001e=\u0005\u0011!P\r\u0006\u0003?\u0001\nQ!\u001b8eKbT!aH\u0011\u000b\u0005\t\u001a\u0013aB4f_6,7/\u0019\u0006\u0003I\u0015\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0004\u0001%z\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00031gUjT\"A\u0019\u000b\u0005I\u0002\u0013aA1qS&\u0011A'\r\u0002\u000e\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0005YRdBA\u001c9\u001b\u0005a\u0012BA\u001d\u001d\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u000f\u001f\u0003\u001bi\u0013\u0014J\u001c3fqZ\u000bG.^3t\u0015\tID\u0004\u0005\u0002+}%\u0011qh\u000b\u0002\u0005\u0019>tw-A\u0002tMR,\u0012A\u0011\t\u0003\u0007*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000baa]5na2,'BA$I\u0003\u001d1W-\u0019;ve\u0016T!!S\u0013\u0002\u000f=\u0004XM\\4jg&\u00111\n\u0012\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\n\u0001b\u001d5be\u0012LgnZ\u000b\u0002\u001fB\u0011\u0001\u0007U\u0005\u0003#F\u0012Qb\u00155be\u0012\u001cFO]1uK\u001eL\u0018!C:iCJ$\u0017N\\4!\u0003%9Wm\\7GS\u0016dG\r\u0005\u0002V9:\u0011aK\u0017\t\u0003/.j\u0011\u0001\u0017\u0006\u00033\u001e\na\u0001\u0010:p_Rt\u0014BA.,\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m[\u0013A\u0002\u001fj]&$h\b\u0006\u0003bE\u000e$\u0007CA\u001c\u0001\u0011\u0015\u0001e\u00011\u0001C\u0011\u0015ie\u00011\u0001P\u0011\u0015\u0019f\u00011\u0001U\u0003\r\u0019hmY\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!.I\u0001\u0006GV\u0014h/Z\u0005\u0003Y&\u0014QA\u0017\u001aT\r\u000e\u000bAa\u001d4dA\u0005Iq-Z8n\u0013:$W\r_\u000b\u0002aB\u0011!&]\u0005\u0003e.\u00121!\u00138u\u0003)9Wm\\7J]\u0012,\u0007\u0010I\u0001\u000bCR$(/\u001b2vi\u0016\u001cX#\u0001<\u0011\u0007]\\HK\u0004\u0002yu:\u0011q+_\u0005\u0002Y%\u0011\u0011hK\u0005\u0003yv\u00141aU3r\u0015\tI4&A\u0006biR\u0014\u0018NY;uKN\u0004\u0013AE5oI\u0016D8*Z=CsR,G*\u001a8hi\",\"!a\u0001\u0011\r]\f)!!\u0003q\u0013\r\t9! \u0002\u0006%&<\u0007\u000e\u001e\t\tU\u0005-\u0011q\u00029qa&\u0019\u0011QB\u0016\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004#\u0002\u0016\u0002\u0012\u0005U\u0011bAA\nW\t)\u0011I\u001d:bsB\u0019!&a\u0006\n\u0007\u0005e1F\u0001\u0003CsR,\u0017aE5oI\u0016D8*Z=CsR,G*\u001a8hi\"\u0004\u0013aB:iCJLgnZ\u000b\u0003\u0003\u001f\t\u0001b\u001d5be&tw\rI\u0001\u000bi>Le\u000eZ3y\u0017\u0016LHCCA\u0014\u0003\u000f\n\t&!\u0016\u0002ZA)\u0011\u0011FA!{9!\u00111FA \u001d\u0011\ti#!\u0010\u000f\t\u0005=\u00121\b\b\u0005\u0003c\tID\u0004\u0003\u00024\u0005]bbA,\u00026%\ta%\u0003\u0002%K%\u0011!eI\u0005\u0003?\u0005J!A\r\u0011\n\u0005e\n\u0014\u0002BA\"\u0003\u000b\u00121BU8x\u0017\u0016Lh+\u00197vK*\u0011\u0011(\r\u0005\b\u0003\u0013\n\u0002\u0019AA&\u0003!9(/\u001b;bE2,\u0007c\u0001\u0019\u0002N%\u0019\u0011qJ\u0019\u0003\u001f]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016Dq!a\u0015\u0012\u0001\u0004\ty!\u0001\u0003uS\u0016\u0014\bbBA,#\u0001\u0007\u0011qB\u0001\u0003S\u0012D\u0011\"a\u0017\u0012!\u0003\u0005\r!!\u0018\u0002\u000f1,g.[3oiB\u0019!&a\u0018\n\u0007\u0005\u00054FA\u0004C_>dW-\u00198\u0002\u001d\u001d,G/\u00138eKb4\u0016\r\\;fgR)Q'a\u001a\u0002v!9\u0011\u0011\u000e\nA\u0002\u0005-\u0014A\u00024jYR,'\u000f\u0005\u0003\u0002n\u0005ETBAA8\u0015\r\tI\u0007S\u0005\u0005\u0003g\nyG\u0001\u0004GS2$XM\u001d\u0005\b\u0003o\u0012\u0002\u0019AA=\u0003\u001d)\u0007\u0010\u001d7bS:\u0004B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007f\u0002\u0013!B;uS2\u001c\u0018\u0002BAB\u0003{\u0012\u0011\"\u0012=qY\u0006Lg.\u001a:\u0002\u0013\u001d,GOU1oO\u0016\u001cHCBAE\u0003+\u000bI\nE\u0003x\u0003\u0017\u000by)C\u0002\u0002\u000ev\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0006\u0003S\t\t*P\u0005\u0005\u0003'\u000b)EA\u0005TG\u0006t'+\u00198hK\"1\u0011qS\nA\u0002U\naA^1mk\u0016\u001c\b\u0002CAN'A\u0005\t\u0019\u00019\u0002\u00155,H\u000e^5qY&,'/A\u0007hKR\u0014\u0016M\\4f\u0005f$Xm\u001d\u000b\u0007\u0003C\u000bI+!,\u0011\u000b]\fY)a)\u0011\t\u0005%\u0012QU\u0005\u0005\u0003O\u000b)EA\u0005CsR,'+\u00198hK\"9\u00111\u0016\u000bA\u0002\u0005%\u0015A\u0002:b]\u001e,7\u000fC\u0005\u0002TQ\u0001\n\u00111\u0001\u0002^\u0005iQo]3Gk2dg)\u001b7uKJ$\u0002\"!\u0018\u00024\u0006m\u0016q\u001b\u0005\b\u0003/+\u0002\u0019AA[!\u0011Q\u0013qW\u001b\n\u0007\u0005e6F\u0001\u0004PaRLwN\u001c\u0005\b\u0003{+\u0002\u0019AA`\u0003\u0019\u0019wN\u001c4jOB)!&a.\u0002BB!\u00111YAi\u001d\u0011\t)-a3\u000f\t\u00055\u0012qY\u0005\u0004\u0003\u0013\u0004\u0013\u0001C4f_R|w\u000e\\:\n\t\u00055\u0017qZ\u0001\u0018\u000f\u0016|W*Z:b\t\u0006$\u0018m\u0015;pe\u00164\u0015m\u0019;pefT1!!3!\u0013\u0011\t\u0019.!6\u0003-\u001d+w.T3tC\u0012\u000bG/Y*u_J,7i\u001c8gS\u001eTA!!4\u0002P\"9\u0011\u0011\\\u000bA\u0002\u0005m\u0017!\u00025j]R\u001c\b\u0003BAo\u0003Sl!!a8\u000b\t\u0005\u0005\u00181]\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t)/a:\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0003\u0013,\u0013\u0002BAv\u0003?\u0014Q\u0001S5oiN\fqB\u0017\u001aJ]\u0012,\u0007pS3z'B\f7-\u001a\t\u0003o]\u0019BaF\u0015\u0002tB1\u0011Q_A~kurA!a\u000b\u0002x&\u0019\u0011\u0011`\u0019\u0002\u001b%sG-\u001a=LKf\u001c\u0006/Y2f\u0013\u0011\ti0a@\u0003)%sG-\u001a=LKf\u001c\u0006/Y2f\r\u0006\u001cGo\u001c:z\u0015\r\tI0\r\u000b\u0003\u0003_\f\u0001b];qa>\u0014Ho\u001d\u000b\u0007\u0003;\u00129A!\u0003\t\u000b\u0001K\u0002\u0019\u0001\"\t\u000bQL\u0002\u0019\u0001<\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\u0005\u0014yA!\u0005\u0003\u0014!)\u0001I\u0007a\u0001\u0005\")AO\u0007a\u0001m\"9\u00111\u000b\u000eA\u0002\u0005u\u0003")
public class Z2IndexKeySpace
implements IndexKeySpace<package.Z2IndexValues, Object> {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String geomField;
    private final Z2SFC sfc;
    private final int geomIndex;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;

    public static Z2IndexKeySpace apply(SimpleFeatureType sft, Seq<String> attributes2, boolean tier) {
        return Z2IndexKeySpace$.MODULE$.apply(sft, (Seq)attributes2, tier);
    }

    public static boolean supports(SimpleFeatureType sft, Seq<String> attributes2) {
        return Z2IndexKeySpace$.MODULE$.supports(sft, attributes2);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public Z2SFC sfc() {
        return this.sfc;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    @Override
    public package.RowKeyValue<Object> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        long l;
        Point geom = (Point)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
        }
        try {
            l = this.sfc().index(geom.getX(), geom.getY(), lenient);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(31).append("Invalid z value from geometry: ").append(geom).toString(), e);
            }
            throw throwable;
        }
        long z = l;
        byte[] shard = this.sharding().apply(writable);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 8 + id.length, (ClassTag)ClassTag$.MODULE$.Byte());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(shard))) {
            ByteArrays$.MODULE$.writeLong(z, bytes, 0);
            System.arraycopy(id, 0, bytes, 8, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(shard)));
            ByteArrays$.MODULE$.writeLong(z, bytes, 1);
            System.arraycopy(id, 0, bytes, 9, id.length);
        }
        return new package.SingleRowKeyValue<Object>(bytes, this.sharing(), shard, BoxesRunTime.boxToLong((long)z), tier, id, writable.values());
    }

    @Override
    public package.Z2IndexValues getIndexValues(Filter filter, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter, this.geomField, true);
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)new .colon.colon((Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon(), (List)Nil$.MODULE$), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Geometries: ").append(geometries).toString());
        if (geometries.disjoint()) {
            explain.apply((Function0<String>)(Function0 & Serializable)() -> "Non-intersecting geometries extracted, short-circuiting to empty query");
            return new package.Z2IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)package$.MODULE$.Seq().empty()));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1 & Serializable)x$1 -> GeometryUtils$.MODULE$.bounds(x$1, multiplier, bits));
        return new package.Z2IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    @Override
    public Iterator<package.ScanRange<Object>> getRanges(package.Z2IndexValues values, int multiplier) {
        package.Z2IndexValues z2IndexValues = values;
        if (z2IndexValues == null) {
            throw new MatchError((Object)z2IndexValues);
        }
        FilterValues<Geometry> geoms = z2IndexValues.geometries();
        Seq<Tuple4<Object, Object, Object, Object>> xy = z2IndexValues.spatialBounds();
        Tuple2 tuple2 = new Tuple2(geoms, xy);
        FilterValues geoms2 = (FilterValues)tuple2._1();
        Seq xy2 = (Seq)tuple2._2();
        if (geoms2.disjoint()) {
            return package$.MODULE$.Iterator().empty();
        }
        Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1 & Serializable)t -> BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(1, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(t)) / multiplier)));
        return this.sfc().ranges(xy2, 64, target).iterator().map((Function1 & Serializable)r -> new package$BoundedRange$mcJ$sp(r.lower(), r.upper()));
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<Object>> ranges, boolean tier) {
        if (this.sharding().length() == 0) {
            return ranges.map((Function1 & Serializable)x0$1 -> {
                package.ScanRange scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }
        return ranges.flatMap((Function1 & Serializable)x0$2 -> {
            package.ScanRange scanRange = x0$2;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                long lo = boundedRange.lower$mcJ$sp();
                long hi = boundedRange.upper$mcJ$sp();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
    }

    @Override
    public boolean useFullFilter(Option<package.Z2IndexValues> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        LazyBoolean simpleGeoms$lzy = new LazyBoolean();
        boolean looseBBox = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(hints.get((Object)QueryHints$.MODULE$.LOOSE_BBOX())).map((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Z2IndexKeySpace.$anonfun$useFullFilter$1(x))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> config.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Z2IndexKeySpace.$anonfun$useFullFilter$3(x$3)))));
        return !looseBBox || !Z2IndexKeySpace.simpleGeoms$1(simpleGeoms$lzy, values);
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$1(Object x) {
        return BoxesRunTime.unboxToBoolean((Object)x);
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$3(GeoMesaDataStoreFactory.GeoMesaDataStoreConfig x$3) {
        return x$3.queries().looseBBox();
    }

    private static final /* synthetic */ boolean simpleGeoms$lzycompute$1(LazyBoolean simpleGeoms$lzy$1, Option values$1) {
        boolean bl;
        LazyBoolean lazyBoolean = simpleGeoms$lzy$1;
        synchronized (lazyBoolean) {
            bl = simpleGeoms$lzy$1.initialized() ? simpleGeoms$lzy$1.value() : simpleGeoms$lzy$1.initialize(((IterableOnceOps)Option$.MODULE$.option2Iterable(values$1).toSeq().flatMap((Function1 & Serializable)x$4 -> x$4.geometries().values())).forall((Function1 & Serializable)geometry -> BoxesRunTime.boxToBoolean((boolean)GeometryUtils$.MODULE$.isRectangular(geometry))));
        }
        return bl;
    }

    private static final boolean simpleGeoms$1(LazyBoolean simpleGeoms$lzy$1, Option values$1) {
        if (simpleGeoms$lzy$1.initialized()) {
            return simpleGeoms$lzy$1.value();
        }
        return Z2IndexKeySpace.simpleGeoms$lzycompute$1(simpleGeoms$lzy$1, values$1);
    }

    public Z2IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField) {
        this.sft = sft;
        this.sharding = sharding;
        this.geomField = geomField;
        Predef$.MODULE$.require(Point.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0 & Serializable)() -> new StringBuilder(61).append("Expected field ").append($this.geomField).append(" to have a point binding, but instead it has: ").append(this.sft().getDescriptor($this.geomField).getType().getBinding().getSimpleName()).toString());
        this.sfc = Z2SFC$.MODULE$;
        this.geomIndex = sft.indexOf(geomField);
        this.attributes = new .colon.colon((Object)geomField, (List)Nil$.MODULE$);
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(8 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }
}

