/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2.legacy;

import java.io.Serializable;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.ShardStrategy$Z2ShardStrategy$;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.z2.Z2Index;
import org.locationtech.geomesa.index.index.z2.Z2IndexKeySpace;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u000f\u001e\u0001-B\u0011\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r$\t\u0013-\u0003!\u0011!Q\u0001\n13\u0006\"C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\\\u0011!a\u0006A!A!\u0002\u0013i\u0006\"\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5~\u0011\u0015q\b\u0001\"\u0005\u0000\u0011\u0019q\b\u0001\"\u0001\u0002\u0018!I\u00111\u0006\u0001C\u0002\u0013E\u0013Q\u0006\u0005\b\u0003_\u0001\u0001\u0015!\u0003^\u0011%\t\t\u0004\u0001b\u0001\n\u0003\n\u0019\u0004\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u001b\u000f\u001d\ti$\bE\u0001\u0003\u007f1a\u0001H\u000f\t\u0002\u0005\u0005\u0003B\u0002@\u000e\t\u0003\tIE\u0002\u0004\u0002L5\u0001\u0011Q\n\u0005\u000b\u0017>\u0011\t\u0011)A\u0005\u0019\u0006=\u0003BCA)\u001f\t\u0015\r\u0011\"\u0011\u0002T!Q\u0011\u0011M\b\u0003\u0002\u0003\u0006I!!\u0016\t\u0019\u0005\rtB!A!\u0002\u0013\t)'!\u001c\t\u0013\u0005=tB!A!\u0002\u0013i\u0006B\u0002@\u0010\t\u0003\t\t\bC\u0005\u0002\u0000=\u0011\r\u0011\"\u0003\u0002\u0002\"A\u0011QS\b!\u0002\u0013\t\u0019\tC\u0005\u0002\u0018>\u0011\r\u0011\"\u0011\u0002\u001a\"A\u0011qU\b!\u0002\u0013\tY\nC\u0004\u0002*>!\t%a+\t\u000f\u0005\rx\u0002\"\u0011\u0002f\nI!LM%oI\u0016Dh\u000b\u000e\u0006\u0003=}\ta\u0001\\3hC\u000eL(B\u0001\u0011\"\u0003\tQ(G\u0003\u0002#G\u0005)\u0011N\u001c3fq*\u0011!\u0005\n\u0006\u0003K\u0019\nqaZ3p[\u0016\u001c\u0018M\u0003\u0002(Q\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0011&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001YA\u0011QFL\u0007\u0002?%\u0011qf\b\u0002\b5JJe\u000eZ3y\u0003\t!7\u000f\r\u00023uA\u00191G\u000e\u001d\u000e\u0003QR!!N\u0012\u0002\u0011\u001d,w\u000e^8pYNL!a\u000e\u001b\u0003!\u001d+w.T3tC\u0012\u000bG/Y*u_J,\u0007CA\u001d;\u0019\u0001!\u0011bO\u0001\u0002\u0002\u0003\u0005)\u0011\u0001\u001f\u0003\u0007}#\u0013'\u0005\u0002>\u0007B\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t9aj\u001c;iS:<\u0007C\u0001 E\u0013\t)uHA\u0002B]fL!\u0001M$\n\u0005!K%aE$f_6+7/\u0019$fCR,(/Z%oI\u0016D(B\u0001&$\u0003\r\t\u0007/[\u0001\u0004g\u001a$\bCA'U\u001b\u0005q%BA(Q\u0003\u0019\u0019\u0018.\u001c9mK*\u0011\u0011KU\u0001\bM\u0016\fG/\u001e:f\u0015\t\u0019\u0006&A\u0004pa\u0016tw-[:\n\u0005Us%!E*j[BdWMR3biV\u0014X\rV=qK&\u00111jR\u0001\bm\u0016\u00148/[8o!\tq\u0014,\u0003\u0002[\u007f\t\u0019\u0011J\u001c;\n\u0005];\u0015\u0001B4f_6\u0004\"AX3\u000f\u0005}\u001b\u0007C\u00011@\u001b\u0005\t'B\u00012+\u0003\u0019a$o\\8u}%\u0011AmP\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002e\u007f\u0005!Qn\u001c3f!\tQ'P\u0004\u0002lo:\u0011A.\u001e\b\u0003[Nt!A\u001c:\u000f\u0005=\fhB\u00011q\u0013\u0005I\u0013BA\u0014)\u0013\t)c%\u0003\u0002uI\u0005)Q\u000f^5mg&\u0011!E\u001e\u0006\u0003i\u0012J!\u0001_=\u0002\u0013%sG-\u001a=N_\u0012,'B\u0001\u0012w\u0013\tYHPA\u0005J]\u0012,\u00070T8eK*\u0011\u00010_\u0005\u0003Q\u001e\u000ba\u0001P5oSRtD\u0003DA\u0001\u0003\u000b\ty!!\u0005\u0002\u0014\u0005U\u0001cAA\u0002\u00015\tQ\u0004\u0003\u00041\r\u0001\u0007\u0011q\u0001\u0019\u0005\u0003\u0013\ti\u0001\u0005\u00034m\u0005-\u0001cA\u001d\u0002\u000e\u0011Q1(!\u0002\u0002\u0002\u0003\u0005)\u0011\u0001\u001f\t\u000b-3\u0001\u0019\u0001'\t\u000b]3\u0001\u0019\u0001-\t\u000bq3\u0001\u0019A/\t\u000b!4\u0001\u0019A5\u0015\u0015\u0005\u0005\u0011\u0011DA\u0013\u0003O\tI\u0003\u0003\u00041\u000f\u0001\u0007\u00111\u0004\u0019\u0005\u0003;\t\t\u0003\u0005\u00034m\u0005}\u0001cA\u001d\u0002\"\u0011Y\u00111EA\r\u0003\u0003\u0005\tQ!\u0001=\u0005\ryFE\r\u0005\u0006\u0017\u001e\u0001\r\u0001\u0014\u0005\u00069\u001e\u0001\r!\u0018\u0005\u0006Q\u001e\u0001\r![\u0001\ri\u0006\u0014G.\u001a(b[\u0016\\U-_\u000b\u0002;\u0006iA/\u00192mK:\u000bW.Z&fs\u0002\n\u0001b[3z'B\f7-Z\u000b\u0003\u0003k\u00012!LA\u001c\u0013\r\tId\b\u0002\u00105JJe\u000eZ3y\u0017\u0016L8\u000b]1dK\u0006I1.Z=Ta\u0006\u001cW\rI\u0001\n5JJe\u000eZ3y-R\u00022!a\u0001\u000e'\ri\u00111\t\t\u0004}\u0005\u0015\u0013bAA$\u007f\t1\u0011I\\=SK\u001a$\"!a\u0010\u0003#i\u0013\u0014J\u001c3fq.+\u0017p\u00159bG\u00164FgE\u0002\u0010\u0003kI1aSA\u001c\u0003\u001d\u0019\b.\u0019:j]\u001e,\"!!\u0016\u0011\u000by\n9&a\u0017\n\u0007\u0005esHA\u0003BeJ\f\u0017\u0010E\u0002?\u0003;J1!a\u0018@\u0005\u0011\u0011\u0015\u0010^3\u0002\u0011MD\u0017M]5oO\u0002\n\u0001b\u001d5be\u0012Lgn\u001a\t\u0005\u0003O\nI'D\u0001J\u0013\r\tY'\u0013\u0002\u000e'\"\f'\u000fZ*ue\u0006$XmZ=\n\t\u0005\r\u0014qG\u0001\nO\u0016|WNR5fY\u0012$\"\"a\u001d\u0002x\u0005e\u00141PA?!\r\t)hD\u0007\u0002\u001b!)1*\u0006a\u0001\u0019\"9\u0011\u0011K\u000bA\u0002\u0005U\u0003bBA2+\u0001\u0007\u0011Q\r\u0005\u0007\u0003_*\u0002\u0019A/\u0002\u001bI\fgnZ3Qe\u00164\u0017\u000e_3t+\t\t\u0019\t\u0005\u0004\u0002\u0006\u0006=\u0015Q\u000b\b\u0005\u0003\u000f\u000bYID\u0002a\u0003\u0013K\u0011\u0001Q\u0005\u0004\u0003\u001b{\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003#\u000b\u0019JA\u0002TKFT1!!$@\u00039\u0011\u0018M\\4f!J,g-\u001b=fg\u0002\n!#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQV\u0011\u00111\u0014\t\b\u0003\u000b\u000bi*!)Y\u0013\u0011\ty*a%\u0003\u000bIKw\r\u001b;\u0011\u0011y\n\u0019+!\u0016Y1bK1!!*@\u0005%1UO\\2uS>t7'A\nj]\u0012,\u0007pS3z\u0005f$X\rT3oORD\u0007%\u0001\u0006u_&sG-\u001a=LKf$\"\"!,\u0002H\u0006E\u0017Q[Am!\u0019\ty+a/\u0002B:!\u0011\u0011WA]\u001d\u0011\t\u0019,a.\u000f\u00075\f),\u0003\u0002#I%\u0011!jI\u0005\u0004\u0003\u001bK\u0015\u0002BA_\u0003\u007f\u00131BU8x\u0017\u0016Lh+\u00197vK*\u0019\u0011QR%\u0011\u0007y\n\u0019-C\u0002\u0002F~\u0012A\u0001T8oO\"9\u0011\u0011\u001a\u000eA\u0002\u0005-\u0017\u0001C<sSR\f'\r\\3\u0011\t\u0005\u001d\u0014QZ\u0005\u0004\u0003\u001fL%aD,sSR\f'\r\\3GK\u0006$XO]3\t\u000f\u0005M'\u00041\u0001\u0002V\u0005!A/[3s\u0011\u001d\t9N\u0007a\u0001\u0003+\n!!\u001b3\t\u0013\u0005m'\u0004%AA\u0002\u0005u\u0017a\u00027f]&,g\u000e\u001e\t\u0004}\u0005}\u0017bAAq\u007f\t9!i\\8mK\u0006t\u0017!D4fiJ\u000bgnZ3CsR,7\u000f\u0006\u0004\u0002h\u0006M\u0018q \t\u0007\u0003\u000b\u000bI/!<\n\t\u0005-\u00181\u0013\u0002\t\u0013R,'/\u0019;peB!\u0011qVAx\u0013\u0011\t\t0a0\u0003\u0013\tKH/\u001a*b]\u001e,\u0007bBA{7\u0001\u0007\u0011q_\u0001\u0007e\u0006tw-Z:\u0011\r\u0005\u0015\u0015\u0011^A}!\u0019\ty+a?\u0002B&!\u0011Q`A`\u0005%\u00196-\u00198SC:<W\rC\u0005\u0002Tn\u0001\n\u00111\u0001\u0002^\u0002")
public class Z2IndexV4
extends Z2Index {
    private final String tableNameKey = new StringBuilder(10).append("table.z2.v").append(super.version()).toString();
    private final Z2IndexKeySpace keySpace;

    @Override
    public String tableNameKey() {
        return this.tableNameKey;
    }

    @Override
    public Z2IndexKeySpace keySpace() {
        return this.keySpace;
    }

    public Z2IndexV4(GeoMesaDataStore<?> ds, SimpleFeatureType sft, int version, String geom, IndexMode.IndexMode mode) {
        super(ds, sft, version, geom, mode);
        this.keySpace = new Z2IndexKeySpaceV4(super.sft(), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(super.sft())), ShardStrategy$Z2ShardStrategy$.MODULE$.apply(super.sft()), geom);
    }

    public Z2IndexV4(GeoMesaDataStore<?> ds, SimpleFeatureType sft, String geom, IndexMode.IndexMode mode) {
        this(ds, sft, 4, geom, mode);
    }

    public static class Z2IndexKeySpaceV4
    extends Z2IndexKeySpace {
        private final byte[] sharing;
        private final Seq<byte[]> rangePrefixes;
        private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;

        @Override
        public byte[] sharing() {
            return this.sharing;
        }

        private Seq<byte[]> rangePrefixes() {
            return this.rangePrefixes;
        }

        @Override
        public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
            return this.indexKeyByteLength;
        }

        @Override
        public package.RowKeyValue<Object> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
            long l;
            Point geom = (Point)writable.getAttribute(this.geomIndex());
            if (geom == null) {
                throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
            }
            try {
                l = this.sfc().index(geom.getX(), geom.getY(), lenient);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringBuilder(31).append("Invalid z value from geometry: ").append(geom).toString(), e);
                }
                throw throwable;
            }
            long z = l;
            byte[] shard = super.sharding().apply(writable);
            byte[] bytes = (byte[])Array$.MODULE$.ofDim(this.sharing().length + shard.length + 8 + id.length, (ClassTag)ClassTag$.MODULE$.Byte());
            int i = 0;
            if (!ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(this.sharing()))) {
                bytes[0] = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(this.sharing())));
                ++i;
            }
            if (!ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(shard))) {
                bytes[i] = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(shard)));
                ++i;
            }
            ByteArrays$.MODULE$.writeLong(z, bytes, i);
            System.arraycopy(id, 0, bytes, i + 8, id.length);
            return new package.SingleRowKeyValue<Object>(bytes, this.sharing(), shard, BoxesRunTime.boxToLong((long)z), tier, id, writable.values());
        }

        @Override
        public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<Object>> ranges, boolean tier) {
            if (this.rangePrefixes().isEmpty()) {
                return ranges.map((Function1 & Serializable)x0$1 -> {
                    package.ScanRange scanRange = x0$1;
                    if (scanRange instanceof package.BoundedRange) {
                        package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                        long lo = boundedRange.lower$mcJ$sp();
                        long hi = boundedRange.upper$mcJ$sp();
                        return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                    }
                    throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
                });
            }
            return ranges.flatMap((Function1 & Serializable)x0$2 -> {
                package.ScanRange scanRange = x0$2;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                    return (IterableOnce)this.rangePrefixes().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }

        public Z2IndexKeySpaceV4(SimpleFeatureType sft, byte[] sharing, ShardStrategy sharding, String geomField) {
            this.sharing = sharing;
            super(sft, sharding, geomField);
            this.rangePrefixes = super.sharding().length() == 0 && ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(sharing)) ? (Seq)package$.MODULE$.Seq().empty() : (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(sharing)) ? super.sharding().shards() : (super.sharding().length() == 0 ? new .colon.colon((Object)sharing, (List)Nil$.MODULE$) : (Seq)super.sharding().shards().map((Function1 & Serializable)x$1 -> ByteArrays$.MODULE$.concat(this.sharing(), x$1))));
            this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(8 + sharing.length + super.sharding().length())));
        }
    }
}

