/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z3;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.XZ3SFC;
import org.locationtech.geomesa.curve.XZ3SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z3.XZ3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction1;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tee\u0001\u0002\u0014(\u0001MB\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\tC\u0002\u0011\t\u0011)A\u0005/\"A!\r\u0001BC\u0002\u0013\u00051\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003e\u0011!A\u0007A!A!\u0002\u0013I\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u000bU\u0004A\u0011\u0001<\t\u000fq\u0004!\u0019!C\t{\"9\u00111\u0001\u0001!\u0002\u0013q\b\u0002CA\u0003\u0001\t\u0007I\u0011C?\t\u000f\u0005\u001d\u0001\u0001)A\u0005}\"I\u0011\u0011\u0002\u0001C\u0002\u0013E\u00111\u0002\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u000e!I\u00111\u0004\u0001C\u0002\u0013E\u0011Q\u0004\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002 !I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002D!I\u0011Q\n\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003k\u0002\u0001\u0015!\u0003\u0002R!I\u0011q\u000f\u0001C\u0002\u0013%\u0011\u0011\u0010\u0005\t\u0003\u0003\u0003\u0001\u0015!\u0003\u0002|!I\u00111\u0011\u0001C\u0002\u0013\u0005\u0013Q\u0011\u0005\t\u0003/\u0003\u0001\u0015!\u0003\u0002\b\"I\u0011\u0011\u0014\u0001C\u0002\u0013\u0005\u00131\u0014\u0005\t\u0003k\u0003\u0001\u0015!\u0003\u0002\u001e\"I\u0011q\u0017\u0001C\u0002\u0013\u0005\u0013\u0011\u0018\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u0002*\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0005\u001b\u0001A\u0011\tB\b\u0011\u001d\u0011)\u0003\u0001C!\u0005OAqAa\u000e\u0001\t\u0003\u0012IdB\u0004\u0003r\u001dB\tAa\u001d\u0007\r\u0019:\u0003\u0012\u0001B;\u0011\u0019)(\u0005\"\u0001\u0003\u0006\"9!q\u0011\u0012\u0005B\t%\u0005b\u0002BHE\u0011\u0005#\u0011\u0013\u0002\u00111j\u001b\u0014J\u001c3fq.+\u0017p\u00159bG\u0016T!\u0001K\u0015\u0002\u0005i\u001c$B\u0001\u0016,\u0003\u0015Ig\u000eZ3y\u0015\tQCF\u0003\u0002.]\u00059q-Z8nKN\f'BA\u00181\u00031awnY1uS>tG/Z2i\u0015\u0005\t\u0014aA8sO\u000e\u00011\u0003\u0002\u00015u-\u0003\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007\u0003B\u001e?\u0001\"k\u0011\u0001\u0010\u0006\u0003{-\n1!\u00199j\u0013\tyDHA\u0007J]\u0012,\u0007pS3z'B\f7-\u001a\t\u0003\u0003\u0016s!AQ\"\u000e\u0003\u001dJ!\u0001R\u0014\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\u000f1j\u001b\u0014J\u001c3fqZ\u000bG.^3t\u0015\t!u\u0005\u0005\u0002B\u0013&\u0011!j\u0012\u0002\u000b5NJe\u000eZ3y\u0017\u0016L\bC\u0001'T\u001b\u0005i%B\u0001(P\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0001\u0016+\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0016aA2p[&\u0011A+\u0014\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002tMR,\u0012a\u0016\t\u00031~k\u0011!\u0017\u0006\u00035n\u000baa]5na2,'B\u0001/^\u0003\u001d1W-\u0019;ve\u0016T!A\u0018\u0019\u0002\u000f=\u0004XM\\4jg&\u0011\u0001-\u0017\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\n\u0001b\u001d5be\u0012LgnZ\u000b\u0002IB\u00111(Z\u0005\u0003Mr\u0012Qb\u00155be\u0012\u001cFO]1uK\u001eL\u0018!C:iCJ$\u0017N\\4!\u0003%9Wm\\7GS\u0016dG\r\u0005\u0002kc:\u00111n\u001c\t\u0003YZj\u0011!\u001c\u0006\u0003]J\na\u0001\u0010:p_Rt\u0014B\u000197\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A4\u0014\u0001\u00033uO\u001aKW\r\u001c3\u0002\rqJg.\u001b;?)\u00159\b0\u001f>|!\t\u0011\u0005\u0001C\u0003V\u000f\u0001\u0007q\u000bC\u0003c\u000f\u0001\u0007A\rC\u0003i\u000f\u0001\u0007\u0011\u000eC\u0003u\u000f\u0001\u0007\u0011.A\u0005hK>l\u0017J\u001c3fqV\ta\u0010\u0005\u00026\u007f&\u0019\u0011\u0011\u0001\u001c\u0003\u0007%sG/\u0001\u0006hK>l\u0017J\u001c3fq\u0002\n\u0001\u0002\u001a;h\u0013:$W\r_\u0001\nIR<\u0017J\u001c3fq\u0002\n1a\u001d4d+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\u0002L\u0001\u0006GV\u0014h/Z\u0005\u0005\u0003/\t\tB\u0001\u0004Y5N\u001afiQ\u0001\u0005g\u001a\u001c\u0007%A\u0006uS6,Gk\\%oI\u0016DXCAA\u0010!\u0011\t\t#a\u000e\u000f\t\u0005\r\u00121\u0007\b\u0005\u0003K\t\tD\u0004\u0003\u0002(\u0005=b\u0002BA\u0015\u0003[q1\u0001\\A\u0016\u0013\u0005\t\u0014BA\u00181\u0013\tic&C\u0002\u0002\u00141JA!!\u000e\u0002\u0012\u0005Q!)\u001b8oK\u0012$\u0016.\\3\n\t\u0005e\u00121\b\u0002\u0011)&lW\rV8CS:tW\r\u001a+j[\u0016TA!!\u000e\u0002\u0012\u0005aA/[7f)>Le\u000eZ3yA\u0005YA-\u0019;f)>Le\u000eZ3y+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005\u001dc\u0002BA\b\u0003gIA!!\u0013\u0002<\t\u0001B)\u0019;f)>\u0014\u0015N\u001c8fIRKW.Z\u0001\rI\u0006$X\rV8J]\u0012,\u0007\u0010I\u0001\u000eE>,h\u000eZ:U_\u0012\u000bG/Z:\u0016\u0005\u0005E\u0003cB\u001b\u0002T\u0005]\u00131O\u0005\u0004\u0003+2$!\u0003$v]\u000e$\u0018n\u001c82!\u001d)\u0014\u0011LA/\u0003;J1!a\u00177\u0005\u0019!V\u000f\u001d7feA)Q'a\u0018\u0002d%\u0019\u0011\u0011\r\u001c\u0003\r=\u0003H/[8o!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\nA\u0001^5nK*\u0011\u0011QN\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002r\u0005\u001d$!\u0004.p]\u0016$G)\u0019;f)&lW\rE\u00046\u00033\n\u0019'a\u0019\u0002\u001d\t|WO\u001c3t)>$\u0015\r^3tA\u0005A\u0011n\u001d)pS:$8/\u0006\u0002\u0002|A\u0019Q'! \n\u0007\u0005}dGA\u0004C_>dW-\u00198\u0002\u0013%\u001c\bk\\5oiN\u0004\u0013AC1uiJL'-\u001e;fgV\u0011\u0011q\u0011\t\u0006\u0003\u0013\u000b\t*\u001b\b\u0005\u0003\u0017\u000byID\u0002m\u0003\u001bK\u0011aN\u0005\u0003\tZJA!a%\u0002\u0016\n\u00191+Z9\u000b\u0005\u00113\u0014aC1uiJL'-\u001e;fg\u0002\n!#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQV\u0011\u0011Q\u0014\t\b\u0003\u0013\u000by*a)\u007f\u0013\u0011\t\t+!&\u0003\u000bIKw\r\u001b;\u0011\u0011U\n)+!+\u007f}zL1!a*7\u0005%1UO\\2uS>t7\u0007E\u00036\u0003W\u000by+C\u0002\u0002.Z\u0012Q!\u0011:sCf\u00042!NAY\u0013\r\t\u0019L\u000e\u0002\u0005\u0005f$X-A\nj]\u0012,\u0007pS3z\u0005f$X\rT3oORD\u0007%A\u0004tQ\u0006\u0014\u0018N\\4\u0016\u0005\u0005%\u0016\u0001C:iCJLgn\u001a\u0011\u0002\u0015Q|\u0017J\u001c3fq.+\u0017\u0010\u0006\u0006\u0002B\u0006U\u0017q\\Ar\u0003O\u0004R!a1\u0002P\"sA!!2\u0002N:!\u0011qYAf\u001d\u0011\t)#!3\n\u0005)b\u0013BA\u001f,\u0013\t!E(\u0003\u0003\u0002R\u0006M'a\u0003*po.+\u0017PV1mk\u0016T!\u0001\u0012\u001f\t\u000f\u0005]G\u00041\u0001\u0002Z\u0006AqO]5uC\ndW\rE\u0002<\u00037L1!!8=\u0005=9&/\u001b;bE2,g)Z1ukJ,\u0007bBAq9\u0001\u0007\u0011\u0011V\u0001\u0005i&,'\u000fC\u0004\u0002fr\u0001\r!!+\u0002\u0005%$\u0007\"CAu9A\u0005\t\u0019AA>\u0003\u001daWM\\5f]R\fabZ3u\u0013:$W\r\u001f,bYV,7\u000fF\u0003A\u0003_\fi\u0010C\u0004\u0002rv\u0001\r!a=\u0002\r\u0019LG\u000e^3s!\u0011\t)0!?\u000e\u0005\u0005](bAAy;&!\u00111`A|\u0005\u00191\u0015\u000e\u001c;fe\"9\u0011q`\u000fA\u0002\t\u0005\u0011aB3ya2\f\u0017N\u001c\t\u0005\u0005\u0007\u0011I!\u0004\u0002\u0003\u0006)\u0019!qA\u0016\u0002\u000bU$\u0018\u000e\\:\n\t\t-!Q\u0001\u0002\n\u000bb\u0004H.Y5oKJ\f\u0011bZ3u%\u0006tw-Z:\u0015\r\tE!Q\u0004B\u0011!\u0019\tIIa\u0005\u0003\u0018%!!QCAK\u0005!IE/\u001a:bi>\u0014\b#BAb\u00053A\u0015\u0002\u0002B\u000e\u0003'\u0014\u0011bU2b]J\u000bgnZ3\t\r\t}a\u00041\u0001A\u0003\u00191\u0018\r\\;fg\"A!1\u0005\u0010\u0011\u0002\u0003\u0007a0\u0001\u0006nk2$\u0018\u000e\u001d7jKJ\fQbZ3u%\u0006tw-\u001a\"zi\u0016\u001cHC\u0002B\u0015\u0005c\u0011)\u0004\u0005\u0004\u0002\n\nM!1\u0006\t\u0005\u0003\u0007\u0014i#\u0003\u0003\u00030\u0005M'!\u0003\"zi\u0016\u0014\u0016M\\4f\u0011\u001d\u0011\u0019d\ba\u0001\u0005#\taA]1oO\u0016\u001c\b\"CAq?A\u0005\t\u0019AA>\u00035)8/\u001a$vY24\u0015\u000e\u001c;feRA\u00111\u0010B\u001e\u0005\u007f\u0011Y\u0006C\u0004\u0003 \u0001\u0002\rA!\u0010\u0011\tU\ny\u0006\u0011\u0005\b\u0005\u0003\u0002\u0003\u0019\u0001B\"\u0003\u0019\u0019wN\u001c4jOB)Q'a\u0018\u0003FA!!q\tB+\u001d\u0011\u0011IEa\u0014\u000f\t\u0005\u001d'1J\u0005\u0004\u0005\u001bZ\u0013\u0001C4f_R|w\u000e\\:\n\t\tE#1K\u0001\u0018\u000f\u0016|W*Z:b\t\u0006$\u0018m\u0015;pe\u00164\u0015m\u0019;pefT1A!\u0014,\u0013\u0011\u00119F!\u0017\u0003-\u001d+w.T3tC\u0012\u000bG/Y*u_J,7i\u001c8gS\u001eTAA!\u0015\u0003T!9!Q\f\u0011A\u0002\t}\u0013!\u00025j]R\u001c\b\u0003\u0002B1\u0005[j!Aa\u0019\u000b\t\t\u0015$qM\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\u0011IGa\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0005\u001b\u0002\u0014\u0002\u0002B8\u0005G\u0012Q\u0001S5oiN\f\u0001\u0003\u0017.4\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0005\t\u00133\u0003\u0002\u00125\u0005o\u0002bA!\u001f\u0003\u0000\u0001Ce\u0002BAc\u0005wJ1A! =\u00035Ie\u000eZ3y\u0017\u0016L8\u000b]1dK&!!\u0011\u0011BB\u0005QIe\u000eZ3y\u0017\u0016L8\u000b]1dK\u001a\u000b7\r^8ss*\u0019!Q\u0010\u001f\u0015\u0005\tM\u0014\u0001C:vaB|'\u000f^:\u0015\r\u0005m$1\u0012BG\u0011\u0015)F\u00051\u0001X\u0011\u001d\t\u0019\t\na\u0001\u0003\u000f\u000bQ!\u00199qYf$ra\u001eBJ\u0005+\u00139\nC\u0003VK\u0001\u0007q\u000bC\u0004\u0002\u0004\u0016\u0002\r!a\"\t\u000f\u0005\u0005X\u00051\u0001\u0002|\u0001")
public class XZ3IndexKeySpace
implements IndexKeySpace<package.XZ3IndexValues, package.Z3IndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String geomField;
    private final String dtgField;
    private final int geomIndex;
    private final int dtgIndex;
    private final XZ3SFC sfc;
    private final Function1<Object, BinnedTime> timeToIndex;
    private final Function1<ZonedDateTime, BinnedTime> dateToIndex;
    private final Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates;
    private final boolean isPoints;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static XZ3IndexKeySpace apply(SimpleFeatureType sft, Seq<String> attributes2, boolean tier) {
        return XZ3IndexKeySpace$.MODULE$.apply(sft, (Seq)attributes2, tier);
    }

    public static boolean supports(SimpleFeatureType sft, Seq<String> attributes2) {
        return XZ3IndexKeySpace$.MODULE$.supports(sft, attributes2);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    private Logger logger$lzycompute() {
        XZ3IndexKeySpace xZ3IndexKeySpace = this;
        synchronized (xZ3IndexKeySpace) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public int dtgIndex() {
        return this.dtgIndex;
    }

    public XZ3SFC sfc() {
        return this.sfc;
    }

    public Function1<Object, BinnedTime> timeToIndex() {
        return this.timeToIndex;
    }

    private Function1<ZonedDateTime, BinnedTime> dateToIndex() {
        return this.dateToIndex;
    }

    private Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates() {
        return this.boundsToDates;
    }

    private boolean isPoints() {
        return this.isPoints;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    @Override
    public package.RowKeyValue<package.Z3IndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        long l;
        Geometry geom = (Geometry)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
        }
        Envelope envelope = geom.getEnvelopeInternal();
        Date dtg = (Date)writable.getAttribute(this.dtgIndex());
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)this.timeToIndex().apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) {
            throw new MatchError((Object)binnedTime);
        }
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long t2 = tuple2._2$mcJ$sp();
        try {
            l = this.sfc().index(envelope.getMinX(), envelope.getMinY(), (double)t2, envelope.getMaxX(), envelope.getMaxY(), (double)t2, lenient);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(38).append("Invalid xz value from geometry/time: ").append(geom).append(",").append(dtg).toString(), e);
            }
            throw throwable;
        }
        long xz = l;
        byte[] shard = this.sharding().apply(writable);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 10 + id.length, (ClassTag)ClassTag$.MODULE$.Byte());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(shard))) {
            ByteArrays$.MODULE$.writeShort(b2, bytes, 0);
            ByteArrays$.MODULE$.writeLong(xz, bytes, 2);
            System.arraycopy(id, 0, bytes, 10, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(shard)));
            ByteArrays$.MODULE$.writeShort(b2, bytes, 1);
            ByteArrays$.MODULE$.writeLong(xz, bytes, 3);
            System.arraycopy(id, 0, bytes, 11, id.length);
        }
        return new package.SingleRowKeyValue<package.Z3IndexKey>(bytes, this.sharing(), shard, new package.Z3IndexKey(b2, xz), tier, id, writable.values());
    }

    @Override
    public package.XZ3IndexValues getIndexValues(Filter filter, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter, this.geomField, this.isPoints());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)new .colon.colon((Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon(), (List)Nil$.MODULE$), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$1 = filter;
        String x$22 = this.dtgField;
        boolean x$3 = true;
        boolean x$4 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$1, x$22, x$4, true);
        explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Geometries: ").append(geometries).toString());
        explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Intervals: ").append(intervals).toString());
        if (intervals.disjoint()) {
            explain.apply((Function0<String>)(Function0 & Serializable)() -> "Disjoint dates extracted, short-circuiting to empty query");
            return new package.XZ3IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)package$.MODULE$.Seq().empty()), (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Tuple2<Object, Object>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)((Seq)package$.MODULE$.Seq().empty()));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1 & Serializable)x$2 -> GeometryUtils$.MODULE$.bounds(x$2, multiplier, bits));
        scala.collection.mutable.Map timesByBin = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Builder unboundedBins = package$.MODULE$.Seq().newBuilder();
        intervals.foreach((Function1 & Serializable)interval -> {
            Tuple2 tuple2 = (Tuple2)this.boundsToDates().apply((Object)interval.bounds());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ZonedDateTime lower = (ZonedDateTime)tuple2._1();
            ZonedDateTime upper = (ZonedDateTime)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)lower, (Object)upper);
            ZonedDateTime lower2 = (ZonedDateTime)tuple22._1();
            ZonedDateTime upper2 = (ZonedDateTime)tuple22._2();
            BinnedTime binnedTime = (BinnedTime)this.dateToIndex().apply((Object)lower2);
            if (binnedTime == null) {
                throw new MatchError((Object)binnedTime);
            }
            short lb = binnedTime.bin();
            long lt = binnedTime.offset();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
            short lb2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long lt2 = tuple23._2$mcJ$sp();
            BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex().apply((Object)upper2);
            if (binnedTime2 == null) {
                throw new MatchError((Object)binnedTime2);
            }
            short ub = binnedTime2.bin();
            long ut = binnedTime2.offset();
            Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
            short ub2 = BoxesRunTime.unboxToShort((Object)tuple24._1());
            long ut2 = tuple24._2$mcJ$sp();
            if (interval.isBoundedBothSides()) {
                if (lb2 == ub2) {
                    XZ3IndexKeySpace.updateTime$1(lb2, lt2, ut2, timesByBin);
                    return BoxedUnit.UNIT;
                }
                XZ3IndexKeySpace.updateTime$1(lb2, lt2, this.sfc().zBounds()._2$mcD$sp(), timesByBin);
                XZ3IndexKeySpace.updateTime$1(ub2, this.sfc().zBounds()._1$mcD$sp(), ut2, timesByBin);
                package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)b -> timesByBin.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.sfc().zBounds()));
                return BoxedUnit.UNIT;
            }
            if (interval.lower().value().isDefined()) {
                XZ3IndexKeySpace.updateTime$1(lb2, lt2, this.sfc().zBounds()._2$mcD$sp(), timesByBin);
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)(lb2 + 1))), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            }
            if (interval.upper().value().isDefined()) {
                XZ3IndexKeySpace.updateTime$1(ub2, this.sfc().zBounds()._1$mcD$sp(), ut2, timesByBin);
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)0), (Object)BoxesRunTime.boxToShort((short)((short)(ub2 - 1)))));
            }
            return BoxedUnit.UNIT;
        });
        return new package.XZ3IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Tuple2<Object, Object>>)timesByBin.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq<Tuple2<Object, Object>>)((Seq)unboundedBins.result()));
    }

    @Override
    public Iterator<package.ScanRange<package.Z3IndexKey>> getRanges(package.XZ3IndexValues values, int multiplier) {
        package.XZ3IndexValues xZ3IndexValues = values;
        if (xZ3IndexValues == null) {
            throw new MatchError((Object)xZ3IndexValues);
        }
        XZ3SFC sfc = xZ3IndexValues.sfc();
        FilterValues<Geometry> geoms = xZ3IndexValues.geometries();
        Seq<Tuple4<Object, Object, Object, Object>> xy = xZ3IndexValues.spatialBounds();
        FilterValues<Bounds<ZonedDateTime>> intervals = xZ3IndexValues.intervals();
        Map<Object, Tuple2<Object, Object>> timesByBin = xZ3IndexValues.temporalBounds();
        Seq<Tuple2<Object, Object>> unboundedBins = xZ3IndexValues.temporalUnbounded();
        Tuple6 tuple6 = new Tuple6((Object)sfc, geoms, xy, intervals, timesByBin, unboundedBins);
        XZ3SFC sfc2 = (XZ3SFC)tuple6._1();
        FilterValues geoms2 = (FilterValues)tuple6._2();
        Seq xy2 = (Seq)tuple6._3();
        FilterValues intervals2 = (FilterValues)tuple6._4();
        Map timesByBin2 = (Map)tuple6._5();
        Seq unboundedBins2 = (Seq)tuple6._6();
        if (geoms2.disjoint() || intervals2.disjoint()) {
            return package$.MODULE$.Iterator().empty();
        }
        if (timesByBin2.isEmpty() && unboundedBins2.isEmpty()) {
            return package$.MODULE$.Iterator().single(new package.UnboundedRange<Object>(null));
        }
        LazyRef wholePeriodRanges$lzy = new LazyRef();
        Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1 & Serializable)t -> BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(1, timesByBin2.isEmpty() ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(t)) : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(t)) / timesByBin2.size() / multiplier)));
        Iterator bounded = timesByBin2.iterator().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Tuple2 times = (Tuple2)tuple2._2();
                Seq zs = times == sfc2.zBounds() ? XZ3IndexKeySpace.wholePeriodRanges$1(wholePeriodRanges$lzy, sfc2, xy2, target) : XZ3IndexKeySpace.toZRanges$1(times, sfc2, xy2, target);
                return (Seq)zs.map((Function1 & Serializable)r -> new package.BoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(bin, r.lower()), new package.Z3IndexKey(bin, r.upper())));
            }
            throw new MatchError((Object)tuple2);
        });
        Iterator unbounded = unboundedBins2.iterator().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (Short.MAX_VALUE == s) {
                    return new package.LowerBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(lower, 0L));
                }
            }
            if (tuple2 != null) {
                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (0 == s) {
                    return new package.UpperBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(upper, Long.MAX_VALUE));
                }
            }
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unexpected unbounded bin endpoints: {}:{}", new Object[]{BoxesRunTime.boxToShort((short)lower), BoxesRunTime.boxToShort((short)upper)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new package.UnboundedRange<package.Z3IndexKey>(new package.Z3IndexKey(0, 0L));
            }
            throw new MatchError((Object)tuple2);
        });
        return bounded.$plus$plus((Function0 & Serializable)() -> unbounded);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<package.Z3IndexKey>> ranges, boolean tier) {
        if (this.sharding().length() == 0) {
            return ranges.map((Function1 & Serializable)x0$1 -> {
                package.ScanRange scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                    package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                }
                if (scanRange instanceof package.LowerBoundedRange) {
                    package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                    package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                if (scanRange instanceof package.UpperBoundedRange) {
                    package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                    package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                }
                if (scanRange instanceof package.UnboundedRange) {
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }
        return ranges.flatMap((Function1 & Serializable)x0$2 -> {
            package.ScanRange scanRange = x0$2;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            if (scanRange instanceof package.LowerBoundedRange) {
                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                byte[] upper = package$ByteRange$.MODULE$.UnboundedUpperRange();
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            if (scanRange instanceof package.UpperBoundedRange) {
                package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                byte[] lower = package$ByteRange$.MODULE$.UnboundedLowerRange();
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            if (scanRange instanceof package.UnboundedRange) {
                return new .colon.colon((Object)new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange()), (List)Nil$.MODULE$);
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
    }

    @Override
    public boolean useFullFilter(Option<package.XZ3IndexValues> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return true;
    }

    private static final void updateTime$1(short bin, double lt, double ut, scala.collection.mutable.Map timesByBin$1) {
        Some some;
        Tuple2 tuple2;
        Tuple2.mcDD.sp sp2;
        Option option = timesByBin$1.get((Object)BoxesRunTime.boxToShort((short)bin));
        if (None$.MODULE$.equals(option)) {
            sp2 = new Tuple2.mcDD.sp(lt, ut);
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            double min2 = tuple2._1$mcD$sp();
            double max2 = tuple2._2$mcD$sp();
            sp2 = new Tuple2.mcDD.sp(scala.math.package$.MODULE$.min(min2, lt), scala.math.package$.MODULE$.max(max2, ut));
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2.mcDD.sp times = sp2;
        timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)bin), (Object)times);
    }

    private static final Seq toZRanges$1(Tuple2 t, XZ3SFC sfc$1, Seq xy$1, Option target$1) {
        return sfc$1.ranges((Seq)xy$1.map((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                return new Tuple6((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)t._1$mcD$sp()), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax), (Object)BoxesRunTime.boxToDouble((double)t._2$mcD$sp()));
            }
            throw new MatchError((Object)tuple4);
        }), target$1);
    }

    private static final /* synthetic */ Seq wholePeriodRanges$lzycompute$1(LazyRef wholePeriodRanges$lzy$1, XZ3SFC sfc$1, Seq xy$1, Option target$1) {
        Seq seq;
        LazyRef lazyRef = wholePeriodRanges$lzy$1;
        synchronized (lazyRef) {
            seq = wholePeriodRanges$lzy$1.initialized() ? (Seq)wholePeriodRanges$lzy$1.value() : (Seq)wholePeriodRanges$lzy$1.initialize((Object)XZ3IndexKeySpace.toZRanges$1(sfc$1.zBounds(), sfc$1, xy$1, target$1));
        }
        return seq;
    }

    private static final Seq wholePeriodRanges$1(LazyRef wholePeriodRanges$lzy$1, XZ3SFC sfc$1, Seq xy$1, Option target$1) {
        if (wholePeriodRanges$lzy$1.initialized()) {
            return (Seq)wholePeriodRanges$lzy$1.value();
        }
        return XZ3IndexKeySpace.wholePeriodRanges$lzycompute$1(wholePeriodRanges$lzy$1, sfc$1, xy$1, target$1);
    }

    public XZ3IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField, String dtgField) {
        this.sft = sft;
        this.sharding = sharding;
        this.geomField = geomField;
        this.dtgField = dtgField;
        LazyLogging.$init$((LazyLogging)this);
        Predef$.MODULE$.require(Geometry.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0 & Serializable)() -> new StringBuilder(64).append("Expected field ").append($this.geomField).append(" to have a geometry binding, but instead it has: ").append(this.sft().getDescriptor($this.geomField).getType().getBinding().getSimpleName()).toString());
        Predef$.MODULE$.require(Date.class.isAssignableFrom(sft.getDescriptor(dtgField).getType().getBinding()), (Function0 & Serializable)() -> new StringBuilder(60).append("Expected field ").append($this.dtgField).append(" to have a date binding, but instead it has: ").append(this.sft().getDescriptor($this.dtgField).getType().getBinding().getSimpleName()).toString());
        this.geomIndex = sft.indexOf(geomField);
        this.dtgIndex = sft.indexOf(dtgField);
        this.sfc = XZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.isPoints = Point.class.isAssignableFrom(sft.getDescriptor(this.geomIndex()).getType().getBinding());
        this.attributes = new .colon.colon((Object)geomField, (List)new .colon.colon((Object)dtgField, (List)Nil$.MODULE$));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(10 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }
}

