/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z3;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z3.Z3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t5e\u0001\u0002\u0013&\u0001EB\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t?\u0002\u0011\t\u0011)A\u0005+\"A\u0001\r\u0001BC\u0002\u0013\u0005\u0011\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003c\u0011!1\u0007A!A!\u0002\u00139\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u000bM\u0004A\u0011\u0001;\t\u000fi\u0004!\u0019!C\tw\"9\u0011Q\u0001\u0001!\u0002\u0013a\b\"CA\u0004\u0001\t\u0007I\u0011CA\u0005\u0011!\t\t\u0002\u0001Q\u0001\n\u0005-\u0001\"CA\n\u0001\t\u0007I\u0011CA\u0005\u0011!\t)\u0002\u0001Q\u0001\n\u0005-\u0001\"CA\f\u0001\t\u0007I\u0011CA\r\u0011!\tI\u0004\u0001Q\u0001\n\u0005m\u0001\"CA\u001e\u0001\t\u0007I\u0011CA\u001f\u0011!\t)\u0005\u0001Q\u0001\n\u0005}\u0002\"CA$\u0001\t\u0007I\u0011BA%\u0011!\ty\u0007\u0001Q\u0001\n\u0005-\u0003\"CA9\u0001\t\u0007I\u0011IA:\u0011!\t)\t\u0001Q\u0001\n\u0005U\u0004\"CAD\u0001\t\u0007I\u0011IAE\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005-\u0005\"CAS\u0001\t\u0007I\u0011IAT\u0011!\tI\u000b\u0001Q\u0001\n\u0005]\u0005bBAV\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\u0011\t\u0001\u0001C!\u0005\u0007AqA!\u0007\u0001\t\u0003\u0012Y\u0002C\u0004\u0003,\u0001!\tE!\f\b\u000f\t\u0015T\u0005#\u0001\u0003h\u00191A%\nE\u0001\u0005SBaa\u001d\u0011\u0005\u0002\te\u0004b\u0002B>A\u0011\u0005#Q\u0010\u0005\b\u0005\u0007\u0003C\u0011\tBC\u0005=Q6'\u00138eKb\\U-_*qC\u000e,'B\u0001\u0014(\u0003\tQ8G\u0003\u0002)S\u0005)\u0011N\u001c3fq*\u0011\u0001F\u000b\u0006\u0003W1\nqaZ3p[\u0016\u001c\u0018M\u0003\u0002.]\u0005aAn\\2bi&|g\u000e^3dQ*\tq&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001eaJ\u0005CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g\r\u0005\u0003:yy2U\"\u0001\u001e\u000b\u0005mJ\u0013aA1qS&\u0011QH\u000f\u0002\u000e\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0005}\u001aeB\u0001!B\u001b\u0005)\u0013B\u0001\"&\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001R#\u0003\u001bi\u001b\u0014J\u001c3fqZ\u000bG.^3t\u0015\t\u0011U\u0005\u0005\u0002@\u000f&\u0011\u0001*\u0012\u0002\u000b5NJe\u000eZ3y\u0017\u0016L\bC\u0001&R\u001b\u0005Y%B\u0001'N\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tqu*\u0001\u0005usB,7/\u00194f\u0015\u0005\u0001\u0016aA2p[&\u0011!k\u0013\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002tMR,\u0012!\u0016\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000baa]5na2,'B\u0001.\\\u0003\u001d1W-\u0019;ve\u0016T!\u0001\u0018\u0018\u0002\u000f=\u0004XM\\4jg&\u0011al\u0016\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\n\u0001b\u001d5be\u0012LgnZ\u000b\u0002EB\u0011\u0011hY\u0005\u0003Ij\u0012Qb\u00155be\u0012\u001cFO]1uK\u001eL\u0018!C:iCJ$\u0017N\\4!\u0003%9Wm\\7GS\u0016dG\r\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003URj\u0011a\u001b\u0006\u0003YB\na\u0001\u0010:p_Rt\u0014B\u000185\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059$\u0014\u0001\u00033uO\u001aKW\r\u001c3\u0002\rqJg.\u001b;?)\u0015)ho\u001e=z!\t\u0001\u0005\u0001C\u0003T\u000f\u0001\u0007Q\u000bC\u0003a\u000f\u0001\u0007!\rC\u0003g\u000f\u0001\u0007q\rC\u0003s\u000f\u0001\u0007q-A\u0002tM\u000e,\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}T\u0013!B2veZ,\u0017bAA\u0002}\n)!lM*G\u0007\u0006!1OZ2!\u0003%9Wm\\7J]\u0012,\u00070\u0006\u0002\u0002\fA\u00191'!\u0004\n\u0007\u0005=AGA\u0002J]R\f!bZ3p[&sG-\u001a=!\u0003!!GoZ%oI\u0016D\u0018!\u00033uO&sG-\u001a=!\u0003-!\u0018.\\3U_&sG-\u001a=\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003gqA!a\b\u000209!\u0011\u0011EA\u0017\u001d\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012\u0011\u0006\b\u0004U\u0006\u001d\u0012\"A\u0018\n\u00055r\u0013BA\u0016-\u0013\ty(&C\u0002\u00022y\f!BQ5o]\u0016$G+[7f\u0013\u0011\t)$a\u000e\u0003!QKW.\u001a+p\u0005&tg.\u001a3US6,'bAA\u0019}\u0006aA/[7f)>Le\u000eZ3yA\u0005YA-\u0019;f)>Le\u000eZ3y+\t\ty\u0004\u0005\u0003\u0002\u001e\u0005\u0005\u0013\u0002BA\"\u0003o\u0011\u0001\u0003R1uKR{')\u001b8oK\u0012$\u0016.\\3\u0002\u0019\u0011\fG/\u001a+p\u0013:$W\r\u001f\u0011\u0002\u001b\t|WO\u001c3t)>$\u0015\r^3t+\t\tY\u0005E\u00044\u0003\u001b\n\t&!\u001c\n\u0007\u0005=CGA\u0005Gk:\u001cG/[8ocA91'a\u0015\u0002X\u0005]\u0013bAA+i\t1A+\u001e9mKJ\u0002RaMA-\u0003;J1!a\u00175\u0005\u0019y\u0005\u000f^5p]B!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014\u0001\u0002;j[\u0016T!!a\u001a\u0002\t)\fg/Y\u0005\u0005\u0003W\n\tGA\u0007[_:,G\rR1uKRKW.\u001a\t\bg\u0005M\u0013QLA/\u00039\u0011w.\u001e8egR{G)\u0019;fg\u0002\n!\"\u0019;ue&\u0014W\u000f^3t+\t\t)\bE\u0003\u0002x\u0005}tM\u0004\u0003\u0002z\u0005udb\u00016\u0002|%\tQ'\u0003\u0002Ci%!\u0011\u0011QAB\u0005\r\u0019V-\u001d\u0006\u0003\u0005R\n1\"\u0019;ue&\u0014W\u000f^3tA\u0005\u0011\u0012N\u001c3fq.+\u0017PQ=uK2+gn\u001a;i+\t\tY\t\u0005\u0005\u0002x\u00055\u0015\u0011SA\u0006\u0013\u0011\ty)a!\u0003\u000bIKw\r\u001b;\u0011\u0017M\n\u0019*a&\u0002\f\u0005-\u00111B\u0005\u0004\u0003+#$!\u0003$v]\u000e$\u0018n\u001c84!\u0015\u0019\u0014\u0011TAO\u0013\r\tY\n\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004g\u0005}\u0015bAAQi\t!!)\u001f;f\u0003MIg\u000eZ3y\u0017\u0016L()\u001f;f\u0019\u0016tw\r\u001e5!\u0003\u001d\u0019\b.\u0019:j]\u001e,\"!a&\u0002\u0011MD\u0017M]5oO\u0002\n!\u0002^8J]\u0012,\u0007pS3z))\ty+a1\u0002N\u0006E\u0017Q\u001b\t\u0006\u0003c\u000biL\u0012\b\u0005\u0003g\u000bYL\u0004\u0003\u00026\u0006ef\u0002BA\u0011\u0003oK!\u0001\u000b\u0016\n\u0005mJ\u0013B\u0001\";\u0013\u0011\ty,!1\u0003\u0017I{woS3z-\u0006dW/\u001a\u0006\u0003\u0005jBq!!2\u001b\u0001\u0004\t9-\u0001\u0005xe&$\u0018M\u00197f!\rI\u0014\u0011Z\u0005\u0004\u0003\u0017T$aD,sSR\f'\r\\3GK\u0006$XO]3\t\u000f\u0005='\u00041\u0001\u0002\u0018\u0006!A/[3s\u0011\u001d\t\u0019N\u0007a\u0001\u0003/\u000b!!\u001b3\t\u0013\u0005]'\u0004%AA\u0002\u0005e\u0017a\u00027f]&,g\u000e\u001e\t\u0004g\u0005m\u0017bAAoi\t9!i\\8mK\u0006t\u0017AD4fi&sG-\u001a=WC2,Xm\u001d\u000b\u0006}\u0005\r\u0018\u0011\u001f\u0005\b\u0003K\\\u0002\u0019AAt\u0003\u00191\u0017\u000e\u001c;feB!\u0011\u0011^Aw\u001b\t\tYOC\u0002\u0002fnKA!a<\u0002l\n1a)\u001b7uKJDq!a=\u001c\u0001\u0004\t)0A\u0004fqBd\u0017-\u001b8\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?*\u0003\u0015)H/\u001b7t\u0013\u0011\ty0!?\u0003\u0013\u0015C\b\u000f\\1j]\u0016\u0014\u0018!C4fiJ\u000bgnZ3t)\u0019\u0011)A!\u0005\u0003\u0016A1\u0011q\u000fB\u0004\u0005\u0017IAA!\u0003\u0002\u0004\nA\u0011\n^3sCR|'\u000fE\u0003\u00022\n5a)\u0003\u0003\u0003\u0010\u0005\u0005'!C*dC:\u0014\u0016M\\4f\u0011\u0019\u0011\u0019\u0002\ba\u0001}\u00051a/\u00197vKND\u0011Ba\u0006\u001d!\u0003\u0005\r!a\u0003\u0002\u00155,H\u000e^5qY&,'/A\u0007hKR\u0014\u0016M\\4f\u0005f$Xm\u001d\u000b\u0007\u0005;\u0011)C!\u000b\u0011\r\u0005]$q\u0001B\u0010!\u0011\t\tL!\t\n\t\t\r\u0012\u0011\u0019\u0002\n\u0005f$XMU1oO\u0016DqAa\n\u001e\u0001\u0004\u0011)!\u0001\u0004sC:<Wm\u001d\u0005\n\u0003\u001fl\u0002\u0013!a\u0001\u00033\fQ\"^:f\rVdGNR5mi\u0016\u0014H\u0003CAm\u0005_\u0011\u0019Da\u0014\t\u000f\tMa\u00041\u0001\u00032A!1'!\u0017?\u0011\u001d\u0011)D\ba\u0001\u0005o\taaY8oM&<\u0007#B\u001a\u0002Z\te\u0002\u0003\u0002B\u001e\u0005\u0013rAA!\u0010\u0003D9!\u0011Q\u0017B \u0013\r\u0011\t%K\u0001\tO\u0016|Go\\8mg&!!Q\tB$\u0003]9Um\\'fg\u0006$\u0015\r^1Ti>\u0014XMR1di>\u0014\u0018PC\u0002\u0003B%JAAa\u0013\u0003N\t1r)Z8NKN\fG)\u0019;b'R|'/Z\"p]\u001aLwM\u0003\u0003\u0003F\t\u001d\u0003b\u0002B)=\u0001\u0007!1K\u0001\u0006Q&tGo\u001d\t\u0005\u0005+\u0012\t'\u0004\u0002\u0003X)!!\u0011\fB.\u0003\u001d1\u0017m\u0019;pefTAA!\u0018\u0003`\u0005!Q\u000f^5m\u0015\r\u0011\tEL\u0005\u0005\u0005G\u00129FA\u0003IS:$8/A\b[g%sG-\u001a=LKf\u001c\u0006/Y2f!\t\u0001\u0005e\u0005\u0003!e\t-\u0004C\u0002B7\u0005grdI\u0004\u0003\u00024\n=\u0014b\u0001B9u\u0005i\u0011J\u001c3fq.+\u0017p\u00159bG\u0016LAA!\u001e\u0003x\t!\u0012J\u001c3fq.+\u0017p\u00159bG\u00164\u0015m\u0019;pefT1A!\u001d;)\t\u00119'\u0001\u0005tkB\u0004xN\u001d;t)\u0019\tINa \u0003\u0002\")1K\ta\u0001+\"9\u0011\u0011\u000f\u0012A\u0002\u0005U\u0014!B1qa2LHcB;\u0003\b\n%%1\u0012\u0005\u0006'\u000e\u0002\r!\u0016\u0005\b\u0003c\u001a\u0003\u0019AA;\u0011\u001d\tym\ta\u0001\u00033\u0004")
public class Z3IndexKeySpace
implements IndexKeySpace<package.Z3IndexValues, package.Z3IndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    private final String geomField;
    private final String dtgField;
    private final Z3SFC sfc;
    private final int geomIndex;
    private final int dtgIndex;
    private final Function1<Object, BinnedTime> timeToIndex;
    private final Function1<ZonedDateTime, BinnedTime> dateToIndex;
    private final Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Z3IndexKeySpace apply(SimpleFeatureType sft, Seq<String> attributes2, boolean tier) {
        return Z3IndexKeySpace$.MODULE$.apply(sft, (Seq)attributes2, tier);
    }

    public static boolean supports(SimpleFeatureType sft, Seq<String> attributes2) {
        return Z3IndexKeySpace$.MODULE$.supports(sft, attributes2);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace.toIndexKey$default$4$(this);
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace.getRanges$default$2$(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace.getRangeBytes$default$2$(this);
    }

    private Logger logger$lzycompute() {
        Z3IndexKeySpace z3IndexKeySpace = this;
        synchronized (z3IndexKeySpace) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public Z3SFC sfc() {
        return this.sfc;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public int dtgIndex() {
        return this.dtgIndex;
    }

    public Function1<Object, BinnedTime> timeToIndex() {
        return this.timeToIndex;
    }

    public Function1<ZonedDateTime, BinnedTime> dateToIndex() {
        return this.dateToIndex;
    }

    private Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToDates() {
        return this.boundsToDates;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    @Override
    public package.RowKeyValue<package.Z3IndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        long l;
        Point geom = (Point)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Null geometry in feature ").append(writable.feature().getID()).toString());
        }
        Date dtg = (Date)writable.getAttribute(this.dtgIndex());
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)this.timeToIndex().apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) {
            throw new MatchError((Object)binnedTime);
        }
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long t2 = tuple2._2$mcJ$sp();
        try {
            l = this.sfc().index(geom.getX(), geom.getY(), t2, lenient);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(37).append("Invalid z value from geometry/time: ").append(geom).append(",").append(dtg).toString(), e);
            }
            throw throwable;
        }
        long z = l;
        byte[] shard = this.sharding().apply(writable);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 10 + id.length, (ClassTag)ClassTag$.MODULE$.Byte());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(shard))) {
            ByteArrays$.MODULE$.writeShort(b2, bytes, 0);
            ByteArrays$.MODULE$.writeLong(z, bytes, 2);
            System.arraycopy(id, 0, bytes, 10, id.length);
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(shard)));
            ByteArrays$.MODULE$.writeShort(b2, bytes, 1);
            ByteArrays$.MODULE$.writeLong(z, bytes, 3);
            System.arraycopy(id, 0, bytes, 11, id.length);
        }
        return new package.SingleRowKeyValue<package.Z3IndexKey>(bytes, this.sharing(), shard, new package.Z3IndexKey(b2, z), tier, id, writable.values());
    }

    @Override
    public package.Z3IndexValues getIndexValues(Filter filter, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter, this.geomField, true);
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)new .colon.colon((Object)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon(), (List)Nil$.MODULE$), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$1 = filter;
        String x$22 = this.dtgField;
        boolean x$3 = true;
        boolean x$4 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$1, x$22, x$4, true);
        explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Geometries: ").append(geometries).toString());
        explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Intervals: ").append(intervals).toString());
        if (geometries.disjoint() || intervals.disjoint()) {
            explain.apply((Function0<String>)(Function0 & Serializable)() -> "Disjoint geometries or dates extracted, short-circuiting to empty query");
            return new package.Z3IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)package$.MODULE$.Seq().empty()), (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)((Seq)package$.MODULE$.Seq().empty()));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1 & Serializable)x$2 -> GeometryUtils$.MODULE$.bounds(x$2, multiplier, bits));
        long minTime = (long)this.sfc().time().min();
        long maxTime = (long)this.sfc().time().max();
        scala.collection.mutable.Map timesByBin = ((scala.collection.mutable.Map)Map$.MODULE$.empty()).withDefaultValue((Object)package$.MODULE$.Seq().empty());
        Builder unboundedBins = package$.MODULE$.Seq().newBuilder();
        intervals.foreach((Function1 & Serializable)interval -> {
            Tuple2 tuple2 = (Tuple2)this.boundsToDates().apply((Object)interval.bounds());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ZonedDateTime lower = (ZonedDateTime)tuple2._1();
            ZonedDateTime upper = (ZonedDateTime)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)lower, (Object)upper);
            ZonedDateTime lower2 = (ZonedDateTime)tuple22._1();
            ZonedDateTime upper2 = (ZonedDateTime)tuple22._2();
            BinnedTime binnedTime = (BinnedTime)this.dateToIndex().apply((Object)lower2);
            if (binnedTime == null) {
                throw new MatchError((Object)binnedTime);
            }
            short lb = binnedTime.bin();
            long lt = binnedTime.offset();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
            short lb2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long lt2 = tuple23._2$mcJ$sp();
            BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex().apply((Object)upper2);
            if (binnedTime2 == null) {
                throw new MatchError((Object)binnedTime2);
            }
            short ub = binnedTime2.bin();
            long ut = binnedTime2.offset();
            Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
            short ub2 = BoxesRunTime.unboxToShort((Object)tuple24._1());
            long ut2 = tuple24._2$mcJ$sp();
            if (interval.isBoundedBothSides()) {
                if (lb2 == ub2) {
                    timesByBin.update((Object)BoxesRunTime.boxToShort((short)lb2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcJJ.sp(lt2, ut2), (List)Nil$.MODULE$)));
                    return BoxedUnit.UNIT;
                }
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)lb2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcJJ.sp(lt2, maxTime), (List)Nil$.MODULE$)));
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)ub2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcJJ.sp(minTime, ut2), (List)Nil$.MODULE$)));
                package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)b -> timesByBin.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.sfc().wholePeriod()));
                return BoxedUnit.UNIT;
            }
            if (interval.lower().value().isDefined()) {
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)lb2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcJJ.sp(lt2, maxTime), (List)Nil$.MODULE$)));
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)(lb2 + 1))), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            }
            if (interval.upper().value().isDefined()) {
                timesByBin.update((Object)BoxesRunTime.boxToShort((short)ub2), ((IterableOps)timesByBin.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2.mcJJ.sp(minTime, ut2), (List)Nil$.MODULE$)));
                return unboundedBins.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)0), (Object)BoxesRunTime.boxToShort((short)((short)(ub2 - 1)))));
            }
            return BoxedUnit.UNIT;
        });
        return new package.Z3IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)timesByBin.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq<Tuple2<Object, Object>>)((Seq)unboundedBins.result()));
    }

    @Override
    public Iterator<package.ScanRange<package.Z3IndexKey>> getRanges(package.Z3IndexValues values, int multiplier) {
        package.Z3IndexValues z3IndexValues = values;
        if (z3IndexValues == null) {
            throw new MatchError((Object)z3IndexValues);
        }
        Z3SFC z3 = z3IndexValues.sfc();
        FilterValues<Geometry> geoms = z3IndexValues.geometries();
        Seq<Tuple4<Object, Object, Object, Object>> xy = z3IndexValues.spatialBounds();
        FilterValues<Bounds<ZonedDateTime>> intervals = z3IndexValues.intervals();
        Map<Object, Seq<Tuple2<Object, Object>>> timesByBin = z3IndexValues.temporalBounds();
        Seq<Tuple2<Object, Object>> unboundedBins = z3IndexValues.temporalUnbounded();
        Tuple6 tuple6 = new Tuple6((Object)z3, geoms, xy, intervals, timesByBin, unboundedBins);
        Z3SFC z32 = (Z3SFC)tuple6._1();
        FilterValues geoms2 = (FilterValues)tuple6._2();
        Seq xy2 = (Seq)tuple6._3();
        FilterValues intervals2 = (FilterValues)tuple6._4();
        Map timesByBin2 = (Map)tuple6._5();
        Seq unboundedBins2 = (Seq)tuple6._6();
        if (geoms2.disjoint() || intervals2.disjoint()) {
            return package$.MODULE$.Iterator().empty();
        }
        if (timesByBin2.isEmpty() && unboundedBins2.isEmpty()) {
            return package$.MODULE$.Iterator().single(new package.UnboundedRange<Object>(null));
        }
        LazyRef wholePeriodRanges$lzy = new LazyRef();
        Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1 & Serializable)t -> BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(1, timesByBin2.isEmpty() ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(t)) : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(t)) / timesByBin2.size() / multiplier)));
        Iterator bounded = timesByBin2.iterator().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                Seq times = (Seq)tuple2._2();
                Seq zs = times == z32.wholePeriod() ? Z3IndexKeySpace.wholePeriodRanges$1(wholePeriodRanges$lzy, z32, xy2, target) : Z3IndexKeySpace.toZRanges$1(times, z32, xy2, target);
                return (Seq)zs.map((Function1 & Serializable)range -> new package.BoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(bin, range.lower()), new package.Z3IndexKey(bin, range.upper())));
            }
            throw new MatchError((Object)tuple2);
        });
        Iterator unbounded = unboundedBins2.iterator().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short s2 = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (0 == s && Short.MAX_VALUE == s2) {
                    return new package.UnboundedRange<package.Z3IndexKey>(new package.Z3IndexKey(0, 0L));
                }
            }
            if (tuple2 != null) {
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (Short.MAX_VALUE == s) {
                    return new package.LowerBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(lower, 0L));
                }
            }
            if (tuple2 != null) {
                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (0 == s) {
                    return new package.UpperBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(upper, Long.MAX_VALUE));
                }
            }
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unexpected unbounded bin endpoints: {}:{}", new Object[]{BoxesRunTime.boxToShort((short)lower), BoxesRunTime.boxToShort((short)upper)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new package.UnboundedRange<package.Z3IndexKey>(new package.Z3IndexKey(0, 0L));
            }
            throw new MatchError((Object)tuple2);
        });
        return bounded.$plus$plus((Function0 & Serializable)() -> unbounded);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<package.Z3IndexKey>> ranges, boolean tier) {
        if (this.sharding().length() == 0) {
            return ranges.map((Function1 & Serializable)x0$1 -> {
                package.ScanRange scanRange = x0$1;
                if (scanRange instanceof package.BoundedRange) {
                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                    package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                    package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                }
                if (scanRange instanceof package.LowerBoundedRange) {
                    package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                    package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                    return new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                if (scanRange instanceof package.UpperBoundedRange) {
                    package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                    package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                }
                if (scanRange instanceof package.UnboundedRange) {
                    return new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange());
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            });
        }
        return ranges.flatMap((Function1 & Serializable)x0$2 -> {
            package.ScanRange scanRange = x0$2;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            if (scanRange instanceof package.LowerBoundedRange) {
                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                byte[] upper = package$ByteRange$.MODULE$.UnboundedUpperRange();
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            if (scanRange instanceof package.UpperBoundedRange) {
                package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                byte[] lower = package$ByteRange$.MODULE$.UnboundedLowerRange();
                byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                return (IterableOnce)this.sharding().shards().map((Function1 & Serializable)p -> new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, lower), ByteArrays$.MODULE$.concat(p, upper)));
            }
            if (scanRange instanceof package.UnboundedRange) {
                return new .colon.colon((Object)new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange()), (List)Nil$.MODULE$);
            }
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
        });
    }

    @Override
    public boolean useFullFilter(Option<package.Z3IndexValues> values, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        boolean looseBBox = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(hints.get((Object)QueryHints$.MODULE$.LOOSE_BBOX())).map((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Z3IndexKeySpace.$anonfun$useFullFilter$1(x))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> config.forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Z3IndexKeySpace.$anonfun$useFullFilter$3(x$7)))));
        return !looseBBox || Z3IndexKeySpace.unboundedDates$1(values) || Z3IndexKeySpace.complexGeoms$1(values);
    }

    private static final Seq toZRanges$1(Seq t, Z3SFC z3$1, Seq xy$1, Option target$1) {
        return z3$1.ranges(xy$1, t, 64, target$1);
    }

    private static final /* synthetic */ Seq wholePeriodRanges$lzycompute$1(LazyRef wholePeriodRanges$lzy$1, Z3SFC z3$1, Seq xy$1, Option target$1) {
        Seq seq;
        LazyRef lazyRef = wholePeriodRanges$lzy$1;
        synchronized (lazyRef) {
            seq = wholePeriodRanges$lzy$1.initialized() ? (Seq)wholePeriodRanges$lzy$1.value() : (Seq)wholePeriodRanges$lzy$1.initialize((Object)Z3IndexKeySpace.toZRanges$1(z3$1.wholePeriod(), z3$1, xy$1, target$1));
        }
        return seq;
    }

    private static final Seq wholePeriodRanges$1(LazyRef wholePeriodRanges$lzy$1, Z3SFC z3$1, Seq xy$1, Option target$1) {
        if (wholePeriodRanges$lzy$1.initialized()) {
            return (Seq)wholePeriodRanges$lzy$1.value();
        }
        return Z3IndexKeySpace.wholePeriodRanges$lzycompute$1(wholePeriodRanges$lzy$1, z3$1, xy$1, target$1);
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$1(Object x) {
        return BoxesRunTime.unboxToBoolean((Object)x);
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$3(GeoMesaDataStoreFactory.GeoMesaDataStoreConfig x$7) {
        return x$7.queries().looseBBox();
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$4(package.Z3IndexValues x$8) {
        return x$8.temporalUnbounded().nonEmpty();
    }

    private static final boolean unboundedDates$1(Option values$1) {
        return values$1.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Z3IndexKeySpace.$anonfun$useFullFilter$4(x$8)));
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$6(Geometry g) {
        return !GeometryUtils$.MODULE$.isRectangular(g);
    }

    public static final /* synthetic */ boolean $anonfun$useFullFilter$5(package.Z3IndexValues x$9) {
        return x$9.geometries().values().exists((Function1 & Serializable)g -> BoxesRunTime.boxToBoolean((boolean)Z3IndexKeySpace.$anonfun$useFullFilter$6(g)));
    }

    private static final boolean complexGeoms$1(Option values$1) {
        return values$1.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Z3IndexKeySpace.$anonfun$useFullFilter$5(x$9)));
    }

    public Z3IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField, String dtgField) {
        this.sft = sft;
        this.sharding = sharding;
        this.geomField = geomField;
        this.dtgField = dtgField;
        LazyLogging.$init$((LazyLogging)this);
        Predef$.MODULE$.require(Point.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0 & Serializable)() -> new StringBuilder(61).append("Expected field ").append($this.geomField).append(" to have a point binding, but instead it has: ").append(this.sft().getDescriptor($this.geomField).getType().getBinding().getSimpleName()).toString());
        Predef$.MODULE$.require(Date.class.isAssignableFrom(sft.getDescriptor(dtgField).getType().getBinding()), (Function0 & Serializable)() -> new StringBuilder(60).append("Expected field ").append($this.dtgField).append(" to have a date binding, but instead it has: ").append(this.sft().getDescriptor($this.dtgField).getType().getBinding().getSimpleName()).toString());
        this.sfc = Z3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.geomIndex = sft.indexOf(geomField);
        this.dtgIndex = sft.indexOf(dtgField);
        this.timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.attributes = new .colon.colon((Object)geomField, (List)new .colon.colon((Object)dtgField, (List)Nil$.MODULE$));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(10 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
    }
}

