/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.package$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.AggregatingScan$;
import org.locationtech.geomesa.index.iterators.ArrowScan;
import org.locationtech.geomesa.index.iterators.ArrowScan$Configuration$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

public final class ArrowScan$
implements LazyLogging {
    public static final ArrowScan$ MODULE$ = new ArrowScan$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        ArrowScan$ arrowScan$ = this;
        synchronized (arrowScan$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public ArrowScan.ArrowScanConfig configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?> index, GeoMesaStats stats, Option<Filter> filter, Option<Filter> ecql, Hints hints) {
        SimpleFeatureType arrowSft = (SimpleFeatureType)QueryHints$.MODULE$.RichHints(hints).getTransformSchema().getOrElse((Function0 & Serializable)() -> sft);
        boolean includeFids = QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid();
        boolean proxyFids = QueryHints$.MODULE$.RichHints(hints).isArrowProxyFid();
        Option<Tuple2<String, Object>> sort = QueryHints$.MODULE$.RichHints(hints).getArrowSort();
        int batchSize = this.getBatchSize(hints);
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids, proxyFids);
        String ipc = (String)QueryHints$.MODULE$.RichHints(hints).getArrowFormatVersion().getOrElse((Function0 & Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get());
        IpcOption ipcOpts = package.FormatVersion$.MODULE$.options(ipc);
        Seq<String> dictionaryFields = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields();
        Map<String, String> base = AggregatingScan$.MODULE$.configure(sft, index, ecql, QueryHints$.MODULE$.RichHints(hints).getTransform(), QueryHints$.MODULE$.RichHints(hints).getSampling(), batchSize);
        Map config = (Map)base.$plus$plus(AggregatingScan$.MODULE$.optionalMap((Seq<Tuple2<String, Either<String, Option<String>>>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.IncludeFidsKey()), AggregatingScan$.MODULE$.StringToConfig(Boolean.toString(includeFids))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.ProxyFidsKey()), AggregatingScan$.MODULE$.StringToConfig(Boolean.toString(proxyFids))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.IpcVersionKey()), AggregatingScan$.MODULE$.StringToConfig(ipc)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.SortKey()), AggregatingScan$.MODULE$.OptionToConfig((Option<String>)sort.map((Function1 & Serializable)x$4 -> (String)x$4._1()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.SortReverseKey()), AggregatingScan$.MODULE$.OptionToConfig((Option<String>)sort.map((Function1 & Serializable)x$5 -> Boolean.toString(x$5._2$mcZ$sp())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowScan$Configuration$.MODULE$.DictionaryKey()), AggregatingScan$.MODULE$.StringToConfig(dictionaryFields.mkString(",")))})));
        boolean process = QueryHints$.MODULE$.RichHints(hints).isArrowProcessDeltas();
        ArrowScan.DeltaReducer reducer = new ArrowScan.DeltaReducer(arrowSft, dictionaryFields, encoding, ipcOpts, batchSize, sort, false, process);
        return new ArrowScan.ArrowScanConfig((Map<String, String>)config, reducer);
    }

    public int getBatchSize(Hints hints) {
        return BoxesRunTime.unboxToInt((Object)QueryHints$.MODULE$.RichHints(hints).getArrowBatchSize().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get()))));
    }

    public SimpleFeature resultFeature() {
        return new ScalaSimpleFeature(package$.MODULE$.ArrowEncodedSft(), "", new Object[]{null, GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
    }

    private ArrowScan$() {
    }
}

