/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.iterators.AggregatingScan;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$Configuration$;
import org.locationtech.geomesa.index.utils.bin.BinSorter$;
import org.locationtech.geomesa.utils.bin.BinaryOutputCallback;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t=ha\u0002\u001b6!\u0003\r\t\u0001\u0011\u0005\b\u0005/\u0004A\u0011\u0001B1\u0011\u001d\u0011I\u000e\u0001C)\u00057DqAa;\u0001\t#\u0012ioB\u0003[k!\u00051LB\u00035k!\u0005A\fC\u0003^\u000b\u0011\u0005alB\u0003`\u000b!\u0005\u0001MB\u0003c\u000b!\u00051\rC\u0003^\u0011\u0011\u0005A\rC\u0004f\u0011\t\u0007I\u0011\u00014\t\r=D\u0001\u0015!\u0003h\u0011\u001d\u0001\bB1A\u0005\u0002\u0019Da!\u001d\u0005!\u0002\u00139\u0007b\u0002:\t\u0005\u0004%\tA\u001a\u0005\u0007g\"\u0001\u000b\u0011B4\t\u000fQD!\u0019!C\u0001M\"1Q\u000f\u0003Q\u0001\n\u001dDqA\u001e\u0005C\u0002\u0013\u0005a\r\u0003\u0004x\u0011\u0001\u0006Ia\u001a\u0005\bq\"\u0011\r\u0011\"\u0001g\u0011\u0019I\b\u0002)A\u0005O\"9!\u0010\u0003b\u0001\n\u00031\u0007bBA\u0003\u0011\u0001\u0006Ia\u001a\u0005\b\u0003\u0013)A\u0011AA\u0006\u0011\u001d\t\t,\u0002C\u0001\u0003g3a!!9\u0006\u0001\u0005\r\bB\u0003B\u00025\t\u0005\t\u0015!\u0003\u0003\u0006!Q!\u0011\u0003\u000e\u0003\u0002\u0004%IAa\u0005\t\u0015\tU!D!a\u0001\n\u0013\u00119\u0002\u0003\u0006\u0003$i\u0011\t\u0011)Q\u0005\u0005\u000bA!B!\n\u001b\u0005\u0003\u0005\u000b\u0011\u0002B\u0014\u0011)\u0011iC\u0007B\u0001B\u0003%\u0011q\u0012\u0005\u000b\u0003/S\"\u0011!Q\u0001\n\u0005e\u0005BB/\u001b\t\u0003\u0011y\u0003C\u0004\u0003>i!\tEa\u0010\t\u000f\tu\"\u0004\"\u0011\u0003T!9!q\f\u000e\u0005B\t\u0005\u0004b\u0002B25\u0011\u0005#Q\r\u0005\b\u0005cRB\u0011\tB:\u0011\u001d\u0011\tI\u0007C!\u0005CBqAa!\u001b\t\u0013\u0011)IB\u0004\u0003\f\u0016\t\tA!$\t\ruSC\u0011\u0001BU\u0011\u001d\u0011yF\u000bC!\u0005[CqA!-+\t\u0003\u0012\u0019\fC\u0004\u00036*\"\tEa.\t\u000f\tu\"\u0006\"\u0011\u0003:\"9!q\u0018\u0016\u0007\u0012\t\u0005\u0007b\u0002BcU\u0011\u0005!q\u0019\u0005\b\u0005\u001bTC\u0011\tBh\u0011\u001d\u0011\u0019N\u000bC!\u0005+\u0014!CQ5o\u0003\u001e<'/Z4bi&twmU2b]*\u0011agN\u0001\nSR,'/\u0019;peNT!\u0001O\u001d\u0002\u000b%tG-\u001a=\u000b\u0005iZ\u0014aB4f_6,7/\u0019\u0006\u0003yu\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011AP\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005;\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g\rE\u0002I\u0013.k\u0011!N\u0005\u0003\u0015V\u0012q\"Q4he\u0016<\u0017\r^5oON\u001b\u0017M\u001c\t\u0003\u0019jq!!\u0014\u0003\u000f\u00059KfBA(Y\u001d\t\u0001vK\u0004\u0002R-:\u0011!+V\u0007\u0002'*\u0011AkP\u0001\u0007yI|w\u000e\u001e \n\u0003yJ!\u0001P\u001f\n\u0005iZ\u0014B\u0001\u001d:\u0013\t1t'\u0001\nCS:\fum\u001a:fO\u0006$\u0018N\\4TG\u0006t\u0007C\u0001%\u0006'\t)\u0011)\u0001\u0004=S:LGO\u0010\u000b\u00027\u0006i1i\u001c8gS\u001e,(/\u0019;j_:\u0004\"!\u0019\u0005\u000e\u0003\u0015\u0011QbQ8oM&<WO]1uS>t7C\u0001\u0005B)\u0005\u0001\u0017aB*peR|\u0005\u000f^\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005Y\u0006twMC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'AB*ue&tw-\u0001\u0005T_J$x\n\u001d;!\u0003!!&/Y2l\u001fB$\u0018!\u0003+sC\u000e\\w\n\u001d;!\u0003\u001d9Um\\7PaR\f\u0001bR3p[>\u0003H\u000fI\u0001\b\t\u0006$Xm\u00149u\u0003!!\u0015\r^3PaR\u0004\u0013\u0001\u0003'bE\u0016dw\n\u001d;\u0002\u00131\u000b'-\u001a7PaR\u0004\u0013\u0001\u0004#bi\u0016\f%O]1z\u001fB$\u0018!\u0004#bi\u0016\f%O]1z\u001fB$\b%\u0001\u0007CCR\u001c\u0007nU5{K>\u0003H\u000fK\u0003\u0017y~\f\t\u0001\u0005\u0002C{&\u0011ap\u0011\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017aB7fgN\fw-Z\u0011\u0003\u0003\u0007\t!&Q4he\u0016<\u0017\r^5oON\u001b\u0017M\u001c\u0018D_:4\u0017nZ;sCRLwN\u001c\u0018CCR\u001c\u0007nU5{K>\u0003H/A\u0007CCR\u001c\u0007nU5{K>\u0003H\u000f\t\u0015\u0006/q|\u0018\u0011A\u0001\nG>tg-[4ve\u0016$b#!\u0004\u0002\"\u0005e\u0012QMA=\u0003{\n\t)a\"\u0002\f\u0006U\u0015q\u0014\t\t\u0003\u001f\t9\"!\b\u0002\u001e9!\u0011\u0011CA\n!\t\u00116)C\u0002\u0002\u0016\r\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u00111!T1q\u0015\r\t)b\u0011\t\u0005\u0003\u001f\ty\"C\u0002o\u00037Aq!a\t\u0019\u0001\u0004\t)#A\u0002tMR\u0004B!a\n\u000265\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003_\t\t$A\u0004gK\u0006$XO]3\u000b\u0007\u0005MR(A\u0004pa\u0016tw-[:\n\t\u0005]\u0012\u0011\u0006\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007B\u0002\u001d\u0019\u0001\u0004\tY\u0004\r\u0004\u0002>\u00055\u0013\u0011\r\t\t\u0003\u007f\t)%!\u0013\u0002`5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007:\u0014aA1qS&!\u0011qIA!\u0005M9Um\\'fg\u00064U-\u0019;ve\u0016Le\u000eZ3y!\u0011\tY%!\u0014\r\u0001\u0011a\u0011qJA\u001d\u0003\u0003\u0005\tQ!\u0001\u0002R\t\u0019q\fJ\u0019\u0012\t\u0005M\u0013\u0011\f\t\u0004\u0005\u0006U\u0013bAA,\u0007\n9aj\u001c;iS:<\u0007c\u0001\"\u0002\\%\u0019\u0011QL\"\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002L\u0005\u0005D\u0001DA2\u0003s\t\t\u0011!A\u0003\u0002\u0005E#aA0%e!9\u0011q\r\rA\u0002\u0005%\u0014A\u00024jYR,'\u000fE\u0003C\u0003W\ny'C\u0002\u0002n\r\u0013aa\u00149uS>t\u0007\u0003BA9\u0003kj!!a\u001d\u000b\t\u0005\u001d\u0014\u0011G\u0005\u0005\u0003o\n\u0019H\u0001\u0004GS2$XM\u001d\u0005\b\u0003wB\u0002\u0019AA\u000f\u0003\u001d!(/Y2l\u0013\u0012Dq!a \u0019\u0001\u0004\ti\"\u0001\u0003hK>l\u0007bBAB1\u0001\u0007\u0011QQ\u0001\u0004IR<\u0007#\u0002\"\u0002l\u0005u\u0001bBAE1\u0001\u0007\u0011QQ\u0001\u0006Y\u0006\u0014W\r\u001c\u0005\b\u0003\u001bC\u0002\u0019AAH\u0003%\u0011\u0017\r^2i'&TX\rE\u0002C\u0003#K1!a%D\u0005\rIe\u000e\u001e\u0005\b\u0003/C\u0002\u0019AAM\u0003\u0011\u0019xN\u001d;\u0011\u0007\t\u000bY*C\u0002\u0002\u001e\u000e\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\"b\u0001\r!a)\u0002\u0011M\fW\u000e\u001d7j]\u001e\u0004RAQA6\u0003K\u0003rAQAT\u0003W\u000b))C\u0002\u0002*\u000e\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001\"\u0002.&\u0019\u0011qV\"\u0003\u000b\u0019cw.\u0019;\u0002\u001bA\u0014x\u000e]3sift\u0015-\\3t)\u0019\t),a2\u0002`B1\u0011qWAa\u0003;qA!!/\u0002>:\u0019!+a/\n\u0003\u0011K1!a0D\u0003\u001d\u0001\u0018mY6bO\u0016LA!a1\u0002F\n\u00191+Z9\u000b\u0007\u0005}6\tC\u0004\u0002Jf\u0001\r!a3\u0002\u000b!Lg\u000e^:\u0011\t\u00055\u00171\\\u0007\u0003\u0003\u001fTA!!5\u0002T\u00069a-Y2u_JL(\u0002BAk\u0003/\fA!\u001e;jY*\u0019\u0011\u0011\\\u001f\u0002\u0011\u001d,w\u000e^8pYNLA!!8\u0002P\n)\u0001*\u001b8ug\"9\u00111E\rA\u0002\u0005\u0015\"A\u0004*fgVdGoQ1mY\n\f7m[\n\u00075\u0005\u000b)/a=\u0011\t\u0005\u001d\u0018Q\u001e\b\u0004\u0011\u0006%\u0018bAAvk\u0005y\u0011iZ4sK\u001e\fG/\u001b8h'\u000e\fg.\u0003\u0003\u0002p\u0006E(A\u0002*fgVdGOC\u0002\u0002lV\u0002B!!>\u0002\u00006\u0011\u0011q\u001f\u0006\u0005\u0003s\fY0A\u0002cS:T1!!@:\u0003\u0015)H/\u001b7t\u0013\u0011\u0011\t!a>\u0003)\tKg.\u0019:z\u001fV$\b/\u001e;DC2d'-Y2l\u0003\u0019\u0011WO\u001a4feB!!q\u0001B\u0007\u001b\t\u0011IAC\u0002\u0003\f-\f1A\\5p\u0013\u0011\u0011yA!\u0003\u0003\u0015\tKH/\u001a\"vM\u001a,'/\u0001\u0005pm\u0016\u0014h\r\\8x+\t\u0011)!\u0001\u0007pm\u0016\u0014h\r\\8x?\u0012*\u0017\u000f\u0006\u0003\u0003\u001a\t}\u0001c\u0001\"\u0003\u001c%\u0019!QD\"\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005Ci\u0012\u0011!a\u0001\u0005\u000b\t1\u0001\u001f\u00132\u0003%yg/\u001a:gY><\b%A\u0004f]\u000e|G-\u001a:\u0011\t\u0005U(\u0011F\u0005\u0005\u0005W\t9PA\nCS:\f'/_(viB,H/\u00128d_\u0012,'/A\u0004cS:\u001c\u0016N_3\u0015\u0019\tE\"1\u0007B\u001b\u0005o\u0011IDa\u000f\u0011\u0005\u0005T\u0002b\u0002B\u0002E\u0001\u0007!Q\u0001\u0005\b\u0005#\u0011\u0003\u0019\u0001B\u0003\u0011\u001d\u0011)C\ta\u0001\u0005OAqA!\f#\u0001\u0004\ty\tC\u0004\u0002\u0018\n\u0002\r!!'\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\te!\u0011\tB\"\u0005\u000f\u0012Y\u0005C\u0004\u0002|\r\u0002\r!a$\t\u000f\t\u00153\u00051\u0001\u0002,\u0006\u0019A.\u0019;\t\u000f\t%3\u00051\u0001\u0002,\u0006\u0019An\u001c8\t\u000f\u0005\r5\u00051\u0001\u0003NA\u0019!Ia\u0014\n\u0007\tE3I\u0001\u0003M_:<G\u0003\u0004B\r\u0005+\u00129F!\u0017\u0003\\\tu\u0003bBA>I\u0001\u0007\u0011q\u0012\u0005\b\u0005\u000b\"\u0003\u0019AAV\u0011\u001d\u0011I\u0005\na\u0001\u0003WCq!a!%\u0001\u0004\u0011i\u0005C\u0004\u0002\n\u0012\u0002\rA!\u0014\u0002\t%t\u0017\u000e\u001e\u000b\u0003\u00053\t\u0011\"Y4he\u0016<\u0017\r^3\u0015\t\u0005=%q\r\u0005\b\u0005S2\u0003\u0019\u0001B6\u0003\t\u0019h\r\u0005\u0003\u0002(\t5\u0014\u0002\u0002B8\u0003S\u0011QbU5na2,g)Z1ukJ,\u0017AB3oG>$W\r\u0006\u0002\u0003vA)!Ia\u001e\u0003|%\u0019!\u0011P\"\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\t\u0013i(C\u0002\u0003\u0000\r\u0013AAQ=uK\u000691\r\\3b]V\u0004\u0018AD3ogV\u0014XmQ1qC\u000eLG/\u001f\u000b\u0005\u0005\u000b\u00119\tC\u0004\u0003\n&\u0002\r!a$\u0002\tML'0\u001a\u0002\u0015\u0005&t'+Z:vYR\u001cHk\u001c$fCR,(/Z:\u0016\t\t=%QU\n\u0005U\u0005\u0013\t\n\u0005\u0004\u0003\u0014\nu%1\u0015\b\u0005\u0005+\u0013IJD\u0002O\u0005/K1!a\u00118\u0013\u0011\u0011Y*!\u0011\u0002\u0013E+XM]=QY\u0006t\u0017\u0002\u0002BP\u0005C\u0013\u0011CU3tk2$8\u000fV8GK\u0006$XO]3t\u0015\u0011\u0011Y*!\u0011\u0011\t\u0005-#Q\u0015\u0003\b\u0005OS#\u0019AA)\u0005\u0005!FC\u0001BV!\u0011\t'Fa)\u0015\t\te!q\u0016\u0005\b\u0005cc\u0003\u0019AA\u0007\u0003\u0015\u0019H/\u0019;f+\t\ti!\u0001\u0004tG\",W.Y\u000b\u0003\u0003K!BAa\u001b\u0003<\"9!QX\u0018A\u0002\t\r\u0016A\u0002:fgVdG/A\u0003csR,7\u000f\u0006\u0003\u0003v\t\r\u0007b\u0002B_a\u0001\u0007!1U\u0001\tG\u0006tW)];bYR!\u0011\u0011\u0014Be\u0011\u001d\u0011Y-\ra\u0001\u00033\nQa\u001c;iKJ\fa!Z9vC2\u001cH\u0003BAM\u0005#DqAa33\u0001\u0004\tI&\u0001\u0005iCND7i\u001c3f)\t\ty)\u0001\u0004%S:LG\u000fJ\u0001\rGJ,\u0017\r^3SKN,H\u000e\u001e\u000b\n\u0017\nu'q\u001cBs\u0005ODq!a\t\u0003\u0001\u0004\t)\u0003C\u0004\u0003b\n\u0001\rAa9\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007#\u0002\"\u0002l\u0005\u0015\u0002bBAG\u0005\u0001\u0007\u0011q\u0012\u0005\b\u0005S\u0014\u0001\u0019AA\u0007\u0003\u001dy\u0007\u000f^5p]N\f\u0001\u0003Z3gCVdGOQ1uG\"\u001c\u0016N_3\u0016\u0005\u0005=\u0005")
public interface BinAggregatingScan
extends AggregatingScan<ResultCallback> {
    public static Seq<String> propertyNames(Hints hints, SimpleFeatureType sft) {
        return BinAggregatingScan$.MODULE$.propertyNames(hints, sft);
    }

    public static Map<String, String> configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?> index, Option<Filter> filter, String trackId, String geom, Option<String> dtg, Option<String> label, int batchSize, boolean sort, Option<Tuple2<Object, Option<String>>> sampling) {
        return BinAggregatingScan$.MODULE$.configure(sft, index, filter, trackId, geom, dtg, label, batchSize, sort, sampling);
    }

    public static /* synthetic */ ResultCallback createResult$(BinAggregatingScan $this, SimpleFeatureType sft, Option transform, int batchSize, Map options) {
        return $this.createResult(sft, (Option<SimpleFeatureType>)transform, batchSize, (Map<String, String>)options);
    }

    @Override
    default public ResultCallback createResult(SimpleFeatureType sft, Option<SimpleFeatureType> transform, int batchSize, Map<String, String> options) {
        Option geom = options.get((Object)BinAggregatingScan$Configuration$.MODULE$.GeomOpt()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != -1);
        Option dtg = options.get((Object)BinAggregatingScan$Configuration$.MODULE$.DateOpt()).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 != -1);
        Option track = options.get((Object)BinAggregatingScan$Configuration$.MODULE$.TrackOpt()).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$5)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 != -1);
        Option label = options.get((Object)BinAggregatingScan$Configuration$.MODULE$.LabelOpt()).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$7)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 != -1);
        BinaryOutputEncoder encoder = BinaryOutputEncoder$.MODULE$.apply(sft, new BinaryOutputEncoder.EncodingOptions(geom, dtg, track, label, BinaryOutputEncoder.EncodingOptions$.MODULE$.apply$default$5()));
        int binSize = label.isEmpty() ? 16 : 24;
        boolean sort = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)options.apply((Object)BinAggregatingScan$Configuration$.MODULE$.SortOpt())));
        ByteBuffer buffer = ByteBuffer.wrap((byte[])Array$.MODULE$.ofDim(batchSize * binSize, (ClassTag)ClassTag$.MODULE$.Byte())).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer overflow = ByteBuffer.wrap((byte[])Array$.MODULE$.ofDim(binSize * 16, (ClassTag)ClassTag$.MODULE$.Byte())).order(ByteOrder.LITTLE_ENDIAN);
        return new ResultCallback(buffer, overflow, encoder, binSize, sort);
    }

    public static /* synthetic */ int defaultBatchSize$(BinAggregatingScan $this) {
        return $this.defaultBatchSize();
    }

    @Override
    default public int defaultBatchSize() {
        throw new IllegalArgumentException("Batch scan is specified per scan");
    }

    public static void $init$(BinAggregatingScan $this) {
    }

    public static abstract class BinResultsToFeatures<T>
    implements QueryPlan.ResultsToFeatures<T> {
        @Override
        public void init(Map<String, String> state) {
        }

        @Override
        public Map<String, String> state() {
            return Predef$.MODULE$.Map().empty();
        }

        @Override
        public SimpleFeatureType schema() {
            return BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        }

        @Override
        public SimpleFeature apply(T result) {
            return new ScalaSimpleFeature(BinaryOutputEncoder$.MODULE$.BinEncodedSft(), "", new Object[]{this.bytes(result), GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
        }

        public abstract byte[] bytes(T var1);

        public boolean canEqual(Object other) {
            return other instanceof BinResultsToFeatures;
        }

        public boolean equals(Object other) {
            BinResultsToFeatures binResultsToFeatures;
            Object object = other;
            return object instanceof BinResultsToFeatures && (binResultsToFeatures = (BinResultsToFeatures)object).canEqual(this);
        }

        public int hashCode() {
            return this.schema().hashCode();
        }
    }

    public static class ResultCallback
    implements AggregatingScan.Result,
    BinaryOutputCallback {
        private final ByteBuffer buffer;
        private ByteBuffer overflow;
        private final BinaryOutputEncoder encoder;
        private final int binSize;
        private final boolean sort;

        public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg) {
            BinaryOutputCallback.put$((BinaryOutputCallback)this, (ByteBuffer)buffer, (int)trackId, (float)lat, (float)lon, (long)dtg);
        }

        public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg, long label) {
            BinaryOutputCallback.put$((BinaryOutputCallback)this, (ByteBuffer)buffer, (int)trackId, (float)lat, (float)lon, (long)dtg, (long)label);
        }

        private ByteBuffer overflow() {
            return this.overflow;
        }

        private void overflow_$eq(ByteBuffer x$1) {
            this.overflow = x$1;
        }

        public void apply(int trackId, float lat, float lon, long dtg) {
            this.put(this.ensureCapacity(16), trackId, lat, lon, dtg);
        }

        public void apply(int trackId, float lat, float lon, long dtg, long label) {
            this.put(this.ensureCapacity(24), trackId, lat, lon, dtg, label);
        }

        @Override
        public void init() {
        }

        @Override
        public int aggregate(SimpleFeature sf) {
            int pos = this.buffer.position() + this.overflow().position();
            this.encoder.encode(sf, (BinaryOutputCallback)this);
            return (this.buffer.position() + this.overflow().position() - pos) / this.binSize;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] encode() {
            byte[] bytes;
            block8: {
                byte[] byArray;
                try {
                    if (this.overflow().position() > 0) {
                        byte[] copy = (byte[])Array$.MODULE$.ofDim(this.buffer.position() + this.overflow().position(), (ClassTag)ClassTag$.MODULE$.Byte());
                        System.arraycopy(this.buffer.array(), 0, copy, 0, this.buffer.position());
                        System.arraycopy(this.overflow().array(), 0, copy, this.buffer.position(), this.overflow().position());
                        byArray = copy;
                    } else if (this.buffer.position() == this.buffer.limit()) {
                        byArray = this.buffer.array();
                    } else {
                        void var3_2;
                        byte[] copy = (byte[])Array$.MODULE$.ofDim(this.buffer.position(), (ClassTag)ClassTag$.MODULE$.Byte());
                        System.arraycopy(this.buffer.array(), 0, copy, 0, this.buffer.position());
                        byArray = var3_2;
                    }
                }
                finally {
                    this.buffer.clear();
                    this.overflow().clear();
                }
                bytes = byArray;
                if (!this.sort) break block8;
                BinSorter$.MODULE$.quickSort(bytes, 0, bytes.length - this.binSize, this.binSize);
            }
            return bytes;
        }

        @Override
        public void cleanup() {
        }

        private ByteBuffer ensureCapacity(int size) {
            if (this.buffer.position() < this.buffer.limit() - size) {
                return this.buffer;
            }
            if (this.overflow().position() < this.overflow().limit() - size) {
                return this.overflow();
            }
            byte[] expanded = (byte[])Array$.MODULE$.ofDim(this.overflow().limit() * 2, (ClassTag)ClassTag$.MODULE$.Byte());
            System.arraycopy(this.overflow().array(), 0, expanded, 0, this.overflow().limit());
            ByteOrder order = this.overflow().order();
            int position = this.overflow().position();
            this.overflow_$eq((ByteBuffer)ByteBuffer.wrap(expanded).order(order).position(position));
            return this.overflow();
        }

        public ResultCallback(ByteBuffer buffer, ByteBuffer overflow, BinaryOutputEncoder encoder, int binSize, boolean sort) {
            this.buffer = buffer;
            this.overflow = overflow;
            this.encoder = encoder;
            this.binSize = binSize;
            this.sort = sort;
            BinaryOutputCallback.$init$((BinaryOutputCallback)this);
        }
    }
}

