/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureDeserialization$;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureSerialization$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.AggregatingScan$;
import org.locationtech.geomesa.index.iterators.DensityScan;
import org.locationtech.geomesa.index.iterators.DensityScan$Configuration$;
import org.locationtech.geomesa.index.iterators.DensityScan$EqualWeight$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.geotools.RenderingGrid;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.interop.SimpleFeatureTypes;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class DensityScan$
implements LazyLogging {
    public static final DensityScan$ MODULE$ = new DensityScan$();
    private static final GeoMesaSystemProperties.SystemProperty BatchSize;
    private static final SimpleFeatureType DensitySft;
    private static final Hints.ClassKey DensityValueKey;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        BatchSize = new GeoMesaSystemProperties.SystemProperty("geomesa.density.batch.size", "100000");
        DensitySft = SimpleFeatureTypes.createType((String)"density", (String)"*geom:Point:srid=4326");
        DensityValueKey = new Hints.ClassKey(byte[].class);
    }

    private Logger logger$lzycompute() {
        DensityScan$ densityScan$ = this;
        synchronized (densityScan$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public GeoMesaSystemProperties.SystemProperty BatchSize() {
        return BatchSize;
    }

    public SimpleFeatureType DensitySft() {
        return DensitySft;
    }

    public Hints.ClassKey DensityValueKey() {
        return DensityValueKey;
    }

    public Map<String, String> configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?> index, Option<Filter> filter, Hints hints) {
        String geom = this.getDensityGeometry(sft, hints);
        Envelope envelope = (Envelope)QueryHints$.MODULE$.RichHints(hints).getDensityEnvelope().get();
        Tuple2 tuple2 = (Tuple2)QueryHints$.MODULE$.RichHints(hints).getDensityBounds().get();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int width = tuple2._1$mcI$sp();
        int height = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(width, height);
        int width2 = sp2._1$mcI$sp();
        int height2 = sp2._2$mcI$sp();
        int batchSize = BoxesRunTime.unboxToInt((Object)this.BatchSize().toInt().get());
        Map<String, String> base = AggregatingScan$.MODULE$.configure(sft, index, filter, (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, QueryHints$.MODULE$.RichHints(hints).getSampling(), batchSize);
        return (Map)base.$plus$plus(AggregatingScan$.MODULE$.optionalMap((Seq<Tuple2<String, Either<String, Option<String>>>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.GeometryOpt()), AggregatingScan$.MODULE$.StringToConfig(geom)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.EnvelopeOpt()), AggregatingScan$.MODULE$.StringToConfig(new java.lang.StringBuilder(3).append(envelope.getMinX()).append(",").append(envelope.getMaxX()).append(",").append(envelope.getMinY()).append(",").append(envelope.getMaxY()).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.GridOpt()), AggregatingScan$.MODULE$.StringToConfig(new java.lang.StringBuilder(1).append(width2).append(",").append(height2).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.WeightOpt()), AggregatingScan$.MODULE$.OptionToConfig(QueryHints$.MODULE$.RichHints(hints).getDensityWeight()))})));
    }

    public byte[] encodeResult(RenderingGrid result) {
        Output output = KryoFeatureSerialization$.MODULE$.getOutput(null);
        result.iterator().toList().groupBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)DensityScan$.$anonfun$encodeResult$1(x$6))).foreach((Function1 & Serializable)x0$1 -> {
            DensityScan$.$anonfun$encodeResult$2(output, x0$1);
            return BoxedUnit.UNIT;
        });
        return output.toBytes();
    }

    public Function1<SimpleFeature, Iterator<Tuple3<Object, Object, Object>>> decodeResult(Envelope envelope, int gridWidth, int gridHeight) {
        GridSnap gridSnap = new GridSnap(envelope, gridWidth, gridHeight);
        return (Function1 & Serializable)sf -> MODULE$.decodeResult(gridSnap, (SimpleFeature)sf);
    }

    public Iterator<Tuple3<Object, Object, Object>> decodeResult(GridSnap gridSnap, SimpleFeature sf) {
        byte[] result = (byte[])sf.getUserData().get(this.DensityValueKey());
        Input input = KryoFeatureDeserialization$.MODULE$.getInput(result, 0, result.length);
        return new Iterator<Tuple3<Object, Object, Object>>(input, gridSnap){
            private double x;
            private int colCount;
            private final Input input$1;
            private final GridSnap gridSnap$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Tuple3<Object, Object, Object>> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Tuple3<Object, Object, Object>> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Tuple3<Object, Object, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> partition(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Tuple3<Object, Object, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Tuple3<Object, Object, Object>> filter(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> filterNot(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> filterImpl(Function1<Tuple3<Object, Object, Object>, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Tuple3<Object, Object, Object>> withFilter(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple3<Object, Object, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Tuple3<Object, Object, Object>> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<Tuple3<Object, Object, Object>> distinctBy(Function1<Tuple3<Object, Object, Object>, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<Tuple3<Object, Object, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple3<Object, Object, Object>, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<Tuple3<Object, Object, Object>, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Tuple3<Object, Object, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple3<Object, Object, Object>> takeWhile(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple3<Object, Object, Object>> dropWhile(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> span(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple3<Object, Object, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<Tuple3<Object, Object, Object>, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Tuple3<Object, Object, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<Tuple3<Object, Object, Object>> tapEach(Function1<Tuple3<Object, Object, Object>, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Tuple3<Object, Object, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Tuple3<Object, Object, Object>, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Tuple3<Object, Object, Object>> find(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple3<Object, Object, Object>> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple3<Object, Object, Object>> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Tuple3<Object, Object, Object>> maxByOption(Function1<Tuple3<Object, Object, Object>, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Tuple3<Object, Object, Object>> minByOption(Function1<Tuple3<Object, Object, Object>, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple3<Object, Object, Object>, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple3<Object, Object, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Tuple3<Object, Object, Object>, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Tuple3<Object, Object, Object>, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Tuple3<Object, Object, Object>> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Tuple3<Object, Object, Object>> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Tuple3<Object, Object, Object>> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<Tuple3<Object, Object, Object>, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Tuple3<Object, Object, Object>> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Tuple3<Object, Object, Object>> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Tuple3<Object, Object, Object>> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Tuple3<Object, Object, Object>> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Tuple3<Object, Object, Object>, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private double x() {
                return this.x;
            }

            private void x_$eq(double x$1) {
                this.x = x$1;
            }

            private int colCount() {
                return this.colCount;
            }

            private void colCount_$eq(int x$1) {
                this.colCount = x$1;
            }

            public boolean hasNext() {
                return this.input$1.position() < this.input$1.limit();
            }

            public Tuple3<Object, Object, Object> next() {
                if (this.colCount() == 0) {
                    this.x_$eq(this.gridSnap$1.x(this.input$1.readInt(true)));
                    this.colCount_$eq(this.input$1.readInt(true));
                }
                double y = this.gridSnap$1.y(this.input$1.readInt(true));
                double weight = this.input$1.readDouble();
                this.colCount_$eq(this.colCount() - 1);
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)this.x()), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToDouble((double)weight));
            }
            {
                this.input$1 = input$1;
                this.gridSnap$1 = gridSnap$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.x = 0.0;
                this.colCount = 0;
            }
        };
    }

    public Seq<String> propertyNames(Hints hints, SimpleFeatureType sft) {
        String geom = (String)QueryHints$.MODULE$.RichHints(hints).getDensityGeometry().getOrElse((Function0 & Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Option weight = QueryHints$.MODULE$.RichHints(hints).getDensityWeight().map((Function1 & Serializable)x$1 -> ECQL.toExpression((String)x$1));
        return (Seq)((SeqOps)new .colon.colon((Object)geom, (List)Nil$.MODULE$).$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(weight).toSeq().flatMap((Function1 & Serializable)x$7 -> FilterHelper$.MODULE$.propertyNames(x$7, sft)))).distinct();
    }

    public DensityScan.GeometryRenderer getRenderer(SimpleFeatureType sft, String geom, Option<String> weight) {
        Class clazz;
        DensityScan.Weigher weigher;
        Option<String> option = weight;
        if (None$.MODULE$.equals(option)) {
            weigher = DensityScan$EqualWeight$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String w = (String)some.value();
            int i = sft.indexOf(w);
            weigher = i == -1 ? new DensityScan.WeightByExpression(ECQL.toExpression((String)w)) : (Number.class.isAssignableFrom(sft.getDescriptor(i).getType().getBinding()) ? new DensityScan.WeightByNumber(i) : new DensityScan.WeightByNonNumber(i));
        } else {
            throw new MatchError(option);
        }
        DensityScan$EqualWeight$ weigher2 = weigher;
        int i = sft.indexOf(geom);
        Class clazz2 = clazz = sft.getDescriptor(i).getType().getBinding();
        Class<Point> clazz3 = Point.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            return new DensityScan.PointRenderer(i, weigher2);
        }
        Class clazz4 = clazz;
        Class<MultiPoint> clazz5 = MultiPoint.class;
        if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
            return new DensityScan.MultiPointRenderer(i, weigher2);
        }
        Class clazz6 = clazz;
        Class<LineString> clazz7 = LineString.class;
        if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
            return new DensityScan.LineStringRenderer(i, weigher2);
        }
        Class clazz8 = clazz;
        Class<MultiLineString> clazz9 = MultiLineString.class;
        if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
            return new DensityScan.MultiLineStringRenderer(i, weigher2);
        }
        Class clazz10 = clazz;
        Class<Polygon> clazz11 = Polygon.class;
        if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
            return new DensityScan.PolygonRenderer(i, weigher2);
        }
        Class clazz12 = clazz;
        Class<MultiPolygon> clazz13 = MultiPolygon.class;
        if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
            return new DensityScan.MultiPolygonRenderer(i, weigher2);
        }
        return new DensityScan.MultiRenderer(i, weigher2);
    }

    public String getDensityGeometry(SimpleFeatureType sft, Hints hints) {
        String geom = (String)QueryHints$.MODULE$.RichHints(hints).getDensityGeometry().getOrElse((Function0 & Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Predef$.MODULE$.require(sft.indexOf(geom) != -1 && Geometry.class.isAssignableFrom(sft.getDescriptor(geom).getType().getBinding()), (Function0 & Serializable)() -> new java.lang.StringBuilder(24).append("Invalid geometry field: ").append(geom).toString());
        return geom;
    }

    public static final /* synthetic */ int $anonfun$encodeResult$1(Tuple2 x$6) {
        return ((Tuple2)x$6._1())._1$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$encodeResult$3(Output output$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Tuple2 xy = (Tuple2)tuple2._1();
            double weight = tuple2._2$mcD$sp();
            output$1.writeInt(xy._2$mcI$sp(), true);
            output$1.writeDouble(weight);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$encodeResult$2(Output output$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int row = tuple2._1$mcI$sp();
            List cols = (List)tuple2._2();
            output$1.writeInt(row, true);
            output$1.writeInt(cols.size(), true);
            cols.foreach((Function1 & Serializable)x0$2 -> {
                DensityScan$.$anonfun$encodeResult$3(output$1, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private DensityScan$() {
    }
}

