/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.io.Serializable;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.iterators.AggregatingScan;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$Configuration$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.geotools.RenderingGrid;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0011ufaB:u!\u0003\r\ta \u0005\b\t7\u0003A\u0011\u0001C$\u0011-!Y\u0004\u0001a\u0001\u0002\u0004%\t\u0002\"(\t\u0017\u0011\u0005\u0006\u00011AA\u0002\u0013EA1\u0015\u0005\b\tO\u0003A\u0011\u000bCU\u0011\u001d!Y\f\u0001C)\u0007c9q!a\ru\u0011\u0003\t)D\u0002\u0004ti\"\u0005\u0011q\u0007\u0005\b\u0003\u001b:A\u0011AA(\u000b\u0019\t\tf\u0002\u0001\u0002T!I\u00111R\u0004C\u0002\u0013\u0005\u0011Q\u0012\u0005\t\u0003[;\u0001\u0015!\u0003\u0002\u0010\"I\u0011qV\u0004C\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\u0003s;\u0001\u0015!\u0003\u00024\"I\u00111X\u0004C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003K<\u0001\u0015!\u0003\u0002@\u001e9\u0011q]\u0004\t\u0002\u0005%haBAw\u000f!\u0005\u0011q\u001e\u0005\b\u0003\u001b\nB\u0011AAy\u0011%\t\u00190\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\bE\u0001\u000b\u0011BA|\u0011%\u0011I!\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\fE\u0001\u000b\u0011BA|\u0011%\u0011i!\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\u0010E\u0001\u000b\u0011BA|\u0011%\u0011\t\"\u0005b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003\u0014E\u0001\u000b\u0011BA|\u0011\u001d\u0011)b\u0002C\u0001\u0005/AqA! \b\t\u0003\u0011y\bC\u0004\u0003\u001c\u001e!\tA!(\t\u000f\tmu\u0001\"\u0001\u0003D\"9!Q[\u0004\u0005\u0002\t]\u0007b\u0002Br\u000f\u0011\u0005!Q\u001d\u0005\b\tC9A\u0011\u0001C\u0012\r\u0019!Ic\u0002\u0001\u0005,!QA1\b\u0012\u0003\u0002\u0003\u0006IAa:\t\u0015\te(E!A!\u0002\u0013\u0011\t\nC\u0004\u0002N\t\"\t\u0001\"\u0010\t\u000f\u0011\u0015#\u0005\"\u0011\u0005H!9A\u0011\n\u0012\u0005B\u0011-\u0003b\u0002C(E\u0011\u0005C\u0011\u000b\u0005\b\t'\u0012C\u0011\tC$\r\u001d!)fBA\u0001\t/Bq!!\u0014+\t\u0003!\u0019\bC\u0004\u0005F)\"\t\u0005b\u001e\t\u000f\u0011m$\u0006\"\u0011\u0005~!9Aq\u0010\u0016\u0005B\u0005E\u0006b\u0002CAU\u0011\u0005C1\u0011\u0005\b\t\u000fSc\u0011\u0003CE\u0011\u001d\u0019IE\u000bC\u0001\t\u001bCq\u0001b%+\t\u0003\")\nC\u0004\u0004V)\"\tea\u0016\u0007\u0013\r%q\u0001%A\u0012\"\r-\u0001bBB\u0007i\u0019\u00051qB\u0004\b\t3;\u0001\u0012QB\u0014\r\u001d\u0019)b\u0002EA\u0007/Aq!!\u00148\t\u0003\u0019)\u0003C\u0004\u0004\u000e]\"\te!\u000b\t\u0013\r5r'!A\u0005B\u0005U\b\"CB\u0018o\u0005\u0005I\u0011AB\u0019\u0011%\u0019\u0019dNA\u0001\n\u0003\u0019)\u0004C\u0005\u0004<]\n\t\u0011\"\u0011\u0004>!I1\u0011J\u001c\u0002\u0002\u0013\u000511\n\u0005\n\u0007+:\u0014\u0011!C!\u0007/B\u0011b!\u00178\u0003\u0003%\tea\u0017\t\u0013\rus'!A\u0005\n\r}cABBI\u000f\u0001\u0019\u0019\n\u0003\u0006\u0004\u0004\t\u0013\t\u0011)A\u0005\u0005sCq!!\u0014C\t\u0003\u0019)\nC\u0004\u0004\u000e\t#\tea'\u0007\r\r\ru\u0001ABC\u0011)\u0019\u0019A\u0012B\u0001B\u0003%!\u0011\u0018\u0005\b\u0003\u001b2E\u0011ABD\u0011\u001d\u0019iA\u0012C!\u0007\u001b3aaa\u001a\b\u0001\r%\u0004BCB6\u0015\n\u0005\t\u0015!\u0003\u0004n!9\u0011Q\n&\u0005\u0002\re\u0004bBB\u0007\u0015\u0012\u00053q\u0010\u0004\n\u0005S<\u0001\u0013aI\u0011\u0005WDqA!<O\r\u0003\u0011yO\u0002\u0004\u0004v\u001e\u00011q\u001f\u0005\u000b\u0007\u0007\u0001&\u0011!Q\u0001\n\te\u0006BCB\u0003!\n\u0005\t\u0015!\u0003\u0004\b!9\u0011Q\n)\u0005\u0002\re\bb\u0002Bw!\u0012\u0005C\u0011\u0001\u0004\u0007\u0007\u007f;\u0001a!1\t\u0015\r\rQK!A!\u0002\u0013\u0011I\f\u0003\u0006\u0004\u0006U\u0013\t\u0011)A\u0005\u0007\u000fAq!!\u0014V\t\u0003\u0019\u0019\rC\u0004\u0003nV#\tea3\u0007\r\t}x\u0001AB\u0001\u0011)\u0019\u0019A\u0017B\u0001B\u0003%!\u0011\u0018\u0005\u000b\u0007\u000bQ&\u0011!Q\u0001\n\r\u001d\u0001bBA'5\u0012\u00051q\u0014\u0005\b\u0005[TF\u0011IBT\r\u0019\u0019ik\u0002\u0001\u00040\"Q11A0\u0003\u0002\u0003\u0006IA!/\t\u0015\r\u0015qL!A!\u0002\u0013\u00199\u0001C\u0004\u0002N}#\ta!-\t\u000f\t5x\f\"\u0011\u0004:\u001a1AqA\u0004\u0001\t\u0013A!ba\u0001e\u0005\u0003\u0005\u000b\u0011\u0002B]\u0011)\u0019)\u0001\u001aB\u0001B\u0003%1q\u0001\u0005\b\u0003\u001b\"G\u0011\u0001C\u0006\u0011\u001d\u0011i\u000f\u001aC!\t'1aa!5\b\u0001\rM\u0007BCB\u0002S\n\u0005\t\u0015!\u0003\u0003:\"Q1QA5\u0003\u0002\u0003\u0006Iaa\u0002\t\u000f\u00055\u0013\u000e\"\u0001\u0004V\"9!Q^5\u0005B\rugABBr\u000f\u0001\u0019)\u000f\u0003\u0006\u0004\u00049\u0014\t\u0011)A\u0005\u0005sC!b!\u0002o\u0005\u0003\u0005\u000b\u0011BB\u0004\u0011\u001d\tiE\u001cC\u0001\u0007ODqA!<o\t\u0003\u001ayOA\u0006EK:\u001c\u0018\u000e^=TG\u0006t'BA;w\u0003%IG/\u001a:bi>\u00148O\u0003\u0002xq\u0006)\u0011N\u001c3fq*\u0011\u0011P_\u0001\bO\u0016|W.Z:b\u0015\tYH0\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001~\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011\u0011AA\u0007!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!BAA\u0004\u0003\u0015\u00198-\u00197b\u0013\u0011\tY!!\u0002\u0003\r\u0005s\u0017PU3g!\u0019\ty!!\u0005\u0002\u00165\tA/C\u0002\u0002\u0014Q\u0014q\"Q4he\u0016<\u0017\r^5oON\u001b\u0017M\u001c\t\u0004\u0003/\u0011cbAA\r\r9!\u00111DA\u0019\u001d\u0011\ti\"a\f\u000f\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tYC\u0004\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9C`\u0001\u0007yI|w\u000e\u001e \n\u0003uL!a\u001f?\n\u0005eT\u0018BA<y\u0013\t)h/A\u0006EK:\u001c\u0018\u000e^=TG\u0006t\u0007cAA\b\u000fM)q!!\u0001\u0002:A!\u00111HA%\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013\u0001D:dC2\fGn\\4hS:<'\u0002BA\"\u0003\u000b\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003\u000f\n1aY8n\u0013\u0011\tY%!\u0010\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005U\"\u0001D$sS\u0012LE/\u001a:bi>\u0014\b\u0003CA\u0002\u0003+\nI&!\u001c\n\t\u0005]\u0013Q\u0001\u0002\n\rVt7\r^5p]F\u0002B!a\u0017\u0002j5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003G\n)'A\u0004gK\u0006$XO]3\u000b\u0007\u0005\u001dD0A\u0004pa\u0016tw-[:\n\t\u0005-\u0014Q\f\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0011\r\u0005=\u0014\u0011PA@\u001d\u0011\t\t(!\u001e\u000f\t\u0005\r\u00121O\u0005\u0003\u0003\u000fIA!a\u001e\u0002\u0006\u00059\u0001/Y2lC\u001e,\u0017\u0002BA>\u0003{\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0005\u0003o\n)\u0001\u0005\u0006\u0002\u0004\u0005\u0005\u0015QQAC\u0003\u000bKA!a!\u0002\u0006\t1A+\u001e9mKN\u0002B!a\u0001\u0002\b&!\u0011\u0011RA\u0003\u0005\u0019!u.\u001e2mK\u0006I!)\u0019;dQNK'0Z\u000b\u0003\u0003\u001f\u0003B!!%\u0002(:!\u00111SAQ\u001d\u0011\t)*a'\u000f\t\u0005u\u0011qS\u0005\u0004\u00033C\u0018!B;uS2\u001c\u0018\u0002BAO\u0003?\u000bAaY8oM*\u0019\u0011\u0011\u0014=\n\t\u0005\r\u0016QU\u0001\u0018\u000f\u0016|W*Z:b'f\u001cH/Z7Qe>\u0004XM\u001d;jKNTA!!(\u0002 &!\u0011\u0011VAV\u00059\u0019\u0016p\u001d;f[B\u0013x\u000e]3sifTA!a)\u0002&\u0006Q!)\u0019;dQNK'0\u001a\u0011\u0002\u0015\u0011+gn]5usN3G/\u0006\u0002\u00024B!\u00111LA[\u0013\u0011\t9,!\u0018\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-A\u0006EK:\u001c\u0018\u000e^=TMR\u0004\u0013a\u0004#f]NLG/\u001f,bYV,7*Z=\u0016\u0005\u0005}\u0006\u0003BAa\u0003?tA!a1\u0002Z:!\u0011QYAj\u001d\u0011\t9-!4\u000f\t\u0005\u0005\u0012\u0011Z\u0005\u0004\u0003\u0017d\u0018\u0001C4f_R|w\u000e\\:\n\t\u0005=\u0017\u0011[\u0001\u0005kRLGNC\u0002\u0002LrLA!!6\u0002X\u00069a-Y2u_JL(\u0002BAh\u0003#LA!a7\u0002^\u0006)\u0001*\u001b8ug*!\u0011Q[Al\u0013\u0011\t\t/a9\u0003\u0011\rc\u0017m]:LKfTA!a7\u0002^\u0006\u0001B)\u001a8tSRLh+\u00197vK.+\u0017\u0010I\u0001\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0007\u0005-\u0018#D\u0001\b\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]N\u0019\u0011#!\u0001\u0015\u0005\u0005%\u0018aC$f_6,GO]=PaR,\"!a>\u0011\t\u0005e(1A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006!A.\u00198h\u0015\t\u0011\t!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0003\u0003w\u0014aa\u0015;sS:<\u0017\u0001D$f_6,GO]=PaR\u0004\u0013aC#om\u0016dw\u000e]3PaR\fA\"\u00128wK2|\u0007/Z(qi\u0002\nqa\u0012:jI>\u0003H/\u0001\u0005He&$w\n\u001d;!\u0003%9V-[4ii>\u0003H/\u0001\u0006XK&<\u0007\u000e^(qi\u0002\n\u0011bY8oM&<WO]3\u0015\u0015\te!Q\u0006B\u0019\u0005;\u0012\t\b\u0005\u0005\u0003\u001c\t\r\"\u0011\u0006B\u0015\u001d\u0011\u0011iBa\b\u0011\t\u0005\r\u0012QA\u0005\u0005\u0005C\t)!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005K\u00119CA\u0002NCBTAA!\t\u0002\u0006A!!1\u0004B\u0016\u0013\u0011\u0011)Aa\n\t\u000f\t=2\u00041\u0001\u00024\u0006\u00191O\u001a;\t\r]\\\u0002\u0019\u0001B\u001aa\u0019\u0011)D!\u0012\u0003ZAA!q\u0007B\u001f\u0005\u0003\u00129&\u0004\u0002\u0003:)\u0019!1\b<\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003@\te\"aE$f_6+7/\u0019$fCR,(/Z%oI\u0016D\b\u0003\u0002B\"\u0005\u000bb\u0001\u0001\u0002\u0007\u0003H\tE\u0012\u0011!A\u0001\u0006\u0003\u0011IEA\u0002`IE\nBAa\u0013\u0003RA!\u00111\u0001B'\u0013\u0011\u0011y%!\u0002\u0003\u000f9{G\u000f[5oOB!\u00111\u0001B*\u0013\u0011\u0011)&!\u0002\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0003D\teC\u0001\u0004B.\u0005c\t\t\u0011!A\u0003\u0002\t%#aA0%e!9!qL\u000eA\u0002\t\u0005\u0014A\u00024jYR,'\u000f\u0005\u0004\u0002\u0004\t\r$qM\u0005\u0005\u0005K\n)A\u0001\u0004PaRLwN\u001c\t\u0005\u0005S\u0012i'\u0004\u0002\u0003l)!!qLA3\u0013\u0011\u0011yGa\u001b\u0003\r\u0019KG\u000e^3s\u0011\u001d\u0011\u0019h\u0007a\u0001\u0005k\nQ\u0001[5oiN\u0004BAa\u001e\u0003z5\u0011\u0011Q\\\u0005\u0005\u0005w\niNA\u0003IS:$8/\u0001\u0007f]\u000e|G-\u001a*fgVdG\u000f\u0006\u0003\u0003\u0002\n5\u0005CBA\u0002\u0005\u0007\u00139)\u0003\u0003\u0003\u0006\u0006\u0015!!B!se\u0006L\b\u0003BA\u0002\u0005\u0013KAAa#\u0002\u0006\t!!)\u001f;f\u0011\u001d\u0011y\t\ba\u0001\u0005#\u000baA]3tk2$\b\u0003\u0002BJ\u0005/k!A!&\u000b\t\u0005-\u0017qT\u0005\u0005\u00053\u0013)JA\u0007SK:$WM]5oO\u001e\u0013\u0018\u000eZ\u0001\rI\u0016\u001cw\u000eZ3SKN,H\u000e\u001e\u000b\t\u0005?\u0013\tK!.\u0003@B\u0019\u00111^\u0005\t\u000f\t\rV\u00041\u0001\u0003&\u0006AQM\u001c<fY>\u0004X\r\u0005\u0003\u0003(\nEVB\u0001BU\u0015\u0011\u0011YK!,\u0002\t\u001d,w.\u001c\u0006\u0004\u0005_S\u0018a\u00016ug&!!1\u0017BU\u0005!)eN^3m_B,\u0007b\u0002B\\;\u0001\u0007!\u0011X\u0001\nOJLGmV5ei\"\u0004B!a\u0001\u0003<&!!QXA\u0003\u0005\rIe\u000e\u001e\u0005\b\u0005\u0003l\u0002\u0019\u0001B]\u0003)9'/\u001b3IK&<\u0007\u000e\u001e\u000b\u0005\u0005\u000b\u0014Y\r\u0006\u0003\u0002n\t\u001d\u0007b\u0002Be=\u0001\u0007\u0011\u0011L\u0001\u0003g\u001aDqA!4\u001f\u0001\u0004\u0011y-\u0001\u0005he&$7K\\1q!\u0011\u0011\u0019J!5\n\t\tM'Q\u0013\u0002\t\u000fJLGm\u00158ba\u0006i\u0001O]8qKJ$\u0018PT1nKN$bA!7\u0003`\n\u0005\bCBA8\u00057\u0014I#\u0003\u0003\u0003^\u0006u$aA*fc\"9!1O\u0010A\u0002\tU\u0004b\u0002B\u0018?\u0001\u0007\u00111W\u0001\fO\u0016$(+\u001a8eKJ,'\u000f\u0006\u0005\u0003h\u0012eA1\u0004C\u000f!\r\tYO\u0014\u0002\u0011\u000f\u0016|W.\u001a;ssJ+g\u000eZ3sKJ\u001c2ATA\u0001\u0003\u0019\u0011XM\u001c3feR1!\u0011\u001fB|\u0005w\u0004B!a\u0001\u0003t&!!Q_A\u0003\u0005\u0011)f.\u001b;\t\u000f\tex\n1\u0001\u0003\u0012\u0006!qM]5e\u0011\u001d\u0011Im\u0014a\u0001\u00033J\u0003B\u0014.`+&t\u0007\u000b\u001a\u0002\u0013\u0019&tWm\u0015;sS:<'+\u001a8eKJ,'oE\u0003[\u0003\u0003\u00119/A\u0001j\u0003\u001d9X-[4iKJ\u00042!a;5\u0005\u001d9V-[4iKJ\u001c2\u0001NA\u0001\u0003\u00199X-[4iiR!\u0011QQB\t\u0011\u001d\u0011I-\u000ea\u0001\u00033JS\u0001N\u001cK\r\n\u00131\"R9vC2<V-[4iiNIq'!\u0001\u0004\b\re1q\u0004\t\u0005\u0003\u0007\u0019Y\"\u0003\u0003\u0004\u001e\u0005\u0015!a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003_\u001a\t#\u0003\u0003\u0004$\u0005u$\u0001D*fe&\fG.\u001b>bE2,GCAB\u0014!\r\tYo\u000e\u000b\u0005\u0003\u000b\u001bY\u0003C\u0004\u0003Jf\u0002\r!!\u0017\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011I,\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tE3q\u0007\u0005\n\u0007sa\u0014\u0011!a\u0001\u0005s\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB !\u0019\u0019\tea\u0012\u0003R5\u001111\t\u0006\u0005\u0007\u000b\n)!\u0001\u0006d_2dWm\u0019;j_:LA!a\u001f\u0004D\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0004N\rM\u0003\u0003BA\u0002\u0007\u001fJAa!\u0015\u0002\u0006\t9!i\\8mK\u0006t\u0007\"CB\u001d}\u0005\u0005\t\u0019\u0001B)\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B]\u0003!!xn\u0015;sS:<GCAA|\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019\t\u0007\u0005\u0003\u0002z\u000e\r\u0014\u0002BB3\u0003w\u0014aa\u00142kK\u000e$(AE,fS\u001eDGOQ=FqB\u0014Xm]:j_:\u001cRASA\u0001\u0007\u000f\t\u0011!\u001a\t\u0005\u0007_\u001a)(\u0004\u0002\u0004r)!11\u000fB6\u0003))\u0007\u0010\u001d:fgNLwN\\\u0005\u0005\u0007o\u001a\tH\u0001\u0006FqB\u0014Xm]:j_:$Baa\u001f\u0004~A\u0019\u00111\u001e&\t\u000f\r-D\n1\u0001\u0004nQ!\u0011QQBA\u0011\u001d\u0011I-\u0014a\u0001\u00033\u0012\u0011cV3jO\"$()\u001f(p]:+XNY3s'\u00151\u0015\u0011AB\u0004)\u0011\u0019Iia#\u0011\u0007\u0005-h\tC\u0004\u0004\u0004!\u0003\rA!/\u0015\t\u0005\u00155q\u0012\u0005\b\u0005\u0013L\u0005\u0019AA-\u000599V-[4ii\nKh*^7cKJ\u001cRAQA\u0001\u0007\u000f!Baa&\u0004\u001aB\u0019\u00111\u001e\"\t\u000f\r\rA\t1\u0001\u0003:R!\u0011QQBO\u0011\u001d\u0011I-\u0012a\u0001\u00033\"ba!)\u0004$\u000e\u0015\u0006cAAv5\"911A/A\u0002\te\u0006bBB\u0003;\u0002\u00071q\u0001\u000b\u0007\u0005c\u001cIka+\t\u000f\teh\f1\u0001\u0003\u0012\"9!\u0011\u001a0A\u0002\u0005e#aF'vYRLG*\u001b8f'R\u0014\u0018N\\4SK:$WM]3s'\u0015y\u0016\u0011\u0001Bt)\u0019\u0019\u0019l!.\u00048B\u0019\u00111^0\t\u000f\r\r!\r1\u0001\u0003:\"91Q\u00012A\u0002\r\u001dAC\u0002By\u0007w\u001bi\fC\u0004\u0003z\u000e\u0004\rA!%\t\u000f\t%7\r1\u0001\u0002Z\t\u0011R*\u001e7uSB{\u0017N\u001c;SK:$WM]3s'\u0015)\u0016\u0011\u0001Bt)\u0019\u0019)ma2\u0004JB\u0019\u00111^+\t\u000f\r\r\u0001\f1\u0001\u0003:\"91Q\u0001-A\u0002\r\u001dAC\u0002By\u0007\u001b\u001cy\rC\u0004\u0003zf\u0003\rA!%\t\u000f\t%\u0017\f1\u0001\u0002Z\t!R*\u001e7uSB{G._4p]J+g\u000eZ3sKJ\u001cR![A\u0001\u0005O$baa6\u0004Z\u000em\u0007cAAvS\"911\u00017A\u0002\te\u0006bBB\u0003Y\u0002\u00071q\u0001\u000b\u0007\u0005c\u001cyn!9\t\u000f\teX\u000e1\u0001\u0003\u0012\"9!\u0011Z7A\u0002\u0005e#!D'vYRL'+\u001a8eKJ,'oE\u0003o\u0003\u0003\u00119\u000f\u0006\u0004\u0004j\u000e-8Q\u001e\t\u0004\u0003Wt\u0007bBB\u0002c\u0002\u0007!\u0011\u0018\u0005\b\u0007\u000b\t\b\u0019AB\u0004)\u0019\u0011\tp!=\u0004t\"9!\u0011 :A\u0002\tE\u0005b\u0002Bee\u0002\u0007\u0011\u0011\f\u0002\u000e!>Lg\u000e\u001e*f]\u0012,'/\u001a:\u0014\u000bA\u000b\tAa:\u0015\r\rm8Q`B\u0000!\r\tY\u000f\u0015\u0005\b\u0007\u0007\u0019\u0006\u0019\u0001B]\u0011\u001d\u0019)a\u0015a\u0001\u0007\u000f!bA!=\u0005\u0004\u0011\u0015\u0001b\u0002B})\u0002\u0007!\u0011\u0013\u0005\b\u0005\u0013$\u0006\u0019AA-\u0005=\u0001v\u000e\\=h_:\u0014VM\u001c3fe\u0016\u00148#\u00023\u0002\u0002\t\u001dHC\u0002C\u0007\t\u001f!\t\u0002E\u0002\u0002l\u0012Dqaa\u0001h\u0001\u0004\u0011I\fC\u0004\u0004\u0006\u001d\u0004\raa\u0002\u0015\r\tEHQ\u0003C\f\u0011\u001d\u0011I\u0010\u001ba\u0001\u0005#CqA!3i\u0001\u0004\tI\u0006C\u0004\u00030\u0001\u0002\r!a-\t\u000f\t-\u0006\u00051\u0001\u0003*!91Q\u0002\u0011A\u0002\u0011}\u0001CBA\u0002\u0005G\u0012I#\u0001\nhKR$UM\\:jif<Um\\7fiJLHC\u0002B\u0015\tK!9\u0003C\u0004\u00030\u0005\u0002\r!a-\t\u000f\tM\u0014\u00051\u0001\u0003v\t\tB)\u001a8tSRL8kY1o%\u0016\u001cX\u000f\u001c;\u0014\u000b\t\n\t\u0001\"\f\u0011\t\u0011=BQ\u0007\b\u0005\u0003\u001f!\t$C\u0002\u00054Q\fq\"Q4he\u0016<\u0017\r^5oON\u001b\u0017M\\\u0005\u0005\to!ID\u0001\u0004SKN,H\u000e\u001e\u0006\u0004\tg!\u0018\u0001\u0003:f]\u0012,'/\u001a:\u0015\r\u0011}B\u0011\tC\"!\r\tYO\t\u0005\b\tw)\u0003\u0019\u0001Bt\u0011\u001d\u0011I0\na\u0001\u0005#\u000bA!\u001b8jiR\u0011!\u0011_\u0001\nC\u001e<'/Z4bi\u0016$BA!/\u0005N!9!\u0011Z\u0014A\u0002\u0005e\u0013AB3oG>$W\r\u0006\u0002\u0003\u0002\u000691\r\\3b]V\u0004(\u0001\u0007#f]NLG/\u001f*fgVdGo\u001d+p\r\u0016\fG/\u001e:fgV!A\u0011\fC8'\u0015Q\u0013\u0011\u0001C.!\u0019!i\u0006b\u001a\u0005n9!Aq\fC2\u001d\u0011\tY\u0002\"\u0019\n\u0007\tmb/\u0003\u0003\u0005f\te\u0012!C)vKJL\b\u000b\\1o\u0013\u0011!I\u0007b\u001b\u0003#I+7/\u001e7ugR{g)Z1ukJ,7O\u0003\u0003\u0005f\te\u0002\u0003\u0002B\"\t_\"q\u0001\"\u001d+\u0005\u0004\u0011IEA\u0001U)\t!)\bE\u0003\u0002l*\"i\u0007\u0006\u0003\u0003r\u0012e\u0004b\u0002C>Y\u0001\u0007!\u0011D\u0001\u0006gR\fG/Z\u000b\u0003\u00053\taa]2iK6\f\u0017!B1qa2LH\u0003BA-\t\u000bCqAa$0\u0001\u0004!i'A\u0003csR,7\u000f\u0006\u0003\u0003\u0002\u0012-\u0005b\u0002BHa\u0001\u0007AQ\u000e\u000b\u0005\u0007\u001b\"y\tC\u0004\u0005\u0012F\u0002\rA!\u0015\u0002\u000b=$\b.\u001a:\u0002\r\u0015\fX/\u00197t)\u0011\u0019i\u0005b&\t\u000f\u0011E%\u00071\u0001\u0003R\u0005YQ)];bY^+\u0017n\u001a5u\u0003\u0019!\u0013N\\5uIU\u0011Aq\u0014\t\u0004\u0003/q\u0015\u0001\u0004:f]\u0012,'/\u001a:`I\u0015\fH\u0003\u0002By\tKC\u0011b!\u000f\u0004\u0003\u0003\u0005\r\u0001b(\u0002\u0019\r\u0014X-\u0019;f%\u0016\u001cX\u000f\u001c;\u0015\u0015\u0005UA1\u0016CW\tg#9\fC\u0004\u00030\u0011\u0001\r!a-\t\u000f\u0011=F\u00011\u0001\u00052\u0006IAO]1og\u001a|'/\u001c\t\u0007\u0003\u0007\u0011\u0019'a-\t\u000f\u0011UF\u00011\u0001\u0003:\u0006I!-\u0019;dQNK'0\u001a\u0005\b\ts#\u0001\u0019\u0001B\r\u0003\u001dy\u0007\u000f^5p]N\f\u0001\u0003Z3gCVdGOQ1uG\"\u001c\u0016N_3")
public interface DensityScan
extends AggregatingScan<DensityScanResult> {
    public static String getDensityGeometry(SimpleFeatureType sft, Hints hints) {
        return DensityScan$.MODULE$.getDensityGeometry(sft, hints);
    }

    public static GeometryRenderer getRenderer(SimpleFeatureType sft, String geom, Option<String> weight) {
        return DensityScan$.MODULE$.getRenderer(sft, geom, weight);
    }

    public static Seq<String> propertyNames(Hints hints, SimpleFeatureType sft) {
        return DensityScan$.MODULE$.propertyNames(hints, sft);
    }

    public static Iterator<Tuple3<Object, Object, Object>> decodeResult(GridSnap gridSnap, SimpleFeature sf) {
        return DensityScan$.MODULE$.decodeResult(gridSnap, sf);
    }

    public static Function1<SimpleFeature, Iterator<Tuple3<Object, Object, Object>>> decodeResult(Envelope envelope, int gridWidth, int gridHeight) {
        return DensityScan$.MODULE$.decodeResult(envelope, gridWidth, gridHeight);
    }

    public static byte[] encodeResult(RenderingGrid result) {
        return DensityScan$.MODULE$.encodeResult(result);
    }

    public static Map<String, String> configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?> index, Option<Filter> filter, Hints hints) {
        return DensityScan$.MODULE$.configure(sft, index, filter, hints);
    }

    public static Hints.ClassKey DensityValueKey() {
        return DensityScan$.MODULE$.DensityValueKey();
    }

    public static SimpleFeatureType DensitySft() {
        return DensityScan$.MODULE$.DensitySft();
    }

    public static GeoMesaSystemProperties.SystemProperty BatchSize() {
        return DensityScan$.MODULE$.BatchSize();
    }

    public GeometryRenderer renderer();

    public void renderer_$eq(GeometryRenderer var1);

    public static /* synthetic */ DensityScanResult createResult$(DensityScan $this, SimpleFeatureType sft, Option transform, int batchSize, Map options) {
        return $this.createResult(sft, (Option<SimpleFeatureType>)transform, batchSize, (Map<String, String>)options);
    }

    @Override
    default public DensityScanResult createResult(SimpleFeatureType sft, Option<SimpleFeatureType> transform, int batchSize, Map<String, String> options) {
        Object object;
        String geom = (String)options.getOrElse((Object)DensityScan$Configuration$.MODULE$.GeometryOpt(), (Function0 & Serializable)() -> sft.getGeometryDescriptor().getLocalName());
        GeometryRenderer renderer = DensityScan$.MODULE$.getRenderer(sft, geom, (Option<String>)options.get((Object)DensityScan$Configuration$.MODULE$.WeightOpt()));
        double[] bounds = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)options.apply((Object)DensityScan$Configuration$.MODULE$.EnvelopeOpt())).split(",")), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$2))), (ClassTag)ClassTag$.MODULE$.Double());
        Envelope envelope = new Envelope(bounds[0], bounds[1], bounds[2], bounds[3]);
        int[] nArray = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)options.apply((Object)DensityScan$Configuration$.MODULE$.GridOpt())).split(",")), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3))), (ClassTag)ClassTag$.MODULE$.Int());
        if (nArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)nArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)nArray);
        }
        int width = BoxesRunTime.unboxToInt((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
        int height = BoxesRunTime.unboxToInt((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(width, height);
        int width2 = sp2._1$mcI$sp();
        int height2 = sp2._2$mcI$sp();
        return new DensityScanResult(renderer, new RenderingGrid(envelope, width2, height2));
    }

    public static /* synthetic */ int defaultBatchSize$(DensityScan $this) {
        return $this.defaultBatchSize();
    }

    @Override
    default public int defaultBatchSize() {
        return BoxesRunTime.unboxToInt((Object)DensityScan$.MODULE$.BatchSize().toInt().get());
    }

    public static void $init$(DensityScan $this) {
    }

    public static abstract class DensityResultsToFeatures<T>
    implements QueryPlan.ResultsToFeatures<T> {
        @Override
        public void init(Map<String, String> state) {
        }

        @Override
        public Map<String, String> state() {
            return Predef$.MODULE$.Map().empty();
        }

        @Override
        public SimpleFeatureType schema() {
            return DensityScan$.MODULE$.DensitySft();
        }

        @Override
        public SimpleFeature apply(T result) {
            ScalaSimpleFeature sf = new ScalaSimpleFeature(DensityScan$.MODULE$.DensitySft(), "", new Object[]{GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            sf.getUserData().put(DensityScan$.MODULE$.DensityValueKey(), this.bytes(result));
            return sf;
        }

        public abstract byte[] bytes(T var1);

        public boolean canEqual(Object other) {
            return other instanceof DensityResultsToFeatures;
        }

        public boolean equals(Object other) {
            DensityResultsToFeatures densityResultsToFeatures;
            Object object = other;
            return object instanceof DensityResultsToFeatures && (densityResultsToFeatures = (DensityResultsToFeatures)object).canEqual(this);
        }

        public int hashCode() {
            return this.schema().hashCode();
        }
    }

    public static class DensityScanResult
    implements AggregatingScan.Result {
        private final GeometryRenderer renderer;
        private final RenderingGrid grid;

        @Override
        public void init() {
        }

        @Override
        public int aggregate(SimpleFeature sf) {
            this.renderer.render(this.grid, sf);
            return 1;
        }

        @Override
        public byte[] encode() {
            byte[] byArray;
            try {
                byArray = DensityScan$.MODULE$.encodeResult(this.grid);
            }
            finally {
                this.grid.clear();
            }
            return byArray;
        }

        @Override
        public void cleanup() {
        }

        public DensityScanResult(GeometryRenderer renderer, RenderingGrid grid) {
            this.renderer = renderer;
            this.grid = grid;
        }
    }

    public static interface GeometryRenderer {
        public void render(RenderingGrid var1, SimpleFeature var2);
    }

    public static class LineStringRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((LineString)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public LineStringRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiLineStringRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((MultiLineString)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiLineStringRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiPointRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((MultiPoint)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiPointRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiPolygonRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((MultiPolygon)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiPolygonRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class MultiRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((Geometry)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public MultiRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class PointRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((Point)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public PointRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static class PolygonRenderer
    implements GeometryRenderer {
        private final int i;
        private final Weigher weigher;

        @Override
        public void render(RenderingGrid grid, SimpleFeature sf) {
            grid.render((Polygon)sf.getAttribute(this.i), this.weigher.weight(sf));
        }

        public PolygonRenderer(int i, Weigher weigher) {
            this.i = i;
            this.weigher = weigher;
        }
    }

    public static interface Weigher {
        public double weight(SimpleFeature var1);
    }

    public static class WeightByExpression
    implements Weigher {
        private final Expression e;

        @Override
        public double weight(SimpleFeature sf) {
            Double d = (Double)this.e.evaluate((Object)sf, Double.class);
            if (d == null) {
                return 0.0;
            }
            return Predef$.MODULE$.Double2double(d);
        }

        public WeightByExpression(Expression e) {
            this.e = e;
        }
    }

    public static class WeightByNonNumber
    implements Weigher {
        private final int i;

        @Override
        public double weight(SimpleFeature sf) {
            Object d = sf.getAttribute(this.i);
            if (d == null) {
                return 0.0;
            }
            Double converted = (Double)FastConverter$.MODULE$.convert(d, Double.class);
            if (converted == null) {
                return 1.0;
            }
            return converted;
        }

        public WeightByNonNumber(int i) {
            this.i = i;
        }
    }

    public static class WeightByNumber
    implements Weigher {
        private final int i;

        @Override
        public double weight(SimpleFeature sf) {
            Number d = (Number)sf.getAttribute(this.i);
            if (d == null) {
                return 0.0;
            }
            return d.doubleValue();
        }

        public WeightByNumber(int i) {
            this.i = i;
        }
    }
}

