/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.AggregatingScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$Configuration$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.StatSerializer;
import org.locationtech.geomesa.utils.stats.StatSerializer$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StatsScan$ {
    public static final StatsScan$ MODULE$ = new StatsScan$();
    private static final GeoMesaSystemProperties.SystemProperty BatchSize = new GeoMesaSystemProperties.SystemProperty("geomesa.stats.batch.size", "10000");
    private static final SimpleFeatureType StatsSft = SimpleFeatureTypes$.MODULE$.createType("stats:stats", "stats:String,geom:Geometry");

    public GeoMesaSystemProperties.SystemProperty BatchSize() {
        return BatchSize;
    }

    public SimpleFeatureType StatsSft() {
        return StatsSft;
    }

    public Map<String, String> configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?> index, Option<Filter> filter, Hints hints) {
        int batchSize = BoxesRunTime.unboxToInt((Object)this.BatchSize().toInt().get());
        return (Map)AggregatingScan$.MODULE$.configure(sft, index, filter, QueryHints$.MODULE$.RichHints(hints).getTransform(), QueryHints$.MODULE$.RichHints(hints).getSampling(), batchSize).$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StatsScan$Configuration$.MODULE$.STATS_STRING_KEY()), (Object)((String)hints.get((Object)QueryHints$.MODULE$.STATS_STRING())))})));
    }

    public Function1<Stat, String> encodeStat(SimpleFeatureType sft) {
        StatSerializer serializer = StatSerializer$.MODULE$.apply(sft);
        return (Function1 & Serializable)stat -> Base64.encodeBase64URLSafeString((byte[])serializer.serialize(stat));
    }

    public Function1<String, Stat> decodeStat(SimpleFeatureType sft) {
        StatSerializer serializer = StatSerializer$.MODULE$.apply(sft);
        return (Function1 & Serializable)encoded -> serializer.deserialize(Base64.decodeBase64((String)encoded), serializer.deserialize$default$2());
    }

    private StatsScan$() {
    }
}

