/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.arrow.io.DeltaWriter;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.ArrowScan;
import org.locationtech.geomesa.index.iterators.ArrowScan$;
import org.locationtech.geomesa.index.iterators.DensityScan;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.utils.FeatureSampler$;
import org.locationtech.geomesa.index.utils.SortingSimpleFeatureIterator;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.security.SecurityUtils;
import org.locationtech.geomesa.security.VisibilityEvaluator$;
import org.locationtech.geomesa.utils.bin.BinaryEncodeCallback;
import org.locationtech.geomesa.utils.bin.BinaryOutputCallback;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RenderingGrid;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class LocalQueryRunner$
implements LazyLogging {
    public static final LocalQueryRunner$ MODULE$ = new LocalQueryRunner$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        LocalQueryRunner$ localQueryRunner$ = this;
        synchronized (localQueryRunner$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Function1<SimpleFeature, Object> visible(Option<AuthorizationsProvider> provider) {
        Option<AuthorizationsProvider> option = provider;
        if (None$.MODULE$.equals(option)) {
            return (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LocalQueryRunner$.MODULE$.noAuthVisibilityCheck(f));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            AuthorizationsProvider p = (AuthorizationsProvider)some.value();
            return (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LocalQueryRunner$.MODULE$.authVisibilityCheck(x$3, (Seq<byte[]>)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getAuthorizations()).asScala()).map((Function1 & Serializable)x$4 -> x$4.getBytes(StandardCharsets.UTF_8))).toSeq()));
        }
        throw new MatchError(option);
    }

    public CloseableIterator<SimpleFeature> transform(SimpleFeatureType sft, CloseableIterator<SimpleFeature> features, Option<Tuple2<String, SimpleFeatureType>> transform, Hints hints, Option<LocalQueryRunner.ArrowDictionaryHook> arrow) {
        Some some;
        Tuple2 tuple2;
        Some some2;
        Tuple2 tuple22;
        CloseableIterator<SimpleFeature> closeableIterator;
        Option<Tuple2<Object, Option<String>>> option = QueryHints$.MODULE$.RichHints(hints).getSampling();
        if (None$.MODULE$.equals(option)) {
            closeableIterator = features;
        } else if (option instanceof Some && (tuple22 = (Tuple2)(some2 = (Some)option).value()) != null) {
            float percent = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            Option field = (Option)tuple22._2();
            closeableIterator = this.sample(sft, percent, (Option<String>)field, features);
        } else {
            throw new MatchError(option);
        }
        CloseableIterator<SimpleFeature> sampled = closeableIterator;
        if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            Option trackId = Option$.MODULE$.apply((Object)QueryHints$.MODULE$.RichHints(hints).getBinTrackIdField()).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LocalQueryRunner$.$anonfun$transform$1(x$11))).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
            Option geom = QueryHints$.MODULE$.RichHints(hints).getBinGeomField().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
            Option dtg = QueryHints$.MODULE$.RichHints(hints).getBinDtgField().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
            boolean sorting = QueryHints$.MODULE$.RichHints(hints).isBinSorting();
            return this.binTransform(sampled, sft, (Option<Object>)trackId, (Option<Object>)geom, (Option<Object>)dtg, (Option<Object>)QueryHints$.MODULE$.RichHints(hints).getBinLabelField().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1))), sorting);
        }
        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            return this.arrowTransform(sampled, sft, transform, hints, arrow);
        }
        if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
            Some some3;
            Tuple2 tuple23;
            Option<Envelope> option2 = QueryHints$.MODULE$.RichHints(hints).getDensityEnvelope();
            if (!(option2 instanceof Some)) {
                throw new MatchError(option2);
            }
            Some some4 = (Some)option2;
            Envelope envelope = (Envelope)some4.value();
            Envelope envelope2 = envelope;
            Option<Tuple2<Object, Object>> option3 = QueryHints$.MODULE$.RichHints(hints).getDensityBounds();
            if (!(option3 instanceof Some) || (tuple23 = (Tuple2)(some3 = (Some)option3).value()) == null) {
                throw new MatchError(option3);
            }
            int width = tuple23._1$mcI$sp();
            int height = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(width, height);
            int width2 = sp2._1$mcI$sp();
            int height2 = sp2._2$mcI$sp();
            String geom = DensityScan$.MODULE$.getDensityGeometry(sft, hints);
            return this.densityTransform(sampled, sft, geom, envelope2, width2, height2, QueryHints$.MODULE$.RichHints(hints).getDensityWeight());
        }
        if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
            return this.statsTransform(sampled, sft, transform, QueryHints$.MODULE$.RichHints(hints).getStatsQuery(), QueryHints$.MODULE$.RichHints(hints).isStatsEncode() || QueryHints$.MODULE$.RichHints(hints).isSkipReduce());
        }
        Option<Tuple2<String, SimpleFeatureType>> option4 = transform;
        if (None$.MODULE$.equals(option4)) {
            return this.noTransform(sampled, QueryHints$.MODULE$.RichHints(hints).getSortFields());
        }
        if (option4 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option4).value()) != null) {
            String defs = (String)tuple2._1();
            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
            return this.projectionTransform(sampled, sft, tsft, defs, QueryHints$.MODULE$.RichHints(hints).getSortFields());
        }
        throw new MatchError(option4);
    }

    public Option<LocalQueryRunner.ArrowDictionaryHook> transform$default$5() {
        return None$.MODULE$;
    }

    private CloseableIterator<SimpleFeature> binTransform(CloseableIterator<SimpleFeature> features, SimpleFeatureType sft, Option<Object> trackId, Option<Object> geom, Option<Object> dtg, Option<Object> label, boolean sorting) {
        SortingSimpleFeatureIterator sortingSimpleFeatureIterator;
        BinaryOutputEncoder encoder = BinaryOutputEncoder$.MODULE$.apply(sft, new BinaryOutputEncoder.EncodingOptions(geom, dtg, trackId, label, BinaryOutputEncoder.EncodingOptions$.MODULE$.apply$default$5()));
        if (!sorting) {
            sortingSimpleFeatureIterator = features;
        } else {
            int i = BoxesRunTime.unboxToInt((Object)dtg.orElse((Function0 & Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Can't sort BIN features by date");
            }));
            sortingSimpleFeatureIterator = new SortingSimpleFeatureIterator(features, (Seq<Tuple2<String, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sft.getDescriptor(i).getLocalName()), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        }
        SortingSimpleFeatureIterator sorted = sortingSimpleFeatureIterator;
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        BinaryEncodeCallback.ByteStreamCallback callback = new BinaryEncodeCallback.ByteStreamCallback((OutputStream)os);
        return new CloseableIterator<SimpleFeature>((CloseableIterator)sorted, os, encoder, callback){
            private final CloseableIterator sorted$1;
            private final ByteArrayOutputStream os$1;
            private final BinaryOutputEncoder encoder$1;
            private final BinaryEncodeCallback.ByteStreamCallback callback$1;

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
                return Iterator.map$((Iterator)this, (Function1)f);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
                return Iterator.filter$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
                return Iterator.filterNot$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$takeWhile(Function1 p) {
                return Iterator.takeWhile$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$dropWhile(Function1 p) {
                return Iterator.dropWhile$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
                return Iterator.collect$((Iterator)this, (PartialFunction)pf);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$tapEach(Function1 f) {
                return Iterator.tapEach$((Iterator)this, (Function1)f);
            }

            public <B> CloseableIterator<B> map(Function1<SimpleFeature, B> f) {
                return CloseableIterator.map$((CloseableIterator)this, f);
            }

            public CloseableIterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.filter$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.withFilter$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.filterNot$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> take(int n) {
                return CloseableIterator.take$((CloseableIterator)this, (int)n);
            }

            public CloseableIterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.takeWhile$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> drop(int n) {
                return CloseableIterator.drop$((CloseableIterator)this, (int)n);
            }

            public CloseableIterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.dropWhile$((CloseableIterator)this, p);
            }

            public <B> CloseableIterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                return CloseableIterator.collect$((CloseableIterator)this, pf);
            }

            public <B> CloseableIterator<B> concat(Function0<IterableOnce<B>> xs) {
                return CloseableIterator.concat$((CloseableIterator)this, xs);
            }

            public <B> CloseableIterator<B> flatMap(Function1<SimpleFeature, IterableOnce<B>> f) {
                return CloseableIterator.flatMap$((CloseableIterator)this, f);
            }

            public <U> CloseableIterator<SimpleFeature> tapEach(Function1<SimpleFeature, U> f) {
                return CloseableIterator.tapEach$((CloseableIterator)this, f);
            }

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<SimpleFeature> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<SimpleFeature> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<SimpleFeature> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<SimpleFeature> filterImpl(Function1<SimpleFeature, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<SimpleFeature> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<SimpleFeature> distinctBy(Function1<SimpleFeature, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<SimpleFeature, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<SimpleFeature> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<SimpleFeature> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<SimpleFeature, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<SimpleFeature> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<SimpleFeature, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<SimpleFeature, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<SimpleFeature, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<SimpleFeature, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<SimpleFeature> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<SimpleFeature> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<SimpleFeature> maxByOption(Function1<SimpleFeature, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<SimpleFeature> minByOption(Function1<SimpleFeature, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<SimpleFeature, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<SimpleFeature> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<SimpleFeature> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<SimpleFeature> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<SimpleFeature, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<SimpleFeature> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<SimpleFeature> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<SimpleFeature> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<SimpleFeature> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<SimpleFeature, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public boolean hasNext() {
                return this.sorted$1.hasNext();
            }

            public SimpleFeature next() {
                this.os$1.reset();
                this.sorted$1.take(64).foreach((Function1 & Serializable)x$13 -> {
                    anon.1.$anonfun$next$1(this, x$13);
                    return BoxedUnit.UNIT;
                });
                return new ScalaSimpleFeature(BinaryOutputEncoder$.MODULE$.BinEncodedSft(), "", new Object[]{this.os$1.toByteArray(), GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            }

            public void close() {
                this.sorted$1.close();
            }

            public static final /* synthetic */ void $anonfun$next$1(anon.1 $this, SimpleFeature x$13) {
                $this.encoder$1.encode(x$13, (BinaryOutputCallback)$this.callback$1);
            }
            {
                this.sorted$1 = sorted$1;
                this.os$1 = os$1;
                this.encoder$1 = encoder$1;
                this.callback$1 = callback$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                CloseableIterator.$init$((CloseableIterator)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1$adapted(org.locationtech.geomesa.index.planning.LocalQueryRunner$$anon$1 org.opengis.feature.simple.SimpleFeature )}, serializedLambda);
            }
        };
    }

    private CloseableIterator<SimpleFeature> arrowTransform(CloseableIterator<SimpleFeature> original, SimpleFeatureType sft, Option<Tuple2<String, SimpleFeatureType>> transform, Hints hints, Option<LocalQueryRunner.ArrowDictionaryHook> hook) {
        Some some;
        Tuple2 tuple2;
        Tuple2 tuple22;
        LazyRef x$16$lzy = new LazyRef();
        LazyRef stats$lzy = new LazyRef();
        LazyRef filter$lzy = new LazyRef();
        Option sort = QueryHints$.MODULE$.RichHints(hints).getArrowSort().map((Function1 & Serializable)x$14 -> (Seq)package$.MODULE$.Seq().fill(1, (Function0 & Serializable)() -> x$14));
        int batchSize = ArrowScan$.MODULE$.getBatchSize(hints);
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid(), QueryHints$.MODULE$.RichHints(hints).isArrowProxyFid());
        IpcOption ipcOpts = package.FormatVersion$.MODULE$.options((String)QueryHints$.MODULE$.RichHints(hints).getArrowFormatVersion().getOrElse((Function0 & Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get()));
        Option<Tuple2<String, SimpleFeatureType>> option = transform;
        if (None$.MODULE$.equals(option)) {
            tuple22 = new Tuple2(this.noTransform(original, (Option<Seq<Tuple2<String, Object>>>)sort), (Object)sft);
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String definitions = (String)tuple2._1();
            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
            tuple22 = new Tuple2(this.projectionTransform(original, sft, tsft, definitions, (Option<Seq<Tuple2<String, Object>>>)sort), (Object)tsft);
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        CloseableIterator features = (CloseableIterator)tuple23._1();
        SimpleFeatureType arrowSft = (SimpleFeatureType)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)features, (Object)arrowSft);
        CloseableIterator features2 = (CloseableIterator)tuple24._1();
        SimpleFeatureType arrowSft2 = (SimpleFeatureType)tuple24._2();
        Seq<String> dictionaryFields = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields();
        DeltaWriter writer = new DeltaWriter(arrowSft2, dictionaryFields, encoding, ipcOpts, (Option)None$.MODULE$, batchSize);
        SimpleFeature[] array = (SimpleFeature[])Array$.MODULE$.ofDim(batchSize, ClassTag$.MODULE$.apply(SimpleFeature.class));
        SimpleFeature sf = ArrowScan$.MODULE$.resultFeature();
        CloseableIterator<SimpleFeature> arrows = new CloseableIterator<SimpleFeature>(features2, batchSize, array, sf, writer){
            private final CloseableIterator features$1;
            private final int batchSize$1;
            private final SimpleFeature[] array$1;
            private final SimpleFeature sf$1;
            private final DeltaWriter writer$1;

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
                return Iterator.map$((Iterator)this, (Function1)f);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
                return Iterator.filter$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
                return Iterator.filterNot$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$takeWhile(Function1 p) {
                return Iterator.takeWhile$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$dropWhile(Function1 p) {
                return Iterator.dropWhile$((Iterator)this, (Function1)p);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
                return Iterator.collect$((Iterator)this, (PartialFunction)pf);
            }

            public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$tapEach(Function1 f) {
                return Iterator.tapEach$((Iterator)this, (Function1)f);
            }

            public <B> CloseableIterator<B> map(Function1<SimpleFeature, B> f) {
                return CloseableIterator.map$((CloseableIterator)this, f);
            }

            public CloseableIterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.filter$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.withFilter$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.filterNot$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> take(int n) {
                return CloseableIterator.take$((CloseableIterator)this, (int)n);
            }

            public CloseableIterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.takeWhile$((CloseableIterator)this, p);
            }

            public CloseableIterator<SimpleFeature> drop(int n) {
                return CloseableIterator.drop$((CloseableIterator)this, (int)n);
            }

            public CloseableIterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                return CloseableIterator.dropWhile$((CloseableIterator)this, p);
            }

            public <B> CloseableIterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                return CloseableIterator.collect$((CloseableIterator)this, pf);
            }

            public <B> CloseableIterator<B> concat(Function0<IterableOnce<B>> xs) {
                return CloseableIterator.concat$((CloseableIterator)this, xs);
            }

            public <B> CloseableIterator<B> flatMap(Function1<SimpleFeature, IterableOnce<B>> f) {
                return CloseableIterator.flatMap$((CloseableIterator)this, f);
            }

            public <U> CloseableIterator<SimpleFeature> tapEach(Function1<SimpleFeature, U> f) {
                return CloseableIterator.tapEach$((CloseableIterator)this, f);
            }

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<SimpleFeature> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<SimpleFeature> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<SimpleFeature> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<SimpleFeature> filterImpl(Function1<SimpleFeature, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<SimpleFeature> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<SimpleFeature> distinctBy(Function1<SimpleFeature, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<SimpleFeature, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<SimpleFeature> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<SimpleFeature> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<SimpleFeature, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<SimpleFeature> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<SimpleFeature, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<SimpleFeature, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<SimpleFeature, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<SimpleFeature, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<SimpleFeature> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<SimpleFeature> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<SimpleFeature> maxByOption(Function1<SimpleFeature, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<SimpleFeature> minByOption(Function1<SimpleFeature, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<SimpleFeature, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<SimpleFeature> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<SimpleFeature> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<SimpleFeature> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<SimpleFeature, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<SimpleFeature> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<SimpleFeature> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<SimpleFeature> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<SimpleFeature> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<SimpleFeature, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public boolean hasNext() {
                return this.features$1.hasNext();
            }

            public SimpleFeature next() {
                int index;
                for (index = 0; index < this.batchSize$1 && this.features$1.hasNext(); ++index) {
                    this.array$1[index] = (SimpleFeature)this.features$1.next();
                }
                this.sf$1.setAttribute(0, (Object)this.writer$1.encode(this.array$1, index));
                return this.sf$1;
            }

            public void close() {
                package.CloseWithLogging$.MODULE$.apply((Object)new .colon.colon((Object)this.features$1, (List)new .colon.colon((Object)this.writer$1, (List)Nil$.MODULE$)), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
            }
            {
                this.features$1 = features$1;
                this.batchSize$1 = batchSize$1;
                this.array$1 = array$1;
                this.sf$1 = sf$1;
                this.writer$1 = writer$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                CloseableIterator.$init$((CloseableIterator)this);
            }
        };
        if (QueryHints$.MODULE$.RichHints(hints).isSkipReduce()) {
            return arrows;
        }
        boolean process = QueryHints$.MODULE$.RichHints(hints).isArrowProcessDeltas();
        return new ArrowScan.DeltaReducer(arrowSft2, dictionaryFields, encoding, ipcOpts, batchSize, (Option<Tuple2<String, Object>>)sort.map((Function1 & Serializable)x$17 -> (Tuple2)x$17.head()), true, process).apply(arrows);
    }

    private CloseableIterator<SimpleFeature> densityTransform(CloseableIterator<SimpleFeature> features, SimpleFeatureType sft, String geom, Envelope envelope, int width, int height, Option<String> weight) {
        DensityScan.GeometryRenderer renderer = DensityScan$.MODULE$.getRenderer(sft, geom, weight);
        RenderingGrid grid = new RenderingGrid(envelope, width, height);
        try {
            features.foreach((Function1 & Serializable)x$18 -> {
                renderer.render(grid, x$18);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            features.close();
        }
        ScalaSimpleFeature sf = new ScalaSimpleFeature(DensityScan$.MODULE$.DensitySft(), "", new Object[]{GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
        sf.getUserData().put(DensityScan$.MODULE$.DensityValueKey(), DensityScan$.MODULE$.encodeResult(grid));
        return CloseableIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ScalaSimpleFeature[]{sf})), (Function0)(JFunction0.mcV.sp & Serializable)() -> CloseableIterator$.MODULE$.apply$default$2());
    }

    private CloseableIterator<SimpleFeature> statsTransform(CloseableIterator<SimpleFeature> features, SimpleFeatureType sft, Option<Tuple2<String, SimpleFeatureType>> transform, String query, boolean encode) {
        Some some;
        Tuple2 tuple2;
        Tuple2 tuple22;
        Option<Tuple2<String, SimpleFeatureType>> option = transform;
        if (None$.MODULE$.equals(option)) {
            tuple22 = new Tuple2((Object)sft, features);
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String tdefs = (String)tuple2._1();
            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
            tuple22 = new Tuple2((Object)tsft, this.projectionTransform(features, sft, tsft, tdefs, (Option<Seq<Tuple2<String, Object>>>)None$.MODULE$));
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        SimpleFeatureType statSft = (SimpleFeatureType)tuple23._1();
        CloseableIterator toObserve = (CloseableIterator)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)statSft, (Object)toObserve);
        SimpleFeatureType statSft2 = (SimpleFeatureType)tuple24._1();
        Stat stat = Stat$.MODULE$.apply(statSft2, query);
        try (CloseableIterator toObserve2 = (CloseableIterator)tuple24._2();){
            toObserve2.foreach((Function1 & Serializable)sf -> {
                stat.observe(sf);
                return BoxedUnit.UNIT;
            });
        }
        String encoded = encode ? (String)StatsScan$.MODULE$.encodeStat(statSft2).apply((Object)stat) : stat.toJson();
        return CloseableIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ScalaSimpleFeature[]{new ScalaSimpleFeature(StatsScan$.MODULE$.StatsSft(), "stat", new Object[]{encoded, GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4())})), (Function0)(JFunction0.mcV.sp & Serializable)() -> CloseableIterator$.MODULE$.apply$default$2());
    }

    private CloseableIterator<SimpleFeature> projectionTransform(CloseableIterator<SimpleFeature> features, SimpleFeatureType sft, SimpleFeatureType transform, String definitions, Option<Seq<Tuple2<String, Object>>> sort) {
        TransformSimpleFeature transformSf = TransformSimpleFeature$.MODULE$.apply(sft, transform, definitions);
        CloseableIterator result = features.map((Function1 & Serializable)x$20 -> LocalQueryRunner$.setValues$1(x$20, new ScalaSimpleFeature(transform, "", ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$3(), ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4()), transformSf, transform));
        Option<Seq<Tuple2<String, Object>>> option = sort;
        if (None$.MODULE$.equals(option)) {
            return result;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq s = (Seq)some.value();
            return new SortingSimpleFeatureIterator((CloseableIterator<SimpleFeature>)result, (Seq<Tuple2<String, Object>>)s);
        }
        throw new MatchError(option);
    }

    private CloseableIterator<SimpleFeature> noTransform(CloseableIterator<SimpleFeature> features, Option<Seq<Tuple2<String, Object>>> sort) {
        Option<Seq<Tuple2<String, Object>>> option = sort;
        if (None$.MODULE$.equals(option)) {
            return features;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq s = (Seq)some.value();
            return new SortingSimpleFeatureIterator(features, (Seq<Tuple2<String, Object>>)s);
        }
        throw new MatchError(option);
    }

    private CloseableIterator<SimpleFeature> sample(SimpleFeatureType sft, float percent, Option<String> by, CloseableIterator<SimpleFeature> features) {
        if (!(percent > 0.0f) || !(percent < 1.0f)) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(46).append("Sampling must be a percentage between (0, 1): ").append(percent).toString());
        }
        int nth = (int)(1.0f / percent);
        Option field = by.map((Function1 & Serializable)name -> BoxesRunTime.boxToInteger((int)LocalQueryRunner$.$anonfun$sample$1(sft, name)));
        if (nth <= 1) {
            return features;
        }
        Function1<SimpleFeature, Object> sample = FeatureSampler$.MODULE$.sample(nth, (Option<Object>)field);
        return features.filter((Function1 & Serializable)v1 -> BoxesRunTime.boxToBoolean((boolean)LocalQueryRunner$.$anonfun$sample$2(sample, v1)));
    }

    private boolean noAuthVisibilityCheck(SimpleFeature f) {
        String vis = SecurityUtils.getVisibility((SimpleFeature)f);
        return vis == null || vis.isEmpty();
    }

    private boolean authVisibilityCheck(SimpleFeature f, Seq<byte[]> auths) {
        String vis = SecurityUtils.getVisibility((SimpleFeature)f);
        return vis == null || VisibilityEvaluator$.MODULE$.parse(vis, VisibilityEvaluator$.MODULE$.parse$default$2()).evaluate(auths);
    }

    public static final /* synthetic */ boolean $anonfun$transform$1(String x$11) {
        String string = x$11;
        String string2 = "id";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private static final /* synthetic */ Tuple2 x$16$lzycompute$1(LazyRef x$16$lzy$1, Option hook$1) {
        Tuple2 tuple2;
        LazyRef lazyRef = x$16$lzy$1;
        synchronized (lazyRef) {
            Tuple2 tuple22;
            if (x$16$lzy$1.initialized()) {
                tuple22 = (Tuple2)x$16$lzy$1.value();
            } else {
                LocalQueryRunner.ArrowDictionaryHook arrowDictionaryHook = (LocalQueryRunner.ArrowDictionaryHook)hook$1.getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException("Arrow query called without required hooks for dictionary lookups");
                });
                if (arrowDictionaryHook == null) {
                    throw new MatchError((Object)arrowDictionaryHook);
                }
                GeoMesaStats stats = arrowDictionaryHook.stats();
                Option<Filter> filter = arrowDictionaryHook.filter();
                tuple22 = (Tuple2)x$16$lzy$1.initialize((Object)new Tuple2((Object)stats, filter));
            }
            tuple2 = tuple22;
        }
        return tuple2;
    }

    private static final /* synthetic */ Tuple2 x$16$1(LazyRef x$16$lzy$1, Option hook$1) {
        if (x$16$lzy$1.initialized()) {
            return (Tuple2)x$16$lzy$1.value();
        }
        return LocalQueryRunner$.x$16$lzycompute$1(x$16$lzy$1, hook$1);
    }

    private static final /* synthetic */ GeoMesaStats stats$lzycompute$1(LazyRef stats$lzy$1, LazyRef x$16$lzy$1, Option hook$1) {
        GeoMesaStats geoMesaStats;
        LazyRef lazyRef = stats$lzy$1;
        synchronized (lazyRef) {
            geoMesaStats = stats$lzy$1.initialized() ? (GeoMesaStats)stats$lzy$1.value() : (GeoMesaStats)stats$lzy$1.initialize(LocalQueryRunner$.x$16$1(x$16$lzy$1, hook$1)._1());
        }
        return geoMesaStats;
    }

    private static final GeoMesaStats stats$1(LazyRef stats$lzy$1, LazyRef x$16$lzy$1, Option hook$1) {
        if (stats$lzy$1.initialized()) {
            return (GeoMesaStats)stats$lzy$1.value();
        }
        return LocalQueryRunner$.stats$lzycompute$1(stats$lzy$1, x$16$lzy$1, hook$1);
    }

    private static final /* synthetic */ Option filter$lzycompute$1(LazyRef filter$lzy$1, LazyRef x$16$lzy$1, Option hook$1) {
        Option option;
        LazyRef lazyRef = filter$lzy$1;
        synchronized (lazyRef) {
            option = filter$lzy$1.initialized() ? (Option)filter$lzy$1.value() : (Option)filter$lzy$1.initialize(LocalQueryRunner$.x$16$1(x$16$lzy$1, hook$1)._2());
        }
        return option;
    }

    private static final Option filter$1(LazyRef filter$lzy$1, LazyRef x$16$lzy$1, Option hook$1) {
        if (filter$lzy$1.initialized()) {
            return (Option)filter$lzy$1.value();
        }
        return LocalQueryRunner$.filter$lzycompute$1(filter$lzy$1, x$16$lzy$1, hook$1);
    }

    private static final ScalaSimpleFeature setValues$1(SimpleFeature from, ScalaSimpleFeature to, TransformSimpleFeature transformSf$1, SimpleFeatureType transform$1) {
        transformSf$1.setFeature(from);
        for (int i = 0; i < transform$1.getAttributeCount(); ++i) {
            to.setAttributeNoConvert(i, transformSf$1.getAttribute(i));
        }
        to.setId(from.getID());
        return to;
    }

    public static final /* synthetic */ int $anonfun$sample$1(SimpleFeatureType sft$5, String name) {
        int i = sft$5.indexOf(name);
        if (i == -1) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(38).append("Invalid sampling field '").append(name).append("' for schema ").append(sft$5.getTypeName()).append(" ").append(SimpleFeatureTypes$.MODULE$.encodeType(sft$5)).toString());
        }
        return i;
    }

    public static final /* synthetic */ boolean $anonfun$sample$2(Function1 sample$1, SimpleFeature v1) {
        return BoxesRunTime.unboxToBoolean((Object)sample$1.apply((Object)v1));
    }

    private LocalQueryRunner$() {
    }
}

