/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.data.Query;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.MetadataBackedDataStore;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.index.planning.StrategyDecider$;
import org.locationtech.geomesa.index.utils.ExplainLogging;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.locationtech.geomesa.index.utils.Reprojection$;
import org.locationtech.geomesa.index.utils.SortingSimpleFeatureIterator;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Transform;
import org.locationtech.geomesa.utils.iterators.ExceptionalIterator$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tmd\u0001B\u0011#\u00015B\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u00065\u0002!\ta\u0017\u0005\b=\u0002\u0011\r\u0011\"\u0015`\u0011\u0019!\b\u0001)A\u0005A\")Q\u000f\u0001C\u0001m\"I\u0011Q\f\u0001\u0012\u0002\u0013\u0005\u0011q\f\u0005\n\u0003k\u0002\u0011\u0013!C\u0001\u0003oBq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\u001e9\u0011\u0011\u001b\u0012\t\u0002\u0005MgAB\u0011#\u0011\u0003\t)\u000e\u0003\u0004[\u0019\u0011\u0005\u0011q\u001b\u0005\u000b\u00033d!\u0019!C\u0001E\u0005m\u0007\u0002CAx\u0019\u0001\u0006I!!8\b\u000f\u0005EH\u0002#\u0001\u0002t\u001a9\u0011q\u001f\u0007\t\u0002\u0005e\bB\u0002.\u0012\t\u0003\u0011\t!\u0002\u0004\u0002xF\u0001!1\u0001\u0005\n\u0005\u0017\t\"\u0019!C\u0001\u0005\u001bA\u0001Ba\u0004\u0012A\u0003%!1\u0001\u0005\n\u0005#\t\"\u0019!C\u0001\u0005\u001bA\u0001Ba\u0005\u0012A\u0003%!1\u0001\u0005\n\u0005+\t\u0012\u0011!C\u0005\u0005/AqA!\u000b\r\t\u0003\u0011Y\u0003C\u0004\u000381!\tA!\u000f\t\u000f\tuB\u0002\"\u0001\u0003@!9!\u0011\t\u0007\u0005\u0002\t\r\u0003b\u0002B%\u0019\u0011\u0005!1\n\u0005\b\u0005KbA\u0011\u0001B4\u0011\u001d\u0011i\u0007\u0004C\u0001\u0005_BqA!\u001e\r\t\u0003\u00119H\u0001\u0007Rk\u0016\u0014\u0018\u0010\u00157b]:,'O\u0003\u0002$I\u0005A\u0001\u000f\\1o]&twM\u0003\u0002&M\u0005)\u0011N\u001c3fq*\u0011q\u0005K\u0001\bO\u0016|W.Z:b\u0015\tI#&\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001,\u0003\ry'oZ\u0002\u0001+\tqcjE\u0003\u0001_UJ\u0014\t\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VM\u001a\t\u0003m]j\u0011AI\u0005\u0003q\t\u00121\"U;fef\u0014VO\u001c8feB\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0006gR\fGo\u001d\u0006\u0003}\u0019\nQ!\u001e;jYNL!\u0001Q\u001e\u0003\u001f5+G\u000f[8e!J|g-\u001b7j]\u001e\u0004\"AQ%\u000e\u0003\rS!\u0001R#\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0019;\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003!\u000b1aY8n\u0013\tQ5IA\u0006MCjLHj\\4hS:<\u0017A\u00013t!\tie\n\u0004\u0001\u0005\u000b=\u0003!\u0019\u0001)\u0003\u0005\u0011\u001b\u0016CA)U!\t\u0001$+\u0003\u0002Tc\t9aj\u001c;iS:<\u0007cA+Y\u00196\taK\u0003\u0002XI\u0005Aq-Z8u_>d7/\u0003\u0002Z-\n\u0001r)Z8NKN\fG)\u0019;b'R|'/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005qk\u0006c\u0001\u001c\u0001\u0019\")1J\u0001a\u0001\u0019\u0006a\u0011N\u001c;fe\u000e,\u0007\u000f^8sgV\t\u0001\r\u0005\u0002bc:\u0011!m\u001c\b\u0003G:t!\u0001Z7\u000f\u0005\u0015dgB\u00014l\u001d\t9'.D\u0001i\u0015\tIG&\u0001\u0004=e>|GOP\u0005\u0002W%\u0011\u0011FK\u0005\u0003O!J!!\n\u0014\n\u0005\r\"\u0013B\u00019#\u0003A\tV/\u001a:z\u0013:$XM]2faR|'/\u0003\u0002sg\n9\u0012+^3ss&sG/\u001a:dKB$xN\u001d$bGR|'/\u001f\u0006\u0003a\n\nQ\"\u001b8uKJ\u001cW\r\u001d;peN\u0004\u0013!\u00039mC:\fV/\u001a:z)%9\u0018QBA\u0013\u0003o\ty\u0005\u0005\u0003y{\u0006\u0005aBA=|\u001d\t9'0C\u00013\u0013\ta\u0018'A\u0004qC\u000e\\\u0017mZ3\n\u0005y|(aA*fc*\u0011A0\r\t\u0006\u0003\u0007\tI\u0001T\u0007\u0003\u0003\u000bQ1!a\u0002%\u0003\r\t\u0007/[\u0005\u0005\u0003\u0017\t)AA\u0005Rk\u0016\u0014\u0018\u0010\u00157b]\"9\u0011qB\u0003A\u0002\u0005E\u0011aA:giB!\u00111CA\u0011\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011AB:j[BdWM\u0003\u0003\u0002\u001c\u0005u\u0011a\u00024fCR,(/\u001a\u0006\u0004\u0003?Q\u0013aB8qK:<\u0017n]\u0005\u0005\u0003G\t)BA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016Dq!a\n\u0006\u0001\u0004\tI#A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0003\u0002,\u0005MRBAA\u0017\u0015\u0011\ty#!\r\u0002\t\u0011\fG/\u0019\u0006\u0003/*JA!!\u000e\u0002.\t)\u0011+^3ss\"AQ%\u0002I\u0001\u0002\u0004\tI\u0004E\u00031\u0003w\ty$C\u0002\u0002>E\u0012aa\u00149uS>t\u0007\u0003BA!\u0003\u0013rA!a\u0011\u0002FA\u0011q-M\u0005\u0004\u0003\u000f\n\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002L\u00055#AB*ue&twMC\u0002\u0002HEB\u0011\"!\u0015\u0006!\u0003\u0005\r!a\u0015\u0002\r=,H\u000f];u!\u0011\t)&!\u0017\u000e\u0005\u0005]#B\u0001 %\u0013\u0011\tY&a\u0016\u0003\u0013\u0015C\b\u000f\\1j]\u0016\u0014\u0018a\u00059mC:\fV/\u001a:zI\u0011,g-Y;mi\u0012\u001aTCAA1U\u0011\tI$a\u0019,\u0005\u0005\u0015\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001c2\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\nIGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0003\u001d7b]F+XM]=%I\u00164\u0017-\u001e7uIQ*\"!!\u001f+\t\u0005M\u00131M\u0001\teVt\u0017+^3ssRA\u0011qPAG\u0003\u001f\u000b\u0019\n\u0005\u0003\u0002\u0002\u0006\u001deb\u00012\u0002\u0004&\u0019\u0011Q\u0011\u0012\u0002\u0017E+XM]=Sk:tWM]\u0005\u0005\u0003\u0013\u000bYIA\u0006Rk\u0016\u0014\u0018PU3tk2$(bAACE!9\u0011q\u0002\u0005A\u0002\u0005E\u0001bBAI\u0011\u0001\u0007\u0011\u0011F\u0001\t_JLw-\u001b8bY\"I\u0011Q\u0013\u0005\u0011\u0002\u0003\u0007\u00111K\u0001\bKb\u0004H.Y5o\u0003\r\u0011XO\u001c\u000b\u0007\u00037\u000by+!-\u0015\u0005\u0005u\u0005CBAP\u0003K\u000bI+\u0004\u0002\u0002\"*\u0019\u00111U\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002(\u0006\u0005&!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB!\u00111CAV\u0013\u0011\ti+!\u0006\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u001d\t9#\u0003a\u0001\u0003SAa!a-\n\u0001\u00049\u0018!\u00029mC:\u001c\u0018!D4fiF+XM]=QY\u0006t7\u000fF\u0006x\u0003s\u000bY,!0\u0002L\u0006=\u0007bBA\b\u0015\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003OQ\u0001\u0019AA\u0015\u0011\u001d\t\tJ\u0003a\u0001\u0003\u007f\u0003B!!1\u0002H6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\fi\"\u0001\u0004gS2$XM]\u0005\u0005\u0003\u0013\f\u0019M\u0001\u0004GS2$XM\u001d\u0005\b\u0003\u001bT\u0001\u0019AA\u001d\u0003%\u0011X-];fgR,G\rC\u0004\u0002R)\u0001\r!a\u0015\u0002\u0019E+XM]=QY\u0006tg.\u001a:\u0011\u0005Yb1c\u0001\u00070\u0003R\u0011\u00111[\u0001\u000ei\"\u0014X-\u00193fI\"Kg\u000e^:\u0016\u0005\u0005u\u0007CBAp\u0003K\fI/\u0004\u0002\u0002b*\u0019\u00111]\u001f\u0002\u000b\r\f7\r[3\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u0010'>4G\u000f\u00165sK\u0006$Gj\\2bYB1\u0011\u0011IAv_=JA!!<\u0002N\t\u0019Q*\u00199\u0002\u001dQD'/Z1eK\u0012D\u0015N\u001c;tA\u0005q1i\\:u\u000bZ\fG.^1uS>t\u0007cAA{#5\tAB\u0001\bD_N$XI^1mk\u0006$\u0018n\u001c8\u0014\u0007E\tY\u0010E\u00021\u0003{L1!a@2\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0015\u0005\u0005M\b\u0003\u0002B\u0003\u0005\u000fi\u0011!E\u0005\u0005\u0005\u0013\tiPA\u0003WC2,X-A\u0003Ti\u0006$8/\u0006\u0002\u0003\u0004\u000511\u000b^1ug\u0002\nQ!\u00138eKb\fa!\u00138eKb\u0004\u0013\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\r!\u0011\u0011YB!\n\u000e\u0005\tu!\u0002\u0002B\u0010\u0005C\tA\u0001\\1oO*\u0011!1E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003(\tu!AB(cU\u0016\u001cG/\u0001\ftKR\u0004VM\u001d+ie\u0016\fG-U;fefD\u0015N\u001c;t)\u0011\u0011iCa\r\u0011\u0007A\u0012y#C\u0002\u00032E\u0012A!\u00168ji\"9!QG\rA\u0002\u0005%\u0018!\u00025j]R\u001c\u0018AF4fiB+'\u000f\u00165sK\u0006$\u0017+^3ss\"Kg\u000e^:\u0016\u0005\tm\u0002#\u0002\u0019\u0002<\u0005%\u0018\u0001G2mK\u0006\u0014\b+\u001a:UQJ,\u0017\rZ)vKJL\b*\u001b8ugR\u0011!QF\u0001\u0013g\u0016$\u0018+^3ssR\u0013\u0018M\\:g_Jl7\u000f\u0006\u0004\u0003.\t\u0015#q\t\u0005\b\u0003\u001fa\u0002\u0019AA\t\u0011\u001d\t9\u0003\ba\u0001\u0003S\ta#\u001a=ue\u0006\u001cG/U;fef$&/\u00198tM>\u0014Xn\u001d\u000b\u0007\u0005\u001b\u0012\tGa\u0019\u0011\u000bA\nYDa\u0014\u0011\u0013A\u0012\t&!\u0005\u0003V\u0005}\u0012b\u0001B*c\t1A+\u001e9mKN\u0002B\u0001_?\u0003XA!!\u0011\fB/\u001b\t\u0011YF\u0003\u0002X{%!!q\fB.\u0005%!&/\u00198tM>\u0014X\u000eC\u0004\u0002\u0010u\u0001\r!!\u0005\t\u000f\u0005\u001dR\u00041\u0001\u0002*\u0005a1/\u001a;Rk\u0016\u0014\u0018pU8siR1!Q\u0006B5\u0005WBq!a\u0004\u001f\u0001\u0004\t\t\u0002C\u0004\u0002(y\u0001\r!!\u000b\u0002\u001bM,G\u000f\u0015:pU\u0016\u001cG/[8o)\u0019\u0011iC!\u001d\u0003t!9\u0011qB\u0010A\u0002\u0005E\u0001bBA\u0014?\u0001\u0007\u0011\u0011F\u0001\u000fg\u0016$X*\u0019=GK\u0006$XO]3t)\u0011\u0011iC!\u001f\t\u000f\u0005\u001d\u0002\u00051\u0001\u0002*\u0001")
public class QueryPlanner<DS extends GeoMesaDataStore<DS>>
implements QueryRunner,
MethodProfiling {
    private final DS ds;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static void setMaxFeatures(Query query) {
        QueryPlanner$.MODULE$.setMaxFeatures(query);
    }

    public static void setProjection(SimpleFeatureType sft, Query query) {
        QueryPlanner$.MODULE$.setProjection(sft, query);
    }

    public static void setQuerySort(SimpleFeatureType sft, Query query) {
        QueryPlanner$.MODULE$.setQuerySort(sft, query);
    }

    public static Option<Tuple3<SimpleFeatureType, Seq<Transform>, String>> extractQueryTransforms(SimpleFeatureType sft, Query query) {
        return QueryPlanner$.MODULE$.extractQueryTransforms(sft, query);
    }

    public static void setQueryTransforms(SimpleFeatureType sft, Query query) {
        QueryPlanner$.MODULE$.setQueryTransforms(sft, query);
    }

    public static void clearPerThreadQueryHints() {
        QueryPlanner$.MODULE$.clearPerThreadQueryHints();
    }

    public static Option<Map<Object, Object>> getPerThreadQueryHints() {
        return QueryPlanner$.MODULE$.getPerThreadQueryHints();
    }

    public static void setPerThreadQueryHints(Map<Object, Object> hints) {
        QueryPlanner$.MODULE$.setPerThreadQueryHints(hints);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    @Override
    public Explainer runQuery$default$3() {
        return QueryRunner.runQuery$default$3$(this);
    }

    @Override
    public Query configureQuery(SimpleFeatureType sft, Query original) {
        return QueryRunner.configureQuery$(this, sft, original);
    }

    @Override
    public SimpleFeatureType getReturnSft(SimpleFeatureType sft, Hints hints) {
        return QueryRunner.getReturnSft$(this, sft, hints);
    }

    private Logger logger$lzycompute() {
        QueryPlanner queryPlanner = this;
        synchronized (queryPlanner) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    public Seq<QueryPlan<DS>> planQuery(SimpleFeatureType sft, Query query, Option<String> index, Explainer output) {
        return this.getQueryPlans(sft, this.configureQuery(sft, query), query.getFilter(), index, output).toList();
    }

    public Option<String> planQuery$default$3() {
        return None$.MODULE$;
    }

    public Explainer planQuery$default$4() {
        return new ExplainLogging();
    }

    @Override
    public QueryRunner.QueryResult runQuery(SimpleFeatureType sft, Query original, Explainer explain) {
        Query query = this.configureQuery(sft, original);
        Seq plans = this.getQueryPlans(sft, query, original.getFilter(), (Option<String>)None$.MODULE$, explain);
        return new QueryRunner.QueryResult(QueryHints$.MODULE$.RichHints(query.getHints()).getReturnSft(), query.getHints(), (Function0<CloseableIterator<SimpleFeature>>)(Function0 & Serializable)() -> this.run(query, plans));
    }

    private CloseableIterator<SimpleFeature> run(Query query, Seq<QueryPlan<DS>> plans) {
        ObjectRef iterator = ObjectRef.create((Object)SelfClosingIterator$.MODULE$.apply(plans.iterator(), (Function0)(JFunction0.mcV.sp & Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable)p -> {
            QueryPlan.ResultsToFeatures<Object> resultsToFeatures = p.resultsToFeatures();
            return p.scan($this.ds).map((Function1 & Serializable)result -> resultsToFeatures.apply(result));
        }));
        if (!QueryHints$.MODULE$.RichHints(query.getHints()).isSkipReduce()) {
            plans.headOption().flatMap((Function1 & Serializable)x$1 -> x$1.reducer()).foreach((Function1 & Serializable)reducer -> {
                QueryPlanner.$anonfun$run$5(plans, iterator, reducer);
                return BoxedUnit.UNIT;
            });
        }
        plans.headOption().flatMap((Function1 & Serializable)x$3 -> x$3.sort()).foreach((Function1 & Serializable)sort -> {
            QueryPlanner.$anonfun$run$9(plans, iterator, sort);
            return BoxedUnit.UNIT;
        });
        plans.headOption().flatMap((Function1 & Serializable)x$5 -> x$5.maxFeatures()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)maxFeatures -> {
            Predef$.MODULE$.require(((IterableOnceOps)plans.tail()).forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)QueryPlanner.$anonfun$run$14(maxFeatures, x$6))), (Function0 & Serializable)() -> "Max features must be the same in all query plans");
            SimpleFeatureType simpleFeatureType = QueryHints$.MODULE$.RichHints(query.getHints()).getReturnSft();
            SimpleFeatureType simpleFeatureType2 = BinaryOutputEncoder$.MODULE$.BinEncodedSft();
            if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
                boolean label = QueryHints$.MODULE$.RichHints(query.getHints()).getBinLabelField().isDefined();
                iterator$1.elem = new BinaryOutputEncoder.FeatureLimitingIterator((CloseableIterator)iterator$1.elem, maxFeatures, label);
                return;
            }
            iterator$1.elem = ((CloseableIterator)iterator$1.elem).take(maxFeatures);
        });
        plans.headOption().flatMap((Function1 & Serializable)x$7 -> x$7.projection()).foreach((Function1 & Serializable)projection -> {
            QueryPlanner.$anonfun$run$17(plans, query, iterator, projection);
            return BoxedUnit.UNIT;
        });
        return ExceptionalIterator$.MODULE$.apply((CloseableIterator)iterator.elem);
    }

    private Seq<QueryPlan<DS>> getQueryPlans(SimpleFeatureType sft, Query query, Filter original, Option<String> requested, Explainer output) {
        return (Seq)this.profile((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)time -> output.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Query planning took ").append(time).append("ms").toString()), (Function0 & Serializable)() -> {
            Hints hints = query.getHints();
            output.pushLevel((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Planning '").append(query.getTypeName()).append("' ").append(package$.MODULE$.filterToString(query.getFilter())).toString());
            output.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Original filter: ").append(package$.MODULE$.filterToString(original)).toString());
            output.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(49).append("Hints: bin[").append(QueryHints$.MODULE$.RichHints(hints).isBinQuery()).append("] arrow[").append(QueryHints$.MODULE$.RichHints(hints).isArrowQuery()).append("] density[").append(QueryHints$.MODULE$.RichHints(hints).isDensityQuery()).append("] ").append("stats[").append(QueryHints$.MODULE$.RichHints(hints).isStatsQuery()).append("] ").append("sampling[").append(QueryHints$.MODULE$.RichHints(hints).getSampling().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    float s = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                    Option f = (Option)tuple2._2();
                    return new StringBuilder(0).append(s).append(f.map((Function1 & Serializable)x$9 -> new StringBuilder(1).append(":").append((String)x$9).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
                }
                throw new MatchError((Object)tuple2);
            }).getOrElse((Function0 & Serializable)() -> "none")).append("]").toString());
            output.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(6).append("Sort: ").append(QueryHints$.MODULE$.RichHints(query.getHints()).getSortFields().map((Function1 & Serializable)sort -> QueryHints$.MODULE$.sortReadableString((Seq<Tuple2<String, Object>>)sort)).getOrElse((Function0 & Serializable)() -> "none")).toString());
            output.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Transforms: ").append(QueryHints$.MODULE$.RichHints(query.getHints()).getTransformDefinition().map((Function1 & Serializable)t -> {
                if (t.isEmpty()) {
                    return "empty";
                }
                return t;
            }).getOrElse((Function0 & Serializable)() -> "none")).toString());
            output.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("Max features: ").append(QueryHints$.MODULE$.RichHints(query.getHints()).getMaxFeatures().getOrElse((Function0 & Serializable)() -> "none")).toString());
            QueryHints$.MODULE$.RichHints(hints).getFilterCompatibility().foreach((Function1 & Serializable)c -> output.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Filter compatibility: ").append(c).toString()));
            output.pushLevel((Function0<String>)(Function0 & Serializable)() -> "Strategy selection:");
            Option requestedIndex = requested.orElse((Function0 & Serializable)() -> QueryHints$.MODULE$.RichHints(hints).getRequestedIndex());
            Option<SimpleFeatureType> transform = QueryHints$.MODULE$.RichHints(query.getHints()).getTransformSchema();
            Enumeration.Value evaluation = QueryHints$.MODULE$.RichHints(query.getHints()).getCostEvaluation();
            Seq<package.FilterStrategy> strategies = StrategyDecider$.MODULE$.getFilterPlan($this.ds, sft, query.getFilter(), transform, evaluation, (Option<String>)requestedIndex, output);
            output.popLevel();
            IntRef strategyCount = IntRef.create((int)1);
            return (Seq)strategies.map((Function1 & Serializable)strategy -> {
                output.pushLevel((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("Strategy ").append(strategyCount$1.elem).append(" of ").append(strategies.length()).append(": ").append(strategy.index()).toString());
                ++strategyCount$1.elem;
                output.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Strategy filter: ").append(strategy).toString());
                return (QueryPlan)this.profile((Function2 & Serializable)(plan, time) -> {
                    QueryPlanner.complete$1(plan, BoxesRunTime.unboxToLong((Object)time), output);
                    return BoxedUnit.UNIT;
                }, (Function0 & Serializable)() -> {
                    package.QueryStrategy qs = strategy.getQueryStrategy(hints, output);
                    this.interceptors().apply(sft).foreach((Function1 & Serializable)x$10 -> {
                        QueryPlanner.$anonfun$getQueryPlans$29(qs, x$10);
                        return BoxedUnit.UNIT;
                    });
                    return ((GeoMesaDataStore)$this.ds).adapter().createQueryPlan(qs);
                });
            });
        });
    }

    public static final /* synthetic */ boolean $anonfun$run$6(QueryPlan.FeatureReducer reducer$1, QueryPlan x$2) {
        return x$2.reducer().contains((Object)reducer$1);
    }

    public static final /* synthetic */ void $anonfun$run$5(Seq plans$2, ObjectRef iterator$1, QueryPlan.FeatureReducer reducer) {
        Predef$.MODULE$.require(((IterableOnceOps)plans$2.tail()).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)QueryPlanner.$anonfun$run$6(reducer, x$2))), (Function0 & Serializable)() -> "Reduce must be the same in all query plans");
        iterator$1.elem = reducer.apply((CloseableIterator<SimpleFeature>)((CloseableIterator)iterator$1.elem));
    }

    public static final /* synthetic */ boolean $anonfun$run$10(Seq sort$1, QueryPlan x$4) {
        return x$4.sort().contains((Object)sort$1);
    }

    public static final /* synthetic */ void $anonfun$run$9(Seq plans$2, ObjectRef iterator$1, Seq sort) {
        Predef$.MODULE$.require(((IterableOnceOps)plans$2.tail()).forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)QueryPlanner.$anonfun$run$10(sort, x$4))), (Function0 & Serializable)() -> "Sort must be the same in all query plans");
        iterator$1.elem = new SortingSimpleFeatureIterator((CloseableIterator<SimpleFeature>)((CloseableIterator)iterator$1.elem), (Seq<Tuple2<String, Object>>)sort);
    }

    public static final /* synthetic */ boolean $anonfun$run$14(int maxFeatures$1, QueryPlan x$6) {
        return x$6.maxFeatures().contains((Object)BoxesRunTime.boxToInteger((int)maxFeatures$1));
    }

    public static final /* synthetic */ boolean $anonfun$run$18(Reprojection.QueryReferenceSystems projection$1, QueryPlan x$8) {
        return x$8.projection().contains((Object)projection$1);
    }

    public static final /* synthetic */ void $anonfun$run$17(Seq plans$2, Query query$2, ObjectRef iterator$1, Reprojection.QueryReferenceSystems projection) {
        Predef$.MODULE$.require(((IterableOnceOps)plans$2.tail()).forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)QueryPlanner.$anonfun$run$18(projection, x$8))), (Function0 & Serializable)() -> "Projection must be the same in all query plans");
        Reprojection project = Reprojection$.MODULE$.apply(QueryHints$.MODULE$.RichHints(query$2.getHints()).getReturnSft(), projection);
        iterator$1.elem = ((CloseableIterator)iterator$1.elem).map((Function1 & Serializable)feature -> project.apply((SimpleFeature)feature));
    }

    private static final void complete$1(QueryPlan plan, long time, Explainer output$1) {
        plan.explain(output$1, plan.explain$default$2());
        output$1.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Plan creation took ").append(time).append("ms").toString()).popLevel();
    }

    public static final /* synthetic */ void $anonfun$getQueryPlans$29(package.QueryStrategy qs$1, QueryInterceptor x$10) {
        x$10.guard(qs$1).foreach((Function1 & Serializable)e -> {
            throw e;
        });
    }

    public QueryPlanner(DS ds) {
        this.ds = ds;
        QueryRunner.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
        this.interceptors = ((MetadataBackedDataStore)ds).interceptors();
    }
}

