/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.EmptyIndex;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex$;
import org.locationtech.geomesa.index.planning.FilterSplitter;
import org.locationtech.geomesa.index.planning.QueryPlanner$CostEvaluation$;
import org.locationtech.geomesa.index.planning.StrategyDecider;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.utils.ExplainNull$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class StrategyDecider$
implements MethodProfiling {
    public static final StrategyDecider$ MODULE$;
    private static final StrategyDecider decider;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        BoxedUnit boxedUnit;
        StrategyDecider strategyDecider;
        MODULE$ = new StrategyDecider$();
        LazyLogging.$init$((LazyLogging)MODULE$);
        MethodProfiling.$init$((MethodProfiling)MODULE$);
        Option option = new GeoMesaSystemProperties.SystemProperty("geomesa.strategy.decider", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option();
        if (None$.MODULE$.equals(option)) {
            strategyDecider = new StrategyDecider.CostBasedStrategyDecider();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String clas = (String)some.value();
            strategyDecider = (StrategyDecider)Class.forName(clas).newInstance();
        } else {
            throw new MatchError((Object)option);
        }
        decider = strategyDecider;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("Using strategy provider '{}'", (Object)MODULE$.decider().getClass().getName());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        StrategyDecider$ strategyDecider$ = this;
        synchronized (strategyDecider$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private StrategyDecider decider() {
        return decider;
    }

    public <DS extends GeoMesaDataStore<DS>> Seq<package.FilterStrategy> getFilterPlan(DS ds, SimpleFeatureType sft, Filter filter, Option<SimpleFeatureType> transform, Enumeration.Value evaluation, Option<String> requested, Explainer explain) {
        Seq<GeoMesaFeatureIndex<?, ?>> indices = ds.manager().indices(sft, IndexMode$.MODULE$.Read());
        Seq options = (Seq)this.profile((Function2 & Serializable)(o, t) -> {
            StrategyDecider$.complete$1("Query processing", BoxesRunTime.unboxToLong((Object)t), o.length(), explain);
            return BoxedUnit.UNIT;
        }, (Function0 & Serializable)() -> new FilterSplitter(sft, indices).getQueryOptions(filter, transform));
        package.FilterPlan selected = (package.FilterPlan)this.profile((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)t -> StrategyDecider$.complete$1("Strategy selection", t, options.length(), explain), (Function0 & Serializable)() -> {
            Some some;
            if (requested.isDefined()) {
                package.FilterPlan forced = MODULE$.matchRequested((String)requested.get(), indices, (Seq<package.FilterPlan>)options, filter);
                explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Filter plan forced to ").append(forced).toString());
                return forced;
            }
            if (options.isEmpty()) {
                explain.apply((Function0<String>)(Function0 & Serializable)() -> "No filter plans found - creating empty plan");
                return new package.FilterPlan((Seq<package.FilterStrategy>)new .colon.colon((Object)new package.FilterStrategy(new EmptyIndex(ds, sft), (Option<Filter>)new Some((Object)Filter.EXCLUDE), (Option<Filter>)None$.MODULE$, false, 1.0f), (List)Nil$.MODULE$));
            }
            if (options.lengthCompare(1) == 0) {
                explain.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Filter plan: ").append(options.head()).toString());
                return (package.FilterPlan)options.head();
            }
            Enumeration.Value value = evaluation;
            Enumeration.Value value2 = QueryPlanner$CostEvaluation$.MODULE$.Stats();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                some = new Some((Object)ds.stats());
            } else {
                Enumeration.Value value4 = QueryPlanner$CostEvaluation$.MODULE$.Index();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    some = None$.MODULE$;
                } else {
                    throw new MatchError((Object)value);
                }
            }
            Some stats = some;
            return MODULE$.decider().selectFilterPlan(sft, (Seq<package.FilterPlan>)options, (Option<GeoMesaStats>)stats, explain);
        });
        return selected.strategies();
    }

    public <DS extends GeoMesaDataStore<DS>> Explainer getFilterPlan$default$7() {
        return ExplainNull$.MODULE$;
    }

    private package.FilterPlan matchRequested(String id, Seq<GeoMesaFeatureIndex<?, ?>> indices, Seq<package.FilterPlan> options, Filter filter) {
        return (package.FilterPlan)StrategyDecider$.byId$1(options, id).orElse((Function0 & Serializable)() -> StrategyDecider$.byName$1(options, id)).orElse((Function0 & Serializable)() -> StrategyDecider$.byJoin$1(id, options)).getOrElse((Function0 & Serializable)() -> StrategyDecider$.fallback$1(indices, id, filter));
    }

    private static final void complete$1(String op, long time, int count, Explainer explain$1) {
        explain$1.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append(op).append(" took ").append(time).append("ms for ").append(count).append(" options").toString());
    }

    public static final /* synthetic */ boolean $anonfun$matchRequested$2(String id$1, package.FilterStrategy x$2) {
        return x$2.index().identifier().equalsIgnoreCase(id$1);
    }

    public static final /* synthetic */ boolean $anonfun$matchRequested$1(String id$1, package.FilterPlan x$1) {
        return x$1.strategies().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StrategyDecider$.$anonfun$matchRequested$2(id$1, x$2)));
    }

    private static final Option byId$1(Seq options$2, String id$1) {
        return options$2.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StrategyDecider$.$anonfun$matchRequested$1(id$1, x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$matchRequested$4(String id$1, package.FilterStrategy x$4) {
        return x$4.index().name().equalsIgnoreCase(id$1);
    }

    public static final /* synthetic */ boolean $anonfun$matchRequested$3(String id$1, package.FilterPlan x$3) {
        return x$3.strategies().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StrategyDecider$.$anonfun$matchRequested$4(id$1, x$4)));
    }

    private static final Option byName$1(Seq options$2, String id$1) {
        return options$2.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StrategyDecider$.$anonfun$matchRequested$3(id$1, x$3)));
    }

    public static final /* synthetic */ boolean $anonfun$matchRequested$6(package.FilterStrategy x$6) {
        String string = x$6.index().name();
        String string2 = AttributeIndex$.MODULE$.JoinIndexName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$matchRequested$5(package.FilterPlan x$5) {
        return x$5.strategies().forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StrategyDecider$.$anonfun$matchRequested$6(x$6)));
    }

    private static final Option byJoin$1(String id$1, Seq options$2) {
        if (!AttributeIndex$.MODULE$.name().equalsIgnoreCase(id$1)) {
            return None$.MODULE$;
        }
        return options$2.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StrategyDecider$.$anonfun$matchRequested$5(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$matchRequested$7(String id$1, GeoMesaFeatureIndex x$7) {
        return x$7.identifier().equalsIgnoreCase(id$1);
    }

    public static final /* synthetic */ boolean $anonfun$matchRequested$9(String id$1, GeoMesaFeatureIndex x$8) {
        return x$8.name().equalsIgnoreCase(id$1);
    }

    private static final package.FilterPlan fallback$1(Seq indices$2, String id$1, Filter filter$2) {
        GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)indices$2.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StrategyDecider$.$anonfun$matchRequested$7(id$1, x$7))).orElse((Function0 & Serializable)() -> indices$2.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StrategyDecider$.$anonfun$matchRequested$9(id$1, x$8)))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(43).append("Invalid index strategy: ").append(id$1).append(". Valid values are ").append(((IterableOnceOps)indices$2.map((Function1 & Serializable)i -> new StringBuilder(2).append(i.name()).append(", ").append(i.identifier()).toString())).mkString(", ")).toString());
        });
        Filter filter = filter$2;
        IncludeFilter includeFilter = Filter.INCLUDE;
        None$ secondary = !(filter != null ? !filter.equals(includeFilter) : includeFilter != null) ? None$.MODULE$ : new Some((Object)filter$2);
        return new package.FilterPlan((Seq<package.FilterStrategy>)new .colon.colon((Object)new package.FilterStrategy(index, (Option<Filter>)None$.MODULE$, (Option<Filter>)secondary, false, Float.POSITIVE_INFINITY), (List)Nil$.MODULE$));
    }

    private StrategyDecider$() {
    }
}

