/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning.guard;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.locationtech.geomesa.index.planning.guard.GraduatedQueryGuard;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Function1;
import scala.MatchError;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GraduatedQueryGuard$
implements LazyLogging {
    public static final GraduatedQueryGuard$ MODULE$ = new GraduatedQueryGuard$();
    private static final String ConfigPath;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        ConfigPath = "geomesa.guard.graduated";
    }

    private Logger logger$lzycompute() {
        GraduatedQueryGuard$ graduatedQueryGuard$ = this;
        synchronized (graduatedQueryGuard$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String ConfigPath() {
        return ConfigPath;
    }

    public boolean disabled(String typeName) {
        return new GeoMesaSystemProperties.SystemProperty(new StringBuilder(32).append("geomesa.guard.graduated.").append(typeName).append(".disable").toString(), GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).toBoolean().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    private Seq<GraduatedQueryGuard.SizeAndDuration> evaluateLimits(Seq<GraduatedQueryGuard.SizeAndDuration> limits) {
        Seq candidate = (Seq)limits.sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.sizeLimit()), (Ordering)Ordering.Int$.MODULE$);
        if (candidate.size() > 1) {
            candidate.sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                GraduatedQueryGuard$.$anonfun$evaluateLimits$2(x0$1);
                return BoxedUnit.UNIT;
            });
        } else if (candidate.isEmpty()) {
            throw new IllegalArgumentException("Graduated query guard configuration is empty.");
        }
        if (((GraduatedQueryGuard.SizeAndDuration)candidate.last()).sizeLimit() != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Graduated query guard configuration must include unbounded restriction.");
        }
        return candidate;
    }

    public Seq<GraduatedQueryGuard.SizeAndDuration> buildLimits(List<? extends Config> guardConfig) {
        Buffer confs = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(guardConfig).asScala()).map((Function1 & Serializable)durationConfig -> {
            int size = durationConfig.hasPath("size") ? durationConfig.getInt("size") : Integer.MAX_VALUE;
            Duration duration = Duration$.MODULE$.apply(durationConfig.getString("duration"));
            return new GraduatedQueryGuard.SizeAndDuration(size, duration);
        });
        return this.evaluateLimits((Seq<GraduatedQueryGuard.SizeAndDuration>)confs.toSeq());
    }

    public static final /* synthetic */ void $anonfun$evaluateLimits$2(Seq x0$1) {
        SeqOps seqOps;
        Seq seq = x0$1;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            GraduatedQueryGuard.SizeAndDuration first = (GraduatedQueryGuard.SizeAndDuration)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            GraduatedQueryGuard.SizeAndDuration second = (GraduatedQueryGuard.SizeAndDuration)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (first.sizeLimit() == second.sizeLimit()) {
                throw new IllegalArgumentException(new StringBuilder(55).append("Graduated query guard configuration ").append("has repeated size: ").append(first.sizeLimit()).toString());
            }
            if (first.durationLimit().compareTo((Object)second.durationLimit()) <= 0) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Graduated query guard configuration ").append("has durations out of order: ").append(first.durationLimit()).append(" is less than ").append(second.durationLimit()).toString());
            }
            return;
        }
        throw new MatchError((Object)seq);
    }

    private GraduatedQueryGuard$() {
    }
}

