/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning.guard;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.index.package;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.guard.GraduatedQueryGuard$;
import org.locationtech.geomesa.index.planning.guard.package$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tUf\u0001B\u0017/\u0001mBQA\u0015\u0001\u0005\u0002MC\u0011B\u0016\u0001A\u0002\u0003\u0007I\u0011B,\t\u0017\te\u0002\u00011AA\u0002\u0013%!1\b\u0005\u000b\u0005\u000b\u0002\u0001\u0019!A!B\u0013A\u0006\"CAt\u0001\u0001\u0007I\u0011\u0002B$\u0011%\u0011I\u0005\u0001a\u0001\n\u0013\u0011Y\u0005\u0003\u0005\u0003P\u0001\u0001\u000b\u0015BAG\u0011\u001d\u0011\t\u0006\u0001C!\u0005'BqA!!\u0001\t\u0003\u0012\u0019\t\u0003\u00040\u0001\u0011\u0005#q\u0012\u0005\b\u0005c\u0003A\u0011\tBZ\u000f\u0015!h\u0006#\u0001v\r\u0015ic\u0006#\u0001w\u0011\u0015\u0011V\u0002\"\u0001|\u0011\u001daXB1A\u0005\u0002uDq!a\u0001\u000eA\u0003%aP\u0002\u0004\u0002\u00065\u0001\u0015q\u0001\u0005\u000b\u0003+\t\"Q3A\u0005\u0002\u0005]\u0001BCA\u0010#\tE\t\u0015!\u0003\u0002\u001a!Q\u0011\u0011E\t\u0003\u0016\u0004%\t!a\t\t\u0015\u0005U\u0012C!E!\u0002\u0013\t)\u0003\u0003\u0004S#\u0011\u0005\u0011q\u0007\u0005\n\u0003\u0003\n\u0012\u0011!C\u0001\u0003\u0007B\u0011\"!\u0013\u0012#\u0003%\t!a\u0013\t\u0013\u0005\u0005\u0014#%A\u0005\u0002\u0005\r\u0004\u0002CA4#\u0005\u0005I\u0011I?\t\u0013\u0005%\u0014#!A\u0005\u0002\u0005]\u0001\"CA6#\u0005\u0005I\u0011AA7\u0011%\tI(EA\u0001\n\u0003\nY\bC\u0005\u0002\nF\t\t\u0011\"\u0001\u0002\f\"I\u0011QS\t\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u00037\u000b\u0012\u0011!C!\u0003;C\u0011\"a(\u0012\u0003\u0003%\t%!)\t\u0013\u0005\r\u0016#!A\u0005B\u0005\u0015v!CAU\u001b\u0005\u0005\t\u0012AAV\r%\t)!DA\u0001\u0012\u0003\ti\u000b\u0003\u0004SI\u0011\u0005\u0011Q\u0019\u0005\n\u0003?#\u0013\u0011!C#\u0003CC\u0011\"a2%\u0003\u0003%\t)!3\t\u0013\u0005=G%!A\u0005\u0002\u0006E\u0007\"CArI\u0005\u0005I\u0011BAs\u0011\u001d\t9/\u0004C\u0001\u0003SDq!!@\u000e\t\u0013\ty\u0010C\u0004\u0003\b5!\tA!\u0003\u0003'\u001d\u0013\u0018\rZ;bi\u0016$\u0017+^3ss\u001e+\u0018M\u001d3\u000b\u0005=\u0002\u0014!B4vCJ$'BA\u00193\u0003!\u0001H.\u00198oS:<'BA\u001a5\u0003\u0015Ig\u000eZ3y\u0015\t)d'A\u0004hK>lWm]1\u000b\u0005]B\u0014\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001aD\t\u0013\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bA\u0001\\1oO*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005\u0019y%M[3diB\u0011QIR\u0007\u0002a%\u0011q\t\r\u0002\u0011#V,'/_%oi\u0016\u00148-\u001a9u_J\u0004\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u00055s\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003=\u000b1aY8n\u0013\t\t&JA\u0006MCjLHj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001U!\t)\u0006!D\u0001/\u0003-9W/\u0019:e\u0019&l\u0017\u000e^:\u0016\u0003a\u00032!W2g\u001d\tQ\u0006M\u0004\u0002\\=6\tAL\u0003\u0002^u\u00051AH]8pizJ\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003C\n\fq\u0001]1dW\u0006<WMC\u0001`\u0013\t!WMA\u0002TKFT!!\u00192\u0011\u0005\u001d\fbB\u00015\r\u001d\tI7O\u0004\u0002ke:\u00111.\u001d\b\u0003YBt!!\\8\u000f\u0005ms\u0017\"A\u001d\n\u0005]B\u0014BA\u001b7\u0013\t\u0019D'\u0003\u00022e%\u0011q\u0006M\u0001\u0014\u000fJ\fG-^1uK\u0012\fV/\u001a:z\u000fV\f'\u000f\u001a\t\u0003+6\u00192!D<I!\tA\u00180D\u0001c\u0013\tQ(M\u0001\u0004B]f\u0014VM\u001a\u000b\u0002k\u0006Q1i\u001c8gS\u001e\u0004\u0016\r\u001e5\u0016\u0003y\u0004\"!P@\n\u0007\u0005\u0005aH\u0001\u0004TiJLgnZ\u0001\f\u0007>tg-[4QCRD\u0007EA\bTSj,\u0017I\u001c3EkJ\fG/[8o'\u0019\tr/!\u0003\u0002\u0010A\u0019\u00010a\u0003\n\u0007\u00055!MA\u0004Qe>$Wo\u0019;\u0011\u0007e\u000b\t\"C\u0002\u0002\u0014\u0015\u0014AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011b]5{K2KW.\u001b;\u0016\u0005\u0005e\u0001c\u0001=\u0002\u001c%\u0019\u0011Q\u00042\u0003\u0007%sG/\u0001\u0006tSj,G*[7ji\u0002\nQ\u0002Z;sCRLwN\u001c'j[&$XCAA\u0013!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\t\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003_\u0011\u0017AC2p]\u000e,(O]3oi&!\u00111GA\u0015\u0005!!UO]1uS>t\u0017A\u00043ve\u0006$\u0018n\u001c8MS6LG\u000f\t\u000b\u0007\u0003s\ti$a\u0010\u0011\u0007\u0005m\u0012#D\u0001\u000e\u0011\u001d\t)B\u0006a\u0001\u00033Aq!!\t\u0017\u0001\u0004\t)#\u0001\u0003d_BLHCBA\u001d\u0003\u000b\n9\u0005C\u0005\u0002\u0016]\u0001\n\u00111\u0001\u0002\u001a!I\u0011\u0011E\f\u0011\u0002\u0003\u0007\u0011QE\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiE\u000b\u0003\u0002\u001a\u0005=3FAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m#-\u0001\u0006b]:|G/\u0019;j_:LA!a\u0018\u0002V\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\r\u0016\u0005\u0003K\ty%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty'!\u001e\u0011\u0007a\f\t(C\u0002\u0002t\t\u00141!\u00118z\u0011%\t9\bHA\u0001\u0002\u0004\tI\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003{\u0002b!a \u0002\u0006\u0006=TBAAA\u0015\r\t\u0019IY\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAD\u0003\u0003\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QRAJ!\rA\u0018qR\u0005\u0004\u0003#\u0013'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003or\u0012\u0011!a\u0001\u0003_\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019a0!'\t\u0013\u0005]t$!AA\u0002\u0005e\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005e\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003y\fa!Z9vC2\u001cH\u0003BAG\u0003OC\u0011\"a\u001e#\u0003\u0003\u0005\r!a\u001c\u0002\u001fMK'0Z!oI\u0012+(/\u0019;j_:\u00042!a\u000f%'\u0015!\u0013qVA^!)\t\t,a.\u0002\u001a\u0005\u0015\u0012\u0011H\u0007\u0003\u0003gS1!!.c\u0003\u001d\u0011XO\u001c;j[\u0016LA!!/\u00024\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fS1!!1A\u0003\tIw.\u0003\u0003\u0002\u0014\u0005}FCAAV\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tI$a3\u0002N\"9\u0011QC\u0014A\u0002\u0005e\u0001bBA\u0011O\u0001\u0007\u0011QE\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019.a8\u0011\u000ba\f).!7\n\u0007\u0005]'M\u0001\u0004PaRLwN\u001c\t\bq\u0006m\u0017\u0011DA\u0013\u0013\r\tiN\u0019\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005\u0005\b&!AA\u0002\u0005e\u0012a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\tA(\u0001\u0005eSN\f'\r\\3e)\u0011\ti)a;\t\u000f\u00055(\u00061\u0001\u0002p\u0006AA/\u001f9f\u001d\u0006lW\r\u0005\u0003\u0002r\u0006eh\u0002BAz\u0003k\u0004\"a\u00172\n\u0007\u0005](-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\tYPC\u0002\u0002x\n\fa\"\u001a<bYV\fG/\u001a'j[&$8\u000f\u0006\u0003\u0003\u0002\t\r\u0001\u0003B-d\u0003sAqA!\u0002,\u0001\u0004\u0011\t!\u0001\u0004mS6LGo]\u0001\fEVLG\u000e\u001a'j[&$8\u000f\u0006\u0003\u0003\u0002\t-\u0001b\u0002B\u0007Y\u0001\u0007!qB\u0001\fOV\f'\u000fZ\"p]\u001aLw\r\r\u0003\u0003\u0012\t\u0005\u0002C\u0002B\n\u00053\u0011i\"\u0004\u0002\u0003\u0016)\u0019!q\u0003!\u0002\tU$\u0018\u000e\\\u0005\u0005\u00057\u0011)B\u0001\u0003MSN$\b\u0003\u0002B\u0010\u0005Ca\u0001\u0001\u0002\u0007\u0003$\t-\u0011\u0011!A\u0001\u0006\u0003\u0011)CA\u0002`IM\nBAa\n\u0003.A\u0019\u0001P!\u000b\n\u0007\t-\"MA\u0004O_RD\u0017N\\4\u0011\t\t=\"QG\u0007\u0003\u0005cQ1Aa\rM\u0003\u0019\u0019wN\u001c4jO&!!q\u0007B\u0019\u0005\u0019\u0019uN\u001c4jO\u0006yq-^1sI2KW.\u001b;t?\u0012*\u0017\u000f\u0006\u0003\u0003>\t\r\u0003c\u0001=\u0003@%\u0019!\u0011\t2\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003o\u001a\u0011\u0011!a\u00011\u0006aq-^1sI2KW.\u001b;tAU\u0011\u0011QR\u0001\rI&\u001c\u0018M\u00197fI~#S-\u001d\u000b\u0005\u0005{\u0011i\u0005C\u0005\u0002x\u0019\t\t\u00111\u0001\u0002\u000e\u0006IA-[:bE2,G\rI\u0001\u0005S:LG\u000f\u0006\u0004\u0003>\tU#\u0011\u000e\u0005\b\u0005/B\u0001\u0019\u0001B-\u0003\t!7\u000f\u0005\u0003\u0003\\\t\u0015TB\u0001B/\u0015\u0011\u0011yF!\u0019\u0002\t\u0011\fG/\u0019\u0006\u0004\u0005GB\u0014\u0001C4f_R|w\u000e\\:\n\t\t\u001d$Q\f\u0002\n\t\u0006$\u0018m\u0015;pe\u0016DqAa\u001b\t\u0001\u0004\u0011i'A\u0002tMR\u0004BAa\u001c\u0003~5\u0011!\u0011\u000f\u0006\u0005\u0005g\u0012)(\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0005o\u0012I(A\u0004gK\u0006$XO]3\u000b\u0007\tm\u0004(A\u0004pa\u0016tw-[:\n\t\t}$\u0011\u000f\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017a\u0002:foJLG/\u001a\u000b\u0005\u0005{\u0011)\tC\u0004\u0003\b&\u0001\rA!#\u0002\u000bE,XM]=\u0011\t\tm#1R\u0005\u0005\u0005\u001b\u0013iFA\u0003Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0003\u0012\ne\u0005#\u0002=\u0002V\nM\u0005cA-\u0003\u0016&\u0019!qS3\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|g\u000eC\u0004\u0003\u001c*\u0001\rA!(\u0002\u0011M$(/\u0019;fOf\u0004BAa(\u0003,:!!\u0011\u0015BT\u001d\rQ'1U\u0005\u0004\u0005K\u0013\u0014aA1qS&\u0019\u0011M!+\u000b\u0007\t\u0015&'\u0003\u0003\u0003.\n=&!D)vKJL8\u000b\u001e:bi\u0016<\u0017PC\u0002b\u0005S\u000bQa\u00197pg\u0016$\"A!\u0010")
public class GraduatedQueryGuard
implements QueryInterceptor,
LazyLogging {
    private Seq<SizeAndDuration> guardLimits;
    private boolean disabled;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Seq<SizeAndDuration> buildLimits(List<? extends Config> guardConfig) {
        return GraduatedQueryGuard$.MODULE$.buildLimits(guardConfig);
    }

    public static String ConfigPath() {
        return GraduatedQueryGuard$.MODULE$.ConfigPath();
    }

    private Logger logger$lzycompute() {
        GraduatedQueryGuard graduatedQueryGuard = this;
        synchronized (graduatedQueryGuard) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Seq<SizeAndDuration> guardLimits() {
        return this.guardLimits;
    }

    private void guardLimits_$eq(Seq<SizeAndDuration> x$1) {
        this.guardLimits = x$1;
    }

    private boolean disabled() {
        return this.disabled;
    }

    private void disabled_$eq(boolean x$1) {
        this.disabled = x$1;
    }

    @Override
    public void init(DataStore ds, SimpleFeatureType sft) {
        BoxedUnit boxedUnit;
        this.disabled_$eq(GraduatedQueryGuard$.MODULE$.disabled(sft.getTypeName()));
        if (this.disabled()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("This guard is disabled for schema '{}' via system property", (Object)sft.getTypeName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.guardLimits_$eq(GraduatedQueryGuard$.MODULE$.buildLimits(ConfigFactory.load().getConfigList(new StringBuilder(1).append(GraduatedQueryGuard$.MODULE$.ConfigPath()).append(".").append(sft.getTypeName()).toString())));
        Predef$.MODULE$.require(this.guardLimits().nonEmpty());
    }

    @Override
    public void rewrite(Query query) {
    }

    @Override
    public Option<IllegalArgumentException> guard(package.QueryStrategy strategy) {
        Object object;
        if (this.disabled() || !(strategy.index() instanceof package.SpatioTemporalIndex)) {
            object = None$.MODULE$;
        } else {
            Some some;
            Tuple2 tuple2;
            Option values = strategy.values().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof package.SpatialIndexValues && A1 instanceof package.TemporalIndexValues) {
                        A1 A12 = A1;
                        return (B1)new Tuple2(((package.SpatialIndexValues)A12).spatialBounds(), ((package.TemporalIndexValues)A12).intervals());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof package.SpatialIndexValues && object instanceof package.TemporalIndexValues;
                }
            });
            Option option = values;
            if (None$.MODULE$.equals(option)) {
                object = new Some((Object)new StringBuilder(98).append("Query does not have a temporal filter. Maximum allowed filter duration for ").append("whole world queries is ").append(((SizeAndDuration)this.guardLimits().last()).durationLimit()).toString());
            } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Seq s = (Seq)tuple2._1();
                FilterValues i = (FilterValues)tuple2._2();
                double spatialExtent = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)s.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)GraduatedQueryGuard.$anonfun$guard$1(x0$1)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                SizeAndDuration limit = (SizeAndDuration)this.guardLimits().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GraduatedQueryGuard.$anonfun$guard$2(spatialExtent, x$2))).getOrElse((Function0 & Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Invalid extents/limits: {} / {}", new Object[]{s.mkString(", "), this.guardLimits().mkString(", ")});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (SizeAndDuration)this.guardLimits().last();
                });
                object = package$.MODULE$.validate((FilterValues<Bounds<ZonedDateTime>>)i, limit.durationLimit()) ? None$.MODULE$ : new Some((Object)new StringBuilder(61).append("Query exceeds maximum allowed filter duration of ").append(limit.durationLimit()).append(" at ").append(limit.sizeLimit()).append(" degrees").toString());
            } else {
                throw new MatchError((Object)option);
            }
        }
        None$ msg = object;
        return msg.map((Function1 & Serializable)m -> new IllegalArgumentException(new StringBuilder(2).append((String)m).append(": ").append(package$.MODULE$.filterString(strategy)).toString()));
    }

    @Override
    public void close() {
    }

    public static final /* synthetic */ double $anonfun$guard$1(Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 != null) {
            double lx = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double ly = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double ux = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double uy = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            return (ux - lx) * (uy - ly);
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$guard$2(double spatialExtent$1, SizeAndDuration x$2) {
        return (double)x$2.sizeLimit() >= spatialExtent$1;
    }

    public GraduatedQueryGuard() {
        QueryInterceptor.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.disabled = false;
    }

    public static class SizeAndDuration
    implements Product,
    Serializable {
        private final int sizeLimit;
        private final Duration durationLimit;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int sizeLimit() {
            return this.sizeLimit;
        }

        public Duration durationLimit() {
            return this.durationLimit;
        }

        public SizeAndDuration copy(int sizeLimit, Duration durationLimit) {
            return new SizeAndDuration(sizeLimit, durationLimit);
        }

        public int copy$default$1() {
            return this.sizeLimit();
        }

        public Duration copy$default$2() {
            return this.durationLimit();
        }

        public String productPrefix() {
            return "SizeAndDuration";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.sizeLimit());
                }
                case 1: {
                    return this.durationLimit();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SizeAndDuration;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "sizeLimit";
                }
                case 1: {
                    return "durationLimit";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.sizeLimit());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.durationLimit()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SizeAndDuration)) return false;
            boolean bl = true;
            if (!bl) return false;
            SizeAndDuration sizeAndDuration = (SizeAndDuration)x$1;
            if (this.sizeLimit() != sizeAndDuration.sizeLimit()) return false;
            Duration duration = this.durationLimit();
            Duration duration2 = sizeAndDuration.durationLimit();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!duration.equals(duration2)) return false;
            if (!sizeAndDuration.canEqual(this)) return false;
            return true;
        }

        public SizeAndDuration(int sizeLimit, Duration durationLimit) {
            this.sizeLimit = sizeLimit;
            this.durationLimit = durationLimit;
            Product.$init$((Product)this);
        }
    }
}

