/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.utils;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.SimpleFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.index.utils.SortingSimpleFeatureIterator;
import org.locationtech.geomesa.index.utils.SortingSimpleFeatureIterator$SizableFeatureIsSizable$;
import org.locationtech.geomesa.index.utils.SortingSimpleFeatureIterator$UnSizableFeatureIsSizable$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.Sizable;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class SortingSimpleFeatureIterator$
implements LazyLogging {
    public static final SortingSimpleFeatureIterator$ MODULE$ = new SortingSimpleFeatureIterator$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        SortingSimpleFeatureIterator$ sortingSimpleFeatureIterator$ = this;
        synchronized (sortingSimpleFeatureIterator$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public CloseableIterator<SimpleFeature> org$locationtech$geomesa$index$utils$SortingSimpleFeatureIterator$$sortInMemory(SimpleFeature head, CloseableIterator<SimpleFeature> tail, Ordering<SimpleFeature> ordering, AtomicBoolean closed) {
        ArrayList<Object> list = new ArrayList<Object>(100);
        list.add(head);
        while (tail.hasNext() && !closed.get()) {
            list.add(tail.next());
        }
        if (closed.get()) {
            return CloseableIterator$.MODULE$.apply(package$.MODULE$.Iterator().empty(), (Function0)(JFunction0.mcV.sp & Serializable)() -> tail.close());
        }
        list.sort((Comparator<Object>)ordering);
        return CloseableIterator$.MODULE$.apply((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(list.iterator()).asScala(), (Function0)(JFunction0.mcV.sp & Serializable)() -> tail.close());
    }

    public CloseableIterator<SimpleFeature> org$locationtech$geomesa$index$utils$SortingSimpleFeatureIterator$$sortWithSpillover(SimpleFeature head, CloseableIterator<SimpleFeature> tail, Ordering<SimpleFeature> ordering, AtomicBoolean closed, long threshold) {
        SortingSimpleFeatureIterator.FeatureIsSizable<SimpleFeature> featureIsSizable;
        LazyRef id$lzy = new LazyRef();
        LazyRef serializer$lzy = new LazyRef();
        SimpleFeature simpleFeature = head;
        if (simpleFeature instanceof Sizable) {
            featureIsSizable = SortingSimpleFeatureIterator$SizableFeatureIsSizable$.MODULE$;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(99).append("Feature class '").append(head.getClass().getName()).append("' doesn't implement Sizable - ").append("using estimated size for memory threshold calculations").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            featureIsSizable = SortingSimpleFeatureIterator$UnSizableFeatureIsSizable$.MODULE$;
        }
        SortingSimpleFeatureIterator$SizableFeatureIsSizable$ sizable = featureIsSizable;
        ArrayBuffer files = ArrayBuffer$.MODULE$.empty();
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>(100);
        list.add(head);
        long size = sizable.sizeOf(head);
        while (tail.hasNext() && !closed.get()) {
            if (size >= threshold) {
                BoxedUnit boxedUnit;
                list.sort((Comparator<SimpleFeature>)ordering);
                File file2 = Files.createTempFile(new StringBuilder(9).append("gm-sort-").append(SortingSimpleFeatureIterator$.id$1(id$lzy, head)).append("-").toString(), ".kryo", new FileAttribute[0]).toFile();
                files.$plus$eq((Object)file2);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Created temp sort file '{}'", (Object)file2.getAbsolutePath());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                package.WithClose$.MODULE$.apply((Object)new FileOutputStream(file2), (Function1 & Serializable)os -> {
                    SortingSimpleFeatureIterator$.$anonfun$sortWithSpillover$1(list, serializer$lzy, head, os);
                    return BoxedUnit.UNIT;
                }, IsCloseable$.MODULE$.closeableIsCloseable());
                list.clear();
                size = 0L;
            }
            SimpleFeature next = (SimpleFeature)tail.next();
            list.add(next);
            size += sizable.sizeOf(next);
        }
        if (closed.get()) {
            files.foreach((Function1 & Serializable)file -> {
                SortingSimpleFeatureIterator$.$anonfun$sortWithSpillover$2(file);
                return BoxedUnit.UNIT;
            });
            return CloseableIterator$.MODULE$.apply(package$.MODULE$.Iterator().empty(), (Function0)(JFunction0.mcV.sp & Serializable)() -> tail.close());
        }
        if (!list.isEmpty()) {
            list.sort((Comparator<SimpleFeature>)ordering);
        }
        if (files.isEmpty()) {
            return CloseableIterator$.MODULE$.apply((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(list.iterator()).asScala(), (Function0)(JFunction0.mcV.sp & Serializable)() -> tail.close());
        }
        return new SortingSimpleFeatureIterator.MergeSortingIterator((IndexedSeq<File>)files.toIndexedSeq(), (SimpleFeatureSerializer)SortingSimpleFeatureIterator$.serializer$1(serializer$lzy, head), (Iterator<SimpleFeature>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(list.iterator()).asScala()), tail, ordering);
    }

    private static final /* synthetic */ String id$lzycompute$1(LazyRef id$lzy$1, SimpleFeature head$1) {
        String string;
        LazyRef lazyRef = id$lzy$1;
        synchronized (lazyRef) {
            String string2;
            if (id$lzy$1.initialized()) {
                string2 = (String)id$lzy$1.value();
            } else {
                String name = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(head$1.getFeatureType().getTypeName().replaceAll("[^A-Za-z0-9_-]", "")), 20);
                string2 = (String)id$lzy$1.initialize((Object)StringOps$.MODULE$.format$extension("%s-%04d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(10000))})));
            }
            string = string2;
        }
        return string;
    }

    private static final String id$1(LazyRef id$lzy$1, SimpleFeature head$1) {
        if (id$lzy$1.initialized()) {
            return (String)id$lzy$1.value();
        }
        return SortingSimpleFeatureIterator$.id$lzycompute$1(id$lzy$1, head$1);
    }

    private static final /* synthetic */ KryoFeatureSerializer serializer$lzycompute$1(LazyRef serializer$lzy$1, SimpleFeature head$1) {
        KryoFeatureSerializer kryoFeatureSerializer;
        LazyRef lazyRef = serializer$lzy$1;
        synchronized (lazyRef) {
            kryoFeatureSerializer = serializer$lzy$1.initialized() ? (KryoFeatureSerializer)serializer$lzy$1.value() : (KryoFeatureSerializer)serializer$lzy$1.initialize((Object)KryoFeatureSerializer$.MODULE$.apply(head$1.getFeatureType(), SerializationOption.SerializationOptions$.MODULE$.withUserData()));
        }
        return kryoFeatureSerializer;
    }

    private static final KryoFeatureSerializer serializer$1(LazyRef serializer$lzy$1, SimpleFeature head$1) {
        if (serializer$lzy$1.initialized()) {
            return (KryoFeatureSerializer)serializer$lzy$1.value();
        }
        return SortingSimpleFeatureIterator$.serializer$lzycompute$1(serializer$lzy$1, head$1);
    }

    public static final /* synthetic */ void $anonfun$sortWithSpillover$1(ArrayList list$1, LazyRef serializer$lzy$1, SimpleFeature head$1, FileOutputStream os) {
        for (int i = 0; i < list$1.size(); ++i) {
            byte[] bytes = SortingSimpleFeatureIterator$.serializer$1(serializer$lzy$1, head$1).serialize((SimpleFeature)list$1.get(i));
            os.write(ByteArrays$.MODULE$.toBytes(bytes.length));
            os.write(bytes);
        }
    }

    public static final /* synthetic */ void $anonfun$sortWithSpillover$2(File file) {
        try {
            if (!file.delete()) {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn("Unable to delete tmp file '{}''", (Object)file.getAbsolutePath());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                file.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn(new StringBuilder(29).append("Unable to delete tmp file '").append(file.getAbsolutePath()).append("''").toString(), e);
                }
            }
            throw throwable;
        }
    }

    private SortingSimpleFeatureIterator$() {
    }
}

