/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.utils.bin;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BinSorter$
implements LazyLogging {
    public static final BinSorter$ MODULE$ = new BinSorter$();
    private static final int INSERTION_SORT_THRESHOLD;
    private static final ThreadLocal<byte[]> swapBuffers;
    private static final Ordering<Tuple2<byte[], Object>> priorityOrdering;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        INSERTION_SORT_THRESHOLD = 3;
        swapBuffers = new ThreadLocal<byte[]>(){

            public byte[] initialValue() {
                return (byte[])Array$.MODULE$.ofDim(24, (ClassTag)ClassTag$.MODULE$.Byte());
            }
        };
        priorityOrdering = new Ordering<Tuple2<byte[], Object>>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Tuple2<byte[], Object>> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public boolean isReverseOf(Ordering<?> other) {
                return Ordering.isReverseOf$((Ordering)this, other);
            }

            public <U> Ordering<U> on(Function1<U, Tuple2<byte[], Object>> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering<Tuple2<byte[], Object>> orElse(Ordering<Tuple2<byte[], Object>> other) {
                return Ordering.orElse$((Ordering)this, other);
            }

            public <S> Ordering<Tuple2<byte[], Object>> orElseBy(Function1<Tuple2<byte[], Object>, S> f, Ordering<S> ord) {
                return Ordering.orElseBy$((Ordering)this, f, ord);
            }

            public Ordering.OrderingOps mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(Tuple2<byte[], Object> x, Tuple2<byte[], Object> y) {
                return BinSorter$.MODULE$.compare((byte[])y._1(), y._2$mcI$sp(), (byte[])x._1(), x._2$mcI$sp());
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }

    private Logger logger$lzycompute() {
        BinSorter$ binSorter$ = this;
        synchronized (binSorter$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private int INSERTION_SORT_THRESHOLD() {
        return INSERTION_SORT_THRESHOLD;
    }

    private ThreadLocal<byte[]> swapBuffers() {
        return swapBuffers;
    }

    private Ordering<Tuple2<byte[], Object>> priorityOrdering() {
        return priorityOrdering;
    }

    public int compare(byte[] left, int leftOffset, byte[] right, int rightOffset) {
        return this.compareIntLittleEndian(left, leftOffset + 4, right, rightOffset + 4);
    }

    private int compareIntLittleEndian(byte[] left, int leftOffset, byte[] right, int rightOffset) {
        byte l3 = left[leftOffset + 3];
        byte r3 = right[rightOffset + 3];
        if (l3 < r3) {
            return -1;
        }
        if (l3 > r3) {
            return 1;
        }
        int l2 = left[leftOffset + 2] & 0xFF;
        int r2 = right[rightOffset + 2] & 0xFF;
        if (l2 < r2) {
            return -1;
        }
        if (l2 > r2) {
            return 1;
        }
        int l1 = left[leftOffset + 1] & 0xFF;
        int r1 = right[rightOffset + 1] & 0xFF;
        if (l1 < r1) {
            return -1;
        }
        if (l1 > r1) {
            return 1;
        }
        int l0 = left[leftOffset] & 0xFF;
        int r0 = right[rightOffset] & 0xFF;
        if (l0 == r0) {
            return 0;
        }
        if (l0 < r0) {
            return -1;
        }
        return 1;
    }

    public Iterator<Tuple2<byte[], Object>> mergeSort(Iterator<byte[]> aggregates, int binSize) {
        BoxedUnit boxedUnit;
        if (aggregates.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        PriorityQueue queue = new PriorityQueue(this.priorityOrdering());
        ArrayBuffer sizes = ArrayBuffer$.MODULE$.empty();
        while (aggregates.hasNext()) {
            byte[] next = (byte[])aggregates.next();
            sizes.append((Object)BoxesRunTime.boxToInteger((int)(next.length / binSize)));
            queue.enqueue((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)next, (Object)BoxesRunTime.boxToInteger((int)0))}));
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new java.lang.StringBuilder(81).append("Got back ").append(queue.length()).append(" aggregates with an average size of ").append(BoxesRunTime.unboxToInt((Object)sizes.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / sizes.length()).append(" chunks and a median size of ").append(((ArrayBuffer)sizes.sorted((Ordering)Ordering.Int$.MODULE$)).apply(sizes.length() / 2)).append(" chunks").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Iterator<Tuple2<byte[], Object>>(queue, binSize){
            private final PriorityQueue queue$1;
            private final int binSize$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Tuple2<byte[], Object>> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Tuple2<byte[], Object>> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Tuple2<byte[], Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Tuple2<byte[], Object>>, Iterator<Tuple2<byte[], Object>>> partition(Function1<Tuple2<byte[], Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<byte[], Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<byte[], Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Tuple2<byte[], Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Tuple2<byte[], Object>> filter(Function1<Tuple2<byte[], Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Tuple2<byte[], Object>> filterNot(Function1<Tuple2<byte[], Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Tuple2<byte[], Object>> filterImpl(Function1<Tuple2<byte[], Object>, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Tuple2<byte[], Object>> withFilter(Function1<Tuple2<byte[], Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<byte[], Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Tuple2<byte[], Object>> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<Tuple2<byte[], Object>> distinctBy(Function1<Tuple2<byte[], Object>, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<Tuple2<byte[], Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<byte[], Object>, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<Tuple2<byte[], Object>, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Tuple2<byte[], Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<byte[], Object>> takeWhile(Function1<Tuple2<byte[], Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Tuple2<byte[], Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<byte[], Object>> dropWhile(Function1<Tuple2<byte[], Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<byte[], Object>>, Iterator<Tuple2<byte[], Object>>> span(Function1<Tuple2<byte[], Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<byte[], Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<byte[], Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<Tuple2<byte[], Object>, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Tuple2<byte[], Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Tuple2<byte[], Object>>, Iterator<Tuple2<byte[], Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<Tuple2<byte[], Object>> tapEach(Function1<Tuple2<byte[], Object>, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Tuple2<byte[], Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<byte[], Object>>, Iterator<Tuple2<byte[], Object>>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Tuple2<byte[], Object>, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Tuple2<byte[], Object>, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Tuple2<byte[], Object>, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Tuple2<byte[], Object>, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Tuple2<byte[], Object>> find(Function1<Tuple2<byte[], Object>, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<byte[], Object>, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<byte[], Object>, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Tuple2<byte[], Object>, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Tuple2<byte[], Object>, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<byte[], Object>, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<byte[], Object>, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<byte[], Object>, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<byte[], Object>, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<byte[], Object>> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<byte[], Object>> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Tuple2<byte[], Object>> maxByOption(Function1<Tuple2<byte[], Object>, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<Tuple2<byte[], Object>> minByOption(Function1<Tuple2<byte[], Object>, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<byte[], Object>, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<byte[], Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Tuple2<byte[], Object>, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Tuple2<byte[], Object>, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Tuple2<byte[], Object>> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Tuple2<byte[], Object>> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Tuple2<byte[], Object>> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<Tuple2<byte[], Object>, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Tuple2<byte[], Object>> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Tuple2<byte[], Object>> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Tuple2<byte[], Object>> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Tuple2<byte[], Object>> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Tuple2<byte[], Object>, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public boolean hasNext() {
                return this.queue$1.nonEmpty();
            }

            public Tuple2<byte[], Object> next() {
                Tuple2 tuple2 = (Tuple2)this.queue$1.dequeue();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                byte[] aggregate = (byte[])tuple2._1();
                int offset = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)aggregate, (Object)BoxesRunTime.boxToInteger((int)offset));
                byte[] aggregate2 = (byte[])tuple22._1();
                int offset2 = tuple22._2$mcI$sp();
                if (offset2 < aggregate2.length - this.binSize$1) {
                    this.queue$1.enqueue((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)aggregate2, (Object)BoxesRunTime.boxToInteger((int)(offset2 + this.binSize$1)))}));
                }
                return new Tuple2((Object)aggregate2, (Object)BoxesRunTime.boxToInteger((int)offset2));
            }
            {
                this.queue$1 = queue$1;
                this.binSize$1 = binSize$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }
        };
    }

    public byte[] mergeSort(byte[] left, byte[] right, int binSize) {
        if (left.length == 0) {
            return right;
        }
        if (right.length == 0) {
            return left;
        }
        byte[] result = (byte[])Array$.MODULE$.ofDim(left.length + right.length, (ClassTag)ClassTag$.MODULE$.Byte());
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int leftIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int rightIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int resultIndex = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)leftIndex), (Object)BoxesRunTime.boxToInteger((int)rightIndex), (Object)BoxesRunTime.boxToInteger((int)resultIndex));
        int leftIndex2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int rightIndex2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int resultIndex2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        while (leftIndex2 < left.length && rightIndex2 < right.length) {
            if (this.compare(left, leftIndex2, right, rightIndex2) > 0) {
                System.arraycopy(right, rightIndex2, result, resultIndex2, binSize);
                rightIndex2 += binSize;
            } else {
                System.arraycopy(left, leftIndex2, result, resultIndex2, binSize);
                leftIndex2 += binSize;
            }
            resultIndex2 += binSize;
        }
        while (leftIndex2 < left.length) {
            System.arraycopy(left, leftIndex2, result, resultIndex2, binSize);
            leftIndex2 += binSize;
            resultIndex2 += binSize;
        }
        while (rightIndex2 < right.length) {
            System.arraycopy(right, rightIndex2, result, resultIndex2, binSize);
            rightIndex2 += binSize;
            resultIndex2 += binSize;
        }
        return result;
    }

    public void quickSort(byte[] bytes, int left, int right, int binSize) {
        this.quickSort(bytes, left, right, binSize, true);
    }

    public void quickSort(byte[] bytes, int left, int right, int binSize, boolean leftmost) {
        while (true) {
            int length;
            if ((length = (right + binSize - left) / binSize) < this.INSERTION_SORT_THRESHOLD()) {
                if (leftmost) {
                    for (int i = left + binSize; i <= right; i += binSize) {
                        int j;
                        byte[] ai = this.getThreadLocalChunk(bytes, i, binSize);
                        for (j = i; j > left && this.compare(bytes, j - binSize, ai, 0) > 0; j -= binSize) {
                            System.arraycopy(bytes, j - binSize, bytes, j, binSize);
                        }
                        if (j == i) continue;
                        System.arraycopy(ai, 0, bytes, j, binSize);
                    }
                } else {
                    int i = left;
                    do {
                        if (i < right) continue;
                        return;
                    } while (this.compare(bytes, i += binSize, bytes, i - binSize) >= 0);
                    byte[] a1 = (byte[])Array$.MODULE$.ofDim(binSize, (ClassTag)ClassTag$.MODULE$.Byte());
                    byte[] a2 = (byte[])Array$.MODULE$.ofDim(binSize, (ClassTag)ClassTag$.MODULE$.Byte());
                    int k = i;
                    while ((i += binSize) <= right) {
                        if (this.compare(bytes, k, bytes, i) < 0) {
                            System.arraycopy(bytes, k, a2, 0, binSize);
                            System.arraycopy(bytes, i, a1, 0, binSize);
                        } else {
                            System.arraycopy(bytes, k, a1, 0, binSize);
                            System.arraycopy(bytes, i, a2, 0, binSize);
                        }
                        while (this.compare(a1, 0, bytes, k -= binSize) < 0) {
                            System.arraycopy(bytes, k, bytes, k + 2 * binSize, binSize);
                        }
                        System.arraycopy(a1, 0, bytes, (k += binSize) + binSize, binSize);
                        while (this.compare(a2, 0, bytes, k -= binSize) < 0) {
                            System.arraycopy(bytes, k, bytes, k + binSize, binSize);
                        }
                        System.arraycopy(a2, 0, bytes, k + binSize, binSize);
                        k = i += binSize;
                    }
                    int j = right;
                    byte[] last = this.getThreadLocalChunk(bytes, j, binSize);
                    while (this.compare(last, 0, bytes, j -= binSize) < 0) {
                        System.arraycopy(bytes, j, bytes, j + binSize, binSize);
                    }
                    System.arraycopy(last, 0, bytes, j + binSize, binSize);
                }
                return;
            }
            int seventh = length / 7 * binSize;
            int e3 = (left + right) / binSize / 2 * binSize;
            int e2 = e3 - seventh;
            int e1 = e2 - seventh;
            int e4 = e3 + seventh;
            int e5 = e4 + seventh;
            if (this.compare(bytes, e2, bytes, e1) < 0) {
                this.swap$1(e2, e1, bytes, binSize);
            }
            if (this.compare(bytes, e3, bytes, e2) < 0) {
                this.swap$1(e3, e2, bytes, binSize);
                if (this.compare(bytes, e2, bytes, e1) < 0) {
                    this.swap$1(e2, e1, bytes, binSize);
                }
            }
            if (this.compare(bytes, e4, bytes, e3) < 0) {
                this.swap$1(e4, e3, bytes, binSize);
                if (this.compare(bytes, e3, bytes, e2) < 0) {
                    this.swap$1(e3, e2, bytes, binSize);
                    if (this.compare(bytes, e2, bytes, e1) < 0) {
                        this.swap$1(e2, e1, bytes, binSize);
                    }
                }
            }
            if (this.compare(bytes, e5, bytes, e4) < 0) {
                this.swap$1(e5, e4, bytes, binSize);
                if (this.compare(bytes, e4, bytes, e3) < 0) {
                    this.swap$1(e4, e3, bytes, binSize);
                    if (this.compare(bytes, e3, bytes, e2) < 0) {
                        this.swap$1(e3, e2, bytes, binSize);
                        if (this.compare(bytes, e2, bytes, e1) < 0) {
                            this.swap$1(e2, e1, bytes, binSize);
                        }
                    }
                }
            }
            int less2 = left;
            int great = right;
            if (this.compare(bytes, e1, bytes, e2) != 0 && this.compare(bytes, e2, bytes, e3) != 0 && this.compare(bytes, e3, bytes, e4) != 0 && this.compare(bytes, e4, bytes, e5) != 0) {
                byte[] pivot1 = (byte[])Array$.MODULE$.ofDim(binSize, (ClassTag)ClassTag$.MODULE$.Byte());
                System.arraycopy(bytes, e2, pivot1, 0, binSize);
                byte[] pivot2 = (byte[])Array$.MODULE$.ofDim(binSize, (ClassTag)ClassTag$.MODULE$.Byte());
                System.arraycopy(bytes, e4, pivot2, 0, binSize);
                System.arraycopy(bytes, left, bytes, e2, binSize);
                System.arraycopy(bytes, right, bytes, e4, binSize);
                while (this.compare(bytes, less2 += binSize, pivot1, 0) < 0) {
                }
                while (this.compare(bytes, great -= binSize, pivot2, 0) > 0) {
                }
                int k = less2 - binSize;
                boolean loop = true;
                while (loop && (k += binSize) <= great) {
                    byte[] ak = this.getThreadLocalChunk(bytes, k, binSize);
                    if (this.compare(ak, 0, pivot1, 0) < 0) {
                        System.arraycopy(bytes, less2, bytes, k, binSize);
                        System.arraycopy(ak, 0, bytes, less2, binSize);
                        less2 += binSize;
                        continue;
                    }
                    if (this.compare(ak, 0, pivot2, 0) <= 0) continue;
                    while (loop && this.compare(bytes, great, pivot2, 0) > 0) {
                        if (great == k) {
                            loop = false;
                        }
                        great -= binSize;
                    }
                    if (!loop) continue;
                    if (this.compare(bytes, great, pivot1, 0) < 0) {
                        System.arraycopy(bytes, less2, bytes, k, binSize);
                        System.arraycopy(bytes, great, bytes, less2, binSize);
                        less2 += binSize;
                    } else {
                        System.arraycopy(bytes, great, bytes, k, binSize);
                    }
                    System.arraycopy(ak, 0, bytes, great, binSize);
                    great -= binSize;
                }
                System.arraycopy(bytes, less2 - binSize, bytes, left, binSize);
                System.arraycopy(pivot1, 0, bytes, less2 - binSize, binSize);
                System.arraycopy(bytes, great + binSize, bytes, right, binSize);
                System.arraycopy(pivot2, 0, bytes, great + binSize, binSize);
                this.quickSort(bytes, left, less2 - 2 * binSize, binSize, leftmost);
                this.quickSort(bytes, great + 2 * binSize, right, binSize, false);
                if (less2 < e1 && e5 < great) {
                    while (this.compare(bytes, less2, pivot1, 0) == 0) {
                        less2 += binSize;
                    }
                    while (this.compare(bytes, great, pivot2, 0) == 0) {
                        great -= binSize;
                    }
                    int k2 = less2 - binSize;
                    loop = true;
                    while (loop && (k2 += binSize) <= great) {
                        byte[] ak = this.getThreadLocalChunk(bytes, k2, binSize);
                        if (this.compare(ak, 0, pivot1, 0) == 0) {
                            System.arraycopy(bytes, less2, bytes, k2, binSize);
                            System.arraycopy(ak, 0, bytes, less2, binSize);
                            less2 += binSize;
                            continue;
                        }
                        if (this.compare(ak, 0, pivot2, 0) != 0) continue;
                        while (loop && this.compare(bytes, great, pivot2, 0) == 0) {
                            if (great == k2) {
                                loop = false;
                            }
                            great -= binSize;
                        }
                        if (!loop) continue;
                        if (this.compare(bytes, great, pivot1, 0) == 0) {
                            System.arraycopy(bytes, less2, bytes, k2, binSize);
                            System.arraycopy(bytes, great, bytes, less2, binSize);
                            less2 += binSize;
                        } else {
                            System.arraycopy(bytes, great, bytes, k2, binSize);
                        }
                        System.arraycopy(ak, 0, bytes, great, binSize);
                        great -= binSize;
                    }
                }
                leftmost = false;
                right = great;
                left = less2;
                continue;
            }
            byte[] pivot = (byte[])Array$.MODULE$.ofDim(binSize, (ClassTag)ClassTag$.MODULE$.Byte());
            System.arraycopy(bytes, e3, pivot, 0, binSize);
            boolean loop = true;
            for (int k = less2; loop && k <= great; k += binSize) {
                int comp = this.compare(bytes, k, pivot, 0);
                if (comp == 0) continue;
                byte[] ak = this.getThreadLocalChunk(bytes, k, binSize);
                if (comp < 0) {
                    System.arraycopy(bytes, less2, bytes, k, binSize);
                    System.arraycopy(ak, 0, bytes, less2, binSize);
                    less2 += binSize;
                    continue;
                }
                while (loop && this.compare(bytes, great, pivot, 0) > 0) {
                    if (k == great) {
                        loop = false;
                    }
                    great -= binSize;
                }
                if (!loop) continue;
                if (this.compare(bytes, great, pivot, 0) < 0) {
                    System.arraycopy(bytes, less2, bytes, k, binSize);
                    System.arraycopy(bytes, great, bytes, less2, binSize);
                    less2 += binSize;
                } else {
                    System.arraycopy(bytes, great, bytes, k, binSize);
                }
                System.arraycopy(ak, 0, bytes, great, binSize);
                great -= binSize;
            }
            this.quickSort(bytes, left, less2 - binSize, binSize, leftmost);
            int n = great + binSize;
            leftmost = false;
            left = n;
        }
    }

    private byte[] getThreadLocalChunk(byte[] bytes, int offset, int binSize) {
        byte[] chunk = this.swapBuffers().get();
        System.arraycopy(bytes, offset, chunk, 0, binSize);
        return chunk;
    }

    private final void swap$1(int left, int right, byte[] bytes$1, int binSize$2) {
        byte[] chunk = this.getThreadLocalChunk(bytes$1, left, binSize$2);
        System.arraycopy(bytes$1, right, bytes$1, left, binSize$2);
        System.arraycopy(chunk, 0, bytes$1, right, binSize$2);
    }

    private BinSorter$() {
    }
}

