/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.view;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.iterators.ArrowScan;
import org.locationtech.geomesa.index.iterators.ArrowScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$StatsReducer$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.QueryInterceptor$QueryInterceptorFactory$;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.view.package$;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator$;
import org.locationtech.geomesa.utils.iterators.SortedMergeIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%h\u0001\u0002\u0017.\u0001aB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\tM\u0002\u0011\t\u0011)A\u0005O\"Q!Q\u0006\u0001\u0003\u0002\u0003\u0006I!a2\t\u0015\t=\u0002A!A!\u0002\u0013\t9\r\u0003\u0004{\u0001\u0011\u0005!\u0011\u0007\u0005\n\u0005{\u0001!\u0019!C)\u0005\u007fA\u0001Ba\u0015\u0001A\u0003%!\u0011\t\u0005\b\u0005+\u0002A\u0011\tB,\u0011!\u0011y\b\u0001C)c\t\u0005\u0005b\u0002BD\u0001\u0011%!\u0011\u0012\u0005\b\u0005;\u0003A\u0011\u0002BP\u0011\u001d\u0011i\f\u0001C\u0005\u0005\u007fCqAa2\u0001\t\u0013\u0011I\r\u0003\u0005\u0003R\u0002!\t&\rBj\u0011\u001d\u0011I\u000e\u0001C\u0005\u00057<QA^\u0017\t\u0002]4Q\u0001L\u0017\t\u0002eDQA_\t\u0005\u0002m4q\u0001`\t\u0011\u0002G\u0005Q\u0010C\u0003\u007f'\u0019\u0005qP\u0002\u0004\u0002@E\u0001\u0015\u0011\t\u0005\n\u001fV\u0011)\u001a!C\u0001\u0003'B!\"a\u0017\u0016\u0005#\u0005\u000b\u0011BA+\u0011\u0019QX\u0003\"\u0001\u0002^!1a0\u0006C!\u0003GB\u0011\"!\u001b\u0016\u0003\u0003%\t!a\u001b\t\u0013\u0005=T#%A\u0005\u0002\u0005E\u0004\"CAD+\u0005\u0005I\u0011IAE\u0011%\tY*FA\u0001\n\u0003\ti\nC\u0005\u0002&V\t\t\u0011\"\u0001\u0002(\"I\u00111W\u000b\u0002\u0002\u0013\u0005\u0013Q\u0017\u0005\n\u0003\u0007,\u0012\u0011!C\u0001\u0003\u000bD\u0011\"a4\u0016\u0003\u0003%\t%!5\t\u0013\u0005UW#!A\u0005B\u0005]\u0007\"CAm+\u0005\u0005I\u0011IAn\u0011%\ti.FA\u0001\n\u0003\nynB\u0005\u0002dF\t\t\u0011#\u0001\u0002f\u001aI\u0011qH\t\u0002\u0002#\u0005\u0011q\u001d\u0005\u0007u\u001a\"\t!a@\t\u0013\u0005eg%!A\u0005F\u0005m\u0007\"\u0003B\u0001M\u0005\u0005I\u0011\u0011B\u0002\u0011%\u00119AJA\u0001\n\u0003\u0013I\u0001C\u0005\u0003\u0016\u0019\n\t\u0011\"\u0003\u0003\u0018\t\tR*\u001a:hK\u0012\fV/\u001a:z%Vtg.\u001a:\u000b\u00059z\u0013\u0001\u0002<jK^T!\u0001M\u0019\u0002\u000b%tG-\u001a=\u000b\u0005I\u001a\u0014aB4f_6,7/\u0019\u0006\u0003iU\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011AN\u0001\u0004_J<7\u0001A\n\u0005\u0001ezT\t\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005>\n\u0001\u0002\u001d7b]:LgnZ\u0005\u0003\t\u0006\u00131\"U;fef\u0014VO\u001c8feB\u0011a)T\u0007\u0002\u000f*\u0011\u0001*S\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u0015.\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0019\u0006\u00191m\\7\n\u00059;%a\u0003'bufdunZ4j]\u001e\f!\u0001Z:\u0011\u0005E\u001bgB\u0001*a\u001d\t\u0019fL\u0004\u0002U;:\u0011Q\u000b\u0018\b\u0003-ns!a\u0016.\u000e\u0003aS!!W\u001c\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014B\u0001\u001b6\u0013\t\u00114'\u0003\u00021c%\u0011qlL\u0001\u0006gR\fGo]\u0005\u0003C\n\fq\u0001]1dW\u0006<WM\u0003\u0002`_%\u0011A-\u001a\u0002\u0010\u0011\u0006\u001cx)Z8NKN\f7\u000b^1ug*\u0011\u0011MY\u0001\u0007gR|'/Z:\u0011\u0007!dwN\u0004\u0002jW:\u0011qK[\u0005\u0002y%\u0011\u0011mO\u0005\u0003[:\u00141aU3r\u0015\t\t7\bE\u0003;aJ\u0014y\"\u0003\u0002rw\t1A+\u001e9mKJ\u0002\"a]\n\u000f\u0005Q\u0004bBA*v\u0013\tqs&A\tNKJ<W\rZ)vKJL(+\u001e8oKJ\u0004\"\u0001_\t\u000e\u00035\u001a\"!E\u001d\u0002\rqJg.\u001b;?)\u00059(!C)vKJL\u0018M\u00197f'\t\u0019\u0012(\u0001\thKR4U-\u0019;ve\u0016\u0014V-\u00193feR1\u0011\u0011AA\u0016\u0003k\u0001\u0002\"a\u0001\u0002\u000e\u0005E\u0011QE\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!A-\u0019;b\u0015\r\tY!N\u0001\tO\u0016|Go\\8mg&!\u0011qBA\u0003\u000551U-\u0019;ve\u0016\u0014V-\u00193feB!\u00111CA\u0011\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011AB:j[BdWM\u0003\u0003\u0002\u001c\u0005u\u0011a\u00024fCR,(/\u001a\u0006\u0004\u0003?)\u0014aB8qK:<\u0017n]\u0005\u0005\u0003G\t)BA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\u0004B!a\u0005\u0002(%!\u0011\u0011FA\u000b\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"9\u0011Q\u0006\u000bA\u0002\u0005=\u0012!A9\u0011\t\u0005\r\u0011\u0011G\u0005\u0005\u0003g\t)AA\u0003Rk\u0016\u0014\u0018\u0010C\u0004\u00028Q\u0001\r!!\u000f\u0002\u0003Q\u0004B!a\u0001\u0002<%!\u0011QHA\u0003\u0005-!&/\u00198tC\u000e$\u0018n\u001c8\u0003%\u0011\u000bG/Y*u_J,\u0017+^3ss\u0006\u0014G.Z\n\t+e\n\u0019%a\u0012\u0002NA\u0019\u0011QI\n\u000e\u0003E\u00012AOA%\u0013\r\tYe\u000f\u0002\b!J|G-^2u!\rA\u0017qJ\u0005\u0004\u0003#r'\u0001D*fe&\fG.\u001b>bE2,WCAA+!\u0011\t\u0019!a\u0016\n\t\u0005e\u0013Q\u0001\u0002\n\t\u0006$\u0018m\u0015;pe\u0016\f1\u0001Z:!)\u0011\ty&!\u0019\u0011\u0007\u0005\u0015S\u0003\u0003\u0004P1\u0001\u0007\u0011Q\u000b\u000b\u0007\u0003\u0003\t)'a\u001a\t\u000f\u00055\u0012\u00041\u0001\u00020!9\u0011qG\rA\u0002\u0005e\u0012\u0001B2paf$B!a\u0018\u0002n!AqJ\u0007I\u0001\u0002\u0004\t)&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M$\u0006BA+\u0003kZ#!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003[\u0014AC1o]>$\u0018\r^5p]&!\u0011QQA>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0005\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0006!!.\u0019<b\u0013\u0011\tI*a$\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\nE\u0002;\u0003CK1!a)<\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI+a,\u0011\u0007i\nY+C\u0002\u0002.n\u00121!\u00118z\u0011%\t\tLHA\u0001\u0002\u0004\ty*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0003b!!/\u0002@\u0006%VBAA^\u0015\r\tilO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAa\u0003w\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qYAg!\rQ\u0014\u0011Z\u0005\u0004\u0003\u0017\\$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003c\u0003\u0013\u0011!a\u0001\u0003S\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111RAj\u0011%\t\t,IA\u0001\u0002\u0004\ty*\u0001\u0005iCND7i\u001c3f)\t\ty*\u0001\u0005u_N#(/\u001b8h)\t\tY)\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\f\t\u000fC\u0005\u00022\u0012\n\t\u00111\u0001\u0002*\u0006\u0011B)\u0019;b'R|'/Z)vKJL\u0018M\u00197f!\r\t)EJ\n\u0006M\u0005%\u0018Q\u001f\t\t\u0003W\f\t0!\u0016\u0002`5\u0011\u0011Q\u001e\u0006\u0004\u0003_\\\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003g\fiOA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!a>\u0002~6\u0011\u0011\u0011 \u0006\u0005\u0003w\f\u0019*\u0001\u0002j_&!\u0011\u0011KA})\t\t)/A\u0003baBd\u0017\u0010\u0006\u0003\u0002`\t\u0015\u0001BB(*\u0001\u0004\t)&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t-!\u0011\u0003\t\u0006u\t5\u0011QK\u0005\u0004\u0005\u001fY$AB(qi&|g\u000eC\u0005\u0003\u0014)\n\t\u00111\u0001\u0002`\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\te\u0001\u0003BAG\u00057IAA!\b\u0002\u0010\n1qJ\u00196fGR\u0004RA\u000fB\u0007\u0005C\u0001BAa\t\u0003*5\u0011!Q\u0005\u0006\u0005\u0005O\ti\"\u0001\u0004gS2$XM]\u0005\u0005\u0005W\u0011)C\u0001\u0004GS2$XM]\u0001\fI\u0016$W\u000f\u001d7jG\u0006$X-\u0001\u0005qCJ\fG\u000e\\3m))\u0011\u0019D!\u000e\u00038\te\"1\b\t\u0003q\u0002AQaT\u0003A\u0002ACQAZ\u0003A\u0002\u001dDqA!\f\u0006\u0001\u0004\t9\rC\u0004\u00030\u0015\u0001\r!a2\u0002\u0019%tG/\u001a:dKB$xN]:\u0016\u0005\t\u0005\u0003\u0003\u0002B\"\u0005\u001brAA!\u0012\u0003J9\u00191Ka\u0012\n\u0005\t{\u0013b\u0001B&\u0003\u0006\u0001\u0012+^3ss&sG/\u001a:dKB$xN]\u0005\u0005\u0005\u001f\u0012\tFA\fRk\u0016\u0014\u00180\u00138uKJ\u001cW\r\u001d;pe\u001a\u000b7\r^8ss*\u0019!1J!\u0002\u001b%tG/\u001a:dKB$xN]:!\u0003!\u0011XO\\)vKJLH\u0003\u0003B-\u0005O\u0012YGa\u001c\u0011\t\tm#\u0011\r\b\u0005\u0005\u000b\u0012i&C\u0002\u0003`\u0005\u000b1\"U;fef\u0014VO\u001c8fe&!!1\rB3\u0005-\tV/\u001a:z%\u0016\u001cX\u000f\u001c;\u000b\u0007\t}\u0013\tC\u0004\u0003j!\u0001\r!!\u0005\u0002\u0007M4G\u000fC\u0004\u0003n!\u0001\r!a\f\u0002\u0011=\u0014\u0018nZ5oC2D\u0011B!\u001d\t!\u0003\u0005\rAa\u001d\u0002\u000f\u0015D\b\u000f\\1j]B!!Q\u000fB>\u001b\t\u00119HC\u0002\u0003z=\nQ!\u001e;jYNLAA! \u0003x\tIQ\t\u001f9mC&tWM]\u0001\u000fG>tg-[4ve\u0016\fV/\u001a:z)\u0019\tyCa!\u0003\u0006\"9!\u0011N\u0005A\u0002\u0005E\u0001b\u0002B7\u0013\u0001\u0007\u0011qF\u0001\u000bCJ\u0014xn^)vKJLHC\u0002BF\u0005/\u0013I\n\u0005\u0004\u0003\u000e\nM\u0015QE\u0007\u0003\u0005\u001fSA!!0\u0003\u0012*\u0019!\u0011P\u0019\n\t\tU%q\u0012\u0002\u0012\u00072|7/Z1cY\u0016LE/\u001a:bi>\u0014\bb\u0002B5\u0015\u0001\u0007\u0011\u0011\u0003\u0005\b\u00057S\u0001\u0019AA\u0018\u0003\u0015\tX/\u001a:z\u00031!WM\\:jif\fV/\u001a:z)!\u0011YI!)\u0003$\n%\u0006b\u0002B5\u0017\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005K[\u0001\u0019\u0001BT\u0003\u001d\u0011X-\u00193feN\u0004B\u0001\u001b7\u0002\u0002!9!1V\u0006A\u0002\t5\u0016!\u00025j]R\u001c\b\u0003\u0002BX\u0005sk!A!-\u000b\t\tM&QW\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\u00119,!\u0003\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005w\u0013\tLA\u0003IS:$8/\u0001\u0006ti\u0006$8/U;fef$\u0002Ba#\u0003B\n\r'Q\u0019\u0005\b\u0005Sb\u0001\u0019AA\t\u0011\u001d\u0011)\u000b\u0004a\u0001\u0005OCqAa+\r\u0001\u0004\u0011i+\u0001\u0005cS:\fV/\u001a:z)!\u0011YIa3\u0003N\n=\u0007b\u0002B5\u001b\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005Kk\u0001\u0019\u0001BT\u0011\u001d\u0011Y+\u0004a\u0001\u0005[\u000bAbZ3u%\u0016$XO\u001d8TMR$b!!\u0005\u0003V\n]\u0007b\u0002B5\u001d\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005Ws\u0001\u0019\u0001BW\u00039!w\u000eU1sC2dW\r\\*dC:$bAa#\u0003^\n}\u0007b\u0002BS\u001f\u0001\u0007!q\u0015\u0005\b\u0005C|\u0001\u0019\u0001Br\u0003\u0019\u0019\u0018N\\4mKB9!H!:\u0002\u0002\t-\u0015b\u0001Btw\tIa)\u001e8di&|g.\r")
public class MergedQueryRunner
implements QueryRunner,
LazyLogging {
    private final Seq<Tuple2<Queryable, Option<Filter>>> stores;
    private final boolean deduplicate;
    private final boolean parallel;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Explainer runQuery$default$3() {
        return QueryRunner.runQuery$default$3$(this);
    }

    private Logger logger$lzycompute() {
        MergedQueryRunner mergedQueryRunner = this;
        synchronized (mergedQueryRunner) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    @Override
    public QueryRunner.QueryResult runQuery(SimpleFeatureType sft, Query original, Explainer explain) {
        Query query = this.configureQuery(sft, original);
        Hints hints = query.getHints();
        None$ maxFeatures = query.isMaxFeaturesUnlimited() ? None$.MODULE$ : Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)query.getMaxFeatures()));
        Object object = QueryHints$.MODULE$.RichHints(hints).isStatsQuery() || QueryHints$.MODULE$.RichHints(hints).isArrowQuery() ? hints.put((Object)QueryHints$Internal$.MODULE$.SKIP_REDUCE(), (Object)Boolean.TRUE) : BoxedUnit.UNIT;
        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            return new QueryRunner.QueryResult(org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft(), hints, (Function0<CloseableIterator<SimpleFeature>>)(Function0 & Serializable)() -> this.arrowQuery(sft, query));
        }
        LazyRef readers$lzy = new LazyRef();
        if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
            return new QueryRunner.QueryResult(DensityScan$.MODULE$.DensitySft(), hints, (Function0<CloseableIterator<SimpleFeature>>)(Function0 & Serializable)() -> this.densityQuery(sft, (Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)this.readers$1(readers$lzy, sft, query), hints));
        }
        if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
            return new QueryRunner.QueryResult(StatsScan$.MODULE$.StatsSft(), hints, (Function0<CloseableIterator<SimpleFeature>>)(Function0 & Serializable)() -> this.statsQuery(sft, (Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)this.readers$1(readers$lzy, sft, query), hints));
        }
        if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            BoxedUnit boxedUnit;
            if (query.getSortBy() != null && !ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])query.getSortBy()))) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Ignoring sort for BIN query");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new QueryRunner.QueryResult(BinaryOutputEncoder$.MODULE$.BinEncodedSft(), hints, (Function0<CloseableIterator<SimpleFeature>>)(Function0 & Serializable)() -> this.binQuery(sft, (Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)this.readers$1(readers$lzy, sft, query), hints));
        }
        SimpleFeatureType resultSft = (SimpleFeatureType)QueryPlanner$.MODULE$.extractQueryTransforms(sft, query).map((Function1 & Serializable)x$1 -> (SimpleFeatureType)x$1._1()).getOrElse((Function0 & Serializable)() -> sft);
        return new QueryRunner.QueryResult(resultSft, hints, (Function0<CloseableIterator<SimpleFeature>>)((Function0 & Serializable)() -> MergedQueryRunner.$anonfun$runQuery$13(this, query, resultSft, (Option)maxFeatures, readers$lzy, sft)));
    }

    @Override
    public Query configureQuery(SimpleFeatureType sft, Query original) {
        Query query = new Query(original);
        QueryPlanner$.MODULE$.getPerThreadQueryHints().foreach((Function1 & Serializable)hints -> {
            MergedQueryRunner.$anonfun$configureQuery$1(query, hints);
            return BoxedUnit.UNIT;
        });
        ViewParams$.MODULE$.setHints(query);
        return query;
    }

    private CloseableIterator<SimpleFeature> arrowQuery(SimpleFeatureType sft, Query query) {
        Hints hints = query.getHints();
        QueryPlanner$.MODULE$.setQuerySort(sft, query);
        SimpleFeatureType arrowSft = (SimpleFeatureType)QueryPlanner$.MODULE$.extractQueryTransforms(sft, query).map((Function1 & Serializable)x$4 -> (SimpleFeatureType)x$4._1()).getOrElse((Function0 & Serializable)() -> sft);
        Option<Tuple2<String, Object>> sort = QueryHints$.MODULE$.RichHints(hints).getArrowSort();
        int batchSize = ArrowScan$.MODULE$.getBatchSize(hints);
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid(), QueryHints$.MODULE$.RichHints(hints).isArrowProxyFid());
        IpcOption ipcOpts = package.FormatVersion$.MODULE$.options((String)QueryHints$.MODULE$.RichHints(hints).getArrowFormatVersion().getOrElse((Function0 & Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get()));
        Seq<String> dictionaryFields = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields();
        boolean process = QueryHints$.MODULE$.RichHints(hints).isArrowProcessDeltas();
        ArrowScan.DeltaReducer reduce = new ArrowScan.DeltaReducer(arrowSft, dictionaryFields, encoding, ipcOpts, batchSize, sort, false, process);
        Seq readers = (Seq)this.stores.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Queryable store = (Queryable)tuple2._1();
                Option filter = (Option)tuple2._2();
                return store.getFeatureReader(package$.MODULE$.mergeFilter(sft, new Query(query), (Option<Filter>)filter), Transaction.AUTO_COMMIT);
            }
            throw new MatchError((Object)tuple2);
        });
        return reduce.apply(this.doParallelScan((Seq<FeatureReader<SimpleFeatureType, SimpleFeature>>)readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable)reader -> MergedQueryRunner.getSingle$1(reader, sft, hints)));
    }

    private CloseableIterator<SimpleFeature> densityQuery(SimpleFeatureType sft, Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Hints hints) {
        return this.doParallelScan(readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable)reader -> MergedQueryRunner.getSingle$2(reader, sft, hints));
    }

    private CloseableIterator<SimpleFeature> statsQuery(SimpleFeatureType sft, Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Hints hints) {
        CloseableIterator<SimpleFeature> results = this.doParallelScan(readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable)reader -> MergedQueryRunner.getSingle$3(reader, sft, hints));
        return StatsScan$StatsReducer$.MODULE$.apply(sft, hints).apply(results);
    }

    private CloseableIterator<SimpleFeature> binQuery(SimpleFeatureType sft, Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Hints hints) {
        return this.doParallelScan(readers, (Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>>)(Function1 & Serializable)reader -> MergedQueryRunner.getSingle$4(reader, sft, hints));
    }

    @Override
    public SimpleFeatureType getReturnSft(SimpleFeatureType sft, Hints hints) {
        if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            return BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        }
        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            return org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft();
        }
        if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
            return DensityScan$.MODULE$.DensitySft();
        }
        if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
            return StatsScan$.MODULE$.StatsSft();
        }
        return QueryRunner.getReturnSft$(this, sft, hints);
    }

    private CloseableIterator<SimpleFeature> doParallelScan(Seq<FeatureReader<SimpleFeatureType, SimpleFeature>> readers, Function1<FeatureReader<SimpleFeatureType, SimpleFeature>, CloseableIterator<SimpleFeature>> single) {
        if (this.parallel) {
            return SelfClosingIterator$.MODULE$.apply(readers.toList().map(single).iterator(), (Function0)(JFunction0.mcV.sp & Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable)i -> i);
        }
        return SelfClosingIterator$.MODULE$.apply(readers.iterator(), (Function0)(JFunction0.mcV.sp & Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap(single);
    }

    private final /* synthetic */ Seq readers$lzycompute$1(LazyRef readers$lzy$1, SimpleFeatureType sft$1, Query query$1) {
        Seq seq;
        LazyRef lazyRef = readers$lzy$1;
        synchronized (lazyRef) {
            seq = readers$lzy$1.initialized() ? (Seq)readers$lzy$1.value() : (Seq)readers$lzy$1.initialize(this.stores.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Queryable store = (Queryable)tuple2._1();
                    Option filter = (Option)tuple2._2();
                    return store.getFeatureReader(package$.MODULE$.mergeFilter(sft$1, new Query(query$1), (Option<Filter>)filter), Transaction.AUTO_COMMIT);
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        return seq;
    }

    private final Seq readers$1(LazyRef readers$lzy$1, SimpleFeatureType sft$1, Query query$1) {
        if (readers$lzy$1.initialized()) {
            return (Seq)readers$lzy$1.value();
        }
        return this.readers$lzycompute$1(readers$lzy$1, sft$1, query$1);
    }

    private final CloseableIterator run$1(Query query$1, SimpleFeatureType resultSft$1, Option maxFeatures$1, LazyRef readers$lzy$1, SimpleFeatureType sft$1) {
        CloseableIterator closeableIterator;
        Seq seq;
        if (this.deduplicate) {
            HashSet cache = HashSet$.MODULE$.empty();
            seq = (Seq)this.readers$1(readers$lzy$1, sft$1, query$1).map((Function1 & Serializable)r -> new DeduplicatingSimpleFeatureIterator((CloseableIterator)SelfClosingIterator$.MODULE$.apply(r), (Set)cache, DeduplicatingSimpleFeatureIterator$.MODULE$.$lessinit$greater$default$3()));
        } else {
            seq = (Seq)this.readers$1(readers$lzy$1, sft$1, query$1).map((Function1 & Serializable)x$2 -> SelfClosingIterator$.MODULE$.apply(x$2));
        }
        Seq iters = seq;
        Option option = Option$.MODULE$.apply((Object)query$1.getSortBy()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])x$3))));
        if (None$.MODULE$.equals(option)) {
            closeableIterator = SelfClosingIterator$.MODULE$.apply(iters.iterator(), (Function0)(JFunction0.mcV.sp & Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable)i -> i);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SortBy[] sort = (SortBy[])some.value();
            closeableIterator = new SortedMergeIterator(iters, SimpleFeatureOrdering$.MODULE$.apply(resultSft$1, sort));
        } else {
            throw new MatchError((Object)option);
        }
        CloseableIterator results = closeableIterator;
        Option option2 = maxFeatures$1;
        if (None$.MODULE$.equals(option2)) {
            return results;
        }
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            int m = BoxesRunTime.unboxToInt((Object)some.value());
            return results.take(m);
        }
        throw new MatchError((Object)option2);
    }

    public static final /* synthetic */ CloseableIterator $anonfun$runQuery$13(MergedQueryRunner $this, Query query$1, SimpleFeatureType resultSft$1, Option maxFeatures$1, LazyRef readers$lzy$1, SimpleFeatureType sft$1) {
        return $this.run$1(query$1, resultSft$1, maxFeatures$1, readers$lzy$1, sft$1);
    }

    public static final /* synthetic */ void $anonfun$configureQuery$1(Query query$2, Map hints) {
        hints.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                return query$2.getHints().put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        QueryPlanner$.MODULE$.clearPerThreadQueryHints();
    }

    private static final CloseableIterator getSingle$1(FeatureReader reader, SimpleFeatureType sft$2, Hints hints$2) {
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            return CloseableIterator$.MODULE$.apply(reader);
        }
        SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$2.getUserData());
        return LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$2, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
    }

    private static final CloseableIterator getSingle$2(FeatureReader reader, SimpleFeatureType sft$3, Hints hints$3) {
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = DensityScan$.MODULE$.DensitySft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            return CloseableIterator$.MODULE$.apply(reader);
        }
        SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$3.getUserData());
        return LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$3, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
    }

    private static final CloseableIterator getSingle$3(FeatureReader reader, SimpleFeatureType sft$4, Hints hints$4) {
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = StatsScan$.MODULE$.StatsSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            return CloseableIterator$.MODULE$.apply(reader);
        }
        SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$4.getUserData());
        return LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$4, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
    }

    private static final CloseableIterator getSingle$4(FeatureReader reader, SimpleFeatureType sft$5, Hints hints$5) {
        SimpleFeatureType schema;
        SimpleFeatureType simpleFeatureType = schema = (SimpleFeatureType)reader.getFeatureType();
        SimpleFeatureType simpleFeatureType2 = BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            return CloseableIterator$.MODULE$.apply(reader);
        }
        SimpleFeatureType copy = SimpleFeatureTypes$.MODULE$.immutable(schema, sft$5.getUserData());
        return LocalQueryRunner$.MODULE$.transform(copy, (CloseableIterator<SimpleFeature>)CloseableIterator$.MODULE$.apply(reader), (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, hints$5, (Option<LocalQueryRunner.ArrowDictionaryHook>)None$.MODULE$);
    }

    public MergedQueryRunner(package.HasGeoMesaStats ds, Seq<Tuple2<Queryable, Option<Filter>>> stores, boolean deduplicate, boolean parallel) {
        this.stores = stores;
        this.deduplicate = deduplicate;
        this.parallel = parallel;
        QueryRunner.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.interceptors = QueryInterceptor$QueryInterceptorFactory$.MODULE$.empty();
    }

    public static class DataStoreQueryable
    implements Queryable,
    Product,
    Serializable {
        private final DataStore ds;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public DataStore ds() {
            return this.ds;
        }

        @Override
        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query q, Transaction t) {
            return this.ds().getFeatureReader(q, t);
        }

        public DataStoreQueryable copy(DataStore ds) {
            return new DataStoreQueryable(ds);
        }

        public DataStore copy$default$1() {
            return this.ds();
        }

        public String productPrefix() {
            return "DataStoreQueryable";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.ds();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DataStoreQueryable;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "ds";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DataStoreQueryable)) return false;
            boolean bl = true;
            if (!bl) return false;
            DataStoreQueryable dataStoreQueryable = (DataStoreQueryable)x$1;
            DataStore dataStore = this.ds();
            DataStore dataStore2 = dataStoreQueryable.ds();
            if (dataStore == null) {
                if (dataStore2 != null) {
                    return false;
                }
            } else if (!dataStore.equals(dataStore2)) return false;
            if (!dataStoreQueryable.canEqual(this)) return false;
            return true;
        }

        public DataStoreQueryable(DataStore ds) {
            this.ds = ds;
            Product.$init$((Product)this);
        }
    }

    public static interface Queryable {
        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query var1, Transaction var2);
    }
}

