/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.view;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource;
import org.locationtech.geomesa.index.view.MergedFeatureSourceView;
import org.locationtech.geomesa.index.view.RoutedDataStoreView;
import org.locationtech.geomesa.utils.geotools.package$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")A\n\u0001C\u0001\u001b\"A\u0011\u000b\u0001EC\u0002\u0013%!\u000b\u0003\u0005j\u0001!\u0015\r\u0011\"\u0003k\u0011\u0015a\b\u0001\"\u0011~\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\tI\u0002\u0001C!\u00037Aq!!\u0007\u0001\t\u0003\ni\u0003C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u00111\b\u0001\u0005B\u0005\u0015\u0003bBA\u001e\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\tI\u0007\u0001C!\u0003WBq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011Q\u0013\u0001\u0005B\u0005]%a\u0006*pkR,GMR3biV\u0014XmU8ve\u000e,g+[3x\u0015\t1r#\u0001\u0003wS\u0016<(B\u0001\r\u001a\u0003\u0015Ig\u000eZ3y\u0015\tQ2$A\u0004hK>lWm]1\u000b\u0005qi\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\t\u0013f\r\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA\u0001\\1oO*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005\u0019y%M[3diB\u0011!&M\u0007\u0002W)\u0011A&L\u0001\u0007g&l\u0007\u000f\\3\u000b\u00059z\u0013\u0001\u00023bi\u0006T!\u0001M\u000f\u0002\u0011\u001d,w\u000e^8pYNL!AM\u0016\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f'>,(oY3\u0011\u0005QZT\"A\u001b\u000b\u0005Y:\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001\u001d:\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001e\u0002\u0007\r|W.\u0003\u0002=k\tYA*\u0019>z\u0019><w-\u001b8h\u0003\t!7\u000f\u0005\u0002@\u00016\tQ#\u0003\u0002B+\t\u0019\"k\\;uK\u0012$\u0015\r^1Ti>\u0014XMV5fo\u0006\u00191O\u001a;\u0011\u0005\u0011SU\"A#\u000b\u000512%BA$I\u0003\u001d1W-\u0019;ve\u0016T!!S\u000f\u0002\u000f=\u0004XM\\4jg&\u00111*\u0012\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017A\u0002\u001fj]&$h\bF\u0002O\u001fB\u0003\"a\u0010\u0001\t\u000bu\u001a\u0001\u0019\u0001 \t\u000b\t\u001b\u0001\u0019A\"\u0002\u000b!Lg\u000e^:\u0016\u0003M\u00032\u0001V,Z\u001b\u0005)&B\u0001,&\u0003\u0011)H/\u001b7\n\u0005a+&aA*fiB\u0011!L\u001a\b\u00037\u000et!\u0001X1\u000f\u0005u\u0003W\"\u00010\u000b\u0005}{\u0012A\u0002\u001fs_>$h(C\u0001'\u0013\t\u0011W%A\u0002boRL!\u0001Z3\u0002\u001dI+g\u000eZ3sS:<\u0007*\u001b8ug*\u0011!-J\u0005\u0003O\"\u00141aS3z\u0015\t!W-\u0001\u0007dCB\f'-\u001b7ji&,7/F\u0001l!\ta\u0017P\u0004\u0002no:\u0011aN\u001e\b\u0003_Vt!\u0001\u001d;\u000f\u0005E\u001chBA/s\u0013\u0005q\u0012B\u0001\u000f\u001e\u0013\tQ2$\u0003\u0002\u00193%\u0011acF\u0005\u0003qV\tq#T3sO\u0016$g)Z1ukJ,7k\\;sG\u00164\u0016.Z<\n\u0005i\\(aF'fe\u001e,G-U;fef\u001c\u0015\r]1cS2LG/[3t\u0015\tAX#A\u0005hKR\u001c6\r[3nCR\t1)\u0001\u0005hKR\u001cu.\u001e8u)\u0011\t\t!!\u0004\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ!!a\u0002\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005-\u0011Q\u0001\u0002\u0004\u0013:$\bbBA\b\u000f\u0001\u0007\u0011\u0011C\u0001\u0006cV,'/\u001f\t\u0005\u0003'\t)\"D\u0001.\u0013\r\t9\"\f\u0002\u0006#V,'/_\u0001\nO\u0016$(i\\;oIN$\"!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005\u0019!\u000e^:\u000b\u0007\u0005\u001dr&\u0001\u0005hK>lW\r\u001e:z\u0013\u0011\tY#!\t\u0003%I+g-\u001a:f]\u000e,G-\u00128wK2|\u0007/\u001a\u000b\u0005\u0003;\ty\u0003C\u0004\u0002\u0010%\u0001\r!!\u0005\u0002)\u001d,G/U;fef\u001c\u0015\r]1cS2LG/[3t)\t\t)\u0004\u0005\u0003\u0002\u0014\u0005]\u0012bAA\u001d[\t\t\u0012+^3ss\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0002\u0017\u001d,GOR3biV\u0014Xm\u001d\u000b\u0003\u0003\u007f\u00012AKA!\u0013\r\t\u0019e\u000b\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:$B!a\u0010\u0002H!9\u0011\u0011\n\u0007A\u0002\u0005-\u0013A\u00024jYR,'\u000f\u0005\u0003\u0002N\u0005ESBAA(\u0015\r\tI\u0005S\u0005\u0005\u0003'\nyE\u0001\u0004GS2$XM\u001d\u000b\u0005\u0003\u007f\t9\u0006C\u0004\u0002\u00105\u0001\r!!\u0005\u0002\u000f\u001d,GOT1nKR\u0011\u0011Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r$\u0002\tQL\b/Z\u0005\u0005\u0003O\n\tG\u0001\u0003OC6,\u0017\u0001D4fi\u0012\u000bG/Y*u_J,GCAA7!\u0011\t\u0019\"a\u001c\n\u0007\u0005ETFA\u0005ECR\f7\u000b^8sK\u0006\tr-\u001a;TkB\u0004xN\u001d;fI\"Kg\u000e^:\u0015\u0003M\u000bqaZ3u\u0013:4w\u000e\u0006\u0002\u0002|A!\u00111CA?\u0013\r\ty(\f\u0002\r%\u0016\u001cx.\u001e:dK&sgm\\\u0001\u0013C\u0012$g)Z1ukJ,G*[:uK:,'\u000f\u0006\u0003\u0002\u0006\u0006-\u0005\u0003BA\u0002\u0003\u000fKA!!#\u0002\u0006\t!QK\\5u\u0011\u001d\tiI\u0005a\u0001\u0003\u001f\u000b\u0001\u0002\\5ti\u0016tWM\u001d\t\u0005\u0003'\t\t*C\u0002\u0002\u00146\u0012qBR3biV\u0014X\rT5ti\u0016tWM]\u0001\u0016e\u0016lwN^3GK\u0006$XO]3MSN$XM\\3s)\u0011\t))!'\t\u000f\u000555\u00031\u0001\u0002\u0010\u0002")
public class RoutedFeatureSourceView
implements SimpleFeatureSource,
LazyLogging {
    private Set<RenderingHints.Key> hints;
    private MergedFeatureSourceView.MergedQueryCapabilities capabilities;
    private final RoutedDataStoreView ds;
    private final SimpleFeatureType sft;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    private Logger logger$lzycompute() {
        RoutedFeatureSourceView routedFeatureSourceView = this;
        synchronized (routedFeatureSourceView) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Set<RenderingHints.Key> hints$lzycompute() {
        RoutedFeatureSourceView routedFeatureSourceView = this;
        synchronized (routedFeatureSourceView) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.hints = Collections.unmodifiableSet(Collections.emptySet());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.hints;
    }

    private Set<RenderingHints.Key> hints() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.hints$lzycompute();
        }
        return this.hints;
    }

    private MergedFeatureSourceView.MergedQueryCapabilities capabilities$lzycompute() {
        RoutedFeatureSourceView routedFeatureSourceView = this;
        synchronized (routedFeatureSourceView) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.capabilities = new MergedFeatureSourceView.MergedQueryCapabilities((Seq<QueryCapabilities>)((Seq)this.ds.stores().map((Function1 & Serializable)x$1 -> x$1.getFeatureSource($this.sft.getTypeName()).getQueryCapabilities())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.capabilities;
    }

    private MergedFeatureSourceView.MergedQueryCapabilities capabilities() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.capabilities$lzycompute();
        }
        return this.capabilities;
    }

    public SimpleFeatureType getSchema() {
        return this.sft;
    }

    public int getCount(Query query) {
        return BoxesRunTime.unboxToInt((Object)this.ds.router().route(this.sft, query).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)RoutedFeatureSourceView.$anonfun$getCount$1(this, query, x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public ReferencedEnvelope getBounds() {
        return this.getBounds(new Query(this.sft.getTypeName()));
    }

    public ReferencedEnvelope getBounds(Query query) {
        return (ReferencedEnvelope)this.ds.router().route(this.sft, query).map((Function1 & Serializable)x$3 -> x$3.getFeatureSource($this.sft.getTypeName()).getBounds(query)).getOrElse((Function0 & Serializable)() -> new ReferencedEnvelope(package$.MODULE$.CRS_EPSG_4326()));
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.capabilities();
    }

    public SimpleFeatureCollection getFeatures() {
        return this.getFeatures((Filter)Filter.INCLUDE);
    }

    public SimpleFeatureCollection getFeatures(Filter filter) {
        return this.getFeatures(new Query(this.sft.getTypeName(), filter));
    }

    public SimpleFeatureCollection getFeatures(Query query) {
        Option<DataStore> option = this.ds.router().route(this.sft, query);
        if (None$.MODULE$.equals(option)) {
            return new ListFeatureCollection(this.sft);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            DataStore store = (DataStore)some.value();
            return store.getFeatureSource(this.sft.getTypeName()).getFeatures(query);
        }
        throw new MatchError(option);
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public DataStore getDataStore() {
        return this.ds;
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return this.hints();
    }

    public ResourceInfo getInfo() {
        return new GeoMesaFeatureSource.DelegatingResourceInfo(this);
    }

    public void addFeatureListener(FeatureListener listener) {
        throw new NotImplementedError();
    }

    public void removeFeatureListener(FeatureListener listener) {
        throw new NotImplementedError();
    }

    public static final /* synthetic */ int $anonfun$getCount$1(RoutedFeatureSourceView $this, Query query$1, DataStore x$2) {
        return x$2.getFeatureSource($this.sft.getTypeName()).getCount(query$1);
    }

    public RoutedFeatureSourceView(RoutedDataStoreView ds, SimpleFeatureType sft) {
        this.ds = ds;
        this.sft = sft;
        LazyLogging.$init$((LazyLogging)this);
    }
}

