/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.conf.QueryHints;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$Keys$;
import org.locationtech.geomesa.jobs.mapreduce.SimpleFeatureSerialization;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class GeoMesaConfigurator$ {
    public static GeoMesaConfigurator$ MODULE$;
    private final String WritableSerialization;
    private final String SimpleFeatureSerialization;
    private final String SerializationString;

    static {
        new GeoMesaConfigurator$();
    }

    private String WritableSerialization() {
        return this.WritableSerialization;
    }

    private String SimpleFeatureSerialization() {
        return this.SimpleFeatureSerialization;
    }

    private String SerializationString() {
        return this.SerializationString;
    }

    public void setDataStoreOutParams(Configuration conf, Map<String, String> params) {
        conf.set(GeoMesaConfigurator$Keys$.MODULE$.DsOutParams(), StringSerialization$.MODULE$.encodeMap(params));
    }

    public Map<String, String> getDataStoreOutParams(Configuration conf) {
        return StringSerialization$.MODULE$.decodeMap(conf.get(GeoMesaConfigurator$Keys$.MODULE$.DsOutParams()));
    }

    public void setIndicesOut(Configuration conf, Seq<String> indices) {
        conf.set(GeoMesaConfigurator$Keys$.MODULE$.IndicesOut(), StringSerialization$.MODULE$.encodeSeq(indices));
    }

    public Option<Seq<String>> getIndicesOut(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get(GeoMesaConfigurator$Keys$.MODULE$.IndicesOut())).map((Function1 & Serializable & scala.Serializable)values -> StringSerialization$.MODULE$.decodeSeq(values));
    }

    public void setFilter(Configuration conf, String filter) {
        conf.set(GeoMesaConfigurator$Keys$.MODULE$.Filter(), filter);
    }

    public Option<String> getFilter(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get(GeoMesaConfigurator$Keys$.MODULE$.Filter()));
    }

    public void setResultsToFeatures(Configuration conf, QueryPlan.ResultsToFeatures<?> resultsToFeatures) {
        conf.set(GeoMesaConfigurator$Keys$.MODULE$.ToFeatures(), QueryPlan.ResultsToFeatures$.MODULE$.serialize(resultsToFeatures));
        this.setSerialization(conf, resultsToFeatures.schema());
    }

    public <T> QueryPlan.ResultsToFeatures<T> getResultsToFeatures(Configuration conf) {
        return QueryPlan.ResultsToFeatures$.MODULE$.deserialize(conf.get(GeoMesaConfigurator$Keys$.MODULE$.ToFeatures()));
    }

    public void setReducer(Configuration conf, QueryPlan.FeatureReducer reducer) {
        conf.set(GeoMesaConfigurator$Keys$.MODULE$.FeatureReducer(), QueryPlan.FeatureReducer$.MODULE$.serialize(reducer));
    }

    public Option<QueryPlan.FeatureReducer> getReducer(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get(GeoMesaConfigurator$Keys$.MODULE$.FeatureReducer())).map((Function1 & Serializable & scala.Serializable)serialized -> QueryPlan.FeatureReducer$.MODULE$.deserialize(serialized));
    }

    public void setSorting(Configuration conf, Seq<Tuple2<String, Object>> sort) {
        conf.set(GeoMesaConfigurator$Keys$.MODULE$.Sorting(), StringSerialization$.MODULE$.encodeSeq((Seq)sort.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String f = (String)tuple2._1();
                boolean r = tuple2._2$mcZ$sp();
                return (Seq)new .colon.colon((Object)f, (List)new .colon.colon((Object)Boolean.toString(r), (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Option<Seq<Tuple2<String, Object>>> getSorting(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get(GeoMesaConfigurator$Keys$.MODULE$.Sorting())).map((Function1 & Serializable & scala.Serializable)s -> StringSerialization$.MODULE$.decodeSeq(s).grouped(2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq = x0$1;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                String f = (String)((SeqLike)some.get()).apply(0);
                String r = (String)((SeqLike)some.get()).apply(1);
                return new Tuple2((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean()));
            }
            throw new MatchError((Object)seq);
        }).toList());
    }

    public void setProjection(Configuration conf, Reprojection.QueryReferenceSystems crs) {
        conf.set(GeoMesaConfigurator$Keys$.MODULE$.Projection(), QueryHints.Internal$.MODULE$.toProjectionHint(crs));
    }

    public Option<Reprojection.QueryReferenceSystems> getProjection(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get(GeoMesaConfigurator$Keys$.MODULE$.Projection())).map((Function1 & Serializable & scala.Serializable)hint -> QueryHints.Internal$.MODULE$.fromProjectionHint(hint));
    }

    public void setSerialization(Configuration conf, SimpleFeatureType sft) {
        String string = conf.get(GeoMesaConfigurator$Keys$.MODULE$.Serializers());
        if (string == null) {
            conf.set(GeoMesaConfigurator$Keys$.MODULE$.Serializers(), this.SerializationString());
        } else if (!string.contains(this.SimpleFeatureSerialization())) {
            conf.set(GeoMesaConfigurator$Keys$.MODULE$.Serializers(), ((TraversableOnce)new .colon.colon((Object)string, (List)new .colon.colon((Object)this.SimpleFeatureSerialization(), (List)Nil$.MODULE$))).mkString(","));
        }
        String spec = SimpleFeatureTypes$.MODULE$.encodeType(sft, true);
        String key = new StringBuilder(1).append(new StringBuilder(0).append(sft.getTypeName()).append(spec).toString().hashCode()).append(":").append(sft.getTypeName()).toString();
        String string2 = conf.get(GeoMesaConfigurator$Keys$.MODULE$.SftNames());
        if (string2 == null) {
            conf.set(GeoMesaConfigurator$Keys$.MODULE$.SftNames(), key);
        } else {
            Seq existing = StringSerialization$.MODULE$.decodeSeq(string2);
            if (!existing.contains((Object)key)) {
                conf.set(GeoMesaConfigurator$Keys$.MODULE$.SftNames(), StringSerialization$.MODULE$.encodeSeq((Seq)existing.$colon$plus((Object)key, Seq$.MODULE$.canBuildFrom())));
            }
        }
        conf.set(new StringBuilder(1).append(GeoMesaConfigurator$Keys$.MODULE$.SftNames()).append(".").append(key).toString(), spec);
    }

    public Seq<Tuple3<String, Object, SimpleFeatureType>> getSerialization(Configuration conf) {
        return (Seq)((TraversableLike)Option$.MODULE$.apply((Object)conf.get(GeoMesaConfigurator$Keys$.MODULE$.SftNames())).map((Function1 & Serializable & scala.Serializable)values -> StringSerialization$.MODULE$.decodeSeq(values)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)key -> {
            int sep = key.indexOf(58);
            int hash = new StringOps(Predef$.MODULE$.augmentString(key.substring(0, sep))).toInt();
            String typeName = key.substring(sep + 1);
            String spec = conf.get(new StringBuilder(1).append(GeoMesaConfigurator$Keys$.MODULE$.SftNames()).append(".").append((String)key).toString());
            return new Tuple3(key, (Object)BoxesRunTime.boxToInteger((int)hash), (Object)SimpleFeatureTypes$.MODULE$.createType(typeName, spec));
        }, Seq$.MODULE$.canBuildFrom());
    }

    private GeoMesaConfigurator$() {
        MODULE$ = this;
        this.WritableSerialization = WritableSerialization.class.getName();
        this.SimpleFeatureSerialization = SimpleFeatureSerialization.class.getName();
        this.SerializationString = new StringBuilder(1).append(this.WritableSerialization()).append(",").append(this.SimpleFeatureSerialization()).toString();
    }
}

