/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.consumer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.WakeupException;
import org.locationtech.geomesa.kafka.consumer.BaseThreadedConsumer;
import org.locationtech.geomesa.kafka.consumer.ThreadedConsumer$;
import org.locationtech.geomesa.kafka.versions.KafkaConsumerVersions$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a!\u0002\u0012$\u0003\u0003q\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011M\u0003!\u0011!Q\u0001\nQC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\u0006A\u0002!\t!\u0019\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0011\u001d\t)\f\u0001Q\u0001\n!Dq!a.\u0001\t#\nI\fC\u0004\u0002N\u00021\t\"a4\u0007\r\u0005m\u0007\u0001AAo\u0011)\t\u0019-\u0003B\u0001B\u0003%\u0011\u0011\u0001\u0005\tI%\u0011\t\u0011)A\u0005\u0005\"Q\u0011\u0011Z\u0005\u0003\u0002\u0003\u0006I!a3\t\r\u0001LA\u0011AAp\u0011%\tY/\u0003a\u0001\n\u0013\ti\u000fC\u0005\u0002v&\u0001\r\u0011\"\u0003\u0002x\"A\u0011Q`\u0005!B\u0013\ty\u000f\u0003\u0006\u0002:%A)\u0019!C\u0005\u0003\u007fDqA!\u0001\n\t\u0003\u0012\u0019aB\u0003uG!\u0005QOB\u0003#G!\u0005a\u000fC\u0003a)\u0011\u0005!PB\u0004|)A\u0005\u0019\u0013\u0001?\t\u000bu4b\u0011\u0001@\u0007\r\u0005mA\u0003AA\u000f\u0011)\t\u0019\u0003\u0007B\u0001B\u0003%\u0011Q\u0005\u0005\u000b\u0003sA\"\u0011!Q\u0001\n\u0005m\u0002B\u00021\u0019\t\u0003\ti\u0004\u0003\u0004~1\u0011\u0005\u0013Q\t\u0004\u0007\u0003\u0017\"\u0002!!\u0014\t\u0015\u0005\rRD!A!\u0002\u0013\t)\u0003\u0003\u0004a;\u0011\u0005\u0011\u0011\r\u0005\b\u0003OjB\u0011IA5\u0011%\ti\nFI\u0001\n\u0003\tyJ\u0001\tUQJ,\u0017\rZ3e\u0007>t7/^7fe*\u0011A%J\u0001\tG>t7/^7fe*\u0011aeJ\u0001\u0006W\u000647.\u0019\u0006\u0003Q%\nqaZ3p[\u0016\u001c\u0018M\u0003\u0002+W\u0005aAn\\2bi&|g\u000e^3dQ*\tA&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001'M\u0007\u0002G%\u0011!g\t\u0002\u0015\u0005\u0006\u001cX\r\u00165sK\u0006$W\rZ\"p]N,X.\u001a:\u0002\u0013\r|gn];nKJ\u001c\bcA\u001b@\u0005:\u0011a\u0007\u0010\b\u0003oij\u0011\u0001\u000f\u0006\u0003s5\na\u0001\u0010:p_Rt\u0014\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005ur\u0014a\u00029bG.\fw-\u001a\u0006\u0002w%\u0011\u0001)\u0011\u0002\u0004'\u0016\f(BA\u001f?!\u0011\u0019%\n\u0014'\u000e\u0003\u0011S!\u0001J#\u000b\u0005\u0019;\u0015aB2mS\u0016tGo\u001d\u0006\u0003M!S!!S\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tYEI\u0001\u0005D_:\u001cX/\\3s!\rie\nU\u0007\u0002}%\u0011qJ\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001bFK!A\u0015 \u0003\t\tKH/Z\u0001\nMJ,\u0017/^3oGf\u0004\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\tQLW.\u001a\u0006\u00023\u0006!!.\u0019<b\u0013\tYfK\u0001\u0005EkJ\fG/[8o\u00039\u0019Gn\\:f\u0007>t7/^7feN\u0004\"!\u00140\n\u0005}s$a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\t\u001cG-\u001a\t\u0003a\u0001AQa\r\u0003A\u0002QBQa\u0015\u0003A\u0002QCq\u0001\u0018\u0003\u0011\u0002\u0003\u0007Q,\u0001\u0005dC2d'-Y2l+\u0005A\u0007CA5\u001e\u001d\tQ7C\u0004\u0002lg:\u0011AN\u001d\b\u0003[Ft!A\u001c9\u000f\u0005]z\u0017\"\u0001\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\t1s%\u0003\u0002%K\u0005\u0001B\u000b\u001b:fC\u0012,GmQ8ogVlWM\u001d\t\u0003aQ\u0019\"\u0001F<\u0011\u00055C\u0018BA=?\u0005\u0019\te.\u001f*fMR\tQO\u0001\u000bD_:\u001cX/\\3s\u000bJ\u0014xN\u001d%b]\u0012dWM]\n\u0003-]\fa\u0001[1oI2,G\u0003B/\u0000\u0003#Aa\u0001J\fA\u0002\u0005\u0005\u0001\u0003BA\u0002\u0003\u0017qA!!\u0002\u0002\bA\u0011qGP\u0005\u0004\u0003\u0013q\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twMC\u0002\u0002\nyBq!a\u0005\u0018\u0001\u0004\t)\"A\u0001f!\r)\u0014qC\u0005\u0004\u00033\t%!\u0003+ie><\u0018M\u00197f\u0005maunZ4j]\u001e\u001cuN\\:v[\u0016\u0014XI\u001d:pe\"\u000bg\u000e\u001a7feN!\u0001d^A\u0010!\r\t\tCF\u0007\u0002)\u00051An\\4hKJ\u0004B!a\n\u000265\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0003\u00020\u0005E\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005M\u0012aA2p[&!\u0011qGA\u0015\u0005\u0019aunZ4fe\u00061Ao\u001c9jGN\u0004B!N \u0002\u0002Q1\u0011qHA!\u0003\u0007\u00022!!\t\u0019\u0011\u001d\t\u0019c\u0007a\u0001\u0003KAq!!\u000f\u001c\u0001\u0004\tY\u0004F\u0003^\u0003\u000f\nI\u0005\u0003\u0004%9\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003'a\u0002\u0019AA\u000b\u0005]aunZ(gMN,GoQ8n[&$8)\u00197mE\u0006\u001c7nE\u0003\u001e\u0003\u001f\nY\u0006\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)\u0006W\u0001\u0005Y\u0006tw-\u0003\u0003\u0002Z\u0005M#AB(cU\u0016\u001cG\u000fE\u0002D\u0003;J1!a\u0018E\u0005QyeMZ:fi\u000e{W.\\5u\u0007\u0006dGNY1dWR!\u00111MA3!\r\t\t#\b\u0005\b\u0003Gy\u0002\u0019AA\u0013\u0003)ygnQ8na2,G/\u001a\u000b\u0007\u0003W\n\t(a%\u0011\u00075\u000bi'C\u0002\u0002py\u0012A!\u00168ji\"9\u00111\u000f\u0011A\u0002\u0005U\u0014aB8gMN,Go\u001d\t\t\u0003o\ni(!!\u0002\u000e6\u0011\u0011\u0011\u0010\u0006\u0004\u0003wB\u0016\u0001B;uS2LA!a \u0002z\t\u0019Q*\u00199\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"H\u0003\u0019\u0019w.\\7p]&!\u00111RAC\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042aQAH\u0013\r\t\t\n\u0012\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f\u0007bBAKA\u0001\u0007\u0011qS\u0001\nKb\u001cW\r\u001d;j_:\u00042!NAM\u0013\r\tY*\u0011\u0002\n\u000bb\u001cW\r\u001d;j_:\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAAQU\ri\u00161U\u0016\u0003\u0003K\u0003B!a*\u000226\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0016 \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00024\u0006%&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006I1-\u00197mE\u0006\u001c7\u000eI\u0001\u0017GJ,\u0017\r^3D_:\u001cX/\\3s%Vtg.\u00192mKRA\u00111XAa\u0003\u000b\f9\r\u0005\u0003\u0002R\u0005u\u0016\u0002BA`\u0003'\u0012\u0001BU;o]\u0006\u0014G.\u001a\u0005\b\u0003\u0007<\u0001\u0019AA\u0001\u0003\tIG\rC\u0003%\u000f\u0001\u0007!\tC\u0004\u0002J\u001e\u0001\r!a3\u0002\u000f!\fg\u000e\u001a7feB\u0011\u0011NF\u0001\bG>t7/^7f)\u0011\tY'!5\t\u000f\u0005M\u0007\u00021\u0001\u0002V\u00061!/Z2pe\u0012\u0004RaQAl\u00192K1!!7E\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0014\u0001cQ8ogVlWM\u001d*v]:\f'\r\\3\u0014\u000b%\ty%a/\u0015\u0011\u0005\u0005\u0018Q]At\u0003S\u00042!a9\n\u001b\u0005\u0001\u0001bBAb\u001b\u0001\u0007\u0011\u0011\u0001\u0005\u0006I5\u0001\rA\u0011\u0005\b\u0003\u0013l\u0001\u0019AAf\u0003))'O]8s\u0007>,h\u000e^\u000b\u0003\u0003_\u00042!TAy\u0013\r\t\u0019P\u0010\u0002\u0004\u0013:$\u0018AD3se>\u00148i\\;oi~#S-\u001d\u000b\u0005\u0003W\nI\u0010C\u0005\u0002|>\t\t\u00111\u0001\u0002p\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\u0015\u0014(o\u001c:D_VtG\u000fI\u000b\u0003\u0003\u0003\t1A];o)\t\tY\u0007")
public abstract class ThreadedConsumer
extends BaseThreadedConsumer {
    public final Duration org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$frequency;
    public final boolean org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$closeConsumers;
    private final LogOffsetCommitCallback org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$callback;

    public static boolean $lessinit$greater$default$3() {
        return ThreadedConsumer$.MODULE$.$lessinit$greater$default$3();
    }

    public LogOffsetCommitCallback org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$callback() {
        return this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$callback;
    }

    @Override
    public Runnable createConsumerRunnable(String id, Consumer<byte[], byte[]> consumer, ConsumerErrorHandler handler) {
        return new ConsumerRunnable(this, id, consumer, handler);
    }

    public abstract void consume(ConsumerRecord<byte[], byte[]> var1);

    public ThreadedConsumer(Seq<Consumer<byte[], byte[]>> consumers, Duration frequency, boolean closeConsumers) {
        this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$frequency = frequency;
        this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$closeConsumers = closeConsumers;
        super(consumers);
        this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$callback = new LogOffsetCommitCallback(this.logger());
    }

    public static interface ConsumerErrorHandler {
        public boolean handle(String var1, Throwable var2);
    }

    public class ConsumerRunnable
    implements Runnable {
        private String topics;
        private final String id;
        private final Consumer<byte[], byte[]> consumer;
        private final ConsumerErrorHandler handler;
        private int errorCount;
        private volatile boolean bitmap$0;
        public final /* synthetic */ ThreadedConsumer $outer;

        private int errorCount() {
            return this.errorCount;
        }

        private void errorCount_$eq(int x$1) {
            this.errorCount = x$1;
        }

        private String topics$lzycompute() {
            ConsumerRunnable consumerRunnable = this;
            synchronized (consumerRunnable) {
                if (!this.bitmap$0) {
                    this.topics = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.consumer.subscription()).asScala()).mkString(", ");
                    this.bitmap$0 = true;
                }
            }
            return this.topics;
        }

        private String topics() {
            if (!this.bitmap$0) {
                return this.topics$lzycompute();
            }
            return this.topics;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                boolean interrupted = false;
                while (this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().isOpen() && !interrupted) {
                    try {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit2;
                        LazyRef topics$lzy = new LazyRef();
                        ConsumerRecords<byte[], byte[]> result = KafkaConsumerVersions$.MODULE$.poll(this.consumer, this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$frequency);
                        if (this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().isDebugEnabled()) {
                            this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().debug("Consumer [{}] poll received {} records for {}", new Object[]{this.id, BoxesRunTime.boxToInteger((int)result.count()), ConsumerRunnable.topics$1(topics$lzy, result)});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        if (result.isEmpty()) continue;
                        Iterator records = result.iterator();
                        while (records.hasNext()) {
                            this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().consume((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.next()));
                        }
                        if (this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().isTraceEnabled()) {
                            this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().trace("Consumer [{}] finished processing {} records from topic {}", new Object[]{this.id, BoxesRunTime.boxToInteger((int)result.count()), ConsumerRunnable.topics$1(topics$lzy, result)});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.consumer.commitAsync((OffsetCommitCallback)this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$callback());
                        this.errorCount_$eq(0);
                    }
                    catch (Throwable throwable) {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit3;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof WakeupException ? true : (throwable2 instanceof InterruptException ? true : throwable2 instanceof InterruptedException)) {
                            interrupted = true;
                            continue;
                        }
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) throw throwable;
                        Throwable e = (Throwable)option.get();
                        this.errorCount_$eq(this.errorCount() + 1);
                        if (this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().isWarnEnabled()) {
                            this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().warn(new StringBuilder(48).append("Consumer [").append(this.id).append("] error receiving message from topic ").append(this.topics()).append(":").toString(), e);
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        if (this.errorCount() <= 300 || this.handler.handle(this.id, e)) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        if (this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().isErrorEnabled()) {
                            this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().error(new StringBuilder(61).append("Consumer [").append(this.id).append("] shutting down due to too many errors from topic ").append(this.topics()).append(":").toString(), e);
                            boxedUnit = BoxedUnit.UNIT;
                            throw e;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw e;
                        return;
                    }
                }
            }
            finally {
                block22: {
                    if (this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$$closeConsumers) {
                        try {
                            this.consumer.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable3 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable3);
                            if (option.isEmpty()) throw throwable;
                            Throwable e = (Throwable)option.get();
                            if (!this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().isWarnEnabled()) break block22;
                            this.org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer().logger().underlying().warn("Error calling close on consumer: ", e);
                        }
                    }
                }
            }
        }

        public /* synthetic */ ThreadedConsumer org$locationtech$geomesa$kafka$consumer$ThreadedConsumer$ConsumerRunnable$$$outer() {
            return this.$outer;
        }

        private static final /* synthetic */ String topics$lzycompute$1(LazyRef topics$lzy$1, ConsumerRecords result$1) {
            String string;
            LazyRef lazyRef = topics$lzy$1;
            synchronized (lazyRef) {
                string = topics$lzy$1.initialized() ? (String)topics$lzy$1.value() : (String)topics$lzy$1.initialize((Object)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(result$1.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> new StringBuilder(3).append("[").append(tp.topic()).append(":").append(tp.partition()).append("]").toString(), Set$.MODULE$.canBuildFrom())).mkString(","));
            }
            return string;
        }

        private static final String topics$1(LazyRef topics$lzy$1, ConsumerRecords result$1) {
            if (topics$lzy$1.initialized()) {
                return (String)topics$lzy$1.value();
            }
            return ConsumerRunnable.topics$lzycompute$1(topics$lzy$1, result$1);
        }

        public ConsumerRunnable(ThreadedConsumer $outer, String id, Consumer<byte[], byte[]> consumer, ConsumerErrorHandler handler) {
            this.id = id;
            this.consumer = consumer;
            this.handler = handler;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.errorCount = 0;
        }
    }

    public static class LogOffsetCommitCallback
    implements OffsetCommitCallback {
        private final Logger logger;

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            BoxedUnit boxedUnit;
            LazyRef o$lzy = new LazyRef();
            if (exception == null) {
                BoxedUnit boxedUnit2;
                if (this.logger.underlying().isTraceEnabled()) {
                    this.logger.underlying().trace("Consumer committed offsets: {}", new Object[]{LogOffsetCommitCallback.o$1(o$lzy, offsets)});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return;
            }
            if (this.logger.underlying().isErrorEnabled()) {
                this.logger.underlying().error(new StringBuilder(38).append("Consumer error committing offsets: ").append(LogOffsetCommitCallback.o$1(o$lzy, offsets)).append(" : ").append(exception.getMessage()).toString(), (Throwable)exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        private static final /* synthetic */ String o$lzycompute$1(LazyRef o$lzy$1, Map offsets$1) {
            String string;
            LazyRef lazyRef = o$lzy$1;
            synchronized (lazyRef) {
                string = o$lzy$1.initialized() ? (String)o$lzy$1.value() : (String)o$lzy$1.initialize((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsets$1).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        OffsetAndMetadata om = (OffsetAndMetadata)tuple2._2();
                        return new StringBuilder(4).append("[").append(tp.topic()).append(":").append(tp.partition()).append(":").append(om.offset()).append("]").toString();
                    }
                    throw new MatchError((Object)tuple2);
                }, Iterable$.MODULE$.canBuildFrom())).mkString(","));
            }
            return string;
        }

        private static final String o$1(LazyRef o$lzy$1, Map offsets$1) {
            if (o$lzy$1.initialized()) {
                return (String)o$lzy$1.value();
            }
            return LogOffsetCommitCallback.o$lzycompute$1(o$lzy$1, offsets$1);
        }

        public LogOffsetCommitCallback(Logger logger) {
            this.logger = logger;
        }
    }

    public static class LoggingConsumerErrorHandler
    implements ConsumerErrorHandler {
        private final Logger logger;
        private final Seq<String> topics;

        @Override
        public boolean handle(String consumer, Throwable e) {
            BoxedUnit boxedUnit;
            if (this.logger.underlying().isErrorEnabled()) {
                this.logger.underlying().error(new StringBuilder(48).append("Consumer [").append(consumer).append("] error receiving message from topic ").append(this.topics.mkString(", ")).append(":").toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return false;
        }

        public LoggingConsumerErrorHandler(Logger logger, Seq<String> topics) {
            this.logger = logger;
            this.topics = topics;
        }
    }
}

