/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.security;

import org.opengis.feature.simple.SimpleFeature;

public class SecurityUtils {
    public static final String FEATURE_VISIBILITY = "geomesa.feature.visibility";

    public static SimpleFeature setFeatureVisibility(SimpleFeature feature, String visibility) {
        String value = null;
        if (visibility != null) {
            value = visibility.intern();
        }
        feature.getUserData().put(FEATURE_VISIBILITY, value);
        return feature;
    }

    public static SimpleFeature setFeatureVisibilities(SimpleFeature feature, String ... visibilities) {
        return SecurityUtils.setFeatureVisibility(feature, String.join((CharSequence)"&", visibilities));
    }

    public static String getVisibility(SimpleFeature feature) {
        return (String)feature.getUserData().get(FEATURE_VISIBILITY);
    }

    public static void copyVisibility(SimpleFeature source, SimpleFeature dest) {
        SecurityUtils.setFeatureVisibility(dest, SecurityUtils.getVisibility(source));
    }
}

