/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.spark.sql.ExperimentalMethods;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SQLRules$;
import org.apache.spark.sql.SQLRules$$anonfun$buildGTFilter$1$;
import org.apache.spark.sql.SQLRules$SpatialJoinStrategy$;
import org.apache.spark.sql.SQLRules$SpatialOptimizationsRule$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.geotools.factory.CommonFactoryFinder;
import org.locationtech.geomesa.spark.jts.rules.GeometryLiteral;
import org.locationtech.geomesa.spark.jts.udf.SpatialRelationFunctions$;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class SQLRules$
implements LazyLogging {
    public static final SQLRules$ MODULE$;
    private final transient FilterFactory2 org$apache$spark$sql$SQLRules$$ff;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SQLRules$();
    }

    private Logger logger$lzycompute() {
        SQLRules$ sQLRules$ = this;
        synchronized (sQLRules$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public FilterFactory2 org$apache$spark$sql$SQLRules$$ff() {
        return this.org$apache$spark$sql$SQLRules$$ff;
    }

    public Option<Filter> scalaUDFtoGTFilter(Expression udf) {
        ScalaUDF scalaUDF;
        Expression expression = udf;
        Option<Filter> option = expression instanceof ScalaUDF && (scalaUDF = (ScalaUDF)expression).children().length() == 2 ? this.buildGTFilter(scalaUDF.function(), (Expression)scalaUDF.children().head(), (Expression)scalaUDF.children().last()) : None$.MODULE$;
        return option;
    }

    private Option<Filter> buildGTFilter(Object func, Expression exprA, Expression exprB) {
        return this.funcToFF(func).flatMap((Function1)new Serializable(exprA, exprB){
            public static final long serialVersionUID = 0L;
            private final Expression exprA$1;
            public final Expression exprB$1;

            public final Option<Filter> apply(Function2<org.opengis.filter.expression.Expression, org.opengis.filter.expression.Expression, Filter> builder) {
                return SQLRules$.MODULE$.sparkExprToGTExpr(this.exprA$1).flatMap((Function1)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.buildGTFilter.1 $outer;
                    public final Function2 builder$1;

                    public final Option<Filter> apply(org.opengis.filter.expression.Expression gtExprA) {
                        return SQLRules$.MODULE$.sparkExprToGTExpr(this.$outer.exprB$1).map((Function1)new Serializable(this, gtExprA){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$buildGTFilter$1$$anonfun$apply$2 $outer;
                            private final org.opengis.filter.expression.Expression gtExprA$1;

                            public final Filter apply(org.opengis.filter.expression.Expression gtExprB) {
                                return (Filter)this.$outer.builder$1.apply((Object)this.gtExprA$1, (Object)gtExprB);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.gtExprA$1 = gtExprA$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builder$1 = builder$1;
                    }
                });
            }
            {
                this.exprA$1 = exprA$1;
                this.exprB$1 = exprB$1;
            }
        });
    }

    public Option<Function2<org.opengis.filter.expression.Expression, org.opengis.filter.expression.Expression, Filter>> funcToFF(Object func) {
        Object object;
        Object object2 = func;
        Function2 function2 = SpatialRelationFunctions$.MODULE$.ST_Contains();
        Object object3 = object2;
        if (!(function2 != null ? !function2.equals(object3) : object3 != null)) {
            object = new Some((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Contains apply(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
                    return SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$ff().contains(expr1, expr2);
                }
            });
        } else {
            Function2 function22 = SpatialRelationFunctions$.MODULE$.ST_Crosses();
            Object object4 = object2;
            if (!(function22 != null ? !function22.equals(object4) : object4 != null)) {
                object = new Some((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Crosses apply(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
                        return SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$ff().crosses(expr1, expr2);
                    }
                });
            } else {
                Function2 function23 = SpatialRelationFunctions$.MODULE$.ST_Disjoint();
                Object object5 = object2;
                if (!(function23 != null ? !function23.equals(object5) : object5 != null)) {
                    object = new Some((Object)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Disjoint apply(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
                            return SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$ff().disjoint(expr1, expr2);
                        }
                    });
                } else {
                    Function2 function24 = SpatialRelationFunctions$.MODULE$.ST_Equals();
                    Object object6 = object2;
                    if (!(function24 != null ? !function24.equals(object6) : object6 != null)) {
                        object = new Some((Object)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Equals apply(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
                                return SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$ff().equal(expr1, expr2);
                            }
                        });
                    } else {
                        Function2 function25 = SpatialRelationFunctions$.MODULE$.ST_Intersects();
                        Object object7 = object2;
                        if (!(function25 != null ? !function25.equals(object7) : object7 != null)) {
                            object = new Some((Object)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final Intersects apply(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
                                    return SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$ff().intersects(expr1, expr2);
                                }
                            });
                        } else {
                            Function2 function26 = SpatialRelationFunctions$.MODULE$.ST_Overlaps();
                            Object object8 = object2;
                            if (!(function26 != null ? !function26.equals(object8) : object8 != null)) {
                                object = new Some((Object)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final Overlaps apply(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
                                        return SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$ff().overlaps(expr1, expr2);
                                    }
                                });
                            } else {
                                Function2 function27 = SpatialRelationFunctions$.MODULE$.ST_Touches();
                                Object object9 = object2;
                                if (!(function27 != null ? !function27.equals(object9) : object9 != null)) {
                                    object = new Some((Object)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final Touches apply(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
                                            return SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$ff().touches(expr1, expr2);
                                        }
                                    });
                                } else {
                                    Function2 function28 = SpatialRelationFunctions$.MODULE$.ST_Within();
                                    Object object10 = object2;
                                    object = !(function28 != null ? !function28.equals(object10) : object10 != null) ? new Some((Object)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final Within apply(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
                                            return SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$ff().within(expr1, expr2);
                                        }
                                    }) : None$.MODULE$;
                                }
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    public Option<Filter> sparkFilterToGTFilter(Expression expr) {
        BinaryComparison binaryComparison;
        Option option;
        None$ none$;
        Expression expression = expr;
        if (expression instanceof ScalaUDF) {
            ScalaUDF scalaUDF = (ScalaUDF)expression;
            none$ = this.scalaUDFtoGTFilter((Expression)scalaUDF);
        } else if (expression instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            None$ none$2;
            Expression left = (Expression)((Tuple2)option.get())._1();
            Expression right = (Expression)((Tuple2)option.get())._2();
            Option<org.opengis.filter.expression.Expression> leftExpr = this.sparkExprToGTExpr(left);
            Option<org.opengis.filter.expression.Expression> rightExpr = this.sparkExprToGTExpr(right);
            if (leftExpr.isEmpty() || rightExpr.isEmpty()) {
                none$2 = None$.MODULE$;
            } else {
                BinaryComparison binaryComparison2 = binaryComparison;
                Object object = binaryComparison2 instanceof EqualTo ? new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().equals((org.opengis.filter.expression.Expression)leftExpr.get(), (org.opengis.filter.expression.Expression)rightExpr.get())) : (binaryComparison2 instanceof LessThan ? new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().less((org.opengis.filter.expression.Expression)leftExpr.get(), (org.opengis.filter.expression.Expression)rightExpr.get())) : (binaryComparison2 instanceof LessThanOrEqual ? new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().lessOrEqual((org.opengis.filter.expression.Expression)leftExpr.get(), (org.opengis.filter.expression.Expression)rightExpr.get())) : (binaryComparison2 instanceof GreaterThan ? new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().greater((org.opengis.filter.expression.Expression)leftExpr.get(), (org.opengis.filter.expression.Expression)rightExpr.get())) : (binaryComparison2 instanceof GreaterThanOrEqual ? new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().greaterOrEqual((org.opengis.filter.expression.Expression)leftExpr.get(), (org.opengis.filter.expression.Expression)rightExpr.get())) : None$.MODULE$))));
                none$2 = object;
            }
            none$ = none$2;
        } else if (expression instanceof UnaryExpression) {
            None$ none$3;
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            Expression sparkExpr = unaryExpression.child();
            Option<org.opengis.filter.expression.Expression> gtExpr = this.sparkExprToGTExpr(sparkExpr);
            if (gtExpr.isEmpty()) {
                none$3 = None$.MODULE$;
            } else {
                UnaryExpression unaryExpression2 = unaryExpression;
                Object object = unaryExpression2 instanceof IsNotNull ? new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().not((Filter)this.org$apache$spark$sql$SQLRules$$ff().isNull((org.opengis.filter.expression.Expression)gtExpr.get()))) : (unaryExpression2 instanceof IsNull ? new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().isNull((org.opengis.filter.expression.Expression)gtExpr.get())) : None$.MODULE$);
                none$3 = object;
            }
            none$ = none$3;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Got expr: {}.  Don't know how to turn this into a GeoTools Expression.", new Object[]{expr});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<org.opengis.filter.expression.Expression> sparkExprToGTExpr(Expression expression) {
        BoxedUnit boxedUnit;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        boolean bl = false;
        Literal literal = null;
        Expression expression2 = expression;
        if (expression2 instanceof GeometryLiteral) {
            GeometryLiteral geometryLiteral = (GeometryLiteral)expression2;
            return new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().literal((Object)geometryLiteral.geom()));
        }
        if (expression2 instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression2;
            String string = attributeReference.name();
            String string2 = "__fid__";
            if (string == null ? string2 != null : !string.equals(string2)) {
                return new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().property(attributeReference.name()));
            }
        }
        if (expression2 instanceof Cast) {
            Cast cast = (Cast)expression2;
            ObjectRef zone$lzy = ObjectRef.zero();
            return this.sparkExprToGTExpr(cast.child()).map((Function1)new Serializable(zone$lzy, cast, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final ObjectRef zone$lzy$1;
                private final Cast x4$1;
                private final VolatileByteRef bitmap$0$1;

                public final org.opengis.filter.expression.Expression apply(org.opengis.filter.expression.Expression x0$1) {
                    org.opengis.filter.expression.Expression expression;
                    org.opengis.filter.expression.Literal literal;
                    org.opengis.filter.expression.Expression expression2 = x0$1;
                    if (expression2 instanceof org.opengis.filter.expression.Literal && (literal = (org.opengis.filter.expression.Literal)expression2).getValue() instanceof Date && SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$zone$1(this.zone$lzy$1, this.x4$1, this.bitmap$0$1) != null) {
                        LocalDateTime date = LocalDateTime.ofInstant(DateUtils$.MODULE$.toInstant((Date)literal.getValue()), SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$zone$1(this.zone$lzy$1, this.x4$1, this.bitmap$0$1));
                        expression = SQLRules$.MODULE$.org$apache$spark$sql$SQLRules$$ff().literal((Object)new Date(date.atZone(ZoneOffset.UTC).toInstant().toEpochMilli()));
                    } else {
                        expression = expression2;
                    }
                    return expression;
                }
                {
                    this.zone$lzy$1 = zone$lzy$1;
                    this.x4$1 = x4$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
        }
        if (expression2 instanceof Literal) {
            bl = true;
            literal = (Literal)expression2;
            DataType dataType = literal.dataType();
            DataType dataType2 = DataTypes.StringType;
            if (dataType == null) {
                if (dataType2 == null) return new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().literal(Option$.MODULE$.apply(literal.value()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$1) {
                        return x$1.toString();
                    }
                }).orNull(Predef$.MODULE$.$conforms())));
            } else if (dataType.equals(dataType2)) {
                return new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().literal(Option$.MODULE$.apply(literal.value()).map((Function1)new /* invalid duplicate definition of identical inner class */).orNull(Predef$.MODULE$.$conforms())));
            }
        }
        if (bl) {
            DataType dataType = literal.dataType();
            DataType dataType3 = DataTypes.TimestampType;
            if (dataType == null) {
                if (dataType3 == null) return new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().literal((Object)new Date(BoxesRunTime.unboxToLong((Object)literal.value()) / 1000L)));
            } else if (dataType.equals(dataType3)) {
                return new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().literal((Object)new Date(BoxesRunTime.unboxToLong((Object)literal.value()) / 1000L)));
            }
        }
        if (bl) {
            return new Some((Object)this.org$apache$spark$sql$SQLRules$$ff().literal(literal.value()));
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Can't turn expression into geotools: {}", new Object[]{expression});
            boxedUnit = BoxedUnit.UNIT;
            return None$.MODULE$;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return None$.MODULE$;
    }

    public void registerOptimizations(SQLContext sqlContext) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SQLRules$SpatialOptimizationsRule$[]{SQLRules$SpatialOptimizationsRule$.MODULE$}))).foreach((Function1)new Serializable(sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;

            public final void apply(SQLRules$SpatialOptimizationsRule$ r) {
                if (!this.sqlContext$1.experimental().extraOptimizations().contains((Object)((Object)r))) {
                    ExperimentalMethods experimentalMethods = this.sqlContext$1.experimental();
                    experimentalMethods.extraOptimizations_$eq((Seq)experimentalMethods.extraOptimizations().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SQLRules$SpatialOptimizationsRule$[]{r})), Seq$.MODULE$.canBuildFrom()));
                }
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SQLRules$SpatialJoinStrategy$[]{SQLRules$SpatialJoinStrategy$.MODULE$}))).foreach((Function1)new Serializable(sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;

            public final void apply(SQLRules$SpatialJoinStrategy$ s) {
                if (!this.sqlContext$1.experimental().extraStrategies().contains((Object)((Object)s))) {
                    ExperimentalMethods experimentalMethods = this.sqlContext$1.experimental();
                    experimentalMethods.extraStrategies_$eq((Seq)experimentalMethods.extraStrategies().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SQLRules$SpatialJoinStrategy$[]{s})), Seq$.MODULE$.canBuildFrom()));
                }
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        });
    }

    private final ZoneId zone$lzycompute$1(ObjectRef zone$lzy$1, Cast x4$1, VolatileByteRef bitmap$0$1) {
        SQLRules$ sQLRules$ = this;
        synchronized (sQLRules$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                zone$lzy$1.elem = (ZoneId)x4$1.timeZoneId().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final ZoneId apply(String x$1) {
                        return ZoneId.of(x$1);
                    }
                }).orNull(Predef$.MODULE$.$conforms());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (ZoneId)zone$lzy$1.elem;
        }
    }

    public final ZoneId org$apache$spark$sql$SQLRules$$zone$1(ObjectRef zone$lzy$1, Cast x4$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.zone$lzycompute$1(zone$lzy$1, x4$1, bitmap$0$1) : (ZoneId)zone$lzy$1.elem;
    }

    private SQLRules$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$apache$spark$sql$SQLRules$$ff = CommonFactoryFinder.getFilterFactory2();
    }
}

