/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SQLTypes$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.geotools.data.DataStore;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.spark.GeoMesaDataSource$;
import org.locationtech.geomesa.spark.GeoMesaRelation$;
import org.locationtech.geomesa.spark.GeoMesaSpark$;
import org.locationtech.geomesa.spark.GeoMesaSparkSQL$;
import org.locationtech.geomesa.spark.SparkUtils;
import org.locationtech.geomesa.spark.SparkUtils$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001-\u0011\u0011cR3p\u001b\u0016\u001c\u0018\rR1uCN{WO]2f\u0015\t\u0019A!A\u0003ta\u0006\u00148N\u0003\u0002\u0006\r\u00059q-Z8nKN\f'BA\u0004\t\u00031awnY1uS>tG/Z2i\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0002\u0001\r%u\u00013E\n\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MYR\"\u0001\u000b\u000b\u0005U1\u0012aB:pkJ\u001cWm\u001d\u0006\u0003/a\t1a]9m\u0015\t\u0019\u0011D\u0003\u0002\u001b\u0011\u00051\u0011\r]1dQ\u0016L!\u0001\b\u000b\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM\u001d\t\u0003'yI!a\b\u000b\u0003!I+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\n\"\u0013\t\u0011CC\u0001\fTG\",W.\u0019*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t\u0019B%\u0003\u0002&)\tI2I]3bi\u0006\u0014G.\u001a*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t9c&D\u0001)\u0015\tI#&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002,Y\u0005AA/\u001f9fg\u00064WMC\u0001.\u0003\r\u0019w.\\\u0005\u0003_!\u00121\u0002T1{s2{wmZ5oO\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"\u0012a\r\t\u0003i\u0001i\u0011A\u0001\u0005\u0006m\u0001!\teN\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\u000f\t\u0003sqr!!\u0004\u001e\n\u0005mr\u0011A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!a\u000f\b\t\u000b\u0001\u0003A\u0011I!\u0002\u001d\r\u0014X-\u0019;f%\u0016d\u0017\r^5p]R\u0019!)R&\u0011\u0005M\u0019\u0015B\u0001#\u0015\u00051\u0011\u0015m]3SK2\fG/[8o\u0011\u00151u\b1\u0001H\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003\u0011&k\u0011AF\u0005\u0003\u0015Z\u0011!bU)M\u0007>tG/\u001a=u\u0011\u0015au\b1\u0001N\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005s9C\u0004(\u0003\u0002P}\t\u0019Q*\u00199\t\u000b\u0001\u0003A\u0011I)\u0015\t\t\u00136\u000b\u0016\u0005\u0006\rB\u0003\ra\u0012\u0005\u0006\u0019B\u0003\r!\u0014\u0005\u0006+B\u0003\rAV\u0001\u0007g\u000eDW-\\1\u0011\u0005]SV\"\u0001-\u000b\u0005e3\u0012!\u0002;za\u0016\u001c\u0018BA.Y\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u0001\u0002!\t%\u0018\u000b\u0006\u0005z{F-\u001a\u0005\u0006\rr\u0003\ra\u0012\u0005\u0006Ar\u0003\r!Y\u0001\u0005[>$W\r\u0005\u0002IE&\u00111M\u0006\u0002\t'\u00064X-T8eK\")A\n\u0018a\u0001\u001b\")a\r\u0018a\u0001O\u0006!A-\u0019;b!\tAgO\u0004\u0002ji:\u0011!n\u001d\b\u0003WJt!\u0001\\9\u000f\u00055\u0004X\"\u00018\u000b\u0005=T\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\tQ\u0002\"\u0003\u0002\u00043%\u0011q\u0003G\u0005\u0003kZ\tq\u0001]1dW\u0006<W-\u0003\u0002xq\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003kZAQA\u001f\u0001\u0005\nm\f!bY8na\u0006$\u0018N\u00197f)\u0011ax0a\u0006\u0011\u00055i\u0018B\u0001@\u000f\u0005\u001d\u0011un\u001c7fC:Dq!!\u0001z\u0001\u0004\t\u0019!A\u0002tMR\u0004B!!\u0002\u0002\u00145\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003\u001b\ty!A\u0004gK\u0006$XO]3\u000b\u0007\u0005E\u0001\"A\u0004pa\u0016tw-[:\n\t\u0005U\u0011q\u0001\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007bBA\rs\u0002\u0007\u00111A\u0001\nI\u0006$\u0018M\u001a:b[\u0016\u0004")
public class GeoMesaDataSource
implements DataSourceRegister,
RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        GeoMesaDataSource geoMesaDataSource = this;
        synchronized (geoMesaDataSource) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String shortName() {
        return "geomesa";
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        SQLTypes$.MODULE$.init(sqlContext);
        return GeoMesaRelation$.MODULE$.apply(sqlContext, parameters);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        return GeoMesaRelation$.MODULE$.apply(sqlContext, parameters, schema);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        String newFeatureName = (String)parameters.apply((Object)GeoMesaSparkSQL$.MODULE$.GEOMESA_SQL_FEATURE());
        SimpleFeatureType sft = SparkUtils$.MODULE$.createFeatureType(newFeatureName, data.schema());
        WithStore$.MODULE$.apply(parameters).apply((Function1)new Serializable(this, newFeatureName, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataSource $outer;
            private final String newFeatureName$1;
            private final SimpleFeatureType sft$1;

            public final void apply(DataStore ds) {
                if (Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames()).contains((Object)this.newFeatureName$1)) {
                    SimpleFeatureType existing = ds.getSchema(this.newFeatureName$1);
                    if (!this.$outer.org$locationtech$geomesa$spark$GeoMesaDataSource$$compatible(existing, this.sft$1)) {
                        throw new IllegalStateException(new StringBuilder().append((Object)"The dataframe is not compatible with the existing schema in the datastore:").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  Dataframe schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$.MODULE$.encodeType(this.sft$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  Datastore schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$.MODULE$.encodeType(existing)}))).toString());
                    }
                } else {
                    this.sft$1.getUserData().put("override.reserved.words", Boolean.TRUE);
                    ds.createSchema((FeatureType)this.sft$1);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newFeatureName$1 = newFeatureName$1;
                this.sft$1 = sft$1;
            }
        });
        StructType structType = data.queryExecution() == null ? SparkUtils$.MODULE$.createStructType(sft) : data.schema();
        RDD rddToSave = data.rdd().mapPartitions((Function1)new Serializable(this, parameters, newFeatureName, structType){
            public static final long serialVersionUID = 0L;
            private final Map parameters$1;
            public final String newFeatureName$1;
            private final StructType structType$1;

            public final Iterator<SimpleFeature> apply(Iterator<Row> partition) {
                SimpleFeatureType sft = (SimpleFeatureType)WithStore$.MODULE$.apply(this.parameters$1).apply((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final SimpleFeatureType apply(DataStore x$1) {
                        return x$1.getSchema(this.$outer.newFeatureName$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                SparkUtils.SimpleFeatureRowMapping mappings = SparkUtils$.MODULE$.rowsToFeatures(sft, this.structType$1);
                return partition.map((Function1)new Serializable(this, mappings){
                    public static final long serialVersionUID = 0L;
                    private final SparkUtils.SimpleFeatureRowMapping mappings$1;

                    /*
                     * WARNING - void declaration
                     */
                    public final SimpleFeature apply(Row row) {
                        void var2_2;
                        SimpleFeature sf = this.mappings$1.apply(row);
                        sf.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
                        return var2_2;
                    }
                    {
                        this.mappings$1 = mappings$1;
                    }
                });
            }
            {
                this.parameters$1 = parameters$1;
                this.newFeatureName$1 = newFeatureName$1;
                this.structType$1 = structType$1;
            }
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(SimpleFeature.class));
        GeoMesaSpark$.MODULE$.apply((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(parameters).asJava()).save(rddToSave, parameters, newFeatureName);
        return GeoMesaRelation$.MODULE$.apply(sqlContext, parameters, data.schema(), sft);
    }

    public boolean org$locationtech$geomesa$spark$GeoMesaDataSource$$compatible(SimpleFeatureType sft, SimpleFeatureType dataframe) {
        return sft.getAttributeCount() == dataframe.getAttributeCount() && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).forall((Function1)new Serializable(this, dataframe){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType dataframe$1;

            public final boolean apply(AttributeDescriptor ad) {
                AttributeDescriptor df = this.dataframe$1.getDescriptor(ad.getLocalName());
                return df != null && ad.getType().getBinding().isAssignableFrom(df.getType().getBinding());
            }
            {
                this.dataframe$1 = dataframe$1;
            }
        });
    }

    public GeoMesaDataSource() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

