/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Collections;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.memory.cqengine.GeoCQEngine;
import org.locationtech.geomesa.memory.cqengine.datastore.GeoCQEngineDataStore;
import org.locationtech.geomesa.spark.GeoMesaRelation;
import org.locationtech.geomesa.spark.GeoMesaSpark$;
import org.locationtech.geomesa.spark.GeoMesaSparkSQL$;
import org.locationtech.geomesa.spark.RelationUtils$;
import org.locationtech.geomesa.spark.SparkUtils$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.jts.util.WKTUtils$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public final class GeoMesaRelation$
implements LazyLogging,
Serializable {
    public static final GeoMesaRelation$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GeoMesaRelation$();
    }

    private Logger logger$lzycompute() {
        GeoMesaRelation$ geoMesaRelation$ = this;
        synchronized (geoMesaRelation$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public GeoMesaRelation apply(SQLContext sqlContext, scala.collection.immutable.Map<String, String> params) {
        String name = (String)params.getOrElse((Object)GeoMesaSparkSQL$.MODULE$.GEOMESA_SQL_FEATURE(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature type must be specified with '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GeoMesaSparkSQL$.MODULE$.GEOMESA_SQL_FEATURE()})));
            }
        });
        SimpleFeatureType sft = (SimpleFeatureType)GeoMesaSpark$.MODULE$.apply((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava()).sft(params, name).getOrElse((Function0)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load feature type with name '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
            }
            {
                this.name$1 = name$1;
            }
        });
        return this.apply(sqlContext, params, SparkUtils$.MODULE$.createStructType(sft), sft);
    }

    public GeoMesaRelation apply(SQLContext sqlContext, scala.collection.immutable.Map<String, String> params, StructType schema) {
        String name = (String)params.getOrElse((Object)GeoMesaSparkSQL$.MODULE$.GEOMESA_SQL_FEATURE(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature type must be specified with '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GeoMesaSparkSQL$.MODULE$.GEOMESA_SQL_FEATURE()})));
            }
        });
        SimpleFeatureType sft = (SimpleFeatureType)GeoMesaSpark$.MODULE$.apply((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava()).sft(params, name).getOrElse((Function0)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$2;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load feature type with name '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2})));
            }
            {
                this.name$2 = name$2;
            }
        });
        return this.apply(sqlContext, params, schema, sft);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeoMesaRelation apply(SQLContext sqlContext, scala.collection.immutable.Map<String, String> params, StructType schema, SimpleFeatureType sft) {
        None$ none$;
        None$ partitioned;
        None$ none$2;
        BoxedUnit boxedUnit;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Creating GeoMesaRelation with sft: {}", new Object[]{sft});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (BoxesRunTime.unboxToBoolean((Object)this.get$1("spatial", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toBoolean();
            }
        }, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, params))) {
            List<Envelope> list;
            Envelope envelope;
            IntRef sampleSize$lzy = IntRef.zero();
            DoubleRef threshold$lzy = DoubleRef.zero();
            SpatialRDD raw = this.rawRDD$1(sqlContext, params, sft);
            Option option = params.get((Object)"bounds");
            if (None$.MODULE$.equals(option)) {
                envelope = RelationUtils$.MODULE$.getBound((RDD<SimpleFeature>)raw);
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                String b = (String)some.x();
                envelope = this.liftedTree1$1(b);
            }
            Envelope bounds = envelope;
            Option partitions = Option$.MODULE$.apply(this.get$1("partitions", (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$6) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$6)).toInt();
                }
            }, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return -1;
                }
            }, params)).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(int x$7) {
                    return this.apply$mcZI$sp(x$7);
                }

                public boolean apply$mcZI$sp(int x$7) {
                    return x$7 > 0;
                }
            });
            int parallelism = BoxesRunTime.unboxToInt((Object)partitions.getOrElse((Function0)new Serializable(sqlContext){
                public static final long serialVersionUID = 0L;
                private final SQLContext sqlContext$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.sqlContext$1.sparkContext().defaultParallelism();
                }
                {
                    this.sqlContext$1 = sqlContext$1;
                }
            }));
            String string = ((String)params.getOrElse((Object)"strategy", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "equal";
                }
            })).toLowerCase(Locale.US);
            if ("equal".equals(string)) {
                list = RelationUtils$.MODULE$.equalPartitioning(bounds, parallelism);
            } else if ("earth".equals(string)) {
                list = RelationUtils$.MODULE$.wholeEarthPartitioning(parallelism);
            } else if ("weighted".equals(string)) {
                list = RelationUtils$.MODULE$.weightedPartitioning((RDD<SimpleFeature>)raw, bounds, parallelism, this.sampleSize$1(params, sampleSize$lzy, bitmap$0));
            } else {
                if (!"rtree".equals(string)) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid partitioning strategy: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
                list = RelationUtils$.MODULE$.rtreePartitioning((RDD<SimpleFeature>)raw, parallelism, this.sampleSize$1(params, sampleSize$lzy, bitmap$0), this.threshold$1(params, threshold$lzy, bitmap$0));
            }
            List<Envelope> envelopes = list;
            RDD<Tuple2<Object, Iterable<SimpleFeature>>> rdd = RelationUtils$.MODULE$.grid(raw, envelopes, parallelism);
            rdd.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
            none$2 = new Some((Object)new GeoMesaRelation.PartitionedRDD(rdd, raw, envelopes, (Option<Object>)partitions, BoxesRunTime.unboxToBoolean((Object)this.get$1("cover", (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$10) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
                }
            }, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }, params))));
        } else {
            none$2 = partitioned = None$.MODULE$;
        }
        if (BoxesRunTime.unboxToBoolean((Object)this.get$1("cache", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$11) {
                return new StringOps(Predef$.MODULE$.augmentString(x$11)).toBoolean();
            }
        }, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, params))) {
            Some some;
            java.util.Map<String, String> check = Collections.singletonMap("cqengine", "true");
            if (!((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(DataStoreFinder.getAvailableDataStores()).asScala()).exists((Function1)new Serializable(check){
                public static final long serialVersionUID = 0L;
                private final java.util.Map check$1;

                public final boolean apply(DataStoreFactorySpi x$12) {
                    return x$12.canProcess(this.check$1);
                }
                {
                    this.check$1 = check$1;
                }
            })) throw new IllegalArgumentException("Caching requires the GeoCQEngineDataStore to be available on the classpath");
            String typeName = sft.getTypeName();
            String encodedSft = SimpleFeatureTypes$.MODULE$.encodeType(sft, true);
            boolean indexGeom = BoxesRunTime.unboxToBoolean((Object)this.get$1("indexGeom", (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$13) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$13)).toBoolean();
                }
            }, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }, params));
            None$ none$3 = partitioned;
            if (none$3 instanceof Some) {
                Some some2 = (Some)none$3;
                GeoMesaRelation.PartitionedRDD p = (GeoMesaRelation.PartitionedRDD)some2.x();
                RDD rdd = RDD$.MODULE$.rddToPairRDDFunctions(p.rdd(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)new Serializable(typeName, encodedSft, indexGeom){
                    public static final long serialVersionUID = 0L;
                    private final String typeName$2;
                    private final String encodedSft$1;
                    private final boolean indexGeom$1;

                    /*
                     * WARNING - void declaration
                     */
                    public final GeoCQEngineDataStore apply(Iterable<SimpleFeature> iter) {
                        void var2_2;
                        GeoCQEngineDataStore engine = new GeoCQEngineDataStore(this.indexGeom$1);
                        engine.createSchema(SimpleFeatureTypes$.MODULE$.createType(this.typeName$2, this.encodedSft$1));
                        ((GeoCQEngine)engine.namesToEngine().get(this.typeName$2)).insert(iter);
                        return var2_2;
                    }
                    {
                        this.typeName$2 = typeName$2;
                        this.encodedSft$1 = encodedSft$1;
                        this.indexGeom$1 = indexGeom$1;
                    }
                });
                p.rdd().unpersist(p.rdd().unpersist$default$1());
                rdd.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
                some = new Some((Object)new GeoMesaRelation.PartitionedIndexedRDD((RDD<Tuple2<Object, GeoCQEngineDataStore>>)rdd, p.envelopes()));
            } else {
                if (!None$.MODULE$.equals(none$3)) throw new MatchError((Object)none$3);
                SpatialRDD qual$1 = this.rawRDD$1(sqlContext, params, sft);
                Serializable x$23 = new Serializable(typeName, encodedSft, indexGeom){
                    public static final long serialVersionUID = 0L;
                    private final String typeName$2;
                    private final String encodedSft$1;
                    private final boolean indexGeom$1;

                    public final Iterator<GeoCQEngineDataStore> apply(Iterator<SimpleFeature> iter) {
                        GeoCQEngineDataStore engine = new GeoCQEngineDataStore(this.indexGeom$1);
                        engine.createSchema(SimpleFeatureTypes$.MODULE$.createType(this.typeName$2, this.encodedSft$1));
                        ((GeoCQEngine)engine.namesToEngine().get(this.typeName$2)).insert((Iterable)iter.toList());
                        return Iterator$.MODULE$.single((Object)engine);
                    }
                    {
                        this.typeName$2 = typeName$2;
                        this.encodedSft$1 = encodedSft$1;
                        this.indexGeom$1 = indexGeom$1;
                    }
                };
                boolean x$24 = qual$1.mapPartitions$default$2();
                RDD rdd = qual$1.mapPartitions((Function1)x$23, x$24, ClassTag$.MODULE$.apply(GeoCQEngineDataStore.class));
                rdd.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
                some = new Some((Object)new GeoMesaRelation.IndexedRDD((RDD<GeoCQEngineDataStore>)rdd));
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        None$ cached = none$;
        return new GeoMesaRelation(sqlContext, sft, schema, params, (Option<Filter>)None$.MODULE$, (Option<GeoMesaRelation.CachedRDD>)cached, (Option<GeoMesaRelation.PartitionedRDD>)partitioned);
    }

    public GeoMesaRelation apply(SQLContext sqlContext, SimpleFeatureType sft, StructType schema, scala.collection.immutable.Map<String, String> params, Option<Filter> filter, Option<GeoMesaRelation.CachedRDD> cached, Option<GeoMesaRelation.PartitionedRDD> partitioned) {
        return new GeoMesaRelation(sqlContext, sft, schema, params, filter, cached, partitioned);
    }

    public Option<Tuple7<SQLContext, SimpleFeatureType, StructType, scala.collection.immutable.Map<String, String>, Option<Filter>, Option<GeoMesaRelation.CachedRDD>, Option<GeoMesaRelation.PartitionedRDD>>> unapply(GeoMesaRelation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.sqlContext(), (Object)x$0.sft(), (Object)x$0.schema(), x$0.params(), x$0.filter(), x$0.cached(), x$0.partitioned()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object get$1(String key, Function1 transform, Function0 function0, scala.collection.immutable.Map params$1) {
        Object object;
        Option option = params$1.get((Object)key);
        if (None$.MODULE$.equals(option)) {
            return function0.apply();
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some = (Some)option;
        String v = (String)some.x();
        try {
            object = transform.apply((Object)v);
            return object;
        }
        catch (Throwable throwable) {
            Object object3;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error evaluating param '", "' with value '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, v})), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            object = object3 = function0.apply();
        }
        return object;
    }

    private final SpatialRDD rawRDD$1(SQLContext sqlContext$1, scala.collection.immutable.Map params$1, SimpleFeatureType sft$1) {
        Query query = new Query(sft$1.getTypeName(), ECQL.toFilter((String)((String)params$1.getOrElse((Object)"query", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "INCLUDE";
            }
        }))));
        return GeoMesaSpark$.MODULE$.apply((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)params$1).asJava()).rdd(new Configuration(), sqlContext$1.sparkContext(), params$1, query);
    }

    private final Envelope liftedTree1$1(String b$1) {
        try {
            return WKTUtils$.MODULE$.read(b$1).getEnvelopeInternal();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading provided bounds '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{b$1})), e);
        }
    }

    private final int sampleSize$lzycompute$1(scala.collection.immutable.Map params$1, IntRef sampleSize$lzy$1, VolatileByteRef bitmap$0$2) {
        GeoMesaRelation$ geoMesaRelation$ = this;
        synchronized (geoMesaRelation$) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                sampleSize$lzy$1.elem = BoxesRunTime.unboxToInt((Object)this.get$1("sampleSize", (Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$8) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
                    }
                }, (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 100;
                    }
                }, params$1));
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return sampleSize$lzy$1.elem;
        }
    }

    private final int sampleSize$1(scala.collection.immutable.Map params$1, IntRef sampleSize$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? this.sampleSize$lzycompute$1(params$1, sampleSize$lzy$1, bitmap$0$2) : sampleSize$lzy$1.elem;
    }

    private final double threshold$lzycompute$1(scala.collection.immutable.Map params$1, DoubleRef threshold$lzy$1, VolatileByteRef bitmap$0$2) {
        GeoMesaRelation$ geoMesaRelation$ = this;
        synchronized (geoMesaRelation$) {
            if ((byte)(bitmap$0$2.elem & 2) == 0) {
                threshold$lzy$1.elem = BoxesRunTime.unboxToDouble((Object)this.get$1("threshold", (Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$9) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toDouble();
                    }
                }, (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 0.3;
                    }
                }, params$1));
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 2);
            }
            return threshold$lzy$1.elem;
        }
    }

    private final double threshold$1(scala.collection.immutable.Map params$1, DoubleRef threshold$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 2) == 0 ? this.threshold$lzycompute$1(params$1, threshold$lzy$1, bitmap$0$2) : threshold$lzy$1.elem;
    }

    private GeoMesaRelation$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

