/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark;

import org.apache.spark.sql.SQLContext;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.geomesa.spark.GeometricDistanceFunctions$;
import org.locationtech.geomesa.spark.jts.util.SQLFunctionHelper$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class GeometricDistanceFunctions$ {
    public static final GeometricDistanceFunctions$ MODULE$;
    private final Function2<Geometry, Geometry, Double> ST_DistanceSpheroid;
    private final Function1<Seq<Geometry>, Double> ST_AggregateDistanceSpheroid;
    private final Function1<LineString, Double> ST_LengthSpheroid;
    private final Function3<Geometry, String, String, Geometry> ST_Transform;
    private final Map<Object, String> distanceNames;
    private final transient ThreadLocal<GeodeticCalculator> geoCalcs;

    static {
        new GeometricDistanceFunctions$();
    }

    public Function2<Geometry, Geometry, Double> ST_DistanceSpheroid() {
        return this.ST_DistanceSpheroid;
    }

    public Function1<Seq<Geometry>, Double> ST_AggregateDistanceSpheroid() {
        return this.ST_AggregateDistanceSpheroid;
    }

    public Function1<LineString, Double> ST_LengthSpheroid() {
        return this.ST_LengthSpheroid;
    }

    public Function3<Geometry, String, String, Geometry> ST_Transform() {
        return this.ST_Transform;
    }

    public Map<Object, String> distanceNames() {
        return this.distanceNames;
    }

    public void registerFunctions(SQLContext sqlContext) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Double").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator1$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator2$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator3$1() {
            }
        }
        sqlContext.udf().register((String)this.distanceNames().apply(this.ST_DistanceSpheroid()), this.ST_DistanceSpheroid(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator2$1()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator3$1()));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Double").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator4$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor()})));
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator5$1() {
            }
        }
        sqlContext.udf().register((String)this.distanceNames().apply(this.ST_AggregateDistanceSpheroid()), this.ST_AggregateDistanceSpheroid(), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator4$1()), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator5$1()));
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Double").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator6$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.LineString").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator7$1() {
            }
        }
        sqlContext.udf().register((String)this.distanceNames().apply(this.ST_LengthSpheroid()), this.ST_LengthSpheroid(), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator6$1()), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator7$1()));
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u9 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m9 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u10 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m10 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u11 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m11 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator8$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator9$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator10$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator11$1() {
            }
        }
        sqlContext.udf().register((String)this.distanceNames().apply(this.ST_Transform()), this.ST_Transform(), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator8$1()), ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator9$1()), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator10$1()), ((TypeTags)$u11).TypeTag().apply((Mirror)$m11, (TypeCreator)new Org_locationtech_geomesa_spark_GeometricDistanceFunctions$$typecreator11$1()));
    }

    private ThreadLocal<GeodeticCalculator> geoCalcs() {
        return this.geoCalcs;
    }

    public double fastDistance(Coordinate c1, Coordinate c2) {
        GeodeticCalculator calc = this.geoCalcs().get();
        calc.setStartingGeographicPoint(c1.x, c1.y);
        calc.setDestinationGeographicPoint(c2.x, c2.y);
        return calc.getOrthodromicDistance();
    }

    private GeometricDistanceFunctions$() {
        MODULE$ = this;
        this.ST_DistanceSpheroid = SQLFunctionHelper$.MODULE$.nullableUDF((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Double apply(Geometry s, Geometry e) {
                return Predef$.MODULE$.double2Double(GeometricDistanceFunctions$.MODULE$.fastDistance(s.getCoordinate(), e.getCoordinate()));
            }
        });
        this.ST_AggregateDistanceSpheroid = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Double apply(Seq<Geometry> a) {
                return (Double)GeometricDistanceFunctions$.MODULE$.ST_DistanceSpheroid().apply(a.apply(0), a.apply(1));
            }
        };
        this.ST_LengthSpheroid = SQLFunctionHelper$.MODULE$.nullableUDF((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Double apply(LineString line) {
                return Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.refArrayOps((Object[])line.getCoordinates()).sliding(2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Coordinate[] x0$1) {
                        Coordinate[] coordinateArray = x0$1;
                        Option option = Array$.MODULE$.unapplySeq((Object)coordinateArray);
                        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                            Coordinate l = (Coordinate)((SeqLike)option.get()).apply(0);
                            Coordinate r = (Coordinate)((SeqLike)option.get()).apply(1);
                            double d = GeometricDistanceFunctions$.MODULE$.fastDistance(l, r);
                            return d;
                        }
                        throw new MatchError((Object)coordinateArray);
                    }
                }).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
            }
        });
        this.ST_Transform = SQLFunctionHelper$.MODULE$.nullableUDF((Function3)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Geometry apply(Geometry geometry, String fromCRSCode, String toCRSCode) {
                GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
                CoordinateReferenceSystem fromCode = CRS.decode((String)fromCRSCode, (boolean)true);
                CoordinateReferenceSystem toCode = CRS.decode((String)toCRSCode, (boolean)true);
                transformer.setMathTransform(CRS.findMathTransform((CoordinateReferenceSystem)fromCode, (CoordinateReferenceSystem)toCode, (boolean)true));
                return transformer.transform(geometry);
            }
        });
        this.distanceNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ST_DistanceSpheroid()), (Object)"st_distanceSpheroid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ST_AggregateDistanceSpheroid()), (Object)"st_aggregateDistanceSpheroid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ST_LengthSpheroid()), (Object)"st_lengthSpheroid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ST_Transform()), (Object)"st_transform")}));
        this.geoCalcs = new ThreadLocal<GeodeticCalculator>(){

            public GeodeticCalculator initialValue() {
                return new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
        };
    }
}

