/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.ArrayList;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.IndexPartitioner;
import org.geotools.factory.CommonFactoryFinder;
import org.locationtech.geomesa.spark.RelationUtils$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory2;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class RelationUtils$
implements LazyLogging {
    public static final RelationUtils$ MODULE$;
    private final transient FilterFactory2 ff;
    private final Ordering<Coordinate> CoordinateOrdering;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new RelationUtils$();
    }

    private Logger logger$lzycompute() {
        RelationUtils$ relationUtils$ = this;
        synchronized (relationUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public FilterFactory2 ff() {
        return this.ff;
    }

    public Ordering<Coordinate> CoordinateOrdering() {
        return this.CoordinateOrdering;
    }

    public RDD<Tuple2<Object, Iterable<SimpleFeature>>> grid(SpatialRDD rdd, List<Envelope> envelopes, int parallelism) {
        int geom = rdd.schema().indexOf(rdd.schema().getGeometryDescriptor().getLocalName());
        return RDD$.MODULE$.rddToPairRDDFunctions(rdd.flatMap((Function1)new Serializable(envelopes, geom){
            public static final long serialVersionUID = 0L;
            private final List envelopes$3;
            private final int geom$2;

            public final List<Tuple2<Object, SimpleFeature>> apply(SimpleFeature x$2) {
                return RelationUtils$.MODULE$.gridIdMapper(x$2, (List<Envelope>)this.envelopes$3, this.geom$2);
            }
            {
                this.envelopes$3 = envelopes$3;
                this.geom$2 = geom$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(SimpleFeature.class), (Ordering)Ordering.Int$.MODULE$).groupByKey((Partitioner)new IndexPartitioner(parallelism));
    }

    public List<Tuple2<Object, SimpleFeature>> gridIdMapper(SimpleFeature sf, List<Envelope> envelopes, int geometryOrdinal) {
        Geometry geom = (Geometry)sf.getAttribute(geometryOrdinal);
        IndexedSeq mappings = (IndexedSeq)envelopes.indices().flatMap((Function1)new Serializable(sf, envelopes, geom){
            public static final long serialVersionUID = 0L;
            private final SimpleFeature sf$1;
            private final List envelopes$2;
            private final Geometry geom$3;

            public final Iterable<Tuple2<Object, SimpleFeature>> apply(int index) {
                return ((Envelope)this.envelopes$2.apply(index)).intersects(this.geom$3.getEnvelopeInternal()) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)this.sf$1))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            {
                this.sf$1 = sf$1;
                this.envelopes$2 = envelopes$2;
                this.geom$3 = geom$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return mappings.isEmpty() ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)sf)})) : mappings.toList();
    }

    public List<Object> gridIdMapper(Geometry geom, List<Envelope> envelopes) {
        IndexedSeq mappings = (IndexedSeq)envelopes.indices().flatMap((Function1)new Serializable(geom, envelopes){
            public static final long serialVersionUID = 0L;
            private final Geometry geom$1;
            private final List envelopes$1;

            public final Iterable<Object> apply(int index) {
                return ((Envelope)this.envelopes$1.apply(index)).intersects(this.geom$1.getEnvelopeInternal()) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToInteger((int)index))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            {
                this.geom$1 = geom$1;
                this.envelopes$1 = envelopes$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return mappings.isEmpty() ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1})) : mappings.toList();
    }

    public Envelope getBound(RDD<SimpleFeature> rdd) {
        return (Envelope)rdd.aggregate((Object)new Envelope(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Envelope apply(Envelope env, SimpleFeature sf) {
                env.expandToInclude(((Geometry)sf.getDefaultGeometry()).getEnvelopeInternal());
                return env;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Envelope apply(Envelope env1, Envelope env2) {
                env1.expandToInclude(env2);
                return env1;
            }
        }, ClassTag$.MODULE$.apply(Envelope.class));
    }

    public List<Envelope> equalPartitioning(Envelope bound, int numPartitions) {
        int partitionsPerDim = (int)Math.sqrt(numPartitions);
        double partitionWidth = bound.getWidth() / (double)partitionsPerDim;
        double partitionHeight = bound.getHeight() / (double)partitionsPerDim;
        double minX = bound.getMinX();
        double minY = bound.getMinY();
        ListBuffer partitionEnvelopes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionsPerDim).foreach$mVc$sp((Function1)new Serializable(partitionsPerDim, partitionWidth, partitionHeight, minX, minY, partitionEnvelopes){
            public static final long serialVersionUID = 0L;
            private final int partitionsPerDim$1;
            private final double partitionWidth$1;
            public final double partitionHeight$1;
            private final double minX$1;
            public final double minY$1;
            public final ListBuffer partitionEnvelopes$1;

            public final void apply(int xIndex) {
                this.apply$mcVI$sp(xIndex);
            }

            public void apply$mcVI$sp(int xIndex) {
                double xPartitionStart = this.minX$1 + (double)xIndex * this.partitionWidth$1;
                double xPartitionEnd = xPartitionStart + this.partitionWidth$1;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitionsPerDim$1).foreach((Function1)new Serializable(this, xPartitionStart, xPartitionEnd){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.equalPartitioning.1 $outer;
                    private final double xPartitionStart$1;
                    private final double xPartitionEnd$1;

                    public final ListBuffer<Envelope> apply(int yIndex) {
                        double yPartitionStart = this.$outer.minY$1 + (double)yIndex * this.$outer.partitionHeight$1;
                        double yPartitionEnd = yPartitionStart + this.$outer.partitionHeight$1;
                        return this.$outer.partitionEnvelopes$1.$plus$eq((Object)new Envelope(this.xPartitionStart$1, this.xPartitionEnd$1, yPartitionStart, yPartitionEnd));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.xPartitionStart$1 = xPartitionStart$1;
                        this.xPartitionEnd$1 = xPartitionEnd$1;
                    }
                });
            }
            {
                this.partitionsPerDim$1 = partitionsPerDim$1;
                this.partitionWidth$1 = partitionWidth$1;
                this.partitionHeight$1 = partitionHeight$1;
                this.minX$1 = minX$1;
                this.minY$1 = minY$1;
                this.partitionEnvelopes$1 = partitionEnvelopes$1;
            }
        });
        return partitionEnvelopes.toList();
    }

    public List<Envelope> weightedPartitioning(RDD<SimpleFeature> rawRDD, Envelope bound, int numPartitions, int sampleSize2) {
        List list;
        int width = (int)Math.sqrt(numPartitions);
        SimpleFeature[] sample = (SimpleFeature[])rawRDD.takeSample(false, sampleSize2, rawRDD.takeSample$default$3());
        int binSize = sample.length / width;
        if (binSize > 0) {
            double[] xSample = (double[])Predef$.MODULE$.refArrayOps((Object[])sample).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(SimpleFeature f) {
                    return ((Coordinate)Predef$.MODULE$.refArrayOps((Object[])((Object[])((Geometry)f.getDefaultGeometry()).getCoordinates())).min(RelationUtils$.MODULE$.CoordinateOrdering())).x;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] ySample = (double[])Predef$.MODULE$.refArrayOps((Object[])sample).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(SimpleFeature f) {
                    return ((Coordinate)Predef$.MODULE$.refArrayOps((Object[])((Object[])((Geometry)f.getDefaultGeometry()).getCoordinates())).min(RelationUtils$.MODULE$.CoordinateOrdering())).y;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] xSorted = (double[])Predef$.MODULE$.doubleArrayOps(xSample).sorted((Ordering)Ordering.Double$.MODULE$);
            double[] ySorted = (double[])Predef$.MODULE$.doubleArrayOps(ySample).sorted((Ordering)Ordering.Double$.MODULE$);
            ListBuffer partitionEnvelopes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)new Serializable(width, binSize, xSorted, ySorted, partitionEnvelopes){
                public static final long serialVersionUID = 0L;
                private final int width$1;
                public final int binSize$1;
                private final double[] xSorted$1;
                public final double[] ySorted$1;
                public final ListBuffer partitionEnvelopes$2;

                public final void apply(int xBin) {
                    this.apply$mcVI$sp(xBin);
                }

                public void apply$mcVI$sp(int xBin) {
                    double minX = this.xSorted$1[xBin * this.binSize$1];
                    double maxX = this.xSorted$1[scala.math.package$.MODULE$.min((xBin + 1) * this.binSize$1, this.xSorted$1.length - 1)];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.width$1).foreach((Function1)new Serializable(this, minX, maxX){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.weightedPartitioning.1 $outer;
                        private final double minX$2;
                        private final double maxX$1;

                        public final ListBuffer<Envelope> apply(int yBin) {
                            double minY = this.$outer.ySorted$1[yBin * this.$outer.binSize$1];
                            double maxY = this.$outer.ySorted$1[scala.math.package$.MODULE$.min((yBin + 1) * this.$outer.binSize$1, this.$outer.ySorted$1.length - 1)];
                            return this.$outer.partitionEnvelopes$2.$plus$eq((Object)new Envelope(this.minX$2, this.maxX$1, minY, maxY));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.minX$2 = minX$2;
                            this.maxX$1 = maxX$1;
                        }
                    });
                }
                {
                    this.width$1 = width$1;
                    this.binSize$1 = binSize$1;
                    this.xSorted$1 = xSorted$1;
                    this.ySorted$1 = ySorted$1;
                    this.partitionEnvelopes$2 = partitionEnvelopes$2;
                }
            });
            list = partitionEnvelopes.toList();
        } else {
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Envelope[]{bound}));
        }
        return list;
    }

    public List<Envelope> wholeEarthPartitioning(int numPartitions) {
        return this.equalPartitioning(new Envelope(-180.0, 180.0, -90.0, 90.0), numPartitions);
    }

    public List<Envelope> rtreePartitioning(RDD<SimpleFeature> rawRDD, int numPartitions, int sampleSize2, double thresholdMultiplier) {
        SimpleFeature[] sample = (SimpleFeature[])rawRDD.takeSample(false, sampleSize2, rawRDD.takeSample$default$3());
        STRtree rtree = new STRtree();
        Predef$.MODULE$.refArrayOps((Object[])sample).foreach((Function1)new Serializable(rtree){
            public static final long serialVersionUID = 0L;
            private final STRtree rtree$1;

            public final void apply(SimpleFeature sf) {
                this.rtree$1.insert(((Geometry)sf.getDefaultGeometry()).getEnvelopeInternal(), (Object)sf);
            }
            {
                this.rtree$1 = rtree$1;
            }
        });
        ArrayList<Envelope> envelopes = new ArrayList<Envelope>();
        int reasonableSize = sampleSize2 / numPartitions;
        int threshold2 = (int)((double)reasonableSize * thresholdMultiplier);
        int minSize = reasonableSize - threshold2;
        int maxSize = reasonableSize + threshold2;
        rtree.build();
        this.queryBoundary(rtree.getRoot(), envelopes, minSize, maxSize);
        return ((TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(envelopes).asScala()).take(numPartitions - 1)).toList();
    }

    public int queryBoundary(AbstractNode node, java.util.List<Envelope> boundaries, int minSize, int maxSize) {
        int n;
        java.util.List childBoundables = node.getChildBoundables();
        boolean flagLeafnode = true;
        for (int i = 0; i < childBoundables.size() && flagLeafnode; ++i) {
            Boundable childBoundable = (Boundable)childBoundables.get(i);
            if (!(childBoundable instanceof AbstractNode)) continue;
            flagLeafnode = false;
        }
        if (flagLeafnode) {
            n = childBoundables.size();
        } else {
            IntRef nodeCount = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), childBoundables.size()).foreach$mVc$sp((Function1)new Serializable(node, boundaries, minSize, maxSize, childBoundables, nodeCount){
                public static final long serialVersionUID = 0L;
                private final AbstractNode node$1;
                public final java.util.List boundaries$1;
                private final int minSize$1;
                private final int maxSize$1;
                private final java.util.List childBoundables$1;
                private final IntRef nodeCount$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Boundable childBoundable = (Boundable)this.childBoundables$1.get(i);
                    Boundable boundable = childBoundable;
                    if (boundable instanceof AbstractNode) {
                        Object object;
                        AbstractNode abstractNode = (AbstractNode)boundable;
                        int childSize = RelationUtils$.MODULE$.queryBoundary(abstractNode, this.boundaries$1, this.minSize$1, this.maxSize$1);
                        if (childSize < this.maxSize$1 && childSize > this.minSize$1) {
                            BooleanRef alreadyAdded = BooleanRef.create((boolean)false);
                            if (this.node$1.getLevel() != 1) {
                                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(abstractNode.getChildBoundables()).asScala()).foreach((Function1)new Serializable(this, alreadyAdded){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.queryBoundary.1 $outer;
                                    private final BooleanRef alreadyAdded$1;

                                    public final void apply(AbstractNode c) {
                                        this.alreadyAdded$1.elem = this.alreadyAdded$1.elem || this.$outer.boundaries$1.contains((Envelope)c.getBounds());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.alreadyAdded$1 = alreadyAdded$1;
                                    }
                                });
                            }
                            object = alreadyAdded.elem ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.boundaries$1.add((Envelope)abstractNode.getBounds()));
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        this.nodeCount$1.elem += childSize;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        ++this.nodeCount$1.elem;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    this.node$1 = node$1;
                    this.boundaries$1 = boundaries$1;
                    this.minSize$1 = minSize$1;
                    this.maxSize$1 = maxSize$1;
                    this.childBoundables$1 = childBoundables$1;
                    this.nodeCount$1 = nodeCount$1;
                }
            });
            n = nodeCount.elem;
        }
        return n;
    }

    private RelationUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ff = CommonFactoryFinder.getFilterFactory2();
        this.CoordinateOrdering = package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Coordinate x$1) {
                return x$1.x;
            }
        }, (Ordering)Ordering.Double$.MODULE$);
    }
}

