/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.jts.GeometryCollectionUDT;
import org.apache.spark.sql.jts.GeometryUDT;
import org.apache.spark.sql.jts.JTSTypes$;
import org.apache.spark.sql.jts.LineStringUDT;
import org.apache.spark.sql.jts.MultiLineStringUDT;
import org.apache.spark.sql.jts.MultiPointUDT;
import org.apache.spark.sql.jts.MultiPolygonUDT;
import org.apache.spark.sql.jts.PointUDT;
import org.apache.spark.sql.jts.PolygonUDT;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.spark.SparkUtils;
import org.locationtech.geomesa.spark.SparkUtils$$anonfun$getExtractors$1$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec;
import org.locationtech.geomesa.utils.uuid.TimeSortedUuidGenerator$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkUtils$
implements LazyLogging {
    public static final SparkUtils$ MODULE$;
    private final transient FilterFactory2 ff;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SparkUtils$();
    }

    private Logger logger$lzycompute() {
        SparkUtils$ sparkUtils$ = this;
        synchronized (sparkUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public FilterFactory2 ff() {
        return this.ff;
    }

    public Function1<SimpleFeature, Object>[] getExtractors(String[] requiredColumns, StructType schema) {
        String[] requiredAttributes = (String[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                String string = x$1;
                String string2 = "__fid__";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        Serializable IdExtractor = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(SimpleFeature sf) {
                return sf.getID();
            }
        };
        return (Function1[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(schema, requiredAttributes, (Function1)IdExtractor){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;
            private final String[] requiredAttributes$1;
            private final Function1 IdExtractor$1;

            public final Function1<SimpleFeature, Object> apply(String x0$1) {
                Object object;
                String string = x0$1;
                if ("__fid__".equals(string)) {
                    object = this.IdExtractor$1;
                } else {
                    Object object2;
                    int index = Predef$.MODULE$.refArrayOps((Object[])this.requiredAttributes$1).indexOf((Object)string);
                    int schemaIndex = this.schema$2.fieldIndex(string);
                    DataType fieldType = this.schema$2.fields()[schemaIndex].dataType();
                    DataType dataType = fieldType;
                    if (dataType instanceof TimestampType) {
                        object2 = new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;

                            public final Timestamp apply(SimpleFeature sf) {
                                Object attr = sf.getAttribute(this.index$1);
                                return attr == null ? null : new Timestamp(((Date)attr).getTime());
                            }
                            {
                                this.index$1 = index$1;
                            }
                        };
                    } else if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType elementType = arrayType.elementType();
                        object2 = new Serializable(this, index, elementType){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;
                            private final DataType elementType$1;

                            public final List<Object> apply(SimpleFeature sf) {
                                List list;
                                Object attr = sf.getAttribute(this.index$1);
                                if (attr == null) {
                                    list = null;
                                } else {
                                    List array = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)attr).asScala()).toList();
                                    DataType dataType = this.elementType$1;
                                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                    list = !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null) ? (List)array.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Timestamp apply(Object d) {
                                            return new Timestamp(((Date)d).getTime());
                                        }
                                    }, List$.MODULE$.canBuildFrom()) : array;
                                }
                                return list;
                            }
                            {
                                this.index$1 = index$1;
                                this.elementType$1 = elementType$1;
                            }
                        };
                    } else if (dataType instanceof MapType) {
                        MapType mapType = (MapType)dataType;
                        DataType keyType = mapType.keyType();
                        DataType valueType = mapType.valueType();
                        object2 = new Serializable(this, index, keyType, valueType){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;
                            public final DataType keyType$1;
                            public final DataType valueType$1;

                            /*
                             * Enabled aggressive block sorting
                             */
                            public final scala.collection.immutable.Map<? super Object, Object> apply(SimpleFeature sf) {
                                scala.collection.immutable.Map map;
                                scala.collection.immutable.Map map2;
                                block5: {
                                    block4: {
                                        Object attr = sf.getAttribute(this.index$1);
                                        if (attr == null) {
                                            return null;
                                        }
                                        map2 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)attr).asScala()).toMap(Predef$.MODULE$.$conforms());
                                        DataType dataType = this.keyType$1;
                                        TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                        if (!(dataType == null ? timestampType$ != null : !dataType.equals(timestampType$))) break block4;
                                        DataType dataType2 = this.valueType$1;
                                        TimestampType$ timestampType$2 = TimestampType$.MODULE$;
                                        if (dataType2 != null ? !dataType2.equals(timestampType$2) : timestampType$2 != null) break block5;
                                    }
                                    map = (scala.collection.immutable.Map)map2.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$getExtractors$1$$anonfun$apply$4 $outer;

                                        public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$2) {
                                            Tuple2<Object, Object> tuple2 = x0$2;
                                            if (tuple2 != null) {
                                                Object key = tuple2._1();
                                                Object value = tuple2._2();
                                                DataType dataType = this.$outer.keyType$1;
                                                TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                                Object newKey = !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null) ? new Timestamp(((Date)key).getTime()) : key;
                                                DataType dataType2 = this.$outer.valueType$1;
                                                TimestampType$ timestampType$2 = TimestampType$.MODULE$;
                                                Object newValue = !(dataType2 != null ? !dataType2.equals(timestampType$2) : timestampType$2 != null) ? new Timestamp(((Date)value).getTime()) : value;
                                                Tuple2 tuple22 = new Tuple2(newKey, newValue);
                                                return tuple22;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, Map$.MODULE$.canBuildFrom());
                                    return map;
                                }
                                map = map2;
                                return map;
                            }
                            {
                                this.index$1 = index$1;
                                this.keyType$1 = keyType$1;
                                this.valueType$1 = valueType$1;
                            }
                        };
                    } else {
                        object2 = new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;

                            public final Object apply(SimpleFeature sf) {
                                return sf.getAttribute(this.index$1);
                            }
                            {
                                this.index$1 = index$1;
                            }
                        };
                    }
                    object = object2;
                }
                return object;
            }
            {
                this.schema$2 = schema$2;
                this.requiredAttributes$1 = requiredAttributes$1;
                this.IdExtractor$1 = IdExtractor$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
    }

    public Option<org.opengis.filter.Filter> sparkFilterToCQLFilter(Filter filt) {
        Filter filter;
        block18: {
            Some some;
            block3: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                In in;
                                                boolean bl;
                                                block9: {
                                                    block8: {
                                                        EqualTo equalTo;
                                                        boolean bl2;
                                                        block7: {
                                                            block6: {
                                                                block5: {
                                                                    block4: {
                                                                        block2: {
                                                                            bl2 = false;
                                                                            equalTo = null;
                                                                            bl = false;
                                                                            in = null;
                                                                            filter = filt;
                                                                            if (!(filter instanceof GreaterThanOrEqual)) break block2;
                                                                            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
                                                                            String attribute = greaterThanOrEqual.attribute();
                                                                            Object v = greaterThanOrEqual.value();
                                                                            some = new Some((Object)this.ff().greaterOrEqual((Expression)this.ff().property(attribute), (Expression)this.ff().literal(v)));
                                                                            break block3;
                                                                        }
                                                                        if (!(filter instanceof GreaterThan)) break block4;
                                                                        GreaterThan greaterThan = (GreaterThan)filter;
                                                                        String attr = greaterThan.attribute();
                                                                        Object v = greaterThan.value();
                                                                        some = new Some((Object)this.ff().greater((Expression)this.ff().property(attr), (Expression)this.ff().literal(v)));
                                                                        break block3;
                                                                    }
                                                                    if (!(filter instanceof LessThanOrEqual)) break block5;
                                                                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
                                                                    String attr = lessThanOrEqual.attribute();
                                                                    Object v = lessThanOrEqual.value();
                                                                    some = new Some((Object)this.ff().lessOrEqual((Expression)this.ff().property(attr), (Expression)this.ff().literal(v)));
                                                                    break block3;
                                                                }
                                                                if (!(filter instanceof LessThan)) break block6;
                                                                LessThan lessThan = (LessThan)filter;
                                                                String attr = lessThan.attribute();
                                                                Object v = lessThan.value();
                                                                some = new Some((Object)this.ff().less((Expression)this.ff().property(attr), (Expression)this.ff().literal(v)));
                                                                break block3;
                                                            }
                                                            if (!(filter instanceof EqualTo)) break block7;
                                                            bl2 = true;
                                                            equalTo = (EqualTo)filter;
                                                            String attr = equalTo.attribute();
                                                            Object v = equalTo.value();
                                                            String string = attr;
                                                            String string2 = "__fid__";
                                                            if (string != null ? !string.equals(string2) : string2 != null) break block7;
                                                            some = new Some((Object)this.ff().id(new FeatureId[]{this.ff().featureId(v.toString())}));
                                                            break block3;
                                                        }
                                                        if (!bl2) break block8;
                                                        String attr = equalTo.attribute();
                                                        Object v = equalTo.value();
                                                        some = new Some((Object)this.ff().equals((Expression)this.ff().property(attr), (Expression)this.ff().literal(v)));
                                                        break block3;
                                                    }
                                                    if (!(filter instanceof In)) break block9;
                                                    bl = true;
                                                    in = (In)filter;
                                                    String attr = in.attribute();
                                                    Object[] values = in.values();
                                                    String string = attr;
                                                    String string3 = "__fid__";
                                                    if (string != null ? !string.equals(string3) : string3 != null) break block9;
                                                    some = new Some((Object)this.ff().id((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final FeatureId apply(Object v) {
                                                            return SparkUtils$.MODULE$.ff().featureId(v.toString());
                                                        }
                                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FeatureId.class)))).toSet()).asJava()));
                                                    break block3;
                                                }
                                                if (!bl) break block10;
                                                String attr = in.attribute();
                                                Object[] values = in.values();
                                                some = new Some(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new Serializable(attr){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String attr$1;

                                                    public final PropertyIsEqualTo apply(Object v) {
                                                        return SparkUtils$.MODULE$.ff().equals((Expression)SparkUtils$.MODULE$.ff().property(this.attr$1), (Expression)SparkUtils$.MODULE$.ff().literal(v));
                                                    }
                                                    {
                                                        this.attr$1 = attr$1;
                                                    }
                                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PropertyIsEqualTo.class)))).reduce((Function2)new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final org.opengis.filter.Or apply(org.opengis.filter.Filter l, org.opengis.filter.Filter r) {
                                                        return SparkUtils$.MODULE$.ff().or(l, r);
                                                    }
                                                }));
                                                break block3;
                                            }
                                            if (!(filter instanceof And)) break block11;
                                            And and = (And)filter;
                                            Filter left = and.left();
                                            Filter right = and.right();
                                            some = new Some((Object)this.ff().and((org.opengis.filter.Filter)this.sparkFilterToCQLFilter(left).get(), (org.opengis.filter.Filter)this.sparkFilterToCQLFilter(right).get()));
                                            break block3;
                                        }
                                        if (!(filter instanceof Or)) break block12;
                                        Or or = (Or)filter;
                                        Filter left = or.left();
                                        Filter right = or.right();
                                        some = new Some((Object)this.ff().or((org.opengis.filter.Filter)this.sparkFilterToCQLFilter(left).get(), (org.opengis.filter.Filter)this.sparkFilterToCQLFilter(right).get()));
                                        break block3;
                                    }
                                    if (!(filter instanceof Not)) break block13;
                                    Not not = (Not)filter;
                                    Filter f = not.child();
                                    some = new Some((Object)this.ff().not((org.opengis.filter.Filter)this.sparkFilterToCQLFilter(f).get()));
                                    break block3;
                                }
                                if (!(filter instanceof StringStartsWith)) break block14;
                                StringStartsWith stringStartsWith = (StringStartsWith)filter;
                                String a = stringStartsWith.attribute();
                                String v = stringStartsWith.value();
                                some = new Some((Object)this.ff().like((Expression)this.ff().property(a), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v}))));
                                break block3;
                            }
                            if (!(filter instanceof StringEndsWith)) break block15;
                            StringEndsWith stringEndsWith = (StringEndsWith)filter;
                            String a = stringEndsWith.attribute();
                            String v = stringEndsWith.value();
                            some = new Some((Object)this.ff().like((Expression)this.ff().property(a), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v}))));
                            break block3;
                        }
                        if (!(filter instanceof StringContains)) break block16;
                        StringContains stringContains = (StringContains)filter;
                        String a = stringContains.attribute();
                        String v = stringContains.value();
                        some = new Some((Object)this.ff().like((Expression)this.ff().property(a), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v}))));
                        break block3;
                    }
                    if (!(filter instanceof IsNull)) break block17;
                    some = None$.MODULE$;
                    break block3;
                }
                if (!(filter instanceof IsNotNull)) break block18;
                some = None$.MODULE$;
            }
            return some;
        }
        throw new MatchError((Object)filter);
    }

    public SimpleFeatureType createFeatureType(String name, StructType struct) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(name);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])struct.fields()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$2) {
                String string = x$2.name();
                String string2 = "__fid__";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        })).foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureTypeBuilder builder$1;

            public final void apply(StructField field) {
                DataType dataType = field.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    Class elementBinding = SparkUtils$.MODULE$.org$locationtech$geomesa$spark$SparkUtils$$basicTypeBinding$1(elementType);
                    if (elementBinding == null) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list element in field ", " is not basic type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name(), elementType.typeName()})));
                    }
                    SimpleFeatureSpec.ListAttributeSpec attributeSpec = new SimpleFeatureSpec.ListAttributeSpec(field.name(), elementBinding, Predef$.MODULE$.Map().empty());
                    this.builder$1.add(attributeSpec.toDescriptor());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType keyType = mapType.keyType();
                    DataType valueType = mapType.valueType();
                    Class keyBinding = SparkUtils$.MODULE$.org$locationtech$geomesa$spark$SparkUtils$$basicTypeBinding$1(keyType);
                    if (keyBinding == null) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"map key in field ", " is not basic type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name(), keyType.typeName()})));
                    }
                    Class valueBinding = SparkUtils$.MODULE$.org$locationtech$geomesa$spark$SparkUtils$$basicTypeBinding$1(valueType);
                    if (valueBinding == null) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"map value in field ", " is not basic type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name(), valueType.typeName()})));
                    }
                    SimpleFeatureSpec.MapAttributeSpec attributeSpec = new SimpleFeatureSpec.MapAttributeSpec(field.name(), keyBinding, valueBinding, Predef$.MODULE$.Map().empty());
                    this.builder$1.add(attributeSpec.toDescriptor());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Class binding = SparkUtils$.MODULE$.org$locationtech$geomesa$spark$SparkUtils$$basicTypeBinding$1(field.dataType());
                    if (binding == null) {
                        binding = SparkUtils$.MODULE$.org$locationtech$geomesa$spark$SparkUtils$$geomTypeBinding$1(field.dataType());
                    }
                    if (binding == null) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected data type for field ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name(), field.dataType().typeName()})));
                    }
                    this.builder$1.add(field.name(), binding);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.buildFeatureType();
    }

    public StructType createStructType(SimpleFeatureType sft) {
        List fields = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<StructField> apply(AttributeDescriptor ad) {
                return Option$.MODULE$.option2Iterable(SparkUtils$.MODULE$.org$locationtech$geomesa$spark$SparkUtils$$createStructField(ad));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        StructField structField = new StructField("__fid__", DataTypes.StringType, false, StructField$.MODULE$.apply$default$4());
        return StructType$.MODULE$.apply((Seq)fields.$colon$colon((Object)structField));
    }

    public Option<StructField> org$locationtech$geomesa$spark$SparkUtils$$createStructField(AttributeDescriptor ad) {
        Option option;
        boolean bl;
        Seq bindings = ObjectType$.MODULE$.selectType(ad);
        Enumeration.Value value = (Enumeration.Value)bindings.head();
        Enumeration.Value value2 = ObjectType$.MODULE$.STRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = ObjectType$.MODULE$.INT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = ObjectType$.MODULE$.LONG();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    bl = true;
                } else {
                    Enumeration.Value value8 = ObjectType$.MODULE$.FLOAT();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        bl = true;
                    } else {
                        Enumeration.Value value10 = ObjectType$.MODULE$.DOUBLE();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            bl = true;
                        } else {
                            Enumeration.Value value12 = ObjectType$.MODULE$.BOOLEAN();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                bl = true;
                            } else {
                                Enumeration.Value value14 = ObjectType$.MODULE$.DATE();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    bl = true;
                                } else {
                                    Enumeration.Value value16 = ObjectType$.MODULE$.UUID();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                        bl = true;
                                    } else {
                                        Enumeration.Value value18 = ObjectType$.MODULE$.BYTES();
                                        Enumeration.Value value19 = value;
                                        bl = !(value18 != null ? !value18.equals(value19) : value19 != null);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (bl) {
            option = this.basicTypeToSQLType$1(bindings);
        } else {
            Enumeration.Value value20 = ObjectType$.MODULE$.LIST();
            Enumeration.Value value21 = value;
            if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
                option = this.listTypeToSQLType$1(bindings);
            } else {
                Enumeration.Value value22 = ObjectType$.MODULE$.MAP();
                Enumeration.Value value23 = value;
                if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
                    option = this.mapTypeToSQLType$1(bindings);
                } else {
                    Enumeration.Value value24 = ObjectType$.MODULE$.GEOMETRY();
                    Enumeration.Value value25 = value;
                    if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                        option = new Some((Object)this.geomTypeToSQLType$1(bindings));
                    } else {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Unexpected bindings for descriptor {}: {}", new Object[]{ad, bindings.mkString(", ")});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        option = None$.MODULE$;
                    }
                }
            }
        }
        Option dt = option;
        return dt.map((Function1)new Serializable(ad){
            public static final long serialVersionUID = 0L;
            private final AttributeDescriptor ad$1;

            public final StructField apply(DataType x$5) {
                return new StructField(this.ad$1.getLocalName(), x$5, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
            {
                this.ad$1 = ad$1;
            }
        });
    }

    public SparkUtils.SimpleFeatureRowMapping rowsToFeatures(SimpleFeatureType sft, StructType schema) {
        Object object;
        Seq mappings = (Seq)Seq$.MODULE$.tabulate(sft.getAttributeCount(), (Function1)new Serializable(sft, schema){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final StructType schema$1;

            public final Tuple3<Object, Object, Object> apply(int i) {
                AttributeDescriptor descriptor = this.sft$1.getDescriptor(i);
                Class binding = descriptor.getType().getBinding();
                boolean needConversion = java.util.List.class.isAssignableFrom(binding) || Map.class.isAssignableFrom(binding);
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)this.schema$1.fieldIndex(descriptor.getLocalName())), (Object)BoxesRunTime.boxToBoolean((boolean)needConversion));
            }
            {
                this.sft$1 = sft$1;
                this.schema$1 = schema$1;
            }
        });
        int n = Predef$.MODULE$.refArrayOps((Object[])schema.fields()).indexWhere((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$6) {
                String string = x$6.name();
                String string2 = "__fid__";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        switch (n) {
            default: {
                object = new Serializable(n){
                    public static final long serialVersionUID = 0L;
                    private final int x1$1;

                    public final String apply(Row r) {
                        return r.getString(this.x1$1);
                    }
                    {
                        this.x1$1 = x1$1;
                    }
                };
                break;
            }
            case -1: {
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x$7) {
                        return TimeSortedUuidGenerator$.MODULE$.createUuid(TimeSortedUuidGenerator$.MODULE$.createUuid$default$1()).toString();
                    }
                };
            }
        }
        Object fid = object;
        return new SparkUtils.SimpleFeatureRowMapping(sft, (Seq<Tuple3<Object, Object, Object>>)mappings, (Function1<Row, String>)fid);
    }

    public SparkUtils.SimpleFeatureRowMapping rowsToFeatures(String name, StructType schema) {
        return this.rowsToFeatures(this.createFeatureType(name, schema), schema);
    }

    public Row sf2row(StructType schema, SimpleFeature sf, Function1<SimpleFeature, Object>[] extractors) {
        Object[] res = (Object[])Array$.MODULE$.ofDim(extractors.length, ClassTag$.MODULE$.Any());
        for (int i = 0; i < extractors.length; ++i) {
            res[i] = extractors[i].apply((Object)sf);
        }
        return new GenericRowWithSchema(res, schema);
    }

    public Row joinedSf2row(StructType schema, SimpleFeature sf1, SimpleFeature sf2, Function1<SimpleFeature, Object>[] extractors) {
        int i;
        int leftLength = sf1.getAttributeCount() + 1;
        Object[] res = (Object[])Array$.MODULE$.ofDim(extractors.length, ClassTag$.MODULE$.Any());
        for (i = 0; i < leftLength; ++i) {
            res[i] = extractors[i].apply((Object)sf1);
        }
        while (i < extractors.length) {
            res[i] = extractors[i].apply((Object)sf2);
            ++i;
        }
        return new GenericRowWithSchema(res, schema);
    }

    public final Class org$locationtech$geomesa$spark$SparkUtils$$basicTypeBinding$1(DataType dataType) {
        Class clazz;
        DataType dataType2 = dataType;
        DataType dataType3 = DataTypes.StringType;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            clazz = String.class;
        } else {
            DataType dataType5 = DataTypes.DateType;
            DataType dataType6 = dataType2;
            if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
                clazz = Date.class;
            } else {
                DataType dataType7 = DataTypes.TimestampType;
                DataType dataType8 = dataType2;
                if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
                    clazz = Date.class;
                } else {
                    DataType dataType9 = DataTypes.IntegerType;
                    DataType dataType10 = dataType2;
                    if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
                        clazz = Integer.class;
                    } else {
                        DataType dataType11 = DataTypes.LongType;
                        DataType dataType12 = dataType2;
                        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
                            clazz = Long.class;
                        } else {
                            DataType dataType13 = DataTypes.FloatType;
                            DataType dataType14 = dataType2;
                            if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
                                clazz = Float.class;
                            } else {
                                DataType dataType15 = DataTypes.DoubleType;
                                DataType dataType16 = dataType2;
                                if (!(dataType15 != null ? !dataType15.equals(dataType16) : dataType16 != null)) {
                                    clazz = Double.class;
                                } else {
                                    DataType dataType17 = DataTypes.BooleanType;
                                    DataType dataType18 = dataType2;
                                    if (!(dataType17 != null ? !dataType17.equals(dataType18) : dataType18 != null)) {
                                        clazz = Boolean.class;
                                    } else {
                                        DataType dataType19 = DataTypes.BinaryType;
                                        DataType dataType20 = dataType2;
                                        clazz = !(dataType19 != null ? !dataType19.equals(dataType20) : dataType20 != null) ? byte[].class : null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return clazz;
    }

    public final Class org$locationtech$geomesa$spark$SparkUtils$$geomTypeBinding$1(DataType dataType) {
        Class clazz;
        DataType dataType2 = dataType;
        PointUDT pointUDT = JTSTypes$.MODULE$.PointTypeInstance();
        DataType dataType3 = dataType2;
        if (!(pointUDT != null ? !pointUDT.equals(dataType3) : dataType3 != null)) {
            clazz = Point.class;
        } else {
            MultiPointUDT multiPointUDT = JTSTypes$.MODULE$.MultiPointTypeInstance();
            DataType dataType4 = dataType2;
            if (!(multiPointUDT != null ? !multiPointUDT.equals(dataType4) : dataType4 != null)) {
                clazz = MultiPoint.class;
            } else {
                LineStringUDT lineStringUDT = JTSTypes$.MODULE$.LineStringTypeInstance();
                DataType dataType5 = dataType2;
                if (!(lineStringUDT != null ? !lineStringUDT.equals(dataType5) : dataType5 != null)) {
                    clazz = LineString.class;
                } else {
                    MultiLineStringUDT multiLineStringUDT = JTSTypes$.MODULE$.MultiLineStringTypeInstance();
                    DataType dataType6 = dataType2;
                    if (!(multiLineStringUDT != null ? !multiLineStringUDT.equals(dataType6) : dataType6 != null)) {
                        clazz = MultiLineString.class;
                    } else {
                        PolygonUDT polygonUDT = JTSTypes$.MODULE$.PolygonTypeInstance();
                        DataType dataType7 = dataType2;
                        if (!(polygonUDT != null ? !polygonUDT.equals(dataType7) : dataType7 != null)) {
                            clazz = Polygon.class;
                        } else {
                            MultiPolygonUDT multiPolygonUDT = JTSTypes$.MODULE$.MultipolygonTypeInstance();
                            DataType dataType8 = dataType2;
                            if (!(multiPolygonUDT != null ? !multiPolygonUDT.equals(dataType8) : dataType8 != null)) {
                                clazz = MultiPolygon.class;
                            } else {
                                GeometryCollectionUDT geometryCollectionUDT = JTSTypes$.MODULE$.GeometryCollectionTypeInstance();
                                DataType dataType9 = dataType2;
                                if (!(geometryCollectionUDT != null ? !geometryCollectionUDT.equals(dataType9) : dataType9 != null)) {
                                    clazz = GeometryCollection.class;
                                } else {
                                    GeometryUDT geometryUDT = JTSTypes$.MODULE$.GeometryTypeInstance();
                                    DataType dataType10 = dataType2;
                                    clazz = !(geometryUDT != null ? !geometryUDT.equals(dataType10) : dataType10 != null) ? Geometry.class : null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return clazz;
    }

    private final Option basicTypeToSQLType$1(Seq bindings) {
        Some some;
        Enumeration.Value value = (Enumeration.Value)bindings.head();
        Enumeration.Value value2 = ObjectType$.MODULE$.STRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            some = new Some((Object)DataTypes.StringType);
        } else {
            Enumeration.Value value4 = ObjectType$.MODULE$.INT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                some = new Some((Object)DataTypes.IntegerType);
            } else {
                Enumeration.Value value6 = ObjectType$.MODULE$.LONG();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    some = new Some((Object)DataTypes.LongType);
                } else {
                    Enumeration.Value value8 = ObjectType$.MODULE$.FLOAT();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        some = new Some((Object)DataTypes.FloatType);
                    } else {
                        Enumeration.Value value10 = ObjectType$.MODULE$.DOUBLE();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            some = new Some((Object)DataTypes.DoubleType);
                        } else {
                            Enumeration.Value value12 = ObjectType$.MODULE$.BOOLEAN();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                some = new Some((Object)DataTypes.BooleanType);
                            } else {
                                Enumeration.Value value14 = ObjectType$.MODULE$.DATE();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    some = new Some((Object)DataTypes.TimestampType);
                                } else {
                                    Enumeration.Value value16 = ObjectType$.MODULE$.BYTES();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                        some = new Some((Object)DataTypes.BinaryType);
                                    } else {
                                        Enumeration.Value value18 = ObjectType$.MODULE$.UUID();
                                        Enumeration.Value value19 = value;
                                        some = !(value18 != null ? !value18.equals(value19) : value19 != null) ? None$.MODULE$ : None$.MODULE$;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return some;
    }

    private final DataType geomTypeToSQLType$1(Seq bindings) {
        Object object;
        Enumeration.Value value = (Enumeration.Value)bindings.last();
        Enumeration.Value value2 = ObjectType$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            object = JTSTypes$.MODULE$.PointTypeInstance();
        } else {
            Enumeration.Value value4 = ObjectType$.MODULE$.LINESTRING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                object = JTSTypes$.MODULE$.LineStringTypeInstance();
            } else {
                Enumeration.Value value6 = ObjectType$.MODULE$.POLYGON();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    object = JTSTypes$.MODULE$.PolygonTypeInstance();
                } else {
                    Enumeration.Value value8 = ObjectType$.MODULE$.MULTIPOINT();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        object = JTSTypes$.MODULE$.MultiPointTypeInstance();
                    } else {
                        Enumeration.Value value10 = ObjectType$.MODULE$.MULTILINESTRING();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            object = JTSTypes$.MODULE$.MultiLineStringTypeInstance();
                        } else {
                            Enumeration.Value value12 = ObjectType$.MODULE$.MULTIPOLYGON();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                object = JTSTypes$.MODULE$.MultipolygonTypeInstance();
                            } else {
                                Enumeration.Value value14 = ObjectType$.MODULE$.GEOMETRY_COLLECTION();
                                Enumeration.Value value15 = value;
                                object = !(value14 != null ? !value14.equals(value15) : value15 != null) ? JTSTypes$.MODULE$.GeometryCollectionTypeInstance() : JTSTypes$.MODULE$.GeometryTypeInstance();
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    private final Option listTypeToSQLType$1(Seq bindings) {
        return this.basicTypeToSQLType$1((Seq)bindings.tail()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayType apply(DataType x$4) {
                return ArrayType$.MODULE$.apply(x$4);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Option mapTypeToSQLType$1(Seq bindings) {
        Tuple2 tuple2 = new Tuple2((Object)this.basicTypeToSQLType$1((Seq)bindings.tail()), (Object)this.basicTypeToSQLType$1((Seq)((TraversableLike)bindings.tail()).tail()));
        if (tuple2 == null) return None$.MODULE$;
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!(option instanceof Some)) return None$.MODULE$;
        Some some = (Some)option;
        DataType keyType = (DataType)some.x();
        if (!(option2 instanceof Some)) return None$.MODULE$;
        Some some2 = (Some)option2;
        DataType valueType = (DataType)some2.x();
        return new Some((Object)MapType$.MODULE$.apply(keyType, valueType));
    }

    private SparkUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ff = CommonFactoryFinder.getFilterFactory2();
    }
}

