/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.classpath;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

public final class ClassPathUtils$
implements LazyLogging {
    public static final ClassPathUtils$ MODULE$;
    private final FilenameFilter org$locationtech$geomesa$utils$classpath$ClassPathUtils$$jarFileFilter;
    private final FileFilter folderFileFilter;
    private final FileFilter fileFilter;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ClassPathUtils$();
    }

    private Logger logger$lzycompute() {
        ClassPathUtils$ classPathUtils$ = this;
        synchronized (classPathUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public FilenameFilter org$locationtech$geomesa$utils$classpath$ClassPathUtils$$jarFileFilter() {
        return this.org$locationtech$geomesa$utils$classpath$ClassPathUtils$$jarFileFilter;
    }

    private FileFilter folderFileFilter() {
        return this.folderFileFilter;
    }

    private FileFilter fileFilter() {
        return this.fileFilter;
    }

    public Seq<File> findJars(Seq<String> jars, Iterator<Function0<Seq<File>>> searchPath) {
        BoxedUnit boxedUnit;
        ArrayBuffer foundJars = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Seq remaining = jars;
        while (remaining.nonEmpty() && searchPath.hasNext()) {
            Seq files = (Seq)((Function0)searchPath.next()).apply();
            remaining = (Seq)remaining.filter((Function1)new Serializable(foundJars, files){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer foundJars$1;
                private final Seq files$1;

                public final boolean apply(String jarPrefix) {
                    Seq matched = (Seq)this.files$1.filter((Function1)new Serializable(this, jarPrefix){
                        public static final long serialVersionUID = 0L;
                        private final String jarPrefix$1;

                        public final boolean apply(File x$1) {
                            return x$1.getName().startsWith(this.jarPrefix$1);
                        }
                        {
                            this.jarPrefix$1 = jarPrefix$1;
                        }
                    });
                    this.foundJars$1.$plus$plus$eq((TraversableOnce)matched);
                    return matched.isEmpty();
                }
                {
                    this.foundJars$1 = foundJars$1;
                    this.files$1 = files$1;
                }
            });
        }
        if (remaining.nonEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Could not find requested jars: {}", new Object[]{remaining});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((SeqLike)foundJars.distinct()).toSeq();
    }

    public Seq<File> getJarsFromEnvironment(String home) {
        return (Seq)Option$.MODULE$.option2Iterable(package$.MODULE$.env().get((Object)home).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$3) {
                return x$3.isDirectory();
            }
        })).toSeq().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply(File dir) {
                return ClassPathUtils$.MODULE$.loadJarsFromFolder(dir);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<File> getJarsFromEnvironment(String home, String path) {
        return (Seq)Option$.MODULE$.option2Iterable(package$.MODULE$.env().get((Object)home).map((Function1)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final File apply(String h) {
                return new File(new File(h), this.path$1);
            }
            {
                this.path$1 = path$1;
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$4) {
                return x$4.isDirectory();
            }
        })).toSeq().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply(File dir) {
                return ClassPathUtils$.MODULE$.loadJarsFromFolder(dir);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<File> getJarsFromClasspath(Class<?> clas) {
        Seq seq;
        ClassLoader classLoader = clas.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final File apply(URL u) {
                    return new File(ClassPathUtils$.MODULE$.cleanClassPathURL(u.getFile()));
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Can't load jars from classloader of type {}", new Object[]{classLoader.getClass().getCanonicalName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Seq<File> getJarsFromSystemClasspath() {
        URL[] urls = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])urls).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(URL u) {
                return new File(ClassPathUtils$.MODULE$.cleanClassPathURL(u.getFile()));
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<File> loadJarsFromFolder(File dir) {
        Seq files = (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)dir.listFiles(this.org$locationtech$geomesa$utils$classpath$ClassPathUtils$$jarFileFilter()))).toSeq().flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<File> apply(File[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        });
        Seq children = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)dir.listFiles(this.folderFileFilter()))).toSeq().flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<File> apply(File[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply(File dir) {
                return ClassPathUtils$.MODULE$.loadJarsFromFolder(dir);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)files.$plus$plus((GenTraversableOnce)children, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<File> getFilesFromSystemProperty(String prop) {
        Option option2;
        block7: {
            Seq seq;
            block6: {
                BoxedUnit boxedUnit;
                block5: {
                    option2 = Option$.MODULE$.apply((Object)System.getProperty(prop));
                    if (!(option2 instanceof Some)) break block5;
                    Some some = (Some)option2;
                    String path = (String)some.x();
                    seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])path.toString().split(":")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final File apply(String x$5) {
                            return new File(x$5);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).toSeq().flatMap((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<File> apply(File file) {
                            return ClassPathUtils$.MODULE$.loadFiles(file);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    break block6;
                }
                if (!None$.MODULE$.equals(option2)) break block7;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("No files loaded onto classpath from system property: {}", new Object[]{prop});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)option2);
    }

    public Seq<File> loadFiles(File file) {
        Seq seq;
        if (file.isDirectory()) {
            Seq files = (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)file.listFiles(this.fileFilter()))).toSeq().flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<File> apply(File[] xs) {
                    return Predef$.MODULE$.refArrayOps((Object[])xs);
                }
            });
            Seq childDirs = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)file.listFiles(this.folderFileFilter()))).toSeq().flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<File> apply(File[] xs) {
                    return Predef$.MODULE$.refArrayOps((Object[])xs);
                }
            })).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<File> apply(File file) {
                    return ClassPathUtils$.MODULE$.loadFiles(file);
                }
            }, Seq$.MODULE$.canBuildFrom());
            seq = (Seq)files.$plus$plus((GenTraversableOnce)childDirs, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)file)).toSeq();
        }
        return seq;
    }

    public String cleanClassPathURL(String url) {
        return URLDecoder.decode(url, "UTF-8").replace("file:", "").replace("!", "");
    }

    /*
     * WARNING - void declaration
     */
    public Seq<File> loadClassPathFromEnv(String prop) {
        void var2_2;
        BoxedUnit boxedUnit;
        Seq files = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(package$.MODULE$.env().get((Object)prop)).toSeq().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$6) {
                return Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$6)).split(':')).toSeq();
            }
        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SeqLike<File, Object> apply(String entry) {
                File f;
                return entry.endsWith("/*") ? Predef$.MODULE$.refArrayOps((Object[])new File((String)new StringOps(Predef$.MODULE$.augmentString(entry)).dropRight(2)).listFiles(ClassPathUtils$.MODULE$.org$locationtech$geomesa$utils$classpath$ClassPathUtils$$jarFileFilter())) : ((f = new File(entry)).isDirectory() ? (SeqLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)f.listFiles())).toSeq().flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<File> apply(File[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }) : (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{f})));
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Loaded env classpath '{}': {}", (Object[])new String[]{prop, ((TraversableOnce)files.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(File x$7) {
                    return x$7.getAbsolutePath();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(":")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    private ClassPathUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$utils$classpath$ClassPathUtils$$jarFileFilter = new FilenameFilter(){

            public boolean accept(File dir, String name2) {
                return name2.endsWith(".jar") && !name2.endsWith("-sources.jar") && !name2.endsWith("-javadoc.jar");
            }
        };
        this.folderFileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        this.fileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
    }
}

