/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.geohash.TwoGeoHashBoundingBox;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.TreeSet;
import scala.collection.mutable.TreeSet$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001b\tQ\"i\\;oI&twMQ8y\u000f\u0016|\u0007*Y:i\u0013R,'/\u0019;pe*\u00111\u0001B\u0001\bO\u0016|\u0007.Y:i\u0015\t)a!A\u0003vi&d7O\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000fE\u0002\u00185qi\u0011\u0001\u0007\u0006\u00033I\tA!\u001e;jY&\u00111\u0004\u0007\u0002\t\u0013R,'/\u0019;peB\u0011QDH\u0007\u0002\u0005%\u0011qD\u0001\u0002\b\u000f\u0016|\u0007*Y:i\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013!\u0002;x_\u001eC\u0007CA\u000f$\u0013\t!#AA\u000bUo><Um\u001c%bg\"\u0014u.\u001e8eS:<'i\u001c=\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\tA\u0013\u0006\u0005\u0002\u001e\u0001!)\u0011%\na\u0001E!Q1\u0006\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002\u0017\u0002\u0007a$\u0013\u0007\u0005\u0003.aI\u0012T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\rQ+\b\u000f\\33!\ti3'\u0003\u00025]\t\u0019\u0011J\u001c;\t\u000fY\u0002!\u0019!C\u0001o\u0005AA.\u0019;Ti\u0016\u00048/F\u00013\u0011\u0019I\u0004\u0001)A\u0005e\u0005IA.\u0019;Ti\u0016\u00048\u000f\t\u0005\bw\u0001\u0011\r\u0011\"\u00018\u0003!awN\\*uKB\u001c\bBB\u001f\u0001A\u0003%!'A\u0005m_:\u001cF/\u001a9tA!Qq\b\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002!\u0002\u0007a$#\u0007\u0005\u0003.a\u0005\u000b\u0005CA\u0017C\u0013\t\u0019eF\u0001\u0003M_:<\u0007bB#\u0001\u0005\u0004%\tAR\u0001\fK:$G*\u0019;J]\u0012,\u00070F\u0001B\u0011\u0019A\u0005\u0001)A\u0005\u0003\u0006aQM\u001c3MCRLe\u000eZ3yA!9!\n\u0001b\u0001\n\u00031\u0015aC3oI2{g.\u00138eKbDa\u0001\u0014\u0001!\u0002\u0013\t\u0015\u0001D3oI2{g.\u00138eKb\u0004\u0003b\u0002(\u0001\u0005\u0004%\taN\u0001\u0003]NDa\u0001\u0015\u0001!\u0002\u0013\u0011\u0014a\u00018tA!9!\u000b\u0001b\u0001\n\u0003\u0019\u0016!B9vKV,W#\u0001+\u0011\u0007USF$D\u0001W\u0015\t9\u0006,A\u0004nkR\f'\r\\3\u000b\u0005es\u0013AC2pY2,7\r^5p]&\u00111L\u0016\u0002\b)J,WmU3u\u0011\u0019i\u0006\u0001)A\u0005)\u00061\u0011/^3vK\u0002Bqa\u0018\u0001A\u0002\u0013\u0005\u0001-\u0001\u0004oKb$x\t[\u000b\u00029!9!\r\u0001a\u0001\n\u0003\u0019\u0017A\u00038fqR<\u0005n\u0018\u0013fcR\u0011Am\u001a\t\u0003[\u0015L!A\u001a\u0018\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0005\f\t\u00111\u0001\u001d\u0011\u0019I\u0007\u0001)Q\u00059\u00059a.\u001a=u\u000f\"\u0004\u0003\"B6\u0001\t\u0003a\u0017a\u00025bg:+\u0007\u0010\u001e\u000b\u0002[B\u0011QF\\\u0005\u0003_:\u0012qAQ8pY\u0016\fg\u000eC\u0003r\u0001\u0011\u0005!/\u0001\u0003oKb$H#\u0001\u000f\t\u000bQ\u0004A\u0011I;\u0002\rI,Wn\u001c<f)\u0005!\u0007")
public class BoundingBoxGeoHashIterator
implements Iterator<GeoHash> {
    private final TwoGeoHashBoundingBox twoGh;
    private final /* synthetic */ Tuple2 x$1;
    private final int latSteps;
    private final int lonSteps;
    private final /* synthetic */ Tuple2 x$2;
    private final long endLatIndex;
    private final long endLonIndex;
    private final int ns;
    private final TreeSet<GeoHash> queue;
    private GeoHash nextGh;

    public int latSteps() {
        return this.latSteps;
    }

    public int lonSteps() {
        return this.lonSteps;
    }

    public long endLatIndex() {
        return this.endLatIndex;
    }

    public long endLonIndex() {
        return this.endLonIndex;
    }

    public int ns() {
        return this.ns;
    }

    public TreeSet<GeoHash> queue() {
        return this.queue;
    }

    public GeoHash nextGh() {
        return this.nextGh;
    }

    public void nextGh_$eq(GeoHash x$1) {
        this.nextGh = x$1;
    }

    @Override
    public boolean hasNext() {
        return this.queue().nonEmpty();
    }

    @Override
    public GeoHash next() {
        if (this.hasNext()) {
            Object object;
            Object object2;
            this.nextGh_$eq((GeoHash)this.queue().head());
            long latIndex = GeoHash$.MODULE$.gridIndexForLatitude(this.nextGh());
            long lonIndex = GeoHash$.MODULE$.gridIndexForLongitude(this.nextGh());
            if (lonIndex + 1L <= this.endLonIndex()) {
                GeoHash nextLonGh = GeoHash$.MODULE$.composeGeoHashFromBitIndicesAndPrec(latIndex, lonIndex + 1L, this.nextGh().prec());
                object2 = this.twoGh.bbox().covers(nextLonGh.getPoint()) ? BoxesRunTime.boxToBoolean((boolean)this.queue().add((Object)nextLonGh)) : BoxedUnit.UNIT;
            } else {
                object2 = BoxedUnit.UNIT;
            }
            if (latIndex + 1L <= this.endLatIndex()) {
                GeoHash nextLatGh = GeoHash$.MODULE$.composeGeoHashFromBitIndicesAndPrec(latIndex + 1L, lonIndex, this.nextGh().prec());
                object = this.twoGh.bbox().covers(nextLatGh.getPoint()) ? BoxesRunTime.boxToBoolean((boolean)this.queue().add((Object)nextLatGh)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            this.queue().remove((Object)this.nextGh());
            return this.nextGh();
        }
        throw new NoSuchElementException("No more geohashes available in iterator");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation not supported");
    }

    public BoundingBoxGeoHashIterator(TwoGeoHashBoundingBox twoGh) {
        this.twoGh = twoGh;
        Tuple2<Object, Object> tuple2 = GeoHash$.MODULE$.getLatitudeLongitudeSpanCount(twoGh.ll(), twoGh.ur(), twoGh.prec());
        if (tuple2 != null) {
            int latSteps = tuple2._1$mcI$sp();
            int lonSteps = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(latSteps, lonSteps);
            this.x$1 = sp2;
            this.latSteps = this.x$1._1$mcI$sp();
            this.lonSteps = this.x$1._2$mcI$sp();
            long[] lArray = GeoHash$.MODULE$.gridIndicesForLatLong(twoGh.ur());
            Option option2 = Array$.MODULE$.unapplySeq((Object)lArray);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                long endLatIndex = BoxesRunTime.unboxToLong((Object)((SeqLike)option2.get()).apply(0));
                long endLonIndex = BoxesRunTime.unboxToLong((Object)((SeqLike)option2.get()).apply(1));
                Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(endLatIndex, endLonIndex);
                this.x$2 = sp3;
                this.endLatIndex = this.x$2._1$mcJ$sp();
                this.endLonIndex = this.x$2._2$mcJ$sp();
                this.ns = this.latSteps() * this.lonSteps();
                this.queue = (TreeSet)TreeSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeoHash[]{twoGh.ll()}), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.nextGh = twoGh.ll();
                return;
            }
            throw new MatchError((Object)lArray);
        }
        throw new MatchError(tuple2);
    }
}

