/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.locationtech.geomesa.utils.geotools.GenerateRichFeatureModels;
import org.locationtech.geomesa.utils.geotools.GenerateRichFeatureModels$;
import org.locationtech.geomesa.utils.geotools.GenerateRichFeatureModels$AttributeMethods$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$RichAttributeDescriptor$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.RichChar$;

public final class GenerateRichFeatureModels$ {
    public static final GenerateRichFeatureModels$ MODULE$;

    static {
        new GenerateRichFeatureModels$();
    }

    public void main(String[] args) {
        String basedir = args[0];
        String packageName = args[1];
        Predef$.MODULE$.assert(basedir != null);
        Predef$.MODULE$.assert(packageName != null);
        List<SimpleFeatureType> sfts2 = SimpleFeatureTypeLoader$.MODULE$.sfts();
        if (sfts2.isEmpty()) {
            Predef$.MODULE$.println((Object)"No formats found");
        } else {
            sfts2.foreach((Function1)new Serializable(basedir, packageName){
                public static final long serialVersionUID = 0L;
                private final String basedir$1;
                public final String packageName$1;

                public final void apply(SimpleFeatureType sft) {
                    String name2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Model"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GenerateRichFeatureModels$.MODULE$.org$locationtech$geomesa$utils$geotools$GenerateRichFeatureModels$$safeIdentifier(sft.getTypeName())}));
                    String classFilePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/src/main/scala/", "/", ".scala"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.basedir$1, this.packageName$1.replaceAll("\\.", "/"), name2}));
                    File classFile = new File(classFilePath);
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing class file ", ".", " with feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.packageName$1, name2, sft.getTypeName()})));
                    package$WithClose$.MODULE$.apply(new FileWriter(classFile), new Serializable(this, name2, sft){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.main.1 $outer;
                        private final String name$1;
                        private final SimpleFeatureType sft$1;

                        public final void apply(FileWriter fw) {
                            GenerateRichFeatureModels$.MODULE$.buildSingleClass(this.sft$1, this.name$1, this.$outer.packageName$1, fw);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.name$1 = name$1;
                            this.sft$1 = sft$1;
                        }
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                }
                {
                    this.basedir$1 = basedir$1;
                    this.packageName$1 = packageName$1;
                }
            });
        }
    }

    public void buildSingleClass(SimpleFeatureType sft, String name2, String pkg, Writer out) {
        out.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"package ", "\\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pkg})));
        out.append("import org.opengis.feature.simple.SimpleFeature\n\n");
        out.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"// this class was generated by ", " for feature type ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), sft.getTypeName()})));
        out.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"object ", " {\\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2})));
        out.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  implicit class RichFeature(val sf: SimpleFeature) extends AnyVal {\\n"})).s((Seq)Nil$.MODULE$));
        for (int i = 0; i < sft.getAttributeCount(); ++i) {
            GenerateRichFeatureModels.AttributeMethods attr = GenerateRichFeatureModels$AttributeMethods$.MODULE$.apply(sft, i);
            out.append("\n");
            out.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr.getter()})));
            out.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr.optionGetter()})));
            out.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr.setter()})));
        }
        out.append(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |    def debug(): String = {\n         |      import scala.collection.JavaConverters._\n         |      val sb = new StringBuilder(s\"${sf.getType.getTypeName}:${sf.getID}\")\n         |      sf.getProperties.asScala.foreach(p => sb.append(s\"|${p.getName.getLocalPart}=${p.getValue}\"))\n         |      sb.toString()\n         |    }\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin());
        out.append("  }\n}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAttributeBinding(AttributeDescriptor descriptor) {
        String string2;
        String binding = descriptor.getType().getBinding().getCanonicalName();
        if (RichAttributeDescriptors$RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor))) {
            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binding, this.subtype$1(RichAttributeDescriptors$RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)))}));
            return string2;
        } else if (RichAttributeDescriptors$RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor))) {
            Tuple2 tuple2;
            Tuple2<Class<?>, Class<?>> tuple22 = RichAttributeDescriptors$RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor));
            if (tuple22 == null) throw new MatchError(tuple22);
            Class keyType = (Class)tuple22._1();
            Class valueType = (Class)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)keyType, (Object)valueType);
            Class keyType2 = (Class)tuple23._1();
            Class valueType2 = (Class)tuple23._2();
            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[", ",", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binding, this.subtype$1(keyType2), this.subtype$1(valueType2)}));
            return string2;
        } else {
            string2 = binding;
        }
        return string2;
    }

    public String org$locationtech$geomesa$utils$geotools$GenerateRichFeatureModels$$safeIdentifier(String name2) {
        StringBuilder safe = new StringBuilder();
        boolean upper = true;
        for (int i = 0; i < name2.length(); ++i) {
            BoxedUnit boxedUnit;
            char c = name2.charAt(i);
            if (c == '_' || i == 0 && !Character.isJavaIdentifierStart(c) || i != 0 && !Character.isJavaIdentifierPart(c)) {
                upper = true;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (upper) {
                safe.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(c)));
                upper = false;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = safe.append(c);
        }
        if (safe.isEmpty()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't create valid Java identifier from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2})));
        }
        return safe.toString();
    }

    private final String subtype$1(Class c) {
        Class clazz = c;
        String string2 = clazz == null ? "String" : clazz.getCanonicalName();
        return string2;
    }

    private GenerateRichFeatureModels$() {
        MODULE$ = this;
    }
}

