/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Date;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.locationtech.geomesa.utils.index.TemporalIndexCheck$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class TemporalIndexCheck$
implements LazyLogging {
    public static final TemporalIndexCheck$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new TemporalIndexCheck$();
    }

    private Logger logger$lzycompute() {
        TemporalIndexCheck$ temporalIndexCheck$ = this;
        synchronized (temporalIndexCheck$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void validateDtgField(SimpleFeatureType sft) {
        scala.collection.immutable.Seq<String> dtgCandidates = this.scanForTemporalAttributes(sft);
        if (!RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).exists((Function1)new Serializable(dtgCandidates){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Seq dtgCandidates$1;

            public final boolean apply(Object elem) {
                return this.dtgCandidates$1.contains(elem);
            }
            {
                this.dtgCandidates$1 = dtgCandidates$1;
            }
        })) {
            RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).foreach((Function1)new Serializable(sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final void apply(String dtg) {
                    BoxedUnit boxedUnit;
                    if (TemporalIndexCheck$.MODULE$.logger().underlying().isWarnEnabled()) {
                        TemporalIndexCheck$.MODULE$.logger().underlying().warn("Invalid date field '{}' specified for schema {}", new Object[]{dtg, this.sft$1});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.clearDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
                }
                {
                    this.sft$1 = sft$1;
                }
            });
            if (!GeoMesaSchemaValidator$.MODULE$.declared(sft, SimpleFeatureTypes$Configs$.MODULE$.IndexIgnoreDtg())) {
                dtgCandidates.headOption().foreach((Function1)new Serializable(sft, dtgCandidates){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$1;
                    private final scala.collection.immutable.Seq dtgCandidates$1;

                    public final void apply(String candidate) {
                        BoxedUnit boxedUnit;
                        ObjectRef theWarning$lzy = ObjectRef.zero();
                        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
                        if (TemporalIndexCheck$.MODULE$.logger().underlying().isWarnEnabled()) {
                            TemporalIndexCheck$.MODULE$.logger().underlying().warn(this.theWarning$1(theWarning$lzy, candidate, bitmap$0));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.setDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1), candidate);
                    }

                    private final String theWarning$lzycompute$1(ObjectRef theWarning$lzy$1, String candidate$1, VolatileByteRef bitmap$0$1) {
                        anonfun.validateDtgField.3 var4_4 = this;
                        synchronized (var4_4) {
                            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                                theWarning$lzy$1.elem = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not valid or defined for simple feature type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$Configs$.MODULE$.DefaultDtgField(), this.sft$1}))).append((Object)"However, the following attribute(s) can be used in GeoMesa's temporal index: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". To disable temporal indexing, put Boolean.TRUE into the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtgCandidates$1.mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SimpleFeatureType user data under the key '", "' before calling createSchema, or "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$Configs$.MODULE$.IndexIgnoreDtg()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"set the system property '", "' to 'true'. GeoMesa will now point ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$Configs$.MODULE$.IndexIgnoreDtg(), SimpleFeatureTypes$Configs$.MODULE$.DefaultDtgField()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to the first temporal attribute found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{candidate$1}))).toString();
                                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
                            }
                            return (String)theWarning$lzy$1.elem;
                        }
                    }

                    private final String theWarning$1(ObjectRef theWarning$lzy$1, String candidate$1, VolatileByteRef bitmap$0$1) {
                        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.theWarning$lzycompute$1(theWarning$lzy$1, candidate$1, bitmap$0$1) : (String)theWarning$lzy$1.elem;
                    }
                    {
                        this.sft$1 = sft$1;
                        this.dtgCandidates$1 = dtgCandidates$1;
                    }
                });
            }
        }
    }

    private scala.collection.immutable.Seq<String> scanForTemporalAttributes(SimpleFeatureType sft) {
        return (scala.collection.immutable.Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).toList().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor x$1) {
                return Date.class.isAssignableFrom(x$1.getType().getBinding());
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(AttributeDescriptor x$2) {
                return x$2.getLocalName();
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private TemporalIndexCheck$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

