/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io.fs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.util.EnumSet;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate$CreateMode$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate$FileHandle$class;
import org.locationtech.geomesa.utils.io.fs.HadoopDelegate$;
import org.locationtech.geomesa.utils.io.fs.package;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\u0001=\u0011a\u0002S1e_>\u0004H)\u001a7fO\u0006$XM\u0003\u0002\u0004\t\u0005\u0011am\u001d\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011!B;uS2\u001c(BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0013\r&dWmU=ti\u0016lG)\u001a7fO\u0006$X\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0011\u0019wN\u001c4\u0011\u0005u\u0019S\"\u0001\u0010\u000b\u0005my\"B\u0001\u0011\"\u0003\u0019A\u0017\rZ8pa*\u0011!\u0005D\u0001\u0007CB\f7\r[3\n\u0005\u0011r\"!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0003Q%\u0002\"a\u0006\u0001\t\u000fm)\u0003\u0013!a\u00019!91\u0006\u0001b\u0001\n\u0013a\u0013!\u0003:fGV\u00148/\u001b<f+\u0005i\u0003CA\t/\u0013\ty#CA\u0004C_>dW-\u00198\t\rE\u0002\u0001\u0015!\u0003.\u0003)\u0011XmY;sg&4X\r\t\u0005\u0006g\u0001!\t\u0005N\u0001\nO\u0016$\b*\u00198eY\u0016$\"!N&\u0011\u0005YBeBA\u001cG\u001d\tATI\u0004\u0002:\t:\u0011!h\u0011\b\u0003w\ts!\u0001P!\u000f\u0005u\u0002U\"\u0001 \u000b\u0005}r\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0005\u001d\u0013\u0011A\u0005$jY\u0016\u001c\u0016p\u001d;f[\u0012+G.Z4bi\u0016L!!\u0013&\u0003\u0015\u0019KG.\u001a%b]\u0012dWM\u0003\u0002H\u0005!)AJ\ra\u0001\u001b\u0006!\u0001/\u0019;i!\tq\u0015K\u0004\u0002\u0012\u001f&\u0011\u0001KE\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q%!)Q\u000b\u0001C!-\u0006i\u0011N\u001c;feB\u0014X\r\u001e)bi\"$\"a\u00161\u0011\u0007akVG\u0004\u0002Z7:\u0011QHW\u0005\u0002'%\u0011ALE\u0001\ba\u0006\u001c7.Y4f\u0013\tqvLA\u0002TKFT!\u0001\u0018\n\t\u000b1#\u0006\u0019A'\b\u000b\t\u0014\u0001\u0012A2\u0002\u001d!\u000bGm\\8q\t\u0016dWmZ1uKB\u0011q\u0003\u001a\u0004\u0006\u0003\tA\t!Z\n\u0003IBAQA\n3\u0005\u0002\u001d$\u0012a\u0019\u0005\bS\u0012\u0014\r\u0011\"\u0003k\u0003\u001d1\u0017m\u0019;pef,\u0012a\u001b\t\u0003YNl\u0011!\u001c\u0006\u0003]>\f\u0011\"\u0019:dQ&4XM]:\u000b\u0005A\f\u0018\u0001C2p[B\u0014Xm]:\u000b\u0005I\f\u0013aB2p[6|gn]\u0005\u0003i6\u0014A#\u0011:dQ&4Xm\u0015;sK\u0006lg)Y2u_JL\bB\u0002<eA\u0003%1.\u0001\u0005gC\u000e$xN]=!\u0011\u001dAHM1A\u0005\u0002e\f\u0001\u0003S5eI\u0016tg)\u001b7f\r&dG/\u001a:\u0016\u0003i\u0004\"a_?\u000e\u0003qT!aA\u0010\n\u0005yd(A\u0003)bi\"4\u0015\u000e\u001c;fe\"9\u0011\u0011\u00013!\u0002\u0013Q\u0018!\u0005%jI\u0012,gNR5mK\u001aKG\u000e^3sA\u00191\u0011Q\u00013\u0001\u0003\u000f\u0011\u0001\u0003S1e_>\u0004h)\u001b7f\u0011\u0006tG\r\\3\u0014\t\u0005\r\u0001#\u000e\u0005\f\u0003\u0017\t\u0019A!A!\u0002\u0013\ti!\u0001\u0002gGB\u001910a\u0004\n\u0007\u0005EAPA\u0006GS2,7i\u001c8uKb$\bbCA\u000b\u0003\u0007\u0011\t\u0011)A\u0005\u0003/\tAAZ5mKB\u001910!\u0007\n\u0007\u0005mAP\u0001\u0003QCRD\u0007b\u0002\u0014\u0002\u0004\u0011\u0005\u0011q\u0004\u000b\u0007\u0003C\t)#a\n\u0011\t\u0005\r\u00121A\u0007\u0002I\"A\u00111BA\u000f\u0001\u0004\ti\u0001\u0003\u0005\u0002\u0016\u0005u\u0001\u0019AA\f\u0011\u001da\u00151\u0001C!\u0003W)\u0012!\u0014\u0005\b\u0003_\t\u0019\u0001\"\u0011-\u0003\u0019)\u00070[:ug\"A\u00111GA\u0002\t\u0003\n)$\u0001\u0004mK:<G\u000f[\u000b\u0003\u0003o\u00012!EA\u001d\u0013\r\tYD\u0005\u0002\u0005\u0019>tw\r\u0003\u0005\u0002@\u0005\rA\u0011IA!\u0003\u0011y\u0007/\u001a8\u0016\u0005\u0005\r\u0003CBA#\u0003\u0017\ny%\u0004\u0002\u0002H)\u0019\u0011\u0011\n\u0004\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0005\u001d#!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB9\u0011#!\u0015\u0002V\u0005m\u0013bAA*%\t1A+\u001e9mKJ\u0002B!EA,\u001b&\u0019\u0011\u0011\f\n\u0003\r=\u0003H/[8o!\u0011\ti&!\u001a\u000e\u0005\u0005}#bA\u0003\u0002b)\u0011\u00111M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002h\u0005}#aC%oaV$8\u000b\u001e:fC6D\u0001\"a\u001b\u0002\u0004\u0011\u0005\u0013QN\u0001\u0006oJLG/\u001a\u000b\u0007\u0003_\n)(a \u0011\t\u0005u\u0013\u0011O\u0005\u0005\u0003g\nyF\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0002x\u0005%\u0004\u0019AA=\u0003\u0011iw\u000eZ3\u0011\u0007Y\nY(C\u0002\u0002~)\u0013!b\u0011:fCR,Wj\u001c3f\u0011%\t\t)!\u001b\u0011\u0002\u0003\u0007Q&A\u0007de\u0016\fG/\u001a)be\u0016tGo\u001d\u0005\t\u0003\u000b\u000b\u0019\u0001\"\u0011\u0002\b\u00061A-\u001a7fi\u0016$B!!#\u0002\u0010B\u0019\u0011#a#\n\u0007\u00055%C\u0001\u0003V]&$\b\u0002C\u0016\u0002\u0004B\u0005\t\u0019A\u0017\u0007\r\u0005ME\rAAK\u0005=A\u0015\rZ8pajK\u0007\u000fS1oI2,7\u0003BAI\u0003CA1\"a\u0003\u0002\u0012\n\u0005\t\u0015!\u0003\u0002\u000e!Y\u0011QCAI\u0005\u0003\u0005\u000b\u0011BA\f\u0011\u001d1\u0013\u0011\u0013C\u0001\u0003;#b!a(\u0002\"\u0006\r\u0006\u0003BA\u0012\u0003#C\u0001\"a\u0003\u0002\u001c\u0002\u0007\u0011Q\u0002\u0005\t\u0003+\tY\n1\u0001\u0002\u0018!A\u0011qHAI\t\u0003\n\t\u0005\u0003\u0005\u0002l\u0005EE\u0011IAU)\u0019\ty'a+\u0002.\"A\u0011qOAT\u0001\u0004\tI\bC\u0005\u0002\u0002\u0006\u001d\u0006\u0013!a\u0001[\u00191\u0011\u0011\u00173\u0001\u0003g\u0013q\u0002S1e_>\u0004H+\u0019:IC:$G.Z\n\u0005\u0003_\u000b\t\u0003C\u0006\u0002\f\u0005=&\u0011!Q\u0001\n\u00055\u0001bCA\u000b\u0003_\u0013\t\u0011)A\u0005\u0003/AqAJAX\t\u0003\tY\f\u0006\u0004\u0002>\u0006}\u0016\u0011\u0019\t\u0005\u0003G\ty\u000b\u0003\u0005\u0002\f\u0005e\u0006\u0019AA\u0007\u0011!\t)\"!/A\u0002\u0005]\u0001\u0002CA \u0003_#\t%!\u0011\t\u0011\u0005-\u0014q\u0016C!\u0003\u000f$b!a\u001c\u0002J\u0006-\u0007\u0002CA<\u0003\u000b\u0004\r!!\u001f\t\u0013\u0005\u0005\u0015Q\u0019I\u0001\u0002\u0004i\u0003\"CAhIF\u0005I\u0011AAi\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u001b\u0016\u00049\u0005U7FAAl!\u0011\tI.a9\u000e\u0005\u0005m'\u0002BAo\u0003?\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005(#\u0001\u0006b]:|G/\u0019;j_:LA!!:\u0002\\\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class HadoopDelegate
implements FileSystemDelegate {
    private final Configuration conf;
    private final boolean recursive;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Configuration $lessinit$greater$default$1() {
        return HadoopDelegate$.MODULE$.$lessinit$greater$default$1();
    }

    public static PathFilter HiddenFileFilter() {
        return HadoopDelegate$.MODULE$.HiddenFileFilter();
    }

    private Logger logger$lzycompute() {
        HadoopDelegate hadoopDelegate = this;
        synchronized (hadoopDelegate) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private boolean recursive() {
        return this.recursive;
    }

    @Override
    public FileSystemDelegate.FileHandle getHandle(String path) {
        HadoopFileHandle hadoopFileHandle;
        Path p = new Path(path);
        FileContext fc = FileContext.getFileContext((URI)p.toUri(), (Configuration)this.conf);
        String string2 = PathUtils$.MODULE$.getUncompressedExtension(p.getName()).toLowerCase(Locale.US);
        if ("tar".equals(string2)) {
            hadoopFileHandle = new HadoopTarHandle(fc, p);
        } else {
            boolean bl = "zip".equals(string2) ? true : "jar".equals(string2);
            hadoopFileHandle = bl ? new HadoopZipHandle(fc, p) : new HadoopFileHandle(fc, p);
        }
        return hadoopFileHandle;
    }

    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        Path p = new Path(path);
        FileContext fc = FileContext.getFileContext((URI)p.toUri(), (Configuration)this.conf);
        FileStatus[] files = fc.util().globStatus(p, HadoopDelegate$.MODULE$.HiddenFileFilter());
        if (files == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        if (Predef$.MODULE$.refArrayOps((Object[])files).isEmpty()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input path does not match any files: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        Queue remaining = (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])files));
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (remaining.nonEmpty()) {
            ListBuffer listBuffer;
            BoxedUnit boxedUnit;
            FileStatus file = (FileStatus)remaining.dequeue();
            if (file.isDirectory()) {
                if (this.recursive()) {
                    RemoteIterator children = fc.listLocatedStatus(file.getPath());
                    Iterator<LocatedFileStatus> iter = new Iterator<LocatedFileStatus>(this, children){
                        private final RemoteIterator children$1;

                        public Iterator<LocatedFileStatus> seq() {
                            return Iterator.class.seq((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.class.isEmpty((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.class.isTraversableAgain((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.class.hasDefiniteSize((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> take(int n) {
                            return Iterator.class.take((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> drop(int n) {
                            return Iterator.class.drop((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> slice(int from, int until) {
                            return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<LocatedFileStatus, B> f) {
                            return Iterator.class.map((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.class.$plus$plus((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<LocatedFileStatus, GenTraversableOnce<B>> f) {
                            return Iterator.class.flatMap((Iterator)this, f);
                        }

                        public Iterator<LocatedFileStatus> filter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.filter((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<LocatedFileStatus, B, Object> p) {
                            return Iterator.class.corresponds((Iterator)this, that, p);
                        }

                        public Iterator<LocatedFileStatus> withFilter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.withFilter((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> filterNot(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.filterNot((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<LocatedFileStatus, B> pf) {
                            return Iterator.class.collect((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return Iterator.class.scanLeft((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return Iterator.class.scanRight((Iterator)this, z, op);
                        }

                        public Iterator<LocatedFileStatus> takeWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.takeWhile((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> partition(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.partition((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> span(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.span((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> dropWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.dropWhile((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<LocatedFileStatus, B>> zip(Iterator<B> that) {
                            return Iterator.class.zip((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.class.padTo((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<LocatedFileStatus, Object>> zipWithIndex() {
                            return Iterator.class.zipWithIndex((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<LocatedFileStatus, U> f) {
                            Iterator.class.foreach((Iterator)this, f);
                        }

                        public boolean forall(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.forall((Iterator)this, p);
                        }

                        public boolean exists(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.exists((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.class.contains((Iterator)this, (Object)elem);
                        }

                        public Option<LocatedFileStatus> find(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.find((Iterator)this, p);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.class.indexWhere((Iterator)this, p);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.class.indexOf((Iterator)this, elem);
                        }

                        public BufferedIterator<LocatedFileStatus> buffered() {
                            return Iterator.class.buffered((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                            return Iterator.class.grouped((Iterator)this, (int)size2);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                            return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
                        }

                        public int length() {
                            return Iterator.class.length((Iterator)this);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> duplicate() {
                            return Iterator.class.duplicate((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.class.sameElements((Iterator)this, that);
                        }

                        public Traversable<LocatedFileStatus> toTraversable() {
                            return Iterator.class.toTraversable((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> toIterator() {
                            return Iterator.class.toIterator((Iterator)this);
                        }

                        public Stream<LocatedFileStatus> toStream() {
                            return Iterator.class.toStream((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.class.toString((Iterator)this);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.class.sliding$default$2((Iterator)this);
                        }

                        public List<LocatedFileStatus> reversed() {
                            return TraversableOnce.class.reversed((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.class.size((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                        }

                        public int count(Function1<LocatedFileStatus, Object> p) {
                            return TraversableOnce.class.count((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<LocatedFileStatus, B> pf) {
                            return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, LocatedFileStatus, B> op) {
                            return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<LocatedFileStatus, B, B> op) {
                            return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, LocatedFileStatus, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                        }

                        public List<LocatedFileStatus> toList() {
                            return TraversableOnce.class.toList((TraversableOnce)this);
                        }

                        public Iterable<LocatedFileStatus> toIterable() {
                            return TraversableOnce.class.toIterable((TraversableOnce)this);
                        }

                        public Seq<LocatedFileStatus> toSeq() {
                            return TraversableOnce.class.toSeq((TraversableOnce)this);
                        }

                        public IndexedSeq<LocatedFileStatus> toIndexedSeq() {
                            return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.class.toBuffer((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.class.toSet((TraversableOnce)this);
                        }

                        public Vector<LocatedFileStatus> toVector() {
                            return TraversableOnce.class.toVector((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, LocatedFileStatus, Col> cbf) {
                            return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                        }

                        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<LocatedFileStatus, Tuple2<T, U>> ev) {
                            return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.class.mkString((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                        }

                        public boolean hasNext() {
                            return this.children$1.hasNext();
                        }

                        public LocatedFileStatus next() {
                            return (LocatedFileStatus)this.children$1.next();
                        }
                        {
                            this.children$1 = children$1;
                            TraversableOnce.class.$init$((TraversableOnce)this);
                            Iterator.class.$init$((Iterator)this);
                        }
                    };
                    boxedUnit = remaining.$plus$plus$eq((TraversableOnce)iter.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(LocatedFileStatus f) {
                            return HadoopDelegate$.MODULE$.HiddenFileFilter().accept(f.getPath());
                        }
                    }));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            String string2 = PathUtils$.MODULE$.getUncompressedExtension(file.getPath().getName()).toLowerCase(Locale.US);
            if ("tar".equals(string2)) {
                listBuffer = result.$plus$eq((Object)new HadoopTarHandle(fc, file.getPath()));
            } else {
                boolean bl = "zip".equals(string2) ? true : "jar".equals(string2);
                listBuffer = bl ? result.$plus$eq((Object)new HadoopZipHandle(fc, file.getPath())) : result.$plus$eq((Object)new HadoopFileHandle(fc, file.getPath()));
            }
            boxedUnit = listBuffer;
        }
        return result.result();
    }

    public HadoopDelegate(Configuration conf) {
        this.conf = conf;
        LazyLogging.class.$init$((LazyLogging)this);
        this.recursive = conf.getBoolean("mapreduce.input.fileinputformat.input.dir.recursive", false);
    }

    public static class HadoopTarHandle
    extends HadoopFileHandle {
        private final FileContext fc;
        private final Path file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream uncompressed = PathUtils$.MODULE$.handleCompression((InputStream)this.fc.open(this.file), this.file.getName());
            ArchiveInputStream archive = HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$HadoopDelegate$$factory().createArchiveInputStream("tar", uncompressed);
            return new package.ArchiveFileIterator(archive, this.file.toString());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$HadoopDelegate$$factory().createArchiveOutputStream("tar", super.write(mode, createParents));
        }

        public HadoopTarHandle(FileContext fc, Path file) {
            this.fc = fc;
            this.file = file;
            super(fc, file);
        }
    }

    public static class HadoopZipHandle
    extends HadoopFileHandle {
        private final FileContext fc;
        private final Path file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            byte[] bytes2 = (byte[])package$WithClose$.MODULE$.apply(PathUtils$.MODULE$.handleCompression((InputStream)this.fc.open(this.file), this.file.getName()), new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(InputStream is) {
                    return IOUtils.toByteArray((InputStream)is);
                }
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            return new package.ZipFileIterator(new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(bytes2)), this.file.toString());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$HadoopDelegate$$factory().createArchiveOutputStream("zip", super.write(mode, createParents));
        }

        public HadoopZipHandle(FileContext fc, Path file) {
            this.fc = fc;
            this.file = file;
            super(fc, file);
        }
    }

    public static class HadoopFileHandle
    implements FileSystemDelegate.FileHandle {
        private final FileContext fc;
        private final Path file;
        private final String format;
        private volatile boolean bitmap$0;

        private String format$lzycompute() {
            HadoopFileHandle hadoopFileHandle = this;
            synchronized (hadoopFileHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate$FileHandle$class.format(this);
                    this.bitmap$0 = true;
                }
                return this.format;
            }
        }

        @Override
        public String format() {
            return this.bitmap$0 ? this.format : this.format$lzycompute();
        }

        @Override
        public boolean write$default$2() {
            return FileSystemDelegate$FileHandle$class.write$default$2(this);
        }

        @Override
        public boolean delete$default$1() {
            return FileSystemDelegate$FileHandle$class.delete$default$1(this);
        }

        @Override
        public String path() {
            return this.file.toString();
        }

        @Override
        public boolean exists() {
            return this.fc.util().exists(this.file);
        }

        @Override
        public long length() {
            return this.exists() ? this.fc.getFileStatus(this.file).getLen() : 0L;
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream is = PathUtils$.MODULE$.handleCompression((InputStream)this.fc.open(this.file), this.file.getName());
            return CloseableIterator$.MODULE$.single(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)is), (Function0<BoxedUnit>)new Serializable(this, is){
                public static final long serialVersionUID = 0L;
                private final InputStream is$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.is$1.close();
                }
                {
                    this.is$1 = is$1;
                }
            });
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            FileSystemDelegate$CreateMode$.MODULE$.validate$extension(mode);
            EnumSet<CreateFlag> flags = EnumSet.noneOf(CreateFlag.class);
            Boolean bl = FileSystemDelegate$CreateMode$.MODULE$.append$extension(mode) ? BoxesRunTime.boxToBoolean((boolean)flags.add(CreateFlag.APPEND)) : (FileSystemDelegate$CreateMode$.MODULE$.overwrite$extension(mode) ? BoxesRunTime.boxToBoolean((boolean)flags.add(CreateFlag.OVERWRITE)) : BoxedUnit.UNIT);
            Object object = FileSystemDelegate$CreateMode$.MODULE$.create$extension(mode) ? BoxesRunTime.boxToBoolean((boolean)flags.add(CreateFlag.CREATE)) : BoxedUnit.UNIT;
            Options.CreateOpts.CreateParent ops = createParents ? Options.CreateOpts.createParent() : Options.CreateOpts.donotCreateParent();
            return this.fc.create(this.file, flags, new Options.CreateOpts[]{ops});
        }

        @Override
        public void delete(boolean recursive) {
            if (this.fc.delete(this.file, recursive)) {
                return;
            }
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})));
        }

        public HadoopFileHandle(FileContext fc, Path file) {
            this.fc = fc;
            this.file = file;
            FileSystemDelegate$FileHandle$class.$init$(this);
        }
    }
}

