/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.iterators;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$class;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.iterators.PlaybackIterator$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.temporal.During;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B\u0001\u0003\u00015\u0011\u0001\u0003\u00157bs\n\f7m[%uKJ\fGo\u001c:\u000b\u0005\r!\u0011!C5uKJ\fGo\u001c:t\u0015\t)a!A\u0003vi&d7O\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)\u0011\u0002\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007cA\u000b\u001955\taC\u0003\u0002\u0018\t\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005e1\"!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB\u00111DI\u0007\u00029)\u0011QDH\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005}\u0001\u0013a\u00024fCR,(/\u001a\u0006\u0003C)\tqa\u001c9f]\u001eL7/\u0003\u0002$9\ti1+[7qY\u00164U-\u0019;ve\u0016\u0004\"!\n\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005%R\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003-\n1aY8n\u0013\ticEA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005\u0011Am\u001d\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001Z1uC*\u0011QGC\u0001\tO\u0016|Go\\8mg&\u0011qG\r\u0002\n\t\u0006$\u0018m\u0015;pe\u0016D\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u0001\tif\u0004XMT1nKB\u00111H\u0010\b\u0003\u001fqJ!!\u0010\t\u0002\rA\u0013X\rZ3g\u0013\ty\u0004I\u0001\u0004TiJLgn\u001a\u0006\u0003{AA\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\tS:$XM\u001d<bYB!q\u0002\u0012$G\u0013\t)\u0005C\u0001\u0004UkBdWM\r\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA!\u001e;jY*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0011!\u0015\r^3\t\u0011=\u0003!\u0011!Q\u0001\nA\u000b1\u0001\u001a;h!\ry\u0011KO\u0005\u0003%B\u0011aa\u00149uS>t\u0007\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\u0002\r\u0019LG\u000e^3s!\ry\u0011K\u0016\t\u0003/fk\u0011\u0001\u0017\u0006\u0003)\u0002J!A\u0017-\u0003\r\u0019KG\u000e^3s\u0011!a\u0006A!A!\u0002\u0013i\u0016A\u0003;sC:\u001chm\u001c:ngB\u0019qB\u0018\u001e\n\u0005}\u0003\"!B!se\u0006L\b\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\u0002\r]Lg\u000eZ8x!\ry\u0011k\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0003QB\t!bY8oGV\u0014(/\u001a8u\u0013\tQWM\u0001\u0005EkJ\fG/[8o\u0011!a\u0007A!A!\u0002\u0013i\u0017\u0001\u0002:bi\u0016\u0004\"a\u00048\n\u0005=\u0004\"!\u0002$m_\u0006$\b\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\u0002\t1Lg/\u001a\t\u0003\u001fML!\u0001\u001e\t\u0003\u000f\t{w\u000e\\3b]\"Aa\u000f\u0001B\u0001B\u0003%q/A\u0005sK\u0006$\u0017\t[3bIB\u0011q\u0002_\u0005\u0003sB\u00111!\u00138u\u0011\u0015Y\b\u0001\"\u0001}\u0003\u0019a\u0014N\\5u}Q!Rp`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\u0001\"A \u0001\u000e\u0003\tAQa\f>A\u0002ABQ!\u000f>A\u0002iBQA\u0011>A\u0002\rCqa\u0014>\u0011\u0002\u0003\u0007\u0001\u000bC\u0004UuB\u0005\t\u0019A+\t\u000fqS\b\u0013!a\u0001;\"9\u0011M\u001fI\u0001\u0002\u0004\u0011\u0007b\u00027{!\u0003\u0005\r!\u001c\u0005\bcj\u0004\n\u00111\u0001s\u0011\u001d1(\u0010%AA\u0002]D\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\u0002\u0007M4G/\u0006\u0002\u0002\u001aA\u00191$a\u0007\n\u0007\u0005uADA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D\u0001\"!\t\u0001A\u0003%\u0011\u0011D\u0001\u0005g\u001a$\b\u0005C\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(\u00059A\r^4OC6,W#\u0001\u001e\t\u000f\u0005-\u0002\u0001)A\u0005u\u0005AA\r^4OC6,\u0007\u0005C\u0005\u00020\u0001\u0011\r\u0011\"\u0003\u00022\u0005)A\u000fZ3ggV\tQ\fC\u0004\u00026\u0001\u0001\u000b\u0011B/\u0002\rQ$WMZ:!\u0011%\tI\u0004\u0001b\u0001\n\u0013\tY$\u0001\u0005ei\u001eLe\u000eZ3y+\u00059\bbBA \u0001\u0001\u0006Ia^\u0001\nIR<\u0017J\u001c3fq\u0002B\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\u0002\u000f\u0011$x\r\u0015:paV\u0011\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n-\u0002\u0015\u0015D\bO]3tg&|g.\u0003\u0003\u0002R\u0005-#\u0001\u0004)s_B,'\u000f^=OC6,\u0007\u0002CA+\u0001\u0001\u0006I!a\u0012\u0002\u0011\u0011$x\r\u0015:pa\u0002B\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0017\u0002\tM|'\u000f^\u000b\u0003\u0003;\u0002Ba\u00040\u0002`A!\u0011\u0011MA3\u001b\t\t\u0019GC\u0002\u0002ZaKA!a\u001a\u0002d\t11k\u001c:u\u0005fD\u0001\"a\u001b\u0001A\u0003%\u0011QL\u0001\u0006g>\u0014H\u000f\t\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003c\nAb^5oI><X*\u001b7mSN,\"!a\u001d\u0011\u0007=\t)(C\u0002\u0002xA\u0011A\u0001T8oO\"A\u00111\u0010\u0001!\u0002\u0013\t\u0019(A\u0007xS:$wn^'jY2L7\u000f\t\u0005\n\u0003\u007f\u0002\u0001\u0019!C\u0005\u0003c\nQa\u001d;beRD\u0011\"a!\u0001\u0001\u0004%I!!\"\u0002\u0013M$\u0018M\u001d;`I\u0015\fH\u0003BAD\u0003\u001b\u00032aDAE\u0013\r\tY\t\u0005\u0002\u0005+:LG\u000f\u0003\u0006\u0002\u0010\u0006\u0005\u0015\u0011!a\u0001\u0003g\n1\u0001\u001f\u00132\u0011!\t\u0019\n\u0001Q!\n\u0005M\u0014AB:uCJ$\b\u0005C\u0005\u0002\u0018\u0002\u0001\r\u0011\"\u0003\u0002r\u0005QQM^3oiN#\u0018M\u001d;\t\u0013\u0005m\u0005\u00011A\u0005\n\u0005u\u0015AD3wK:$8\u000b^1si~#S-\u001d\u000b\u0005\u0003\u000f\u000by\n\u0003\u0006\u0002\u0010\u0006e\u0015\u0011!a\u0001\u0003gB\u0001\"a)\u0001A\u0003&\u00111O\u0001\fKZ,g\u000e^*uCJ$\b\u0005C\u0005\u0002(\u0002\u0011\r\u0011\"\u0003\u0002*\u0006Aa-Z1ukJ,7/\u0006\u0002\u0002,B)\u0011QVAY55\u0011\u0011q\u0016\u0006\u0003Q\"KA!a-\u00020\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vK\"A\u0011q\u0017\u0001!\u0002\u0013\tY+A\u0005gK\u0006$XO]3tA!Y\u00111\u0018\u0001A\u0002\u0003\u0007I\u0011BA_\u0003\u0019\u0019H/Y4fIV\t!\u0004C\u0006\u0002B\u0002\u0001\r\u00111A\u0005\n\u0005\r\u0017AC:uC\u001e,Gm\u0018\u0013fcR!\u0011qQAc\u0011%\ty)a0\u0002\u0002\u0003\u0007!\u0004C\u0004\u0002J\u0002\u0001\u000b\u0015\u0002\u000e\u0002\u000fM$\u0018mZ3eA!I\u0011Q\u001a\u0001C\u0002\u0013%\u0011qZ\u0001\tKb,7-\u001e;peV\u0011\u0011\u0011\u001b\t\u0005\u0003[\u000b\u0019.\u0003\u0003\u0002V\u0006=&aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011\u0005e\u0007\u0001)A\u0005\u0003#\f\u0011\"\u001a=fGV$xN\u001d\u0011\t\u000f\u0005u\u0007\u0001\"\u0011\u0002`\u00069\u0001.Y:OKb$X#\u0001:\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\u0006!a.\u001a=u)\u0005Q\u0002bBAu\u0001\u0011\u0005\u00131^\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u000f3a!a<\u0001\t\u0005E(!D)vKJL(+\u001e8oC\ndWm\u0005\u0004\u0002n\u0006M\u0018q \t\u0005\u0003k\fY0\u0004\u0002\u0002x*\u0019\u0011\u0011 &\u0002\t1\fgnZ\u0005\u0005\u0003{\f9P\u0001\u0004PE*,7\r\u001e\t\u0005\u0003k\u0014\t!\u0003\u0003\u0003\u0004\u0005](\u0001\u0003*v]:\f'\r\\3\t\u000fm\fi\u000f\"\u0001\u0003\bQ\u0011!\u0011\u0002\t\u0005\u0005\u0017\ti/D\u0001\u0001\u0011!\u0011y!!<\u0005B\u0005-\u0018a\u0001:v]\u001e9!1\u0003\u0002\t\u0002\tU\u0011\u0001\u0005)mCf\u0014\u0017mY6Ji\u0016\u0014\u0018\r^8s!\rq(q\u0003\u0004\u0007\u0003\tA\tA!\u0007\u0014\u0007\t]a\u0002C\u0004|\u0005/!\tA!\b\u0015\u0005\tU\u0001B\u0003B\u0011\u0005/\u0011\r\u0011\"\u0003\u0003$\u0005\u0011aMZ\u000b\u0003\u0005K\u00012a\u0016B\u0014\u0013\r\u0011I\u0003\u0017\u0002\u000f\r&dG/\u001a:GC\u000e$xN]=3\u0011%\u0011iCa\u0006!\u0002\u0013\u0011)#A\u0002gM\u0002B!B!\r\u0003\u0018\t\u0007I\u0011\u0002B\u001a\u0003!!XM]7j]\u0006dWC\u0001B\u001b!\u0011\u00119D!\u0010\u000e\u0005\te\"bA\u000f\u0003<)\u0011q\u0004N\u0005\u0005\u0005\u007f\u0011IDA\tTS6\u0004H.\u001a$fCR,(/Z%na2D\u0011Ba\u0011\u0003\u0018\u0001\u0006IA!\u000e\u0002\u0013Q,'/\\5oC2\u0004\u0003B\u0003B$\u0005/\t\n\u0011\"\u0001\u0003J\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"Aa\u0013+\u0007A\u0013ie\u000b\u0002\u0003PA!!\u0011\u000bB.\u001b\t\u0011\u0019F\u0003\u0003\u0003V\t]\u0013!C;oG\",7m[3e\u0015\r\u0011I\u0006E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B/\u0005'\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011\tGa\u0006\u0012\u0002\u0013\u0005!1M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\u0015$fA+\u0003N!Q!\u0011\u000eB\f#\u0003%\tAa\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011iGK\u0002^\u0005\u001bB!B!\u001d\u0003\u0018E\u0005I\u0011\u0001B:\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!Q\u000f\u0016\u0004E\n5\u0003B\u0003B=\u0005/\t\n\u0011\"\u0001\u0003|\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa*\"A! +\u00075\u0014i\u0005\u0003\u0006\u0003\u0002\n]\u0011\u0013!C\u0001\u0005\u0007\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012JTC\u0001BCU\r\u0011(Q\n\u0005\u000b\u0005\u0013\u00139\"%A\u0005\u0002\t-\u0015\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005\u001bS3a\u001eB'\u0001")
public class PlaybackIterator
implements CloseableIterator<SimpleFeature>,
StrictLogging {
    public final DataStore org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ds;
    public final String org$locationtech$geomesa$utils$iterators$PlaybackIterator$$typeName;
    public final Tuple2<Date, Date> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval;
    public final Option<Filter> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$filter;
    private final float rate;
    private final boolean live;
    private final SimpleFeatureType org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sft;
    private final String dtgName;
    private final String[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs;
    private final int dtgIndex;
    private final PropertyName org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp;
    private final SortBy[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort;
    private final long org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis;
    private long start;
    private long eventStart;
    private final LinkedBlockingQueue<SimpleFeature> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features;
    private SimpleFeature staged;
    private final ExecutorService executor;
    private final Logger logger;

    public static int $lessinit$greater$default$10() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean $lessinit$greater$default$9() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$9();
    }

    public static float $lessinit$greater$default$8() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Duration> $lessinit$greater$default$7() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$7();
    }

    public static String[] $lessinit$greater$default$6() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Filter> $lessinit$greater$default$5() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$4();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
        return Iterator.class.map((Iterator)this, (Function1)f);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
        return Iterator.class.filter((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
        return Iterator.class.filterNot((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
        return Iterator.class.take((Iterator)this, (int)n);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$takeWhile(Function1 p) {
        return Iterator.class.takeWhile((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
        return Iterator.class.collect((Iterator)this, (PartialFunction)pf);
    }

    @Override
    public <B> CloseableIterator<B> map(Function1<SimpleFeature, B> f) {
        return CloseableIterator$class.map(this, f);
    }

    @Override
    public CloseableIterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
        return CloseableIterator$class.filter(this, p);
    }

    @Override
    public CloseableIterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
        return CloseableIterator$class.filterNot(this, p);
    }

    @Override
    public CloseableIterator<SimpleFeature> take(int n) {
        return CloseableIterator$class.take(this, n);
    }

    @Override
    public CloseableIterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
        return CloseableIterator$class.takeWhile(this, p);
    }

    @Override
    public <B> CloseableIterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
        return CloseableIterator$class.collect(this, pf);
    }

    @Override
    public <B> CloseableIterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return CloseableIterator$class.$plus$plus(this, that);
    }

    @Override
    public <B> CloseableIterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
        return CloseableIterator$class.flatMap(this, f);
    }

    public Iterator<SimpleFeature> seq() {
        return Iterator.class.seq((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.class.isEmpty((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.class.isTraversableAgain((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.class.hasDefiniteSize((Iterator)this);
    }

    public Iterator<SimpleFeature> drop(int n) {
        return Iterator.class.drop((Iterator)this, (int)n);
    }

    public Iterator<SimpleFeature> slice(int from, int until) {
        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
        return Iterator.class.corresponds((Iterator)this, that, p);
    }

    public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
        return Iterator.class.withFilter((Iterator)this, p);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
        return Iterator.class.scanLeft((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
        return Iterator.class.scanRight((Iterator)this, z, op);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
        return Iterator.class.partition((Iterator)this, p);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
        return Iterator.class.span((Iterator)this, p);
    }

    public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
        return Iterator.class.dropWhile((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
        return Iterator.class.zip((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.class.padTo((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
        return Iterator.class.zipWithIndex((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<SimpleFeature, U> f) {
        Iterator.class.foreach((Iterator)this, f);
    }

    public boolean forall(Function1<SimpleFeature, Object> p) {
        return Iterator.class.forall((Iterator)this, p);
    }

    public boolean exists(Function1<SimpleFeature, Object> p) {
        return Iterator.class.exists((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.class.contains((Iterator)this, (Object)elem);
    }

    public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
        return Iterator.class.find((Iterator)this, p);
    }

    public int indexWhere(Function1<SimpleFeature, Object> p) {
        return Iterator.class.indexWhere((Iterator)this, p);
    }

    public <B> int indexOf(B elem) {
        return Iterator.class.indexOf((Iterator)this, elem);
    }

    public BufferedIterator<SimpleFeature> buffered() {
        return Iterator.class.buffered((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size2) {
        return Iterator.class.grouped((Iterator)this, (int)size2);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
        return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
    }

    public int length() {
        return Iterator.class.length((Iterator)this);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
        return Iterator.class.duplicate((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.class.sameElements((Iterator)this, that);
    }

    public Traversable<SimpleFeature> toTraversable() {
        return Iterator.class.toTraversable((Iterator)this);
    }

    public Iterator<SimpleFeature> toIterator() {
        return Iterator.class.toIterator((Iterator)this);
    }

    public Stream<SimpleFeature> toStream() {
        return Iterator.class.toStream((Iterator)this);
    }

    public String toString() {
        return Iterator.class.toString((Iterator)this);
    }

    public <B> int sliding$default$2() {
        return Iterator.class.sliding$default$2((Iterator)this);
    }

    public List<SimpleFeature> reversed() {
        return TraversableOnce.class.reversed((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.class.size((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
    }

    public int count(Function1<SimpleFeature, Object> p) {
        return TraversableOnce.class.count((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
    }

    public List<SimpleFeature> toList() {
        return TraversableOnce.class.toList((TraversableOnce)this);
    }

    public Iterable<SimpleFeature> toIterable() {
        return TraversableOnce.class.toIterable((TraversableOnce)this);
    }

    public Seq<SimpleFeature> toSeq() {
        return TraversableOnce.class.toSeq((TraversableOnce)this);
    }

    public IndexedSeq<SimpleFeature> toIndexedSeq() {
        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.class.toBuffer((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.class.toSet((TraversableOnce)this);
    }

    public Vector<SimpleFeature> toVector() {
        return TraversableOnce.class.toVector((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<SimpleFeature, Tuple2<T, U>> ev) {
        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.class.mkString((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
    }

    public SimpleFeatureType org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sft() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sft;
    }

    private String dtgName() {
        return this.dtgName;
    }

    public String[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs;
    }

    private int dtgIndex() {
        return this.dtgIndex;
    }

    public PropertyName org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp;
    }

    public SortBy[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort;
    }

    public long org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long eventStart() {
        return this.eventStart;
    }

    private void eventStart_$eq(long x$1) {
        this.eventStart = x$1;
    }

    public LinkedBlockingQueue<SimpleFeature> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features;
    }

    private SimpleFeature staged() {
        return this.staged;
    }

    private void staged_$eq(SimpleFeature x$1) {
        this.staged = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    public boolean hasNext() {
        boolean bl;
        if (this.staged() == null) {
            this.staged_$eq(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().take());
            if (PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$terminal() == this.staged()) {
                this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().put(this.staged());
                this.staged_$eq(null);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeature next() {
        void var1_1;
        long featureRelativeTime;
        long sleep;
        SimpleFeature feature = this.staged();
        this.staged_$eq(null);
        long featureTime = ((Date)feature.getAttribute(this.dtgIndex())).getTime();
        if (this.start() == -1L) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Starting replay clock");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.start_$eq(System.currentTimeMillis());
            this.eventStart_$eq(featureTime);
        }
        if ((sleep = (featureRelativeTime = this.start() + (long)((double)(featureTime - this.eventStart()) / (double)this.rate)) - System.currentTimeMillis()) > 0L) {
            Thread.sleep(sleep);
        }
        if (this.live) {
            feature.setAttribute(this.dtgIndex(), (Object)new Date(featureRelativeTime));
        }
        return var1_1;
    }

    @Override
    public void close() {
        this.executor().shutdownNow();
    }

    public PlaybackIterator(DataStore ds, String typeName, Tuple2<Date, Date> interval, Option<String> dtg, Option<Filter> filter2, String[] transforms, Option<Duration> window, float rate, boolean live, int readAhead) {
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ds = ds;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$typeName = typeName;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval = interval;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$filter = filter2;
        this.rate = rate;
        this.live = live;
        TraversableOnce.class.$init$((TraversableOnce)this);
        Iterator.class.$init$((Iterator)this);
        CloseableIterator$class.$init$(this);
        StrictLogging.class.$init$((StrictLogging)this);
        Predef$.MODULE$.require(((Date)interval._2()).after((Date)interval._1()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaybackIterator $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Interval is not ordered correctly: ", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._1(), this.$outer.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sft = ds.getSchema(typeName);
        this.dtgName = (String)dtg.orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaybackIterator $outer;

            public final Option<String> apply() {
                return RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.$outer.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sft()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException("Schema does not have a default date field");
            }
        });
        String[] stringArray = transforms;
        String[] stringArray2 = stringArray == null ? null : (Predef$.MODULE$.refArrayOps((Object[])stringArray).indexOf((Object)this.dtgName()) == -1 ? (String[])Predef$.MODULE$.refArrayOps((Object[])stringArray).$colon$plus((Object)this.dtgName(), ClassTag$.MODULE$.apply(String.class)) : stringArray);
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs = stringArray2;
        String[] stringArray3 = this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs();
        int n = stringArray3 == null ? this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sft().indexOf(this.dtgName()) : Predef$.MODULE$.refArrayOps((Object[])stringArray3).indexOf((Object)this.dtgName());
        this.dtgIndex = n;
        Predef$.MODULE$.require(this.dtgIndex() != -1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid date field";
            }
        });
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp = PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().property(this.dtgName());
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort = (SortBy[])((Object[])new SortBy[]{PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().sort(this.dtgName(), SortOrder.ASCENDING)});
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis = BoxesRunTime.unboxToLong((Object)window.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Duration x$1) {
                return x$1.toMillis();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaybackIterator $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return ((Date)this.$outer.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2()).getTime() - ((Date)this.$outer.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._1()).getTime() + 1L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.start = -1L;
        this.eventStart = -1L;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features = new LinkedBlockingQueue(readAhead);
        this.executor = Executors.newSingleThreadExecutor();
        this.executor().submit(new QueryRunnable());
    }

    public class QueryRunnable
    implements Runnable {
        @Override
        public void run() {
            try {
                try {
                    Date from = (Date)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._1();
                    Date to = new Date(from.getTime() + this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis());
                    boolean loop = true;
                    while (loop && !Thread.currentThread().isInterrupted()) {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit2;
                        if (((Date)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2()).before(to)) {
                            to = (Date)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2();
                            loop = false;
                        }
                        if (this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().isDebugEnabled()) {
                            this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().debug("Running query window {} to {}", (Object[])new Date[]{from, to});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        DefaultPeriod period = new DefaultPeriod((Instant)new DefaultInstant((Position)new DefaultPosition(from)), (Instant)new DefaultInstant((Position)new DefaultPosition(to)));
                        During during = PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().during((Expression)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp(), (Expression)PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().literal((Object)period));
                        Query query2 = new Query(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$typeName, (Filter)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$filter.map((Function1)new Serializable(this, during){
                            public static final long serialVersionUID = 0L;
                            private final During during$1;

                            public final And apply(Filter x$2) {
                                return PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().and(x$2, (Filter)this.during$1);
                            }
                            {
                                this.during$1 = during$1;
                            }
                        }).getOrElse((Function0)new Serializable(this, during){
                            public static final long serialVersionUID = 0L;
                            private final During during$1;

                            public final During apply() {
                                return this.during$1;
                            }
                            {
                                this.during$1 = during$1;
                            }
                        }), this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs());
                        query2.setSortBy(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort());
                        query2.getHints().put((Object)Hints.MAX_MEMORY_SORT, (Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
                        LongRef count2 = LongRef.create((long)0L);
                        SelfClosingIterator$.MODULE$.apply(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ds.getFeatureReader(query2, Transaction.AUTO_COMMIT)).foreach((Function1)new Serializable(this, count2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ QueryRunnable $outer;
                            private final LongRef count$1;

                            public final void apply(SimpleFeature f) {
                                this.$outer.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().put(f);
                                ++this.count$1.elem;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.count$1 = count$1;
                            }
                        });
                        if (this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().isDebugEnabled()) {
                            this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().debug("Returned {} features from query window {} to {}", new Object[]{BoxesRunTime.boxToLong((long)count2.elem), from, to});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        from = to;
                        to = new Date(from.getTime() + this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis());
                    }
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                    if (option2.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option2.get();
                    if (this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().isErrorEnabled()) {
                        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().error("Error querying playback:", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                }
            }
            finally {
                this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().put((SimpleFeature)PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$terminal());
            }
        }

        public /* synthetic */ PlaybackIterator org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer() {
            return PlaybackIterator.this;
        }

        public QueryRunnable() {
            if (PlaybackIterator.this == null) {
                throw null;
            }
        }
    }
}

