/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$class;
import org.locationtech.geomesa.utils.stats.Z3Histogram$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u0001\u0003\u00015\u00111BW\u001aISN$xn\u001a:b[*\u00111\u0001B\u0001\u0006gR\fGo\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0005'R\fG\u000f\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u0005a1oY1mC2|wmZ5oO*\u0011QDH\u0001\tif\u0004Xm]1gK*\tq$A\u0002d_6L!!\t\u000e\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005\u00191O\u001a;\u0016\u0003\u0015\u0002\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\rMLW\u000e\u001d7f\u0015\tQ3&A\u0004gK\u0006$XO]3\u000b\u00051R\u0011aB8qK:<\u0017n]\u0005\u0003]\u001d\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011!\u0001\u0004A!A!\u0002\u0013)\u0013\u0001B:gi\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\u0005O\u0016|W.F\u00015!\t)\u0004H\u0004\u0002\u0010m%\u0011q\u0007E\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028!!AA\b\u0001B\u0001B\u0003%A'A\u0003hK>l\u0007\u0005\u0003\u0005?\u0001\t\u0015\r\u0011\"\u00014\u0003\r!Go\u001a\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005i\u0005!A\r^4!\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0015A\u00029fe&|G-F\u0001E!\t)UK\u0004\u0002G%:\u0011q\t\u0015\b\u0003\u0011>s!!\u0013(\u000f\u0005)kU\"A&\u000b\u00051c\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011\u0011KB\u0001\u0006GV\u0014h/Z\u0005\u0003'R\u000b!\u0002V5nKB+'/[8e\u0015\t\tf!\u0003\u0002W/\nQA+[7f!\u0016\u0014\u0018n\u001c3\u000b\u0005M#\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\u000fA,'/[8eA!A1\f\u0001BC\u0002\u0013\u0005A,\u0001\u0004mK:<G\u000f[\u000b\u0002;B\u0011qBX\u0005\u0003?B\u00111!\u00138u\u0011!\t\u0007A!A!\u0002\u0013i\u0016a\u00027f]\u001e$\b\u000e\t\u0005\u0006G\u0002!\t\u0001Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u00154w\r[5k!\t)\u0002\u0001C\u0003$E\u0002\u0007Q\u0005C\u00033E\u0002\u0007A\u0007C\u0003?E\u0002\u0007A\u0007C\u0003CE\u0002\u0007A\tC\u0003\\E\u0002\u0007Q,\u0002\u0003m\u0001\u0001*'!A*\t\u000f9\u0004!\u0019!C\u00059\u0006\tq\r\u0003\u0004q\u0001\u0001\u0006I!X\u0001\u0003O\u0002BqA\u001d\u0001C\u0002\u0013%A,A\u0001e\u0011\u0019!\b\u0001)A\u0005;\u0006\u0011A\r\t\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u0003\r\u0019hmY\u000b\u0002qB\u0011\u0011P_\u0007\u0002)&\u00111\u0010\u0016\u0002\u00065N\u001afi\u0011\u0005\u0007{\u0002\u0001\u000b\u0011\u0002=\u0002\tM47\r\t\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005IA/[7f)>\u0014\u0015N\\\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f9\u0019\u00110a\u0002\n\u0007\u0005%A+\u0001\u0006CS:tW\r\u001a+j[\u0016LA!!\u0004\u0002\u0010\t\u0001B+[7f)>\u0014\u0015N\u001c8fIRKW.\u001a\u0006\u0004\u0003\u0013!\u0006\u0002CA\n\u0001\u0001\u0006I!a\u0001\u0002\u0015QLW.\u001a+p\u0005&t\u0007\u0005C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a\u0005I!-\u001b8U_\u0012\u000bG/Z\u000b\u0003\u00037\u0001B!!\u0002\u0002\u001e%!\u0011qDA\b\u0005A\u0011\u0015N\u001c8fIRKW.\u001a+p\t\u0006$X\r\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\u000e\u0003)\u0011\u0017N\u001c+p\t\u0006$X\r\t\u0005\n\u0003O\u0001!\u0019!C\u0005\u0003S\tA!\\5o5V\u0011\u00111\u0006\t\u0004\u001f\u00055\u0012bAA\u0018!\t!Aj\u001c8h\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005-\u0012!B7j]j\u0003\u0003\"CA\u001c\u0001\t\u0007I\u0011BA\u0015\u0003\u0011i\u0017\r\u001f.\t\u0011\u0005m\u0002\u0001)A\u0005\u0003W\tQ!\\1y5\u0002B\u0011\"a\u0010\u0001\u0011\u000b\u0007I\u0011B\u001a\u0002\u0015)\u001cxN\u001c$pe6\fG\u000fC\u0005\u0002D\u0001A\t\u0011)Q\u0005i\u0005Y!n]8o\r>\u0014X.\u0019;!\u0011)\t9\u0005\u0001b\u0001\n\u0003\u0011\u0011\u0011J\u0001\u0007E&tW*\u00199\u0016\u0005\u0005-\u0003\u0003CA'\u0003/\nY&!\u0019\u000e\u0005\u0005=#\u0002BA)\u0003'\nq!\\;uC\ndWMC\u0002\u0002VA\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI&a\u0014\u0003\u00075\u000b\u0007\u000fE\u0002\u0010\u0003;J1!a\u0018\u0011\u0005\u0015\u0019\u0006n\u001c:u!\u0015)\u00121MA4\u0013\r\t)G\u0001\u0002\f\u0005&tg.\u001a3BeJ\f\u0017\u0010\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\t1\fgn\u001a\u0006\u0003\u0003c\nAA[1wC&!\u0011qFA6\u0011!\t9\b\u0001Q\u0001\n\u0005-\u0013a\u00022j]6\u000b\u0007\u000f\t\u0005\t\u0003w\u0002A\u0011\u0001\u0002\u0002~\u00059a.Z<CS:\u001cXCAA1\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007\u000b\u0001\u0002^5nK\nKgn]\u000b\u0003\u0003\u000b\u0003b!a\"\u0002\u0012\u0006mc\u0002BAE\u0003\u001bs1ASAF\u0013\u0005\t\u0012bAAH!\u00059\u0001/Y2lC\u001e,\u0017\u0002BAJ\u0003+\u00131aU3r\u0015\r\ty\t\u0005\u0005\b\u00033\u0003A\u0011AAN\u0003\u0015\u0019w.\u001e8u)\u0019\tY#!(\u0002\"\"A\u0011qTAL\u0001\u0004\tY&A\u0004uS6,')\u001b8\t\u000f\u0005\r\u0016q\u0013a\u0001;\u0006\t\u0011\u000eC\u0004\u0002(\u0002!\t!!+\u0002\u0017\u0011L'/Z2u\u0013:$W\r\u001f\u000b\u0006;\u0006-\u0016Q\u0016\u0005\t\u0003?\u000b)\u000b1\u0001\u0002\\!A\u0011qVAS\u0001\u0004\tY#A\u0003wC2,X\rC\u0004\u00024\u0002!\t!!.\u0002\u000f%tG-\u001a=PMR!\u0011qWA_!\u0019y\u0011\u0011XA.;&\u0019\u00111\u0018\t\u0003\rQ+\b\u000f\\33\u0011!\ty+!-A\u0002\u0005}\u0006cB\b\u0002:\u0006\u0005\u0017q\u001a\t\u0005\u0003\u0007\fY-\u0004\u0002\u0002F*\u0019!'a2\u000b\u0007\u0005%\u0007\"A\u0002kiNLA!!4\u0002F\nAq)Z8nKR\u0014\u0018\u0010\u0005\u0003\u0002R\u0006]WBAAj\u0015\u0011\t).a\u001c\u0002\tU$\u0018\u000e\\\u0005\u0005\u00033\f\u0019N\u0001\u0003ECR,\u0007bBAo\u0001\u0011\u0005\u0011q\\\u0001\f[\u0016$\u0017.\u00198WC2,X\r\u0006\u0004\u0002@\u0006\u0005\u00181\u001d\u0005\t\u0003?\u000bY\u000e1\u0001\u0002\\!9\u00111UAn\u0001\u0004i\u0006bBAt\u0001\u0011%\u0011\u0011^\u0001\u0006i>\\U-\u001f\u000b\t\u0003W\fi/a<\u0002rB9q\"!/\u0002\\\u0005-\u0002b\u0002\u001a\u0002f\u0002\u0007\u0011\u0011\u0019\u0005\b}\u0005\u0015\b\u0019AAh\u0011!\t\u00190!:A\u0002\u0005U\u0018a\u00027f]&,g\u000e\u001e\t\u0004\u001f\u0005]\u0018bAA}!\t9!i\\8mK\u0006t\u0007bBA\u007f\u0001\u0011%\u0011q`\u0001\bMJ|WnS3z)\u0019\tyL!\u0001\u0003\u0004!A\u0011qTA~\u0001\u0004\tY\u0006\u0003\u0005\u0003\u0006\u0005m\b\u0019AA\u0016\u0003\u0005Q\bb\u0002B\u0005\u0001\u0011\u0005!1B\u0001\fgBd\u0017\u000e\u001e\"z)&lW-\u0006\u0002\u0003\u000eA1\u0011qQAI\u0005\u001f\u0001baDA]\u00037*\u0007b\u0002B\n\u0001\u0011\u0005#QC\u0001\b_\n\u001cXM\u001d<f)\u0011\u00119B!\b\u0011\u0007=\u0011I\"C\u0002\u0003\u001cA\u0011A!\u00168ji\"A!q\u0004B\t\u0001\u0004\u0011\t#\u0001\u0002tMB\u0019aEa\t\n\u0007\t\u0015rEA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0003%)hn\u001c2tKJ4X\r\u0006\u0003\u0003\u0018\t5\u0002\u0002\u0003B\u0010\u0005O\u0001\rA!\t\t\u000f\tE\u0002\u0001\"\u0011\u00034\u0005)A\u0005\u001d7vgR\u0019QM!\u000e\t\u000f\t]\"q\u0006a\u0001K\u0006)q\u000e\u001e5fe\"9!1\b\u0001\u0005B\tu\u0012\u0001\u0003\u0013qYV\u001cH%Z9\u0015\t\t]!q\b\u0005\b\u0005o\u0011I\u00041\u0001f\u0011\u001d\u0011\u0019\u0005\u0001C!\u0005\u000b\nA\u0002^8Kg>twJ\u00196fGR,\"Aa\u0012\u0011\u0007=\u0011I%C\u0002\u0003LA\u00111!\u00118z\u0011\u001d\u0011y\u0005\u0001C!\u0005#\nq![:F[B$\u00180\u0006\u0002\u0002v\"9!Q\u000b\u0001\u0005B\t]\u0013!B2mK\u0006\u0014HC\u0001B\f\u0011\u001d\u0011Y\u0006\u0001C!\u0005;\nA\"[:FcVLg/\u00197f]R$B!!>\u0003`!9!q\u0007B-\u0001\u0004!ra\u0002B2\u0005!\u0005!QM\u0001\f5NB\u0015n\u001d;pOJ\fW\u000eE\u0002\u0016\u0005O2a!\u0001\u0002\t\u0002\t%4c\u0001B4\u001d!91Ma\u001a\u0005\u0002\t5DC\u0001B3\u0011)\u0011\tHa\u001aC\u0002\u0013%!1O\u0001\u0003O\u001a,\"A!\u001e\u0011\t\u0005\r'qO\u0005\u0005\u0005s\n)MA\bHK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z\u0011%\u0011iHa\u001a!\u0002\u0013\u0011)(A\u0002hM\u0002B!B!!\u0003h\t\u0007I\u0011\u0001BB\u0003\u001di\u0017N\\$f_6,\"A!\"\u0011\t\u0005\r'qQ\u0005\u0005\u0005\u0013\u000b)MA\u0003Q_&tG\u000fC\u0005\u0003\u000e\n\u001d\u0004\u0015!\u0003\u0003\u0006\u0006AQ.\u001b8HK>l\u0007\u0005\u0003\u0006\u0003\u0012\n\u001d$\u0019!C\u0001\u0005\u0007\u000bq!\\1y\u000f\u0016|W\u000eC\u0005\u0003\u0016\n\u001d\u0004\u0015!\u0003\u0003\u0006\u0006AQ.\u0019=HK>l\u0007\u0005")
public class Z3Histogram
implements Stat,
LazyLogging {
    private final SimpleFeatureType sft;
    private final String geom;
    private final String dtg;
    private final Enumeration.Value period;
    private final int length;
    private final int g;
    private final int d;
    private final Z3SFC sfc;
    private final Function1<Object, BinnedTime> timeToBin;
    private final Function1<BinnedTime, ZonedDateTime> binToDate;
    private final long minZ;
    private final long maxZ;
    private String org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat;
    private final Map<Object, BinnedArray<Long>> binMap;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static Point maxGeom() {
        return Z3Histogram$.MODULE$.maxGeom();
    }

    public static Point minGeom() {
        return Z3Histogram$.MODULE$.minGeom();
    }

    private String org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat$lzycompute() {
        Z3Histogram z3Histogram2 = this;
        synchronized (z3Histogram2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String string2;
                Enumeration.Value value2 = this.period();
                Enumeration.Value value3 = TimePeriod$.MODULE$.Day();
                Enumeration.Value value4 = value2;
                if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                    string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%05d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                } else {
                    Enumeration.Value value5 = TimePeriod$.MODULE$.Week();
                    Enumeration.Value value6 = value2;
                    if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%04d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                    } else {
                        Enumeration.Value value7 = TimePeriod$.MODULE$.Month();
                        Enumeration.Value value8 = value2;
                        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%03d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                        } else {
                            Enumeration.Value value9 = TimePeriod$.MODULE$.Year();
                            Enumeration.Value value10 = value2;
                            if (value9 != null ? !value9.equals(value10) : value10 != null) {
                                throw new MatchError((Object)value2);
                            }
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%02d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                        }
                    }
                }
                this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat = string2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat;
        }
    }

    private Logger logger$lzycompute() {
        Z3Histogram z3Histogram2 = this;
        synchronized (z3Histogram2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat$class.$plus$eq(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat$class.$plus(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat$class.toJson(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String geom() {
        return this.geom;
    }

    public String dtg() {
        return this.dtg;
    }

    public Enumeration.Value period() {
        return this.period;
    }

    public int length() {
        return this.length;
    }

    private int g() {
        return this.g;
    }

    private int d() {
        return this.d;
    }

    private Z3SFC sfc() {
        return this.sfc;
    }

    private Function1<Object, BinnedTime> timeToBin() {
        return this.timeToBin;
    }

    private Function1<BinnedTime, ZonedDateTime> binToDate() {
        return this.binToDate;
    }

    private long minZ() {
        return this.minZ;
    }

    private long maxZ() {
        return this.maxZ;
    }

    public String org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat$lzycompute() : this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat;
    }

    public Map<Object, BinnedArray<Long>> binMap() {
        return this.binMap;
    }

    public BinnedArray<Long> newBins() {
        return new BinnedArray<Long>(new BinnedArray.LongBinning(this.length(), (Tuple2<Long, Long>)new Tuple2((Object)Predef$.MODULE$.long2Long(this.minZ()), (Object)Predef$.MODULE$.long2Long(this.maxZ()))));
    }

    public Seq<Object> timeBins() {
        return (Seq)this.binMap().keys().toSeq().sorted((Ordering)Ordering.Short$.MODULE$);
    }

    public long count(short timeBin, int i) {
        return BoxesRunTime.unboxToLong((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1)new Serializable(this, i){
            public static final long serialVersionUID = 0L;
            private final int i$1;

            public final long apply(BinnedArray<Long> x$1) {
                return x$1.counts()[this.i$1];
            }
            {
                this.i$1 = i$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public int directIndex(short timeBin, long value2) {
        return BoxesRunTime.unboxToInt((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1)new Serializable(this, value2){
            public static final long serialVersionUID = 0L;
            private final long value$1;

            public final int apply(BinnedArray<Long> x$2) {
                return x$2.indexOf(Predef$.MODULE$.long2Long(this.value$1));
            }
            {
                this.value$1 = value$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }));
    }

    public Tuple2<Object, Object> indexOf(Tuple2<Geometry, Date> value2) {
        Tuple2<Object, Object> tuple2 = this.toKey((Geometry)value2._1(), (Date)value2._2(), false);
        if (tuple2 != null) {
            Tuple2 tuple22;
            short timeBin = BoxesRunTime.unboxToShort((Object)tuple2._1());
            long z = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z));
            short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long z2 = tuple23._2$mcJ$sp();
            return new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin2), (Object)BoxesRunTime.boxToInteger((int)this.directIndex(timeBin2, z2)));
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Geometry, Date> medianValue(short timeBin, int i) {
        return this.fromKey(timeBin, Predef$.MODULE$.Long2long((Long)((BinnedArray)this.binMap().apply((Object)BoxesRunTime.boxToShort((short)timeBin))).medianValue(i)));
    }

    private Tuple2<Object, Object> toKey(Geometry geom, Date dtg, boolean lenient) {
        BinnedTime binnedTime = (BinnedTime)this.timeToBin().apply((Object)BoxesRunTime.boxToLong((long)dtg.getTime()));
        if (binnedTime != null) {
            Tuple2 tuple2;
            short bin = binnedTime.bin();
            long offset = binnedTime.offset();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)offset));
            short bin2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
            long offset2 = tuple22._2$mcJ$sp();
            Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
            long z = this.sfc().index(centroid.getX(), centroid.getY(), offset2, lenient);
            return new Tuple2((Object)BoxesRunTime.boxToShort((short)bin2), (Object)BoxesRunTime.boxToLong((long)z));
        }
        throw new MatchError((Object)binnedTime);
    }

    private Tuple2<Geometry, Date> fromKey(short timeBin, long z) {
        Tuple3 tuple3 = this.sfc().invert(z);
        if (tuple3 != null) {
            Tuple3 tuple32;
            double x = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double y = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            long t = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToLong((long)t));
            double x2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
            double y2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
            long t2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
            Date dtg = Date.from(((ChronoZonedDateTime)this.binToDate().apply((Object)new BinnedTime(timeBin, t2))).toInstant());
            Point geom = Z3Histogram$.MODULE$.org$locationtech$geomesa$utils$stats$Z3Histogram$$gf().createPoint(new Coordinate(x2, y2));
            return new Tuple2((Object)geom, (Object)dtg);
        }
        throw new MatchError((Object)tuple3);
    }

    public Seq<Tuple2<Object, Z3Histogram>> splitByTime() {
        return (Seq)this.binMap().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Histogram $outer;

            public final Tuple2<Object, Z3Histogram> apply(Tuple2<Object, BinnedArray<Long>> x0$1) {
                Tuple2<Object, BinnedArray<Long>> tuple2 = x0$1;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedArray bins = (BinnedArray)tuple2._2();
                    Z3Histogram hist = new Z3Histogram(this.$outer.sft(), this.$outer.geom(), this.$outer.dtg(), this.$outer.period(), this.$outer.length());
                    hist.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)w), (Object)hist);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.g());
        Date dtg = (Date)sf.getAttribute(this.d());
        if (geom != null && dtg != null) {
            try {
                Tuple2 tuple2;
                Tuple2<Object, Object> tuple22 = this.toKey(geom, dtg, false);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z3 = tuple22._2$mcJ$sp();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                ((BinnedArray)this.binMap().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)timeBin2), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Z3Histogram $outer;

                    public final BinnedArray<Long> apply() {
                        return this.$outer.newBins();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).add(Predef$.MODULE$.long2Long(z32), 1L);
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, exception.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.g());
        Date dtg = (Date)sf.getAttribute(this.d());
        if (geom != null && dtg != null) {
            try {
                Tuple2 tuple2;
                Tuple2<Object, Object> tuple22 = this.toKey(geom, dtg, true);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z3 = tuple22._2$mcJ$sp();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin2)).foreach((Function1)new Serializable(this, z32){
                    public static final long serialVersionUID = 0L;
                    private final long z3$1;

                    public final void apply(BinnedArray<Long> x$8) {
                        x$8.add(Predef$.MODULE$.long2Long(this.z3$1), -1L);
                    }
                    {
                        this.z3$1 = z3$1;
                    }
                });
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error un-observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, exception.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Z3Histogram $plus(Z3Histogram other) {
        void var2_2;
        Z3Histogram plus2 = new Z3Histogram(this.sft(), this.geom(), this.dtg(), this.period(), this.length());
        plus2.$plus$eq(this);
        plus2.$plus$eq(other);
        return var2_2;
    }

    public void $plus$eq(Z3Histogram other) {
        if (this.length() != other.length()) {
            throw new NotImplementedError("Can only add z3 histograms with the same length");
        }
        other.binMap().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Histogram $outer;

            public final Object apply(Tuple2<Object, BinnedArray<Long>> x0$2) {
                Tuple2<Object, BinnedArray<Long>> tuple2;
                block3: {
                    Option option2;
                    block6: {
                        Option option3;
                        block5: {
                            BinnedArray bins;
                            block4: {
                                tuple2 = x0$2;
                                if (tuple2 == null) break block3;
                                short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                bins = (BinnedArray)tuple2._2();
                                option2 = this.$outer.binMap().get((Object)BoxesRunTime.boxToShort((short)w));
                                if (!None$.MODULE$.equals(option2)) break block4;
                                option3 = this.$outer.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
                                break block5;
                            }
                            if (!(option2 instanceof Some)) break block6;
                            Some some = (Some)option2;
                            BinnedArray b = (BinnedArray)some.x();
                            for (int i = 0; i < b.length(); ++i) {
                                int n = i;
                                b.counts()[n] = b.counts()[n] + bins.counts()[i];
                            }
                            option3 = BoxedUnit.UNIT;
                        }
                        Option option4 = option3;
                        return option4;
                    }
                    throw new MatchError((Object)option2);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Object toJsonObject() {
        return ((TraversableLike)((TraversableLike)this.binMap().toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(Tuple2<Object, BinnedArray<Long>> x$9) {
                return BoxesRunTime.unboxToShort((Object)x$9._1());
            }
        }, (Ordering)Ordering.Short$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Histogram $outer;

            public final Tuple2<String, BinnedArray<Long>> apply(Tuple2<Object, BinnedArray<Long>> x0$3) {
                Tuple2<Object, BinnedArray<Long>> tuple2 = x0$3;
                if (tuple2 != null) {
                    short p = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedArray bins = (BinnedArray)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)String.format(this.$outer.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat(), BoxesRunTime.boxToShort((short)p)), (Object)bins);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, long[]>> apply(Tuple2<String, BinnedArray<Long>> x0$4) {
                Tuple2<String, BinnedArray<Long>> tuple2 = x0$4;
                if (tuple2 != null) {
                    String label = (String)tuple2._1();
                    BinnedArray bins = (BinnedArray)tuple2._2();
                    scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), (Object)bins.counts())})))}));
                    return map2;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isEmpty() {
        return this.binMap().values().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BinnedArray<Long> x$10) {
                return Predef$.MODULE$.longArrayOps(x$10.counts()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$11) {
                        return this.apply$mcZJ$sp(x$11);
                    }

                    public boolean apply$mcZJ$sp(long x$11) {
                        return x$11 == 0L;
                    }
                });
            }
        });
    }

    @Override
    public void clear() {
        this.binMap().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BinnedArray<Long> x$12) {
                x$12.clear();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat2 = other;
        if (!(stat2 instanceof Z3Histogram)) return false;
        Z3Histogram z3Histogram2 = (Z3Histogram)stat2;
        if (this.g() != z3Histogram2.g()) return false;
        if (this.d() != z3Histogram2.d()) return false;
        Enumeration.Value value2 = this.period();
        Enumeration.Value value3 = z3Histogram2.period();
        if (value2 == null) {
            if (value3 != null) {
                return false;
            }
        } else if (!value2.equals(value3)) return false;
        if (this.length() != z3Histogram2.length()) return false;
        Set set = this.binMap().keySet();
        Set set2 = z3Histogram2.binMap().keySet();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        if (!this.binMap().forall((Function1)new Serializable(this, z3Histogram2){
            public static final long serialVersionUID = 0L;
            private final Z3Histogram x2$1;

            public final boolean apply(Tuple2<Object, BinnedArray<Long>> x0$5) {
                Tuple2<Object, BinnedArray<Long>> tuple2 = x0$5;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedArray bins = (BinnedArray)tuple2._2();
                    boolean bl = Arrays.equals(bins.counts(), ((BinnedArray)this.x2$1.binMap().apply((Object)BoxesRunTime.boxToShort((short)w))).counts());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.x2$1 = x2$1;
            }
        })) return false;
        return true;
    }

    public Z3Histogram(SimpleFeatureType sft, String geom, String dtg, Enumeration.Value period, int length2) {
        this.sft = sft;
        this.geom = geom;
        this.dtg = dtg;
        this.period = period;
        this.length = length2;
        Stat$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.g = sft.indexOf(geom);
        this.d = sft.indexOf(dtg);
        this.sfc = Z3SFC$.MODULE$.apply(period);
        this.timeToBin = BinnedTime$.MODULE$.timeToBinnedTime(period);
        this.binToDate = BinnedTime$.MODULE$.binnedTimeToDate(period);
        this.minZ = this.sfc().index(Z3Histogram$.MODULE$.minGeom().getX(), Z3Histogram$.MODULE$.minGeom().getY(), (long)this.sfc().time().min(), this.sfc().index$default$4());
        this.maxZ = this.sfc().index(Z3Histogram$.MODULE$.maxGeom().getX(), Z3Histogram$.MODULE$.maxGeom().getY(), (long)this.sfc().time().max(), this.sfc().index$default$4());
        this.binMap = Map$.MODULE$.empty();
    }
}

