/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.classpath;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClassPathUtils$
implements LazyLogging {
    public static final ClassPathUtils$ MODULE$ = new ClassPathUtils$();
    private static final FilenameFilter jarFileFilter;
    private static final FileFilter folderFileFilter;
    private static final FileFilter fileFilter;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        jarFileFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && !name.endsWith("-sources.jar") && !name.endsWith("-javadoc.jar");
            }
        };
        folderFileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        fileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
    }

    private Logger logger$lzycompute() {
        ClassPathUtils$ classPathUtils$ = this;
        synchronized (classPathUtils$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private FilenameFilter jarFileFilter() {
        return jarFileFilter;
    }

    private FileFilter folderFileFilter() {
        return folderFileFilter;
    }

    private FileFilter fileFilter() {
        return fileFilter;
    }

    public scala.collection.immutable.Seq<File> findJars(scala.collection.immutable.Seq<String> jars, Iterator<Function0<scala.collection.immutable.Seq<File>>> searchPath) {
        BoxedUnit boxedUnit;
        ArrayBuffer foundJars = ArrayBuffer$.MODULE$.empty();
        scala.collection.immutable.Seq remaining = jars;
        while (remaining.nonEmpty() && searchPath.hasNext()) {
            scala.collection.immutable.Seq files = (scala.collection.immutable.Seq)((Function0)searchPath.next()).apply();
            remaining = (scala.collection.immutable.Seq)remaining.filter((Function1 & Serializable)jarPrefix -> BoxesRunTime.boxToBoolean((boolean)ClassPathUtils$.$anonfun$findJars$1(files, foundJars, jarPrefix)));
        }
        if (remaining.nonEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Could not find requested jars: {}", remaining);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((IterableOnceOps)foundJars.distinct()).toSeq();
    }

    public scala.collection.immutable.Seq<File> getJarsFromEnvironment(String home) {
        return (scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable(scala.sys.package$.MODULE$.env().get((Object)home).map((Function1 & Serializable)x$2 -> new File((String)x$2)).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDirectory()))).toSeq().flatMap((Function1 & Serializable)dir -> MODULE$.loadJarsFromFolder((File)dir));
    }

    public scala.collection.immutable.Seq<File> getJarsFromEnvironment(String home, String path) {
        return (scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable(scala.sys.package$.MODULE$.env().get((Object)home).map((Function1 & Serializable)h -> new File(new File((String)h), path)).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDirectory()))).toSeq().flatMap((Function1 & Serializable)dir -> MODULE$.loadJarsFromFolder((File)dir));
    }

    public scala.collection.immutable.Seq<File> getJarsFromClasspath(Class<?> clas) {
        BoxedUnit boxedUnit;
        ClassLoader classLoader = clas.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs()), (Function1 & Serializable)u -> new File(MODULE$.cleanClassPathURL(u.getFile())), ClassTag$.MODULE$.apply(File.class)));
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Can't load jars from classloader of type {}", (Object)classLoader.getClass().getCanonicalName());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    public scala.collection.immutable.Seq<File> getJarsFromSystemClasspath() {
        URL[] urls = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])urls), (Function1 & Serializable)u -> new File(MODULE$.cleanClassPathURL(u.getFile())), ClassTag$.MODULE$.apply(File.class)));
    }

    public scala.collection.immutable.Seq<File> loadJarsFromFolder(File dir2) {
        scala.collection.immutable.Seq files = (scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)dir2.listFiles(this.jarFileFilter()))).toSeq().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
        scala.collection.immutable.Seq children = (scala.collection.immutable.Seq)((IterableOps)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)dir2.listFiles(this.folderFileFilter()))).toSeq().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs))).flatMap((Function1 & Serializable)dir -> MODULE$.loadJarsFromFolder((File)dir));
        return (scala.collection.immutable.Seq)files.$plus$plus((IterableOnce)children);
    }

    public scala.collection.immutable.Seq<File> getFilesFromSystemProperty(String prop) {
        Option option = Option$.MODULE$.apply((Object)System.getProperty(prop));
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            return (scala.collection.immutable.Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])path.toString().split(":")), (Function1 & Serializable)x$5 -> new File((String)x$5), ClassTag$.MODULE$.apply(File.class)))).flatMap((Function1 & Serializable)file -> MODULE$.loadFiles((File)file));
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("No files loaded onto classpath from system property: {}", (Object)prop);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        throw new MatchError((Object)option);
    }

    public scala.collection.immutable.Seq<File> loadFiles(File file2) {
        if (file2.isDirectory()) {
            scala.collection.immutable.Seq files = (scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)file2.listFiles(this.fileFilter()))).toSeq().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
            scala.collection.immutable.Seq childDirs = (scala.collection.immutable.Seq)((IterableOps)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)file2.listFiles(this.folderFileFilter()))).toSeq().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs))).flatMap((Function1 & Serializable)file -> MODULE$.loadFiles((File)file));
            return (scala.collection.immutable.Seq)files.$plus$plus((IterableOnce)childDirs);
        }
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)file2)).toSeq();
    }

    public String cleanClassPathURL(String url) {
        return URLDecoder.decode(url, "UTF-8").replace("file:", "").replace("!", "");
    }

    public scala.collection.immutable.Seq<File> loadClassPathFromEnv(String prop) {
        BoxedUnit boxedUnit;
        scala.collection.immutable.Seq files = (scala.collection.immutable.Seq)((IterableOps)Option$.MODULE$.option2Iterable(scala.sys.package$.MODULE$.env().get((Object)prop)).toSeq().flatMap((Function1 & Serializable)x$6 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$6), ':'))))).flatMap((Function1 & Serializable)entry -> {
            if (entry.endsWith("/*")) {
                return Predef$.MODULE$.wrapRefArray((Object[])new File(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entry), 2)).listFiles(MODULE$.jarFileFilter()));
            }
            File f = new File((String)entry);
            if (f.isDirectory()) {
                return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)f.listFiles())).toSeq().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
            }
            return new .colon.colon((Object)f, (List)Nil$.MODULE$);
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Loaded env classpath '{}': {}", new Object[]{prop, ((IterableOnceOps)files.map((Function1 & Serializable)x$7 -> x$7.getAbsolutePath())).mkString(":")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return files;
    }

    public static final /* synthetic */ boolean $anonfun$findJars$2(String jarPrefix$1, File x$1) {
        return x$1.getName().startsWith(jarPrefix$1);
    }

    public static final /* synthetic */ boolean $anonfun$findJars$1(scala.collection.immutable.Seq files$1, ArrayBuffer foundJars$1, String jarPrefix) {
        scala.collection.immutable.Seq matched = (scala.collection.immutable.Seq)files$1.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClassPathUtils$.$anonfun$findJars$2(jarPrefix, x$1)));
        foundJars$1.$plus$plus$eq((IterableOnce)matched);
        return matched.isEmpty();
    }

    private ClassPathUtils$() {
    }
}

