/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.classpath;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ServiceLoader;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;

public final class ServiceLoader$
implements LazyLogging {
    public static final ServiceLoader$ MODULE$ = new ServiceLoader$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        ServiceLoader$ serviceLoader$ = this;
        synchronized (serviceLoader$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public <T> List<T> load(Option<ClassLoader> loader, ClassTag<T> ct) {
        Class clas = ct.runtimeClass();
        ClassLoader ldr = (ClassLoader)loader.getOrElse((Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl == null || ServiceLoader$.chain$1(clas.getClassLoader()).contains((Object)ccl)) {
                return clas.getClassLoader();
            }
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Using a context ClassLoader that does not contain the class to load ({}): {}", new Object[]{clas.getName(), ccl});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return ccl;
        });
        return ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(clas, ldr)).asScala()).toList();
    }

    public <T> Option<ClassLoader> load$default$1() {
        return None$.MODULE$;
    }

    public <T> T loadExactlyOne(Option<ClassLoader> loader, ClassTag<T> ct) throws IllegalStateException {
        List<T> all = this.load(loader, ct);
        if (all.lengthCompare(1) != 0) {
            throw new IllegalStateException(new StringBuilder(34).append("Expected 1 instance of ").append(ct.runtimeClass().getName()).append(" but found ").append(all.length()).toString());
        }
        return (T)all.head();
    }

    public <T> Option<ClassLoader> loadExactlyOne$default$1() {
        return None$.MODULE$;
    }

    public <T> Option<T> loadAtMostOne(Option<ClassLoader> loader, ClassTag<T> ct) throws IllegalStateException {
        List<T> all = this.load(loader, ct);
        if (all.lengthCompare(1) > 0) {
            throw new IllegalStateException(new StringBuilder(40).append("Expected 0 or 1 instances of ").append(ct.runtimeClass().getName()).append(" but found ").append(all.length()).toString());
        }
        return all.headOption();
    }

    public <T> Option<ClassLoader> loadAtMostOne$default$1() {
        return None$.MODULE$;
    }

    private static final Stream chain$1(ClassLoader cl) {
        if (cl == null) {
            return package$.MODULE$.Stream().empty();
        }
        ClassLoader classLoader = cl;
        return Stream.Deferrer$.MODULE$.$hash$colon$colon$extension(Stream$.MODULE$.toDeferrer((Function0 & Serializable)() -> ServiceLoader$.chain$1(cl.getParent())), (Object)classLoader);
    }

    private ServiceLoader$() {
    }
}

