/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.clearspring;

import com.clearspring.analytics.stream.frequency.IFrequency;
import com.clearspring.analytics.stream.membership.Filter;
import org.locationtech.geomesa.utils.clearspring.CountMinSketch$;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\u0012$\u00019B\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\r\"AQ\n\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003G\u0011%y\u0005A!b\u0001\n\u0003)\u0003\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003R\u0011%I\u0006A!a\u0001\n\u0003)#\fC\u0005\\\u0001\t\u0005\r\u0011\"\u0001&9\"A!\r\u0001B\u0001B\u0003&Q\u000b\u0003\u0005d\u0001\t\u0015\r\u0011\"\u0003e\u0011!A\u0007A!A!\u0002\u0013)\u0007\u0002C5\u0001\u0005\u000b\u0007I\u0011\u00023\t\u0011)\u0004!\u0011!Q\u0001\n\u0015D\u0001b\u001b\u0001\u0003\u0006\u0004%I\u0001\u001c\u0005\t[\u0002\u0011\t\u0011)A\u0005)\")a\u000e\u0001C\u0005_\")\u0011\u0010\u0001C\u0001\u000b\")!\u0010\u0001C\u0001\u000b\")1\u0010\u0001C\u0005y\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA\u0002\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\tI\u0003\u0001C!\u0003_Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u00111\n\u0001\u0005B\u00055saBA(G!\u0005\u0011\u0011\u000b\u0004\u0007E\rB\t!a\u0015\t\r9lB\u0011AA.\u0011!\ti&\bb\u0001\n\u0013Q\u0006bBA0;\u0001\u0006I!\u0016\u0005\b\u0003CjB\u0011AA2\u00059\u0019u.\u001e8u\u001b&t7k[3uG\"T!\u0001J\u0013\u0002\u0017\rdW-\u0019:taJLgn\u001a\u0006\u0003M\u001d\nQ!\u001e;jYNT!\u0001K\u0015\u0002\u000f\u001d,w.\\3tC*\u0011!fK\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aL\u001c\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001\u00027b]\u001eT\u0011\u0001N\u0001\u0005U\u00064\u0018-\u0003\u00027c\t1qJ\u00196fGR\u0004\"\u0001\u000f\"\u000e\u0003eR!AO\u001e\u0002\u0013\u0019\u0014X-];f]\u000eL(B\u0001\u001f>\u0003\u0019\u0019HO]3b[*\u0011ahP\u0001\nC:\fG.\u001f;jGNT!\u0001\n!\u000b\u0003\u0005\u000b1aY8n\u0013\t\u0019\u0015H\u0001\u0006J\rJ,\u0017/^3oGf\f1!\u001a9t+\u00051\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%A\u0002#pk\ndW-\u0001\u0003faN\u0004\u0013AC2p]\u001aLG-\u001a8dK\u0006Y1m\u001c8gS\u0012,gnY3!\u0003\u0015!\u0018M\u00197f+\u0005\t\u0006cA$S)&\u00111\u000b\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u000fJ+\u0006CA$W\u0013\t9\u0006J\u0001\u0003M_:<\u0017A\u0002;bE2,\u0007%A\u0003`g&TX-F\u0001V\u0003%y6/\u001b>f?\u0012*\u0017\u000f\u0006\u0002^AB\u0011qIX\u0005\u0003?\"\u0013A!\u00168ji\"9\u0011\rCA\u0001\u0002\u0004)\u0016a\u0001=%c\u00051ql]5{K\u0002\nQ\u0001Z3qi\",\u0012!\u001a\t\u0003\u000f\u001aL!a\u001a%\u0003\u0007%sG/\u0001\u0004eKB$\b\u000eI\u0001\u0006o&$G\u000f[\u0001\u0007o&$G\u000f\u001b\u0011\u0002\u000b!\f7\u000f[!\u0016\u0003Q\u000ba\u0001[1tQ\u0006\u0003\u0013A\u0002\u001fj]&$h\b\u0006\u0005qeN$XO^<y!\t\t\b!D\u0001$\u0011\u0015!\u0005\u00031\u0001G\u0011\u0015i\u0005\u00031\u0001G\u0011\u0015y\u0005\u00031\u0001R\u0011\u0015I\u0006\u00031\u0001V\u0011\u0015\u0019\u0007\u00031\u0001f\u0011\u0015I\u0007\u00031\u0001f\u0011\u0015Y\u0007\u00031\u0001U\u0003A9W\r\u001e*fY\u0006$\u0018N^3FeJ|'/A\u0007hKR\u001cuN\u001c4jI\u0016t7-Z\u0001\u0005Q\u0006\u001c\b\u000eF\u0002f{~DQA`\nA\u0002U\u000bA!\u001b;f[\"1\u0011\u0011A\nA\u0002\u0015\f\u0011![\u0001\u0004C\u0012$G#B/\u0002\b\u0005%\u0001\"\u0002@\u0015\u0001\u0004)\u0006BBA\u0006)\u0001\u0007Q+A\u0003d_VtG\u000fF\u0003^\u0003\u001f\t9\u0003\u0003\u0004\u007f+\u0001\u0007\u0011\u0011\u0003\t\u0005\u0003'\t\tC\u0004\u0003\u0002\u0016\u0005u\u0001cAA\f\u00116\u0011\u0011\u0011\u0004\u0006\u0004\u00037i\u0013A\u0002\u001fs_>$h(C\u0002\u0002 !\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u0011aa\u0015;sS:<'bAA\u0010\u0011\"1\u00111B\u000bA\u0002U\u000bQ\"Z:uS6\fG/Z\"pk:$HcA+\u0002.!)aP\u0006a\u0001+R\u0019Q+!\r\t\ry<\u0002\u0019AA\t\u0003!!\u0003\u000f\\;tI\u0015\fHcA/\u00028!1\u0011\u0011\b\rA\u0002A\fQa\u001c;iKJ\fQa\u00197fCJ$\u0012!X\u0001\rSN,\u0015/^5wC2,g\u000e\u001e\u000b\u0005\u0003\u0007\nI\u0005E\u0002H\u0003\u000bJ1!a\u0012I\u0005\u001d\u0011un\u001c7fC:Da!!\u000f\u001b\u0001\u0004\u0001\u0018\u0001B:ju\u0016$\u0012!V\u0001\u000f\u0007>,h\u000e^'j]N[W\r^2i!\t\tXdE\u0002\u001e\u0003+\u00022aRA,\u0013\r\tI\u0006\u0013\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005E\u0013\u0001\u0004)sS6,Wj\u001c3vYV\u001c\u0018!\u0004)sS6,Wj\u001c3vYV\u001c\b%A\u0003baBd\u0017\u0010F\u0004q\u0003K\n9'!\u001b\t\u000b\u0011\u000b\u0003\u0019\u0001$\t\u000b5\u000b\u0003\u0019\u0001$\t\r\u0005-\u0014\u00051\u0001f\u0003\u0011\u0019X-\u001a3")
public class CountMinSketch
implements IFrequency {
    private final double eps;
    private final double confidence;
    private final long[][] table;
    private long _size;
    private final int depth;
    private final int width;
    private final long[] hashA;

    public static CountMinSketch apply(double eps, double confidence, int seed) {
        return CountMinSketch$.MODULE$.apply(eps, confidence, seed);
    }

    public double eps() {
        return this.eps;
    }

    public double confidence() {
        return this.confidence;
    }

    public long[][] table() {
        return this.table;
    }

    public long _size() {
        return this._size;
    }

    public void _size_$eq(long x$1) {
        this._size = x$1;
    }

    private int depth() {
        return this.depth;
    }

    private int width() {
        return this.width;
    }

    private long[] hashA() {
        return this.hashA;
    }

    public double getRelativeError() {
        return this.eps();
    }

    public double getConfidence() {
        return this.confidence();
    }

    private int hash(long item, int i) {
        long hash = this.hashA()[i] * item;
        hash += hash >> 32;
        return (int)(hash &= CountMinSketch$.MODULE$.org$locationtech$geomesa$utils$clearspring$CountMinSketch$$PrimeModulus()) % this.width();
    }

    public void add(long item, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        for (int i = 0; i < this.depth(); ++i) {
            long[] lArray = this.table()[i];
            int n = this.hash(item, i);
            lArray[n] = lArray[n] + count;
        }
        this._size_$eq(this._size() + count);
    }

    public void add(String item, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        int[] buckets = Filter.getHashBuckets((String)item, (int)this.depth(), (int)this.width());
        for (int i = 0; i < this.depth(); ++i) {
            long[] lArray = this.table()[i];
            int n = buckets[i];
            lArray[n] = lArray[n] + count;
        }
        this._size_$eq(this._size() + count);
    }

    public long estimateCount(long item) {
        long res = Long.MAX_VALUE;
        for (int i = 0; i < this.depth(); ++i) {
            long[] row = this.table()[i];
            res = package$.MODULE$.min(res, row[this.hash(item, i)]);
        }
        return res;
    }

    public long estimateCount(String item) {
        long res = Long.MAX_VALUE;
        int[] buckets = Filter.getHashBuckets((String)item, (int)this.depth(), (int)this.width());
        for (int i = 0; i < this.depth(); ++i) {
            res = Math.min(res, this.table()[i][buckets[i]]);
        }
        return res;
    }

    public void $plus$eq(CountMinSketch other) {
        if (this.depth() != other.depth() || this.width() != other.width()) {
            throw new IllegalArgumentException("Can't merge CountMinSketch of different sizes");
        }
        int j = 0;
        for (int i = 0; i < this.table().length; ++i) {
            long[] row = this.table()[i];
            long[] otherRow = other.table()[i];
            while (j < row.length) {
                int n = j;
                row[n] = row[n] + otherRow[j];
                ++j;
            }
            j = 0;
        }
        this._size_$eq(this._size() + other.size());
    }

    public void clear() {
        int j = 0;
        for (int i = 0; i < this.depth(); ++i) {
            long[] row = this.table()[i];
            while (j < this.width()) {
                row[j] = 0L;
                ++j;
            }
            j = 0;
        }
        this._size_$eq(0L);
    }

    public boolean isEquivalent(CountMinSketch other) {
        if (this.size() != other.size() || this.depth() != other.depth() || this.width() != other.width()) {
            return false;
        }
        int j = 0;
        for (int i = 0; i < this.depth(); ++i) {
            if (this.hashA()[i] != other.hashA()[i]) {
                return false;
            }
            long[] row = this.table()[i];
            long[] otherRow = other.table()[i];
            while (j < this.width()) {
                if (row[j] != otherRow[j]) {
                    return false;
                }
                ++j;
            }
            j = 0;
        }
        return true;
    }

    public long size() {
        return this._size();
    }

    public CountMinSketch(double eps, double confidence, long[][] table, long _size, int depth, int width, long[] hashA) {
        this.eps = eps;
        this.confidence = confidence;
        this.table = table;
        this._size = _size;
        this.depth = depth;
        this.width = width;
        this.hashA = hashA;
    }
}

