/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.collection;

import org.locationtech.geomesa.utils.collection.CircularByteQueue$;
import scala.Array$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q4A!\u0007\u000e\u0001K!AA\u0006\u0001B\u0001B\u0003%Q\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u00046\u0001\u0001\u0007I\u0011\u0002\u001c\t\u000fu\u0002\u0001\u0019!C\u0005}!1A\t\u0001Q!\n]Bq!\u0012\u0001A\u0002\u0013%a\tC\u0004H\u0001\u0001\u0007I\u0011\u0002%\t\r)\u0003\u0001\u0015)\u0003.\u0011\u001dY\u0005\u00011A\u0005\n\u0019Cq\u0001\u0014\u0001A\u0002\u0013%Q\n\u0003\u0004P\u0001\u0001\u0006K!\f\u0005\u0006!\u0002!\tA\u0012\u0005\u0006#\u0002!\tA\u0012\u0005\u0006%\u0002!\ta\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\u00065\u0002!\ta\u0017\u0005\u00065\u0002!\t!\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006M\u0002!\ta\u001a\u0005\u0006S\u0002!IA[\u0004\bYj\t\t\u0011#\u0001n\r\u001dI\"$!A\t\u00029DQ\u0001\r\f\u0005\u0002=Dq\u0001\u001d\f\u0012\u0002\u0013\u0005\u0011OA\tDSJ\u001cW\u000f\\1s\u0005f$X-U;fk\u0016T!a\u0007\u000f\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002\u001e=\u0005)Q\u000f^5mg*\u0011q\u0004I\u0001\bO\u0016|W.Z:b\u0015\t\t#%\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001$\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\fS:LG/[1m'&TX\r\u0005\u0002(]%\u0011q\u0006\u000b\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u00023iA\u00111\u0007A\u0007\u00025!9AF\u0001I\u0001\u0002\u0004i\u0013!B1se\u0006LX#A\u001c\u0011\u0007\u001dB$(\u0003\u0002:Q\t)\u0011I\u001d:bsB\u0011qeO\u0005\u0003y!\u0012AAQ=uK\u0006I\u0011M\u001d:bs~#S-\u001d\u000b\u0003\u007f\t\u0003\"a\n!\n\u0005\u0005C#\u0001B+oSRDqa\u0011\u0003\u0002\u0002\u0003\u0007q'A\u0002yIE\na!\u0019:sCf\u0004\u0013!B:uCJ$X#A\u0017\u0002\u0013M$\u0018M\u001d;`I\u0015\fHCA J\u0011\u001d\u0019u!!AA\u00025\naa\u001d;beR\u0004\u0013A\u00027f]\u001e$\b.\u0001\u0006mK:<G\u000f[0%KF$\"a\u0010(\t\u000f\rS\u0011\u0011!a\u0001[\u00059A.\u001a8hi\"\u0004\u0013\u0001B:ju\u0016\f\u0001bY1qC\u000eLG/_\u0001\tIAdWo\u001d\u0013fcR\u0011q\b\u0016\u0005\u0006+:\u0001\rAO\u0001\u0005Ef$X-A\u0007%a2,8\u000f\n9mkN$S-\u001d\u000b\u0003\u007faCQ!W\bA\u0002]\nQAY=uKN\fq!\u001a8rk\u0016,X\r\u0006\u0002@9\")Q\u000b\u0005a\u0001uQ!qHX0b\u0011\u0015I\u0016\u00031\u00018\u0011\u0015\u0001\u0017\u00031\u0001.\u0003\u0019ygMZ:fi\")!-\u0005a\u0001[\u0005)1m\\;oi\u00069A-Z9vKV,GCA\u001cf\u0011\u0015\u0011'\u00031\u0001.\u0003\u0011!'o\u001c9\u0015\u0005}B\u0007\"\u00022\u0014\u0001\u0004i\u0013AB3ogV\u0014X\r\u0006\u0002@W\")!\r\u0006a\u0001[\u0005\t2)\u001b:dk2\f'OQ=uKF+X-^3\u0011\u0005M22C\u0001\f')\u0005i\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'F\u0001sU\ti3oK\u0001u!\t)(0D\u0001w\u0015\t9\b0A\u0005v]\u000eDWmY6fI*\u0011\u0011\u0010K\u0001\u000bC:tw\u000e^1uS>t\u0017BA>w\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class CircularByteQueue {
    private byte[] array;
    private int start;
    private int length;

    public static int $lessinit$greater$default$1() {
        return CircularByteQueue$.MODULE$.$lessinit$greater$default$1();
    }

    private byte[] array() {
        return this.array;
    }

    private void array_$eq(byte[] x$1) {
        this.array = x$1;
    }

    private int start() {
        return this.start;
    }

    private void start_$eq(int x$1) {
        this.start = x$1;
    }

    private int length() {
        return this.length;
    }

    private void length_$eq(int x$1) {
        this.length = x$1;
    }

    public int size() {
        return this.length();
    }

    public int capacity() {
        return this.array().length - this.length();
    }

    public void $plus$eq(byte by) {
        this.enqueue(by);
    }

    public void $plus$plus$eq(byte[] bytes2) {
        this.enqueue(bytes2, 0, bytes2.length);
    }

    public void enqueue(byte by) {
        this.ensure(1);
        int last = this.start() + this.length();
        if (last >= this.array().length) {
            last -= this.array().length;
        }
        this.array()[last] = by;
        this.length_$eq(this.length() + 1);
    }

    public void enqueue(byte[] bytes2, int offset, int count) {
        this.ensure(count);
        int first = this.start() + this.length();
        if (first >= this.array().length) {
            first -= this.array().length;
        }
        if (first + count < this.array().length) {
            System.arraycopy(bytes2, offset, this.array(), first, count);
        } else {
            int tail = this.array().length - first;
            System.arraycopy(bytes2, offset, this.array(), first, tail);
            System.arraycopy(bytes2, offset + tail, this.array(), 0, count - tail);
        }
        this.length_$eq(this.length() + count);
    }

    public byte[] dequeue(int count) {
        int total = package$.MODULE$.min(this.length(), count);
        byte[] result = (byte[])Array$.MODULE$.ofDim(total, (ClassTag)ClassTag$.MODULE$.Byte());
        if (this.start() + total <= this.array().length) {
            System.arraycopy(this.array(), this.start(), result, 0, total);
        } else {
            int tail = this.array().length - this.start();
            System.arraycopy(this.array(), this.start(), result, 0, tail);
            System.arraycopy(this.array(), 0, result, tail, total - tail);
        }
        this.start_$eq(this.start() + total);
        if (this.start() >= this.array().length) {
            this.start_$eq(this.start() - this.array().length);
        }
        this.length_$eq(this.length() - total);
        return result;
    }

    public void drop(int count) {
        int total = package$.MODULE$.min(this.length(), count);
        this.start_$eq(this.start() + total);
        if (this.start() >= this.array().length) {
            this.start_$eq(this.start() - this.array().length);
        }
        this.length_$eq(this.length() - total);
    }

    private void ensure(int count) {
        if (this.length() + count > this.array().length) {
            int newSize;
            for (newSize = this.array().length * 2; newSize < this.length() + count; newSize *= 2) {
            }
            byte[] tmp = (byte[])Array$.MODULE$.ofDim(newSize, (ClassTag)ClassTag$.MODULE$.Byte());
            if (this.start() + this.length() <= this.array().length) {
                System.arraycopy(this.array(), this.start(), tmp, 0, this.length());
            } else {
                int tailBytes = this.array().length - this.start();
                System.arraycopy(this.array(), this.start(), tmp, 0, tailBytes);
                System.arraycopy(this.array(), 0, tmp, tailBytes, this.length() - tailBytes);
            }
            this.array_$eq(tmp);
            this.start_$eq(0);
            return;
        }
    }

    public CircularByteQueue(int initialSize) {
        this.array = (byte[])Array$.MODULE$.ofDim(initialSize, (ClassTag)ClassTag$.MODULE$.Byte());
        this.start = 0;
        this.length = 0;
    }
}

