/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.concurrent;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.locationtech.geomesa.utils.concurrent.CachedThreadPool$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u0013'\u0001EB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u0019\u0002!\t!\u0014\u0005\b#\u0002\u0001\r\u0011\"\u0003S\u0011\u001d\u0019\u0006\u00011A\u0005\nQCaA\u0017\u0001!B\u00131\u0005bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\b\u0003_\u0001\u0001\u0015!\u0003b\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t\u0019\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001b\u0011%\t9\u0005\u0001b\u0001\n\u0013\tI\u0005\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA&\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA/\u0011%\tY\u0001\u0001b\u0001\n\u0013\tY\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA7\u0011\u001d\t)\b\u0001C!\u0003\u001bAq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u0004\"9\u0011Q\u0012\u0001\u0005B\u0005=\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\ty\f\u0001C)\u0003\u00034A\u0001\u001b\u0001\u0001S\"A\u0011\u0010\u0007B\u0001B\u0003%!\u0010C\u0005\u0002\u0002a\u0011\t\u0011)A\u0005]\"1A\n\u0007C\u0001\u0003\u0007Aq!a\u0003\u0019\t\u0003\ni\u0001C\u0004\u0002\u0010a!\t%!\u0005\b\u000f\u0005Eg\u0005#\u0001\u0002T\u001a1QE\nE\u0001\u0003+Da\u0001T\u0010\u0005\u0002\u0005u\u0007\"CAp?\t\u0007I\u0011BAq\u0011!\tIo\bQ\u0001\n\u0005\r\bbBAS?\u0011\u0005\u00111\u001e\u0005\b\u0003_|B\u0011AAy\u0005A\u0019\u0015m\u00195fIRC'/Z1e!>|GN\u0003\u0002(Q\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005%R\u0013!B;uS2\u001c(BA\u0016-\u0003\u001d9Wm\\7fg\u0006T!!\f\u0018\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003=\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u001a<!\t\u0019\u0014(D\u00015\u0015\t9SG\u0003\u00027o\u0005!Q\u000f^5m\u0015\u0005A\u0014\u0001\u00026bm\u0006L!A\u000f\u001b\u0003/\u0005\u00137\u000f\u001e:bGR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007C\u0001\u001fD\u001b\u0005i$B\u0001 @\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0001\u0015)\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0015aA2p[&\u0011A)\u0010\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0006nCb$\u0006N]3bIN\u0004\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u00131!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0011a\n\u0015\t\u0003\u001f\u0002i\u0011A\n\u0005\u0006\u000b\n\u0001\rAR\u0001\nCZ\f\u0017\u000e\\1cY\u0016,\u0012AR\u0001\u000eCZ\f\u0017\u000e\\1cY\u0016|F%Z9\u0015\u0005UC\u0006CA$W\u0013\t9\u0006J\u0001\u0003V]&$\bbB-\u0005\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\n\u0014AC1wC&d\u0017M\u00197fA!\u0012Q\u0001\u0018\t\u0003\u000fvK!A\u0018%\u0003\u0011Y|G.\u0019;jY\u0016\fQ!];fk\u0016,\u0012!\u0019\t\u0004E\u000e,W\"A\u001b\n\u0005\u0011,$A\u0003'j].,G\rT5tiB\u001aa-a\u000b\u0011\t\u001dD\u0012\u0011F\u0007\u0002\u0001\t\u0019BK]1dW\u0006\u0014G.\u001a$viV\u0014X\rV1tWV\u0011!\u000e]\n\u00031-\u00042a\r7o\u0013\tiGG\u0001\u0006GkR,(/\u001a+bg.\u0004\"a\u001c9\r\u0001\u0011)\u0011\u000f\u0007b\u0001e\n\tA+\u0005\u0002tmB\u0011q\t^\u0005\u0003k\"\u0013qAT8uQ&tw\r\u0005\u0002Ho&\u0011\u0001\u0010\u0013\u0002\u0004\u0003:L\u0018\u0001\u0003:v]:\f'\r\\3\u0011\u0005mtX\"\u0001?\u000b\u0005u<\u0014\u0001\u00027b]\u001eL!a ?\u0003\u0011I+hN\\1cY\u0016\faA]3tk2$HCBA\u0003\u0003\u000f\tI\u0001E\u0002h19DQ!_\u000eA\u0002iDa!!\u0001\u001c\u0001\u0004q\u0017\u0001\u00023p]\u0016$\u0012!V\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0003\t\u0005\u0003+\t\u0019C\u0004\u0003\u0002\u0018\u0005}\u0001cAA\r\u00116\u0011\u00111\u0004\u0006\u0004\u0003;\u0001\u0014A\u0002\u001fs_>$h(C\u0002\u0002\"!\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011\u0011B\u0019q.a\u000b\u0005\u0015\u00055r!!A\u0001\u0002\u000b\u0005!OA\u0002`IE\na!];fk\u0016\u0004\u0013!\u0002;bg.\u001cXCAA\u001b!\u0015\u0011\u0017qGA\u001e\u0013\r\tI$\u000e\u0002\b\u0011\u0006\u001c\bnU3ua\u0011\ti$!\u0011\u0011\t\u001dD\u0012q\b\t\u0004_\u0006\u0005CACA\"\u0013\u0005\u0005\t\u0011!B\u0001e\n\u0019q\f\n\u001a\u0002\rQ\f7o[:!\u0003\u001d\u0019Ho\u001c9qK\u0012,\"!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u00155\u0003\u0019\tGo\\7jG&!\u0011QKA(\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006A1\u000f^8qa\u0016$\u0007%\u0001\u0003m_\u000e\\WCAA/!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2i\u0005)An\\2lg&!\u0011qMA1\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006)An\\2lAU\u0011\u0011Q\u000e\t\u0005\u0003?\ny'\u0003\u0003\u0002r\u0005\u0005$!C\"p]\u0012LG/[8o\u0003\u0015!wN\\3!\u0003!\u0019\b.\u001e;e_^t\u0017aC:ikR$wn\u001e8O_^$\"!a\u001f\u0011\t\t\fiH_\u0005\u0004\u0003\u007f*$\u0001\u0002'jgR\f!\"[:TQV$Hm\\<o)\t\t)\tE\u0002H\u0003\u000fK1!!#I\u0005\u001d\u0011un\u001c7fC:\fA\"[:UKJl\u0017N\\1uK\u0012\f\u0001#Y<bSR$VM]7j]\u0006$\u0018n\u001c8\u0015\r\u0005\u0015\u0015\u0011SAN\u0011\u001d\t\u0019\n\u0006a\u0001\u0003+\u000bq\u0001^5nK>,H\u000fE\u0002H\u0003/K1!!'I\u0005\u0011auN\\4\t\u000f\u0005uE\u00031\u0001\u0002 \u0006!QO\\5u!\r\u0019\u0014\u0011U\u0005\u0004\u0003G#$\u0001\u0003+j[\u0016,f.\u001b;\u0002\u000f\u0015DXmY;uKR\u0019Q+!+\t\r\u0005-V\u00031\u0001{\u0003\u001d\u0019w.\\7b]\u0012\faB];o\u001fJ\fV/Z;f)\u0006\u001c8\u000eF\u0002V\u0003cCq!a-\u0017\u0001\u0004\t),\u0001\u0003uCN\\\u0007\u0007BA\\\u0003w\u0003Ba\u001a\r\u0002:B\u0019q.a/\u0005\u0017\u0005u\u0016\u0011WA\u0001\u0002\u0003\u0015\tA\u001d\u0002\u0004?\u0012\"\u0014A\u00038foR\u000b7o\u001b$peV!\u00111YAe)\u0019\t)-a3\u0002NB!q\rGAd!\ry\u0017\u0011\u001a\u0003\u0006c^\u0011\rA\u001d\u0005\u0006s^\u0001\rA\u001f\u0005\b\u0003\u001f<\u0002\u0019AAd\u0003\u00151\u0018\r\\;f\u0003A\u0019\u0015m\u00195fIRC'/Z1e!>|G\u000e\u0005\u0002P?M\u0019q$a6\u0011\u0007\u001d\u000bI.C\u0002\u0002\\\"\u0013a!\u00118z%\u00164GCAAj\u0003\u0011\u0001xn\u001c7\u0016\u0005\u0005\r\bcA\u001a\u0002f&\u0019\u0011q\u001d\u001b\u0003%QC'/Z1e!>|G.\u0012=fGV$xN]\u0001\u0006a>|G\u000e\t\u000b\u0004+\u00065\bBBAVG\u0001\u0007!0\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u0003g\u0014\t\u0001\r\u0003\u0002v\u0006u\b#B\u001a\u0002x\u0006m\u0018bAA}i\t1a)\u001e;ve\u0016\u00042a\\A\u007f\t)\ty\u0010JA\u0001\u0002\u0003\u0015\tA\u001d\u0002\u0004?\u0012*\u0004BBAVI\u0001\u0007!\u0010")
public class CachedThreadPool
extends AbstractExecutorService
implements LazyLogging {
    private final int maxThreads;
    private volatile int org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available;
    private final LinkedList<TrackableFutureTask<?>> org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue;
    private final HashSet<TrackableFutureTask<?>> org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks;
    private final AtomicBoolean stopped;
    private final ReentrantLock org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock;
    private final Condition org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CachedThreadPool cachedThreadPool = this;
        synchronized (cachedThreadPool) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public int org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available;
    }

    public void org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available_$eq(int x$1) {
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available = x$1;
    }

    public LinkedList<TrackableFutureTask<?>> org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue;
    }

    public HashSet<TrackableFutureTask<?>> org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    public ReentrantLock org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock;
    }

    public Condition org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done;
    }

    @Override
    public void shutdown() {
        this.stopped().set(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Runnable> shutdownNow() {
        void v0;
        this.stopped().set(true);
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().lock();
        try {
            void var1_1;
            ArrayList waiting = new ArrayList(this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue());
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue().clear();
            Iterator<TrackableFutureTask<?>> running = new ArrayList(this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks()).iterator();
            while (running.hasNext()) {
                ((Future)running.next()).cancel(true);
            }
            v0 = var1_1;
        }
        finally {
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().unlock();
        }
        return v0;
    }

    @Override
    public boolean isShutdown() {
        return this.stopped().get();
    }

    @Override
    public boolean isTerminated() {
        return this.stopped().get() && this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() == this.maxThreads;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        boolean bl;
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().lock();
        try {
            if (this.isTerminated()) {
                bl = true;
            } else {
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done().await(timeout, unit);
                bl = this.isTerminated();
            }
        }
        finally {
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().unlock();
        }
        return bl;
    }

    @Override
    public void execute(Runnable command) {
        RunnableFuture runnableFuture;
        if (this.stopped().get()) {
            throw new RejectedExecutionException("Trying to execute a task but executor service is shut down");
        }
        Runnable runnable = command;
        if (runnable instanceof TrackableFutureTask && ((TrackableFutureTask)runnable).org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer() == this) {
            TrackableFutureTask trackableFutureTask = (TrackableFutureTask)runnable;
            runnableFuture = trackableFutureTask;
        } else {
            runnableFuture = this.newTaskFor(runnable, (Object)null);
        }
        RunnableFuture task = runnableFuture;
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$runOrQueueTask((TrackableFutureTask<?>)task);
    }

    public void org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$runOrQueueTask(TrackableFutureTask<?> task) {
        block8: {
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().lock();
            try {
                if (this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() > 0) {
                    try {
                        CachedThreadPool$.MODULE$.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$pool().execute(task);
                    }
                    catch (RejectedExecutionException e) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(new StringBuilder(102).append("CachedThreadPool rejected queued task (likely due to shutdown),").append("creating new single thread executor: ").append(task).append(": ").append(e).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        ExecutorService pool = Executors.newSingleThreadExecutor();
                        pool.execute(task);
                        pool.shutdown();
                    }
                    this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available_$eq(this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() - 1);
                    this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks().add(task);
                    break block8;
                }
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue().offer(task);
            }
            finally {
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().unlock();
            }
        }
    }

    public <T> TrackableFutureTask<T> newTaskFor(Runnable runnable, T value) {
        return new TrackableFutureTask<T>(this, runnable, value);
    }

    public CachedThreadPool(int maxThreads) {
        this.maxThreads = maxThreads;
        LazyLogging.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available = maxThreads;
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue = new LinkedList();
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks = new HashSet();
        this.stopped = new AtomicBoolean(false);
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock = new ReentrantLock();
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done = this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().newCondition();
    }

    public class TrackableFutureTask<T>
    extends FutureTask<T> {
        private final Runnable runnable;
        public final /* synthetic */ CachedThreadPool $outer;

        @Override
        public void done() {
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().lock();
            try {
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available_$eq(this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() + 1);
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks().remove(this);
                TrackableFutureTask<?> next = this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue().poll();
                if (next != null) {
                    this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$runOrQueueTask(next);
                } else if (this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().isTerminated()) {
                    this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done().signalAll();
                }
            }
            finally {
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().unlock();
            }
        }

        @Override
        public String toString() {
            return new StringBuilder(21).append("TrackableFutureTask[").append(this.runnable).append("]").toString();
        }

        public /* synthetic */ CachedThreadPool org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer() {
            return this.$outer;
        }

        public TrackableFutureTask(CachedThreadPool $outer, Runnable runnable, T result) {
            this.runnable = runnable;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(runnable, result);
        }
    }
}

