/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.conf;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public final class ConfigLoader$
implements LazyLogging {
    public static final ConfigLoader$ MODULE$ = new ConfigLoader$();
    private static Map<String, Tuple2<String, Object>> Config;
    private static final String GEOMESA_CONFIG_FILE_PROP;
    private static final String GEOMESA_CONFIG_FILE_NAME;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile boolean bitmap$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        GEOMESA_CONFIG_FILE_PROP = "geomesa.config.file";
        GEOMESA_CONFIG_FILE_NAME = "geomesa-site.xml";
    }

    private Logger logger$lzycompute() {
        ConfigLoader$ configLoader$ = this;
        synchronized (configLoader$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String GEOMESA_CONFIG_FILE_PROP() {
        return GEOMESA_CONFIG_FILE_PROP;
    }

    public String GEOMESA_CONFIG_FILE_NAME() {
        return GEOMESA_CONFIG_FILE_NAME;
    }

    private Map<String, Tuple2<String, Object>> Config$lzycompute() {
        ConfigLoader$ configLoader$ = this;
        synchronized (configLoader$) {
            if (!bitmap$0) {
                Config = this.loadConfig((String)package$.MODULE$.props().getOrElse((Object)this.GEOMESA_CONFIG_FILE_PROP(), (Function0 & Serializable)() -> MODULE$.GEOMESA_CONFIG_FILE_NAME()));
                bitmap$0 = true;
            }
        }
        return Config;
    }

    public Map<String, Tuple2<String, Object>> Config() {
        if (!bitmap$0) {
            return this.Config$lzycompute();
        }
        return Config;
    }

    public Map<String, Tuple2<String, Object>> loadConfig(String path) {
        BoxedUnit boxedUnit;
        Map map;
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(path);
        if (input == null) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            try {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Loading config: {}", (Object)path);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                map = this.loadConfig(input, path);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    BoxedUnit boxedUnit3;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(30).append("Error reading config file at: ").append(path).toString(), e);
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    map = Predef$.MODULE$.Map().empty();
                }
                throw throwable;
            }
        }
        Map config = map;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Loaded {}", (Object)config.mkString(","));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return config;
    }

    public Map<String, Tuple2<String, Object>> loadConfig(InputStream input, String path) {
        Elem xml = (Elem)XML$.MODULE$.load(input);
        NodeSeq properties = xml.$bslash$bslash("configuration").$bslash$bslash("property");
        return ((IterableOnceOps)properties.flatMap((Function1 & Serializable)prop -> {
            Try pair;
            block1: {
                pair = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    String key = prop.$bslash("name").text();
                    String value = prop.$bslash("value").text();
                    boolean isFinal = Boolean.parseBoolean(prop.$bslash("final").text());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToBoolean((boolean)isFinal)));
                });
                Try try_ = pair;
                if (!(try_ instanceof Failure)) break block1;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn(new StringBuilder(31).append("Unable to load property from: ").append(path).append("\n").append(prop).toString(), e);
                }
            }
            return pair.toOption().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigLoader$.$anonfun$loadConfig$3(x0$1)));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$loadConfig$3(Tuple2 x0$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            String v = (String)tuple2._1();
            return v != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(v));
        }
        throw new MatchError((Object)tuple22);
    }

    private ConfigLoader$() {
    }
}

