/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.conf;

import java.util.Date;
import java.util.regex.Matcher;
import org.locationtech.geomesa.utils.conf.FeatureExpiration;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class FeatureExpiration$ {
    public static final FeatureExpiration$ MODULE$ = new FeatureExpiration$();
    private static final Regex AttributeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^()]+)\\((.+)\\)"));

    private Regex AttributeRegex() {
        return AttributeRegex;
    }

    public FeatureExpiration apply(SimpleFeatureType sft, String expiration) {
        Matcher matcher = this.AttributeRegex().pattern().matcher(expiration);
        if (matcher.matches()) {
            String attribute = matcher.group(1);
            int i = sft.indexOf(attribute);
            if (i == -1 || !Date.class.isAssignableFrom(sft.getDescriptor(i).getType().getBinding())) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid age-off attribute: ").append(attribute).toString());
            }
            return new FeatureExpiration.FeatureTimeExpiration(attribute, i, this.duration(matcher.group(2)));
        }
        return new FeatureExpiration.IngestTimeExpiration(this.duration(expiration));
    }

    public Option<String> unapply(FeatureExpiration expiration) {
        FeatureExpiration featureExpiration = expiration;
        if (featureExpiration instanceof FeatureExpiration.IngestTimeExpiration) {
            FeatureExpiration.IngestTimeExpiration ingestTimeExpiration = (FeatureExpiration.IngestTimeExpiration)featureExpiration;
            Duration duration = ingestTimeExpiration.ttl();
            return new Some((Object)duration.toString());
        }
        if (featureExpiration instanceof FeatureExpiration.FeatureTimeExpiration) {
            FeatureExpiration.FeatureTimeExpiration featureTimeExpiration = (FeatureExpiration.FeatureTimeExpiration)featureExpiration;
            String attribute = featureTimeExpiration.attribute();
            Duration duration = featureTimeExpiration.ttl();
            return new Some((Object)new StringBuilder(2).append(attribute).append("(").append(duration).append(")").toString());
        }
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Duration duration(String string) {
        void v0;
        try {
            void var3_2;
            Duration duration = Duration$.MODULE$.apply(string);
            if (!duration.isFinite()) {
                throw new IllegalArgumentException("Duration is infinite");
            }
            if (duration.$less$eq((Object)Duration$.MODULE$.Zero())) {
                throw new IllegalArgumentException("Duration is negative");
            }
            v0 = var3_2;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(30).append("Invalid age-off time-to-live: ").append(string).toString(), e);
            }
            throw throwable;
        }
        return v0;
    }

    private FeatureExpiration$() {
    }
}

