/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.conf;

import java.io.Serializable;
import org.locationtech.geomesa.utils.conf.SemanticVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class SemanticVersion$
implements Serializable {
    public static final SemanticVersion$ MODULE$ = new SemanticVersion$();
    private static final Regex Regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+)\\.(\\d+)\\.(\\d+)(-([0-9A-Za-z-.]+))?(\\+([0-9A-Za-z-.]+))?"));
    private static final Regex LenientRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+)\\.?"));

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    private Regex Regex() {
        return Regex;
    }

    private Regex LenientRegex() {
        return LenientRegex;
    }

    public SemanticVersion apply(String version) {
        Option option;
        String string = version;
        if (string == null || (option = this.Regex().unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(7) != 0) {
            throw new MatchError((Object)string);
        }
        String major = (String)((LinearSeqOps)option.get()).apply(0);
        String minor = (String)((LinearSeqOps)option.get()).apply(1);
        String patch = (String)((LinearSeqOps)option.get()).apply(2);
        String preRelease = (String)((LinearSeqOps)option.get()).apply(4);
        String build = (String)((LinearSeqOps)option.get()).apply(6);
        Tuple5 tuple5 = new Tuple5((Object)major, (Object)minor, (Object)patch, (Object)preRelease, (Object)build);
        String major2 = (String)tuple5._1();
        String minor2 = (String)tuple5._2();
        String patch2 = (String)tuple5._3();
        String preRelease2 = (String)tuple5._4();
        String build2 = (String)tuple5._5();
        return new SemanticVersion(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(major2)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(minor2)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(patch2)), (Option<String>)Option$.MODULE$.apply((Object)preRelease2), (Option<String>)Option$.MODULE$.apply((Object)build2));
    }

    public SemanticVersion apply(String version, boolean lenient) {
        SemanticVersion semanticVersion;
        try {
            semanticVersion = this.apply(version);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                if (lenient) {
                    Iterator versions = this.LenientRegex().findAllMatchIn((CharSequence)version).flatMap((Function1 & Serializable)m -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(1)))).toOption().iterator());
                    if (versions.hasNext()) {
                        SeqOps seqOps;
                        Seq seq = versions.$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 0}))).take(3).toSeq();
                        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) {
                            throw new MatchError((Object)seq);
                        }
                        int major = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0));
                        int minor = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1));
                        int patch = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2));
                        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)major), (Object)BoxesRunTime.boxToInteger((int)minor), (Object)BoxesRunTime.boxToInteger((int)patch));
                        int major2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        int minor2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        int patch2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
                        semanticVersion = new SemanticVersion(major2, minor2, patch2, this.apply$default$4(), this.apply$default$5());
                    }
                    throw e;
                }
            }
            throw throwable;
        }
        return semanticVersion;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public int org$locationtech$geomesa$utils$conf$SemanticVersion$$comparePreReleases(Option<String> first, Option<String> second) {
        if (first.isEmpty() && second.isEmpty()) {
            return 0;
        }
        if (first.isEmpty() && second.isDefined()) {
            return 1;
        }
        if (first.isDefined() && second.isEmpty()) {
            return -1;
        }
        Either[] firstParsed = (Either[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString((String)first.get()), '.')), (Function1 & Serializable)version -> MODULE$.parsePreRelease((String)version), ClassTag$.MODULE$.apply(Either.class));
        Either[] secondParsed = (Either[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString((String)second.get()), '.')), (Function1 & Serializable)version -> MODULE$.parsePreRelease((String)version), ClassTag$.MODULE$.apply(Either.class));
        int[] compare = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])firstParsed), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])secondParsed))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)SemanticVersion$.$anonfun$comparePreReleases$3(x0$1)), (ClassTag)ClassTag$.MODULE$.Int());
        return BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.intArrayOps(compare), (Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 != 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> ArrayOps$.MODULE$.lengthCompare$extension(Predef$.MODULE$.refArrayOps((Object[])firstParsed), secondParsed.length)));
    }

    private Either<String, Object> parsePreRelease(String version) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(version))));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                right = package$.MODULE$.Left().apply((Object)version);
            }
            throw throwable;
        }
        return right;
    }

    public SemanticVersion apply(int major, int minor, int patch, Option<String> preRelease, Option<String> build) {
        return new SemanticVersion(major, minor, patch, preRelease, build);
    }

    public Option<Tuple5<Object, Object, Object, Option<String>, Option<String>>> unapply(SemanticVersion x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)x$0.major()), (Object)BoxesRunTime.boxToInteger((int)x$0.minor()), (Object)BoxesRunTime.boxToInteger((int)x$0.patch()), x$0.preRelease(), x$0.build()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SemanticVersion$.class);
    }

    public static final /* synthetic */ int $anonfun$comparePreReleases$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Either firstInt = (Either)tuple2._1();
            Either secondInt = (Either)tuple2._2();
            Either either = firstInt;
            if (either instanceof Left) {
                Left left = (Left)either;
                String f = (String)left.value();
                Either either2 = secondInt;
                if (either2 instanceof Left) {
                    Left left2 = (Left)either2;
                    String s = (String)left2.value();
                    return f.compareTo(s);
                }
                if (either2 instanceof Right) {
                    return 1;
                }
                throw new MatchError((Object)either2);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                int f = BoxesRunTime.unboxToInt((Object)right.value());
                Either either3 = secondInt;
                if (either3 instanceof Left) {
                    return -1;
                }
                if (either3 instanceof Right) {
                    Right right2 = (Right)either3;
                    int s = BoxesRunTime.unboxToInt((Object)right2.value());
                    if (f > s) {
                        return 1;
                    }
                    if (f < s) {
                        return -1;
                    }
                    return 0;
                }
                throw new MatchError((Object)either3);
            }
            throw new MatchError((Object)either);
        }
        throw new MatchError((Object)tuple2);
    }

    private SemanticVersion$() {
    }
}

