/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.locationtech.geomesa.utils.geohash.BoundingBox;
import org.locationtech.geomesa.utils.geohash.Bounds;
import org.locationtech.geomesa.utils.geohash.CoveringGeoHashes;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import scala.Array$;
import scala.Function$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BitSet;
import scala.collection.BitSet$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

public final class BoundingBox$
implements Serializable {
    public static final BoundingBox$ MODULE$ = new BoundingBox$();
    private static GeometryFactory latLonGeoFactory;
    private static final int DEFAULT_PRECISION;
    private static volatile boolean bitmap$0;

    static {
        DEFAULT_PRECISION = 40;
    }

    public int DEFAULT_PRECISION() {
        return DEFAULT_PRECISION;
    }

    public Envelope toEnvelope(BoundingBox bbox) {
        return bbox.envelope();
    }

    public Geometry toGeometry(BoundingBox bbox) {
        return bbox.geom();
    }

    private GeometryFactory latLonGeoFactory$lzycompute() {
        BoundingBox$ boundingBox$ = this;
        synchronized (boundingBox$) {
            if (!bitmap$0) {
                latLonGeoFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
                bitmap$0 = true;
            }
        }
        return latLonGeoFactory;
    }

    public GeometryFactory latLonGeoFactory() {
        if (!bitmap$0) {
            return this.latLonGeoFactory$lzycompute();
        }
        return latLonGeoFactory;
    }

    public BoundingBox apply(double x1, double x2, double y1, double y2) {
        return this.apply(new Bounds(Math.min(x1, x2), Math.max(x1, x2)), new Bounds(Math.min(y1, y2), Math.max(y1, y2)));
    }

    public BoundingBox apply(Bounds lons, Bounds lats) {
        Bounds bounds = lats;
        if (bounds == null) {
            throw new MatchError((Object)bounds);
        }
        double minLat = bounds.low();
        double maxLat = bounds.high();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(minLat, maxLat);
        double minLat2 = sp2._1$mcD$sp();
        double maxLat2 = sp2._2$mcD$sp();
        Bounds bounds2 = lons;
        if (bounds2 == null) {
            throw new MatchError((Object)bounds2);
        }
        double minLon = bounds2.low();
        double maxLon = bounds2.high();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(minLon, maxLon);
        double minLon2 = sp3._1$mcD$sp();
        double maxLon2 = sp3._2$mcD$sp();
        return new BoundingBox(this.latLonGeoFactory().createPoint(new Coordinate(minLon2, minLat2)), this.latLonGeoFactory().createPoint(new Coordinate(maxLon2, maxLat2)));
    }

    public BoundingBox apply(Envelope env) {
        return this.apply(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY());
    }

    public GeoHash geoHashFromEwkb(String ewkb, int precision) {
        byte[] b = Base64.decodeBase64((byte[])ewkb.getBytes());
        Geometry wkt = WKBUtils$.MODULE$.read(b);
        return GeoHash$.MODULE$.apply(wkt.getInteriorPoint().getY(), wkt.getInteriorPoint().getX(), precision);
    }

    public int geoHashFromEwkb$default$2() {
        return this.DEFAULT_PRECISION();
    }

    public double getAreaOfBoundingBox(BoundingBox bbox) {
        return bbox.geom().getArea();
    }

    public Polygon bboxToPoly(Point ll, Point ur) {
        return this.latLonGeoFactory().createPolygon(this.latLonGeoFactory().createLinearRing((Coordinate[])((Object[])new Coordinate[]{new Coordinate(ll.getX(), ll.getY()), new Coordinate(ll.getX(), ur.getY()), new Coordinate(ur.getX(), ur.getY()), new Coordinate(ur.getX(), ll.getY()), new Coordinate(ll.getX(), ll.getY())})), (LinearRing[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LinearRing.class)));
    }

    public boolean intersects(BoundingBox l, BoundingBox r) {
        return l.geom().intersects(r.geom());
    }

    public BoundingBox getCoveringBoundingBox(BoundingBox l, BoundingBox r) {
        double maxLon = package$.MODULE$.max(l.ur().getX(), r.ur().getX());
        double minLon = package$.MODULE$.min(l.ll().getX(), r.ll().getX());
        double maxLat = package$.MODULE$.max(l.ur().getY(), r.ur().getY());
        double minLat = package$.MODULE$.min(l.ll().getY(), r.ll().getY());
        return this.apply(new Bounds(minLon, maxLon), new Bounds(minLat, maxLat));
    }

    public List<String> getGeoHashesFromBoundingBox(BoundingBox bbox) {
        return this.getGeoHashesFromBoundingBox(bbox, 32, this.DEFAULT_PRECISION());
    }

    public List<String> getGeoHashesFromBoundingBox(BoundingBox bbox, int maxHashes, int precision) {
        return BoundingBox$.getMinBoxes$1((List)new .colon.colon((Object)this.getCoveringGeoHash(bbox, precision), (List)Nil$.MODULE$), bbox, maxHashes, precision);
    }

    public int getGeoHashesFromBoundingBox$default$2() {
        return 32;
    }

    public int getGeoHashesFromBoundingBox$default$3() {
        return this.DEFAULT_PRECISION();
    }

    public CoveringGeoHashes getCoveringGeoHashesFromBoundingBox(BoundingBox bbox, int maxHashes) {
        return this.getCoveringGeoHashesFromBoundingBox(bbox, maxHashes, this.DEFAULT_PRECISION());
    }

    public CoveringGeoHashes getCoveringGeoHashesFromBoundingBox(BoundingBox bbox, int maxHashes, int precision) {
        return new CoveringGeoHashes((List<GeoHash>)this.getGeoHashesFromBoundingBox(bbox, maxHashes, precision).map((Function1 & Serializable)x$3 -> GeoHash$.MODULE$.apply((String)x$3)));
    }

    public GeoHash getCoveringGeoHash(BoundingBox bbox, int precision) {
        String ll = GeoHash$.MODULE$.apply(bbox.ll(), precision).hash();
        String ur = GeoHash$.MODULE$.apply(bbox.ur().getX() - 1.0E-12, bbox.ur().getY() - 1.0E-12, precision).hash();
        return GeoHash$.MODULE$.apply(((IterableOnceOps)((IterableOps)((IterableOps)Predef$.MODULE$.wrapString(ll).zip((IterableOnce)Predef$.MODULE$.wrapString(ur))).takeWhile(Function$.MODULE$.tupled((Function2 & Serializable)(x$4, x$5) -> BoxesRunTime.boxToBoolean((boolean)BoundingBox$.$anonfun$getCoveringGeoHash$1(BoxesRunTime.unboxToChar((Object)x$4), BoxesRunTime.unboxToChar((Object)x$5)))))).unzip(Predef$.MODULE$.$conforms())._1()).mkString());
    }

    public int getCoveringGeoHashesFromBoundingBox$default$3() {
        return this.DEFAULT_PRECISION();
    }

    public Seq<GeoHash> generateSubGeoHashes(GeoHash hash) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 31).map((Function1 & Serializable)i -> BoundingBox$.$anonfun$generateSubGeoHashes$1(hash, BoxesRunTime.unboxToInt((Object)i)));
    }

    private String padLongToString(long i) {
        return String.format("%5s", RichLong$.MODULE$.toBinaryString$extension(Predef$.MODULE$.longWrapper(i))).replace(' ', '0');
    }

    public BoundingBox apply(Point ll, Point ur) {
        return new BoundingBox(ll, ur);
    }

    public Option<Tuple2<Point, Point>> unapply(BoundingBox x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.ll(), (Object)x$0.ur()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BoundingBox$.class);
    }

    private static final List getMinBoxes$1(List hashList, BoundingBox bbox$1, int maxHashes$1, int precision$1) {
        List hashes = hashList.flatMap((Function1 & Serializable)h -> MODULE$.generateSubGeoHashes((GeoHash)h)).filter((Function1 & Serializable)hash -> BoxesRunTime.boxToBoolean((boolean)BoundingBox$.MODULE$.intersects(bbox$1, hash.bbox())));
        if (hashes.size() < maxHashes$1 && hashes.size() > 0 && ((GeoHash)hashes.head()).prec() < precision$1) {
            List childHashes = BoundingBox$.getMinBoxes$1(hashes, bbox$1, maxHashes$1, precision$1);
            if (childHashes.size() > maxHashes$1) {
                return hashes.map((Function1 & Serializable)hash -> hash.hash());
            }
            return childHashes;
        }
        return hashes.map((Function1 & Serializable)hash -> hash.hash());
    }

    public static final /* synthetic */ boolean $anonfun$getCoveringGeoHash$1(char x$4, char x$5) {
        return x$4 == x$5;
    }

    public static final /* synthetic */ boolean $anonfun$generateSubGeoHashes$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            char ch = tuple2._1$mcC$sp();
            return ch != '0';
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$generateSubGeoHashes$3(GeoHash hash$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int idx = tuple2._2$mcI$sp();
            return hash$1.prec() + idx;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ GeoHash $anonfun$generateSubGeoHashes$1(GeoHash hash$1, int i) {
        IndexedSeq oneBits = (IndexedSeq)((IndexedSeqOps)((IterableOps)Predef$.MODULE$.wrapString(MODULE$.padLongToString(i)).zipWithIndex()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BoundingBox$.$anonfun$generateSubGeoHashes$2(x0$1)))).map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)BoundingBox$.$anonfun$generateSubGeoHashes$3(hash$1, x0$2)));
        return GeoHash$.MODULE$.apply((BitSet)hash$1.bitset().$bar((Set)BitSet$.MODULE$.apply((Seq)oneBits)), hash$1.prec() + 5);
    }

    private BoundingBox$() {
    }
}

