/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.locationtech.geomesa.utils.geohash.BoundingBox;
import org.locationtech.geomesa.utils.geohash.BoundingBox$;
import org.locationtech.geomesa.utils.geohash.Bounds;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class GeoHash$
implements LazyLogging,
Serializable {
    public static final GeoHash$ MODULE$ = new GeoHash$();
    private static GeometryFactory factory;
    private static double latRange;
    private static double lonRange;
    private static Map<Object, Object> powersOf2Map;
    private static Map<Object, Object> latDeltaMap;
    private static Map<Object, Object> lonDeltaMap;
    private static final int MAX_PRECISION;
    private static final Map<Object, String> org$locationtech$geomesa$utils$geohash$GeoHash$$boolMap;
    private static final Bounds latBounds;
    private static final Bounds lonBounds;
    private static final int[] bits;
    private static final String base32;
    private static final Map<Object, scala.collection.BitSet> characterMap;
    private static final double lonMax;
    private static final double latMax;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile byte bitmap$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        MAX_PRECISION = 63;
        org$locationtech$geomesa$utils$geohash$GeoHash$$boolMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)"1")}));
        latBounds = new Bounds(-90.0, 90.0);
        lonBounds = new Bounds(-180.0, 180.0);
        bits = new int[]{16, 8, 4, 2, 1};
        base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
        characterMap = ((IterableOnceOps)((IndexedSeqOps)Predef$.MODULE$.wrapString(MODULE$.base32()).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                char c = tuple2._1$mcC$sp();
                int i = tuple2._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)c)), (Object)MODULE$.bitSetFromBase32Character(i));
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        lonMax = (double)360 - package$.MODULE$.pow(0.5, 32.0);
        latMax = (double)180 - package$.MODULE$.pow(0.5, 32.0);
    }

    private Logger logger$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public int MAX_PRECISION() {
        return MAX_PRECISION;
    }

    public Geometry toGeometry(GeoHash gh) {
        return gh.geom();
    }

    public Map<Object, String> org$locationtech$geomesa$utils$geohash$GeoHash$$boolMap() {
        return org$locationtech$geomesa$utils$geohash$GeoHash$$boolMap;
    }

    private GeometryFactory factory$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                factory = new GeometryFactory(new PrecisionModel(), 4326);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return factory;
    }

    public GeometryFactory factory() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.factory$lzycompute();
        }
        return factory;
    }

    private Bounds latBounds() {
        return latBounds;
    }

    private double latRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                latRange = this.latBounds().high() - this.latBounds().low();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return latRange;
    }

    private double latRange() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.latRange$lzycompute();
        }
        return latRange;
    }

    private Bounds lonBounds() {
        return lonBounds;
    }

    private double lonRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                lonRange = this.lonBounds().high() - this.lonBounds().low();
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return lonRange;
    }

    private double lonRange() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.lonRange$lzycompute();
        }
        return lonRange;
    }

    private Map<Object, Object> powersOf2Map$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                powersOf2Map = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1 & Serializable)i -> GeoHash$.$anonfun$powersOf2Map$1(BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return powersOf2Map;
    }

    private Map<Object, Object> powersOf2Map() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.powersOf2Map$lzycompute();
        }
        return powersOf2Map;
    }

    private Map<Object, Object> latDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                latDeltaMap = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1 & Serializable)i -> GeoHash$.$anonfun$latDeltaMap$1(BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return latDeltaMap;
    }

    private Map<Object, Object> latDeltaMap() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.latDeltaMap$lzycompute();
        }
        return latDeltaMap;
    }

    public double latitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    private Map<Object, Object> lonDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                lonDeltaMap = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1 & Serializable)i -> GeoHash$.$anonfun$lonDeltaMap$1(BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return lonDeltaMap;
    }

    private Map<Object, Object> lonDeltaMap() {
        if ((byte)(bitmap$0 & 0x20) == 0) {
            return this.lonDeltaMap$lzycompute();
        }
        return lonDeltaMap;
    }

    public double longitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    private int[] bits() {
        return bits;
    }

    public String base32() {
        return base32;
    }

    private Map<Object, scala.collection.BitSet> characterMap() {
        return characterMap;
    }

    private double lonMax() {
        return lonMax;
    }

    private double latMax() {
        return latMax;
    }

    public GeoHash fromBinaryString(String bitsString) {
        int numBits = bitsString.length();
        scala.collection.BitSet bitSet = (scala.collection.BitSet)((IterableOnceOps)Predef$.MODULE$.wrapString(bitsString).zipWithIndex()).foldLeft(scala.collection.BitSet$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(bsSoFar, bitPosTuple) -> {
            Tuple2 tuple2 = bitPosTuple;
            if (tuple2 != null) {
                char bitChar = tuple2._1$mcC$sp();
                int pos = tuple2._2$mcI$sp();
                if (bitChar == '1') {
                    return (scala.collection.BitSet)bsSoFar.$plus((Object)BoxesRunTime.boxToInteger((int)pos));
                }
            }
            return bsSoFar;
        });
        return this.apply(bitSet, numBits);
    }

    public GeoHash apply(String string) {
        return this.decode(string, this.decode$default$2());
    }

    public GeoHash apply(String string, int precision) {
        return this.decode(string, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)precision)));
    }

    public GeoHash apply(Point p, int prec) {
        return this.apply(p.getX(), p.getY(), prec);
    }

    public GeoHash apply(scala.collection.BitSet bs, int prec) {
        return this.decode(this.org$locationtech$geomesa$utils$geohash$GeoHash$$toBase32(bs, prec), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    public GeoHash apply(double lon, double lat, int prec) {
        Predef$.MODULE$.require(lon >= -180.0 && lon <= 180.0);
        Predef$.MODULE$.require(lat >= -90.0 && lat <= 90.0);
        this.checkPrecision(prec);
        double lonDelta = BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        double latDelta = BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        long lonIndex = lon == 180.0 ? (long)(this.lonMax() / lonDelta) : (long)((lon - this.lonBounds().low()) / lonDelta);
        long latIndex = lat == 90.0 ? (long)(this.latMax() / latDelta) : (long)((lat - this.latBounds().low()) / latDelta);
        return this.encode(lonIndex, latIndex, lonDelta, latDelta, prec);
    }

    public int apply$default$3() {
        return 25;
    }

    public Seq<GeoHash> covering(GeoHash ll, GeoHash ur, int prec) {
        this.checkPrecision(prec);
        BoundingBox bbox = new BoundingBox(ll.getPoint(), ur.getPoint());
        GeoHash init = BoundingBox$.MODULE$.getCoveringGeoHash(bbox, prec);
        return GeoHash$.subsIntersecting$1(init, prec, bbox);
    }

    public int covering$default$3() {
        return 25;
    }

    public void checkPrecision(int precision) {
        Predef$.MODULE$.require(precision <= this.MAX_PRECISION(), (Function0 & Serializable)() -> new StringBuilder(72).append("GeoHash precision of ").append(precision).append(" requested, but precisions above ").append(MODULE$.MAX_PRECISION()).append(" are not supported").toString());
    }

    public Tuple2<Object, Object> getLatitudeLongitudeSpanCount(GeoHash g1, GeoHash g2, int precision) {
        Object object;
        Object object2;
        Predef$.MODULE$.require(g1.prec() == precision, (Function0 & Serializable)() -> new StringBuilder(50).append("Geohash ").append(g1.hash()).append(" has precision ").append(g1.prec()).append(" but precision ").append(precision).append(" is required").toString());
        Predef$.MODULE$.require(g2.prec() == precision, (Function0 & Serializable)() -> new StringBuilder(50).append("Geohash ").append(g2.hash()).append(" has precision ").append(g2.prec()).append(" but precision ").append(precision).append(" is required").toString());
        long[] lArray = this.gridIndicesForLatLong(g1);
        if (lArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)lArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) != 0) {
            throw new MatchError((Object)lArray);
        }
        long latIndex1 = BoxesRunTime.unboxToLong((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0));
        long lonIndex1 = BoxesRunTime.unboxToLong((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1));
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(latIndex1, lonIndex1);
        long latIndex12 = sp2._1$mcJ$sp();
        long lonIndex12 = sp2._2$mcJ$sp();
        long[] lArray2 = this.gridIndicesForLatLong(g2);
        if (lArray2 == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)lArray2)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)lArray2);
        }
        long latIndex2 = BoxesRunTime.unboxToLong((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
        long lonIndex2 = BoxesRunTime.unboxToLong((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
        Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(latIndex2, lonIndex2);
        long latIndex22 = sp3._1$mcJ$sp();
        long lonIndex22 = sp3._2$mcJ$sp();
        return new Tuple2.mcII.sp((int)(package$.MODULE$.abs(latIndex22 - latIndex12) + 1L), (int)(package$.MODULE$.abs(lonIndex22 - lonIndex12) + 1L));
    }

    public long[] gridIndicesForLatLong(GeoHash gh) {
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.longArrayOps(gh.bitset().toBitMask()))), gh.prec());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long lonIndex = tuple2._1$mcJ$sp();
        long latIndex = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(lonIndex, latIndex);
        long lonIndex2 = sp2._1$mcJ$sp();
        long latIndex2 = sp2._2$mcJ$sp();
        return new long[]{latIndex2, lonIndex2};
    }

    public long gridIndexForLatitude(GeoHash gh) {
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.longArrayOps(gh.bitset().toBitMask()))), gh.prec());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long latIndex = tuple2._2$mcJ$sp();
        long latIndex2 = latIndex;
        return latIndex2;
    }

    public long gridIndexForLongitude(GeoHash gh) {
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.longArrayOps(gh.bitset().toBitMask()))), gh.prec());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long lonIndex = tuple2._1$mcJ$sp();
        long lonIndex2 = lonIndex;
        return lonIndex2;
    }

    public GeoHash composeGeoHashFromBitIndicesAndPrec(long latIndex, long lonIndex, int prec) {
        this.checkPrecision(prec);
        return this.encode(lonIndex, latIndex, BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))), BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))), prec);
    }

    public GeoHash next(GeoHash gh) {
        return this.apply(this.next(gh.bitset(), this.next$default$2()), gh.prec());
    }

    public scala.collection.BitSet next(scala.collection.BitSet bs, int precision) {
        return (scala.collection.BitSet)((Tuple2)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), precision).reverse().foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), scala.collection.BitSet$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2 & Serializable)(t, idx) -> GeoHash$.$anonfun$next$1(bs, t, BoxesRunTime.unboxToInt((Object)idx))))._2();
    }

    public int next$default$2() {
        return 63;
    }

    public GeoHash encode(long lonIndex, long latIndex, double lonDelta, double latDelta, int prec) {
        BitSet bitSet = BitSet$.MODULE$.fromBitMaskNoCopy(new long[]{this.interleaveReverseBits(lonIndex, latIndex, prec)});
        BoundingBox bbox = this.bboxFromIndiciesDeltas(lonIndex, latIndex, lonDelta, latDelta);
        return this.apply(bbox.midLon(), bbox.midLat(), bbox, (scala.collection.BitSet)bitSet, prec, (Option<String>)None$.MODULE$);
    }

    private GeoHash decode(String string, Option<Object> precisionOption) {
        scala.collection.BitSet bitSet;
        int prec = BoxesRunTime.unboxToInt((Object)precisionOption.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 5 * string.length()));
        this.checkPrecision(prec);
        IndexedSeq bitsets = (IndexedSeq)((IndexedSeqOps)Predef$.MODULE$.wrapString(string).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                char c = tuple2._1$mcC$sp();
                int i = tuple2._2$mcI$sp();
                if (true) {
                    char c2 = c;
                    if (true) {
                        int n = i;
                        return MODULE$.shift(n * 5, (scala.collection.BitSet)MODULE$.characterMap().apply((Object)BoxesRunTime.boxToCharacter((char)c2)));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        int n = bitsets.size();
        switch (n) {
            case 0: {
                bitSet = (scala.collection.BitSet)scala.collection.BitSet$.MODULE$.apply((Seq)Nil$.MODULE$);
                break;
            }
            case 1: {
                bitSet = (scala.collection.BitSet)bitsets.apply(0);
                break;
            }
            default: {
                bitSet = (scala.collection.BitSet)bitsets.reduce((Function2 & Serializable)(x$4, x$5) -> (scala.collection.BitSet)x$4.$bar((Set)x$5));
                break;
            }
        }
        scala.collection.BitSet finalBitset = bitSet;
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.longArrayOps(finalBitset.toBitMask()))), prec);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long lonIndex = tuple2._1$mcJ$sp();
        long latIndex = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(lonIndex, latIndex);
        long lonIndex2 = sp2._1$mcJ$sp();
        long latIndex2 = sp2._2$mcJ$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))), BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))));
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        double lonDelta = sp3._1$mcD$sp();
        double latDelta = sp3._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(lonDelta, latDelta);
        double lonDelta2 = sp4._1$mcD$sp();
        double latDelta2 = sp4._2$mcD$sp();
        BoundingBox bbox = this.bboxFromIndiciesDeltas(lonIndex2, latIndex2, lonDelta2, latDelta2);
        return this.apply(bbox.midLon(), bbox.midLat(), bbox, finalBitset, prec, (Option<String>)new Some((Object)string));
    }

    private Option<Object> decode$default$2() {
        return None$.MODULE$;
    }

    private BoundingBox bboxFromIndiciesDeltas(long lonIndex, long latIndex, double lonDelta, double latDelta) {
        return BoundingBox$.MODULE$.apply(new Bounds(this.lonBounds().low() + lonDelta * (double)lonIndex, this.lonBounds().low() + lonDelta * (double)(lonIndex + 1L)), new Bounds(this.latBounds().low() + latDelta * (double)latIndex, this.latBounds().low() + latDelta * (double)(latIndex + 1L)));
    }

    private long interleaveReverseBits(long first, long second, int numBits) {
        Tuple2.mcJJ.sp sp2;
        boolean even = (numBits & 1) == 0;
        Tuple2.mcJJ.sp sp3 = sp2 = even ? new Tuple2.mcJJ.sp(second, first) : new Tuple2.mcJJ.sp(first, second);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        long actualFirst = sp2._1$mcJ$sp();
        long actualSecond = sp2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(actualFirst, actualSecond);
        long actualFirst2 = sp4._1$mcJ$sp();
        long actualSecond2 = sp4._2$mcJ$sp();
        int numPairs = numBits >> 1;
        LongRef result = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)pairNum -> {
            result$1.elem = result$1.elem << 1 | actualFirst2 >> pairNum & 1L;
            result$1.elem = result$1.elem << 1 | actualSecond2 >> pairNum & 1L;
        });
        if (!even) {
            return result.elem << 1 | actualFirst2 >> numPairs & 1L;
        }
        return result.elem;
    }

    private Tuple2<Object, Object> extractReverseBits(long value, int numBits) {
        int numPairs = numBits >> 1;
        LongRef first = LongRef.create((long)0L);
        LongRef second = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)pairNum -> {
            first$1.elem = first$1.elem << 1 | value >> pairNum * 2 & 1L;
            second$1.elem = second$1.elem << 1 | value >> pairNum * 2 + 1 & 1L;
        });
        return new Tuple2.mcJJ.sp((numBits & 1) == 1 ? first.elem << 1 | value >> numBits - 1 & 1L : first.elem, second.elem);
    }

    private scala.collection.BitSet shift(int n, scala.collection.BitSet bs) {
        return bs.map((Function1)(JFunction1.mcII.sp & Serializable)x$9 -> x$9 + n);
    }

    private scala.collection.BitSet bitSetFromBase32Character(long charIndex) {
        return (scala.collection.BitSet)scala.collection.BitSet$.MODULE$.apply((Seq)((IndexedSeqOps)((IterableOps)Predef$.MODULE$.wrapString(this.toPaddedBinaryString(charIndex, 5)).zipWithIndex()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GeoHash$.$anonfun$bitSetFromBase32Character$1(x0$1)))).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10._2$mcI$sp())));
    }

    private String toPaddedBinaryString(long i, int length) {
        return String.format(new StringBuilder(2).append("%").append(length).append("s").toString(), RichLong$.MODULE$.toBinaryString$extension(Predef$.MODULE$.longWrapper(i))).replace(' ', '0');
    }

    public String org$locationtech$geomesa$utils$geohash$GeoHash$$toBase32(scala.collection.BitSet bitset, int prec) {
        int n;
        int numLeftoverBits;
        int n2 = numLeftoverBits = prec % 5;
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            default: {
                n = 5 - numLeftoverBits;
                break;
            }
        }
        int precision = prec + n;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), precision).grouped(5).map((Function1 & Serializable)i -> BoxesRunTime.boxToCharacter((char)GeoHash$.MODULE$.ch((IndexedSeq<Object>)i, bitset))).mkString();
    }

    private char ch(IndexedSeq<Object> v, scala.collection.BitSet bitset) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.base32()), BoxesRunTime.unboxToInt((Object)v.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(cur, i) -> cur + (bitset.apply((Object)BoxesRunTime.boxToInteger((int)i)) ? MODULE$.bits()[i % MODULE$.bits().length] : 0))));
    }

    public GeoHash apply(double x, double y, BoundingBox bbox, scala.collection.BitSet bitset, int prec, Option<String> optHash) {
        return new GeoHash(x, y, bbox, bitset, prec, optHash);
    }

    public Option<Tuple6<Object, Object, BoundingBox, scala.collection.BitSet, Object, Option<String>>> unapply(GeoHash x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)BoxesRunTime.boxToDouble((double)x$0.x()), (Object)BoxesRunTime.boxToDouble((double)x$0.y()), (Object)x$0.bbox(), (Object)x$0.bitset(), (Object)BoxesRunTime.boxToInteger((int)x$0.prec()), x$0.org$locationtech$geomesa$utils$geohash$GeoHash$$optHash()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GeoHash$.class);
    }

    public static final /* synthetic */ Tuple2 $anonfun$powersOf2Map$1(int i) {
        return new Tuple2.mcIJ.sp(i, 1L << i);
    }

    public static final /* synthetic */ Tuple2 $anonfun$latDeltaMap$1(int i) {
        return new Tuple2.mcID.sp(i, MODULE$.latRange() / (double)BoxesRunTime.unboxToLong((Object)MODULE$.powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2)))));
    }

    public static final /* synthetic */ Tuple2 $anonfun$lonDeltaMap$1(int i) {
        return new Tuple2.mcID.sp(i, MODULE$.lonRange() / (double)BoxesRunTime.unboxToLong((Object)MODULE$.powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2 + i % 2)))));
    }

    private static final Seq subsIntersecting$1(GeoHash hash, int prec$1, BoundingBox bbox$1) {
        if (hash.prec() == prec$1) {
            return new .colon.colon((Object)hash, (List)Nil$.MODULE$);
        }
        Seq<GeoHash> subs = BoundingBox$.MODULE$.generateSubGeoHashes(hash);
        return (Seq)subs.flatMap((Function1 & Serializable)x0$1 -> {
            GeoHash geoHash = x0$1;
            if (!bbox$1.intersects(geoHash.bbox())) {
                return Nil$.MODULE$;
            }
            return GeoHash$.subsIntersecting$1(geoHash, prec$1, bbox$1);
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$next$1(scala.collection.BitSet bs$1, Tuple2 t, int idx) {
        Tuple2 tuple2 = t;
        if (tuple2 != null) {
            boolean carry = tuple2._1$mcZ$sp();
            scala.collection.BitSet newBS = (scala.collection.BitSet)tuple2._2();
            if (carry) {
                if (bs$1.apply((Object)BoxesRunTime.boxToInteger((int)idx))) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)newBS);
                }
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)newBS.$plus((Object)BoxesRunTime.boxToInteger((int)idx)));
            }
            if (bs$1.apply((Object)BoxesRunTime.boxToInteger((int)idx))) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)newBS.$plus((Object)BoxesRunTime.boxToInteger((int)idx)));
            }
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)newBS);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$bitSetFromBase32Character$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            char c = tuple2._1$mcC$sp();
            return c == '1';
        }
        throw new MatchError((Object)tuple2);
    }

    private GeoHash$() {
    }
}

