/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.geohash.GeohashUtils;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$2$;
import org.locationtech.geomesa.utils.geohash.GeomDistance;
import org.locationtech.geomesa.utils.geohash.GeomDistance$Distance$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.iterators.CartesianProductIterable;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BitSet;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.WrappedString;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class GeohashUtils$
implements GeomDistance,
LazyLogging {
    public static final GeohashUtils$ MODULE$ = new GeohashUtils$();
    private static Geometry emptyGeometry;
    private static final IndexedSeq<List<WrappedString>> Base32Padding;
    private static final IndexedSeq<List<Seq<Object>>> BinaryPadding;
    private static final int maxRealisticGeoHashPrecision;
    private static final long numDistinctGridPoints;
    private static final PrecisionModel defaultPrecisionModel;
    private static final GeometryFactory defaultGeometryFactory;
    private static transient Logger logger;
    private static volatile GeomDistance$Distance$ Distance$module;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile boolean bitmap$0;

    static {
        GeomDistance.$init$(MODULE$);
        LazyLogging.$init$((LazyLogging)MODULE$);
        Base32Padding = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).map((Function1 & Serializable)i -> GeohashUtils$.$anonfun$Base32Padding$1(BoxesRunTime.unboxToInt((Object)i)));
        BinaryPadding = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)i -> GeohashUtils$.$anonfun$BinaryPadding$1(BoxesRunTime.unboxToInt((Object)i)));
        maxRealisticGeoHashPrecision = 45;
        numDistinctGridPoints = 1L << (int)((long)((MODULE$.maxRealisticGeoHashPrecision() + 1) / 2));
        defaultPrecisionModel = new PrecisionModel((double)MODULE$.numDistinctGridPoints());
        defaultGeometryFactory = new GeometryFactory(MODULE$.defaultPrecisionModel(), 4326);
    }

    private Logger logger$lzycompute() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public GeomDistance$Distance$ Distance() {
        if (Distance$module == null) {
            this.Distance$lzycompute$1();
        }
        return Distance$module;
    }

    public IndexedSeq<List<WrappedString>> Base32Padding() {
        return Base32Padding;
    }

    public IndexedSeq<List<Seq<Object>>> BinaryPadding() {
        return BinaryPadding;
    }

    public int maxRealisticGeoHashPrecision() {
        return maxRealisticGeoHashPrecision;
    }

    public long numDistinctGridPoints() {
        return numDistinctGridPoints;
    }

    public PrecisionModel defaultPrecisionModel() {
        return defaultPrecisionModel;
    }

    public GeometryFactory defaultGeometryFactory() {
        return defaultGeometryFactory;
    }

    public GeoHash getMinimumBoundingGeohash(Geometry geom, GeohashUtils.ResolutionRange resolutions) {
        Point centroid = this.getCentroid(geom);
        Geometry env = this.defaultGeometryFactory().toGeometry(geom.getEnvelopeInternal());
        Tuple2 tuple2 = (Tuple2)resolutions.range().foldRight((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)resolutions.minBitsResolution()), (Object)Option$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> GeohashUtils$.$anonfun$getMinimumBoundingGeohash$1(centroid, env, BoxesRunTime.unboxToInt((Object)x0$1), x1$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option ghOpt = (Option)tuple2._2();
        Option ghOpt2 = ghOpt;
        GeoHash gh = (GeoHash)ghOpt2.getOrElse((Function0 & Serializable)() -> GeoHash$.MODULE$.apply(centroid.getX(), centroid.getY(), resolutions.minBitsResolution()));
        if (!GeoHash$.MODULE$.toGeometry(gh).contains(env) && !gh.geom().equals(env)) {
            throw new Exception(new StringBuilder(69).append("ERROR:  Could not find a suitable ").append(resolutions.minBitsResolution()).append("-bit MBR for the target geometry:  ").append(geom).toString());
        }
        return gh;
    }

    public Point getCentroid(Geometry geom) {
        Point pt = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
        return geom.getFactory().createPoint(new Coordinate(pt.getX(), pt.getY()));
    }

    private Geometry emptyGeometry$lzycompute() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if (!bitmap$0) {
                emptyGeometry = WKTUtils$.MODULE$.read("POLYGON((0 0,0 0,0 0,0 0,0 0))");
                bitmap$0 = true;
            }
        }
        return emptyGeometry;
    }

    public Geometry emptyGeometry() {
        if (!bitmap$0) {
            return this.emptyGeometry$lzycompute();
        }
        return emptyGeometry;
    }

    public boolean decompositionCandidateSorter(GeohashUtils.DecompositionCandidate a, GeohashUtils.DecompositionCandidate b) {
        return a.isLT(b);
    }

    private List<GeoHash> decomposeGeometry_(Geometry targetGeom, int maxSize, GeohashUtils.ResolutionRange resolutions) {
        LazyRef geomCatcher$lzy = new LazyRef();
        double targetArea = BoxesRunTime.unboxToDouble((Object)GeohashUtils$.geomCatcher$1(geomCatcher$lzy).opt((Function0)(JFunction0.mcD.sp & Serializable)() -> targetGeom.getArea()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        double targetLength = BoxesRunTime.unboxToDouble((Object)GeohashUtils$.geomCatcher$1(geomCatcher$lzy).opt((Function0)(JFunction0.mcD.sp & Serializable)() -> targetGeom.getLength()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        GeoHash ghMBR = this.getMinimumBoundingGeohash(targetGeom, resolutions);
        GeohashUtils.DecompositionCandidate candidateMBR = GeohashUtils$.createDecompositionCandidate$1(ghMBR, targetGeom, targetArea, resolutions, targetLength);
        List keepers = this.decomposeStep$1((List)new .colon.colon((Object)candidateMBR, (List)Nil$.MODULE$), maxSize, resolutions, targetGeom, targetArea, targetLength);
        return ((List)keepers.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)GeohashUtils$.$anonfun$decomposeGeometry_$8(check$ifrefutable$1))).map((Function1 & Serializable)keeper -> keeper.gh())).toList();
    }

    public Geometry getDecomposableGeometry(Geometry targetGeom) {
        Geometry geometry = targetGeom;
        if (geometry instanceof Point) {
            return targetGeom;
        }
        if (geometry instanceof Polygon) {
            return targetGeom;
        }
        if (geometry instanceof LineString && targetGeom.getNumPoints() < 100) {
            return targetGeom;
        }
        if (geometry instanceof MultiLineString && targetGeom.getNumPoints() < 100) {
            return targetGeom;
        }
        return targetGeom.convexHull();
    }

    public Try<Geometry> getInternationalDateLineSafeGeometry(Geometry targetGeom) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Geometry copy = GeometryUtils$.MODULE$.geoFactory().createGeometry(targetGeom);
            Geometry withinBoundsGeom = targetGeom.getEnvelopeInternal().getMinX() < (double)-180 || targetGeom.getEnvelopeInternal().getMaxX() > (double)180 ? this.translateGeometry$1(copy) : copy;
            return JtsSpatialContext.GEO.makeShape(withinBoundsGeom, true, true).getGeom();
        });
    }

    public List<GeoHash> decomposeGeometry(Geometry targetGeom, int maxSize, GeohashUtils.ResolutionRange resolutions, boolean relaxFit) {
        Geometry geometry = targetGeom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return new .colon.colon((Object)GeoHash$.MODULE$.apply(point.getX(), point.getY(), resolutions.maxBitsResolution()), (List)Nil$.MODULE$);
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            return (List)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), geometryCollection.getNumGeometries()).toList().flatMap((Function1 & Serializable)i -> GeohashUtils$.MODULE$.decomposeGeometry(geometryCollection.getGeometryN(BoxesRunTime.unboxToInt((Object)i)), maxSize, resolutions, relaxFit)).distinct();
        }
        Geometry safeGeom = (Geometry)this.getInternationalDateLineSafeGeometry(targetGeom).getOrElse((Function0 & Serializable)() -> targetGeom);
        return this.decomposeGeometry_(relaxFit ? this.getDecomposableGeometry(safeGeom) : safeGeom, maxSize, resolutions);
    }

    private int decomposeGeometry_$default$2() {
        return 100;
    }

    private GeohashUtils.ResolutionRange decomposeGeometry_$default$3() {
        return new GeohashUtils.ResolutionRange(5, 40, 5);
    }

    public int decomposeGeometry$default$2() {
        return 100;
    }

    public GeohashUtils.ResolutionRange decomposeGeometry$default$3() {
        return new GeohashUtils.ResolutionRange(0, 40, 5);
    }

    public boolean decomposeGeometry$default$4() {
        return true;
    }

    public Iterator<String> getGeohashStringDottingIterator(Seq<String> set, int maxSize) {
        int len = BoxesRunTime.unboxToInt((Object)set.headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.length())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), len).iterator().flatMap((Function1 & Serializable)i -> GeohashUtils$.$anonfun$getGeohashStringDottingIterator$3(set, len, BoxesRunTime.unboxToInt((Object)i))).take(maxSize + 1);
    }

    public Geometry promoteToRegion(Geometry geom) {
        Geometry geometry = geom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return point.buffer(1.0E-6);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            if (polygon.getArea() > 0.0) {
                return polygon;
            }
            return Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)polygon)).buffer(1.0E-6);
        }
        Geometry env = geometry.getEnvelope();
        if (env.getArea() > 0.0) {
            return env;
        }
        return env.getCentroid().buffer(1.0E-6);
    }

    public Try<Seq<String>> getUniqueGeohashSubstringsInPolygon(Geometry geom, int offset, int length, int MAX_KEYS_IN_LIST, boolean includeDots) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            LazyRef BitPrefixes$module = new LazyRef();
            Geometry cover = MODULE$.promoteToRegion(geom);
            int maxBits = (offset + length) * 5;
            int minBits = offset * 5;
            int usedBits = length * 5;
            GeohashUtils.ResolutionRange allResolutions = new GeohashUtils.ResolutionRange(0, Math.min(35, maxBits), 1);
            int maxKeys = Math.min(2 << Math.min(usedBits, 29), MAX_KEYS_IN_LIST);
            Point polyCentroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(cover));
            GeoHash ghMBR = MODULE$.getMinimumBoundingGeohash(geom, allResolutions);
            public class Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1
            implements Product,
            Serializable {
                private final Seq<String> prefixes;
                private final boolean hasEverythingPrefix;
                private final int entailedSize;
                private final boolean usesAll;
                private final int minBits$1;
                private final int maxKeys$1;
                private final int usedBits$1;
                private final int maxBits$1;
                private final int length$1;

                public Iterator<String> productElementNames() {
                    return Product.productElementNames$((Product)this);
                }

                public Seq<String> prefixes() {
                    return this.prefixes;
                }

                public boolean hasEverythingPrefix() {
                    return this.hasEverythingPrefix;
                }

                public int entailedSize() {
                    return this.entailedSize;
                }

                public boolean usesAll() {
                    return this.usesAll;
                }

                public boolean hasRoom() {
                    return this.entailedSize() <= this.maxKeys$1;
                }

                public boolean notDone() {
                    return !this.usesAll() && this.hasRoom();
                }

                public boolean overflowed() {
                    if (this.usesAll()) {
                        return 1 << this.usedBits$1 > this.maxKeys$1;
                    }
                    return this.entailedSize() > this.maxKeys$1;
                }

                public Seq<String> generateAll(String prefix) {
                    String prefixHash = GeoHash$.MODULE$.fromBinaryString(prefix).hash();
                    if (prefixHash.length() < this.length$1) {
                        List charSeqs = (List)GeohashUtils$.MODULE$.Base32Padding().apply(this.length$1 - prefixHash.length());
                        return new CartesianProductIterable((Seq<Seq<Object>>)charSeqs).toList().map((Function1 & Serializable)x$4 -> new StringBuilder(0).append(prefixHash).append(x$4.mkString()).toString());
                    }
                    return new .colon.colon((Object)prefixHash, (List)Nil$.MODULE$);
                }

                public Seq<String> generateSome() {
                    return ((IterableOnceOps)this.prefixes().foldLeft(HashSet$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(ghsSoFar, prefix) -> {
                        .colon.colon colon2;
                        int bitsToBoundary = (65 - prefix.length()) % 5;
                        if (bitsToBoundary == 0) {
                            colon2 = new .colon.colon(prefix, (List)Nil$.MODULE$);
                        } else {
                            List fillers = (List)GeohashUtils$.MODULE$.BinaryPadding().apply(bitsToBoundary);
                            List result = new CartesianProductIterable((Seq<Seq<Object>>)fillers).toList().map((Function1 & Serializable)x$5 -> new StringBuilder(0).append((String)prefix).append(x$5.mkString()).toString());
                            colon2 = result;
                        }
                        .colon.colon bases = colon2;
                        return (HashSet)bases.foldLeft(ghsSoFar, (Function2 & Serializable)(ghs, base) -> {
                            String baseTrimmed = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(base), $this.minBits$1);
                            Seq<String> newSubs = this.generateAll(baseTrimmed);
                            return (HashSet)ghs.$plus$plus(newSubs);
                        });
                    })).toSeq();
                }

                public Seq<String> toSeq() {
                    if (this.usesAll()) {
                        return this.generateAll("");
                    }
                    return this.generateSome();
                }

                public Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 copy(Seq<String> prefixes) {
                    return new Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1(prefixes, this.minBits$1, this.maxKeys$1, this.usedBits$1, this.maxBits$1, this.length$1);
                }

                public Seq<String> copy$default$1() {
                    return this.prefixes();
                }

                public String productPrefix() {
                    return "BitPrefixes";
                }

                public int productArity() {
                    return 1;
                }

                public Object productElement(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return this.prefixes();
                        }
                    }
                    return Statics.ioobe((int)x$1);
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1;
                }

                public String productElementName(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return "prefixes";
                        }
                    }
                    return (String)Statics.ioobe((int)x$1);
                }

                public int hashCode() {
                    return ScalaRunTime$.MODULE$._hashCode((Product)this);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 var4_3 = (Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1)x$1;
                    Seq<String> seq = this.prefixes();
                    Seq<String> seq2 = var4_3.prefixes();
                    if (seq == null) {
                        if (seq2 != null) {
                            return false;
                        }
                    } else if (!seq.equals(seq2)) return false;
                    if (!var4_3.canEqual(this)) return false;
                    return true;
                }

                public static final /* synthetic */ boolean $anonfun$hasEverythingPrefix$1(Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 $this, String prefix) {
                    return prefix.length() <= $this.minBits$1;
                }

                public static final /* synthetic */ int $anonfun$entailedSize$1(Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 $this, int sumSoFar, String prefix) {
                    return sumSoFar + (1 << Math.min($this.usedBits$1, $this.maxBits$1 - prefix.length()));
                }

                public static final /* synthetic */ boolean $anonfun$usesAll$1(Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 $this, String prefix) {
                    return prefix.length() <= $this.minBits$1;
                }

                public Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1(Seq<String> prefixes) {
                    this.prefixes = prefixes;
                    this.minBits$1 = minBits$1;
                    this.maxKeys$1 = maxKeys$1;
                    this.usedBits$1 = usedBits$1;
                    this.maxBits$1 = maxBits$1;
                    this.length$1 = length$1;
                    Product.$init$((Product)this);
                    this.hasEverythingPrefix = prefixes.exists((Function1 & Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1.$anonfun$hasEverythingPrefix$1(this, prefix)));
                    this.entailedSize = this.hasEverythingPrefix() ? maxKeys$1 : Math.min(1 << usedBits$1, BoxesRunTime.unboxToInt((Object)prefixes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(sumSoFar, prefix) -> BoxesRunTime.boxToInteger((int)Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1.$anonfun$entailedSize$1(this, BoxesRunTime.unboxToInt((Object)sumSoFar), prefix)))));
                    this.usesAll = prefixes.exists((Function1 & Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1.$anonfun$usesAll$1(this, prefix))) || this.entailedSize() == maxKeys$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$entailedSize$1$adapted(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 java.lang.Object java.lang.String ), $anonfun$generateAll$1(java.lang.String scala.collection.immutable.Seq ), $anonfun$generateSome$1(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 scala.collection.immutable.HashSet java.lang.String ), $anonfun$generateSome$2(java.lang.String scala.collection.immutable.Seq ), $anonfun$generateSome$3(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 scala.collection.immutable.HashSet java.lang.String ), $anonfun$hasEverythingPrefix$1$adapted(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 java.lang.String ), $anonfun$usesAll$1$adapted(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 java.lang.String )}, serializedLambda);
                }
            }
            Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 bitPrefixes = this.BitPrefixes$3(BitPrefixes$module, minBits, maxKeys, usedBits, maxBits, length).apply((Seq<String>)(ghMBR.prec() <= maxBits ? GeohashUtils$.considerCandidate$1(ghMBR, geom, cover, maxBits, polyCentroid, minBits) : new .colon.colon((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(ghMBR.toBinaryString()), minBits)), usedBits), (List)Nil$.MODULE$)));
            if (bitPrefixes.overflowed()) {
                throw new IllegalStateException(new StringBuilder(162).append("Bit prefixes overflowed while calculating unique Geohash substrings in polygon using the following parameters: ").append("\nGeometry: ").append(geom).append(" \nOffset: ").append(offset).append(" \nLength: ").append(length).append(" \nMax Keys in List: ").append(MAX_KEYS_IN_LIST).toString());
            }
            Seq<String> unDotted = bitPrefixes.toSeq();
            if (includeDots) {
                if (unDotted.size() < maxKeys) {
                    List keepers = MODULE$.getGeohashStringDottingIterator(unDotted, MAX_KEYS_IN_LIST).take(MAX_KEYS_IN_LIST + 1).toList();
                    if (keepers.size() <= MAX_KEYS_IN_LIST) {
                        return keepers.toSeq();
                    }
                    return (Seq)Nil$.MODULE$;
                }
                return (Seq)Nil$.MODULE$;
            }
            return unDotted;
        });
    }

    public int getUniqueGeohashSubstringsInPolygon$default$4() {
        return 0x7FFFFFFE;
    }

    public boolean getUniqueGeohashSubstringsInPolygon$default$5() {
        return true;
    }

    private final void Distance$lzycompute$1() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if (Distance$module == null) {
                Distance$module = new GeomDistance$Distance$(this);
            }
        }
    }

    public static final /* synthetic */ List $anonfun$Base32Padding$1(int i) {
        return (List)package$.MODULE$.List().fill(i, (Function0 & Serializable)() -> (WrappedString)Predef$.MODULE$.wrapString(GeoHash$.MODULE$.base32()).toSeq());
    }

    public static final /* synthetic */ List $anonfun$BinaryPadding$1(int i) {
        return (List)package$.MODULE$.List().fill(i, (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'0', '1'})));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getMinimumBoundingGeohash$1(Point centroid$1, Geometry env$1, int x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int bits = tuple2._1$mcI$sp();
            Tuple2 orig = (Tuple2)tuple2._2();
            if (orig != null) {
                int res = orig._1$mcI$sp();
                GeoHash gh = GeoHash$.MODULE$.apply(centroid$1.getX(), centroid$1.getY(), bits);
                if (GeoHash$.MODULE$.toGeometry(gh).contains(env$1) && bits >= res) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)bits), (Object)new Some((Object)gh));
                }
                return orig;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ Exception.Catch geomCatcher$lzycompute$1(LazyRef geomCatcher$lzy$1) {
        Exception.Catch catch_;
        LazyRef lazyRef = geomCatcher$lzy$1;
        synchronized (lazyRef) {
            catch_ = geomCatcher$lzy$1.initialized() ? (Exception.Catch)geomCatcher$lzy$1.value() : (Exception.Catch)geomCatcher$lzy$1.initialize((Object)Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{Exception.class})));
        }
        return catch_;
    }

    private static final Exception.Catch geomCatcher$1(LazyRef geomCatcher$lzy$1) {
        if (geomCatcher$lzy$1.initialized()) {
            return (Exception.Catch)geomCatcher$lzy$1.value();
        }
        return GeohashUtils$.geomCatcher$lzycompute$1(geomCatcher$lzy$1);
    }

    private static final GeohashUtils.DecompositionCandidate createDecompositionCandidate$1(GeoHash gh, Geometry targetGeom$1, double targetArea$1, GeohashUtils.ResolutionRange resolutions$2, double targetLength$1) {
        Geometry geometry = targetGeom$1;
        if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            return new GeohashUtils.PolygonDecompositionCandidate(gh, multiPolygon, targetArea$1, resolutions$2);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            return new GeohashUtils.PolygonDecompositionCandidate(gh, new MultiPolygon((Polygon[])((Object[])new Polygon[]{polygon}), polygon.getFactory()), targetArea$1, resolutions$2);
        }
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            return new GeohashUtils.LineDecompositionCandidate(gh, new MultiLineString((LineString[])((Object[])new LineString[]{lineString}), lineString.getFactory()), targetLength$1, resolutions$2);
        }
        if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            return new GeohashUtils.LineDecompositionCandidate(gh, multiLineString, targetLength$1, resolutions$2);
        }
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return new GeohashUtils.PointDecompositionCandidate(gh, point, targetArea$1, resolutions$2);
        }
        throw new Exception(new StringBuilder(46).append("Unsupported Geometry type for decomposition:  ").append(targetGeom$1.getClass().getName()).toString());
    }

    private final List decomposeStep$1(List candidates, int maxSize$1, GeohashUtils.ResolutionRange resolutions$2, Geometry targetGeom$1, double targetArea$1, double targetLength$1) {
        while (true) {
            if (candidates.size() > maxSize$1) {
                throw new Exception("Too many candidates upon entry.");
            }
            GeohashUtils.DecompositionCandidate candidate = (GeohashUtils.DecompositionCandidate)candidates.apply(0);
            int childResolution = candidate.gh().prec() + resolutions$2.numBitsIncrement();
            BitSet candidateBitSet = candidate.gh().bitset();
            List children = resolutions$2.getNextChildren(candidateBitSet, candidate.gh().prec()).map((Function1 & Serializable)childBitSet -> GeohashUtils$.createDecompositionCandidate$1(GeoHash$.MODULE$.apply((BitSet)childBitSet, childResolution), targetGeom$1, targetArea$1, resolutions$2, targetLength$1)).filter((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)child.intersectsTarget()));
            List newCandidates = (List)((SeqOps)((IterableOps)candidates.tail()).$plus$plus((IterableOnce)children)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)GeohashUtils$.MODULE$.decompositionCandidateSorter(a, b)));
            if (newCandidates.size() > maxSize$1 || childResolution > resolutions$2.maxBitsResolution()) break;
            candidates = newCandidates;
        }
        return candidates;
    }

    public static final /* synthetic */ boolean $anonfun$decomposeGeometry_$8(GeohashUtils.DecompositionCandidate check$ifrefutable$1) {
        GeohashUtils.DecompositionCandidate decompositionCandidate = check$ifrefutable$1;
        return decompositionCandidate != null;
    }

    private static final double degreesLonTranslation$1(double lon) {
        return (int)(RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((lon + (double)180) / 360.0)) * (double)-360);
    }

    private static final Coordinate translateCoord$1(Coordinate coord) {
        return new Coordinate(coord.x + GeohashUtils$.degreesLonTranslation$1(coord.x), coord.y);
    }

    private final Geometry translatePolygon$1(Geometry geometry) {
        return this.defaultGeometryFactory().createPolygon((Coordinate[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])geometry.getCoordinates()), (Function1 & Serializable)c -> GeohashUtils$.translateCoord$1(c), ClassTag$.MODULE$.apply(Coordinate.class)));
    }

    private final Geometry translateLineString$1(Geometry geometry) {
        return this.defaultGeometryFactory().createLineString((Coordinate[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])geometry.getCoordinates()), (Function1 & Serializable)c -> GeohashUtils$.translateCoord$1(c), ClassTag$.MODULE$.apply(Coordinate.class)));
    }

    private final Geometry translateMultiLineString$1(Geometry geometry) {
        IndexedSeq coords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), geometry.getNumGeometries()).map((Function1 & Serializable)i -> geometry.getGeometryN(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq translated = (IndexedSeq)coords.map((Function1 & Serializable)c -> (LineString)this.translateLineString$1((Geometry)c));
        return this.defaultGeometryFactory().createMultiLineString((LineString[])translated.toArray(ClassTag$.MODULE$.apply(LineString.class)));
    }

    private final Geometry translateMultiPolygon$1(Geometry geometry) {
        IndexedSeq coords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), geometry.getNumGeometries()).map((Function1 & Serializable)i -> geometry.getGeometryN(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq translated = (IndexedSeq)coords.map((Function1 & Serializable)c -> (Polygon)this.translatePolygon$1((Geometry)c));
        return this.defaultGeometryFactory().createMultiPolygon((Polygon[])translated.toArray(ClassTag$.MODULE$.apply(Polygon.class)));
    }

    private final Geometry translateMultiPoint$1(Geometry geometry) {
        return this.defaultGeometryFactory().createMultiPoint((Coordinate[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])geometry.getCoordinates()), (Function1 & Serializable)c -> GeohashUtils$.translateCoord$1(c), ClassTag$.MODULE$.apply(Coordinate.class)));
    }

    private final Geometry translatePoint$1(Geometry geometry) {
        return this.defaultGeometryFactory().createPoint(GeohashUtils$.translateCoord$1(geometry.getCoordinate()));
    }

    private final Geometry translateGeometry$1(Geometry geometry) {
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Polygon) {
            return this.translatePolygon$1(geometry);
        }
        if (geometry2 instanceof LineString) {
            return this.translateLineString$1(geometry);
        }
        if (geometry2 instanceof MultiLineString) {
            return this.translateMultiLineString$1(geometry);
        }
        if (geometry2 instanceof MultiPolygon) {
            return this.translateMultiPolygon$1(geometry);
        }
        if (geometry2 instanceof MultiPoint) {
            return this.translateMultiPoint$1(geometry);
        }
        if (geometry2 instanceof Point) {
            return this.translatePoint$1(geometry);
        }
        throw new MatchError((Object)geometry2);
    }

    public static final /* synthetic */ Seq $anonfun$getGeohashStringDottingIterator$3(Seq set$1, int len$1, int i) {
        return (Seq)((IterableOps)((IterableOps)((SeqOps)set$1.map((Function1 & Serializable)x$2 -> StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(x$2), i))).distinct()).map((Function1 & Serializable)hash -> {
            String newStr = new StringBuilder(0).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hash), i)).append(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(""), len$1 - i, (Object)".").mkString()).toString();
            return new Tuple2(hash, (Object)newStr);
        })).map((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                String newStr = (String)tuple2._2();
                return newStr;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final /* synthetic */ GeohashUtils$BitPrefixes$2$ BitPrefixes$lzycompute$1(LazyRef BitPrefixes$module$1, int minBits$1, int maxKeys$1, int usedBits$1, int maxBits$1, int length$1) {
        GeohashUtils$BitPrefixes$2$ geohashUtils$BitPrefixes$2$;
        LazyRef lazyRef = BitPrefixes$module$1;
        synchronized (lazyRef) {
            geohashUtils$BitPrefixes$2$ = BitPrefixes$module$1.initialized() ? (GeohashUtils$BitPrefixes$2$)BitPrefixes$module$1.value() : (GeohashUtils$BitPrefixes$2$)BitPrefixes$module$1.initialize((Object)new GeohashUtils$BitPrefixes$2$(minBits$1, maxKeys$1, usedBits$1, maxBits$1, length$1));
        }
        return geohashUtils$BitPrefixes$2$;
    }

    private final GeohashUtils$BitPrefixes$2$ BitPrefixes$3(LazyRef BitPrefixes$module$1, int minBits$1, int maxKeys$1, int usedBits$1, int maxBits$1, int length$1) {
        if (BitPrefixes$module$1.initialized()) {
            return (GeohashUtils$BitPrefixes$2$)BitPrefixes$module$1.value();
        }
        return GeohashUtils$.BitPrefixes$lzycompute$1(BitPrefixes$module$1, minBits$1, maxKeys$1, usedBits$1, maxBits$1, length$1);
    }

    private static final Seq considerCandidate$1(GeoHash candidate, Geometry geom$1, Geometry cover$1, int maxBits$1, Point polyCentroid$1, int minBits$1) {
        String bitString = candidate.toBinaryString();
        if (!geom$1.intersects(candidate.geom())) {
            return Nil$.MODULE$;
        }
        if (cover$1.covers(candidate.geom()) || StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(bitString)) == maxBits$1) {
            return new .colon.colon((Object)bitString, (List)Nil$.MODULE$);
        }
        if (StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(bitString)) < maxBits$1) {
            Some some;
            String bitStr;
            double d1;
            Tuple2 tuple2;
            GeoHash gh0 = GeoHash$.MODULE$.fromBinaryString(new StringBuilder(1).append(bitString).append("0").toString());
            GeoHash gh1 = GeoHash$.MODULE$.fromBinaryString(new StringBuilder(1).append(bitString).append("1").toString());
            double d0 = Math.hypot(gh0.getPoint().getX() - polyCentroid$1.getX(), gh0.getPoint().getY() - polyCentroid$1.getY());
            Tuple2 tuple22 = tuple2 = d0 <= (d1 = Math.hypot(gh1.getPoint().getX() - polyCentroid$1.getX(), gh1.getPoint().getY() - polyCentroid$1.getY())) ? new Tuple2((Object)gh0, (Object)gh1) : new Tuple2((Object)gh1, (Object)gh0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeoHash firstChild = (GeoHash)tuple2._1();
            GeoHash secondChild = (GeoHash)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)firstChild, (Object)secondChild);
            GeoHash firstChild2 = (GeoHash)tuple23._1();
            GeoHash secondChild2 = (GeoHash)tuple23._2();
            Seq firstChildList = GeohashUtils$.considerCandidate$1(firstChild2, geom$1, cover$1, maxBits$1, polyCentroid$1, minBits$1);
            Option option = firstChildList.headOption();
            return (Seq)firstChildList.$plus$plus((IterableOnce)(option instanceof Some && (bitStr = (String)(some = (Some)option).value()).length() <= minBits$1 ? Nil$.MODULE$ : GeohashUtils$.considerCandidate$1(secondChild2, geom$1, cover$1, maxBits$1, polyCentroid$1, minBits$1)));
        }
        return Nil$.MODULE$;
    }

    private GeohashUtils$() {
    }
}

